--
-- LLRNet - network part of LLR
--
-- (C) 2004-2005 Vincent Penne
--
-- Released under GNU LIBRARY GENERAL PUBLIC LICENSE
-- (See file LICENSE that must be included with this software)
--

local print = print
if orig_print then
   print = orig_print
end

local i, n

-- this was initially developped with lua 5 alpha, thus this backward 
-- compatibility definition
if getfenv then
   getglobals = getfenv
   setglobals = setfenv
end

-- initialize C side of the fox binding
local ofox_init = fox_init
fox = nil
fox_init()
-- have to do that because fox_init reset the fox_init 
-- global variable
fox_init = ofox_init 

reverse_fox = { }
for i, n in fox do
   if not string.find(i, "SDL") and not string.find(i, "BLT")
      and not string.find(i, "FONT") and not string.find(i, "DEF_")
      and not string.find(i, "STIPPLE_") and not string.find(i, "PRINT_") 
      and not string.find(i, "_ISOC_") and not string.find(i, "ILU?T?_")
      and not string.find(i, "GL_") then
      if type(n) == "string" or type(n) == "number" then
	 getglobals()[i] = n
	 --setglobal(i, n)
	 reverse_fox[n] = i
      end
   end
end

fxHandlers = { }
fxCmdHandlers = { }

local count=0
function FXCallback(this, sender, event1, event2, d1,d2,d3,d4)
   this = FXObjectAddress(this)

--   print(format("FXCallback called ! %d, event = %d, %d(%s)", count, event1, event2, reverse_fox[event2] or "?"))
--   count = count + 1

   local f
   f = fxCmdHandlers[this]
   if f then
      f = f[event2]
      if f and f(this, sender, event1, event2, d1,d2,d3,d4) then
	 return 1
      end
   end
   f = fxHandlers[this]
   return f and f(this, sender, event1, event2, d1,d2,d3,d4)
end

function FXRemoveCb(obj)
   local addr = FXObjectAddress(obj)
   fxCmdHandlers[addr] = nil
   fxHandlers[addr] = nil
end

function FXAddCb(obj, handler, command)
   local addr = FXObjectAddress(obj)
   if not addr then
      return
   end
   if command then
      local t = fxCmdHandlers[addr]
      if not t then
	 t = { }
	 fxCmdHandlers[addr] = t
      end
      t[command] = handler
   else
      fxHandlers[addr] = handler
   end
end

function FXAsk(question, ...)
   local answers = arg
   local dialog = 
      fox.FXDialogBox(mainWindow,"LLR question",
		      DECOR_TITLE+DECOR_BORDER)

   local vframe=fox.FXVerticalFrame(dialog,LAYOUT_FILL_Y+LAYOUT_LEFT);

   fox.FXLabel(vframe,question,NULL,LAYOUT_CENTER_X+0*LAYOUT_RIGHT+0*JUSTIFY_RIGHT+LAYOUT_FILL_ROW);

   local buttons=fox.FXHorizontalFrame(vframe,FRAME_NONE+LAYOUT_FILL_X+PACK_UNIFORM_WIDTH)
   local i
   print(getn(answers))
   for i=1, getn(answers), 1 do
      fox.FXButton(buttons,answers[i],NULL,dialog,FXDialogBox.ID_ACCEPT+1-i,
		   FRAME_THICK+FRAME_RAISED);
   end   

   dialog:create()
   local res = dialog:execute()
   
   dialog:delete()

   --print("FXAsk", res)
   return res
end

-- Windoz specific
WM_CAPTURECHANGED = 533
WM_MOUSELEAVE = 512+10*16+3
--function FXDispatchEvent(hwnd, iMsg, wParam, lParam)

   --print(WM_CAPTURECHANGED)
   --if mainWindow and iMsg == WM_CAPTURECHANGED and hwnd == FXGetId(mainWindow) then

--   if iMsg == WM_CAPTURECHANGED then -- and lParam == 0 then
--      print("DispatchEvent", hwnd, iMsg, wParam, lParam)
--      return 1
--   end
--   if iMsg == WM_MOUSELEAVE then
--      print("DispatchEvent", hwnd, iMsg, wParam, lParam)
--      return 1
--   end

--   if 1 or iMsg == 1024+1 then
--      --exit(0)
--      print("DispatchEvent", hwnd, iMsg, wParam, lParam)
--      return 1
--   end
--end



return 1
