--
-- LLRNet - network part of LLR
--
-- (C) 2004-2005 Vincent Penne
--
-- Released under GNU LIBRARY GENERAL PUBLIC LICENSE
-- (See file LICENSE that must be included with this software)
--

if loaded_libs then
   return 1
end

--print("Running 'init.lua' ...")

loaded_libs = { init = 1 }

function dolib(name, force)
   if not force and loaded_libs[name] then
      return 1
   end

--   print(format("Loading library '%s' ...", name))
   if not dofile(EXEDIR..name..".lua") then
      print(" --> FAILED !")
      return
   end

   loaded_libs[name] = 1

   return 1
end

-- lua 4 compatibility code
format = string.format

getn = table.getn
tinsert = table.insert
tremove = table.remove

min = math.min
max = math.max

openfile = io.open
closefile = io.close
function read(file, f)
   if f == "*w" then
      local res = ""
      local c = file:read(1)
      if not c then
	 return nil
      end
      while string.find(c, "%s") do
	 c = file:read(1)
	 if not c then
	    return nil
	 end
      end
      while not string.find(c, "%s") do
	 res = res..c
	 c = file:read(1)
	 if not c then
	    break
	 end
      end
      return res
   else
      return file:read(f)
   end
end
function write(file, s)
   file:write(s)
end

sort = table.sort
execute = os.execute
date = os.date
exit = os.exit
strrep = string.rep

return 1

