#include "FlTextOutput.h"
#include <FL/fl_draw.H>
//#include <FL/Fl_Boxtype.H>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#define MAX_LINES 200

// Win32 specific 

#define FIXED_FONT 5
#define FIXED_FONTSIZE 12


static void sb_cb(Fl_Widget* o, void* p)
{
  FlTextOutput* to = (FlTextOutput*) p;

  //  printf("CALLBACK %d !\n", to->sb->value());

  if (to->sb->value() < to->nbl)
    to->o->position(to->l[to->sb->value()]);
  else
    to->o->position(to->cursize);

  to->redraw();
}

FlTextOutput::FlTextOutput(int x, int y, int w, int h, char* L) :
  Fl_Group(x, y, w, h, L)
{
  sb = new Fl_Scrollbar(x+w-15, y, 15, h);
  o = new Fl_Multiline_Output(x, y, w-15, h);
  resizable(o);
  l =  (int*) malloc(sizeof(int)*16);
  szl = 16;
  nbl = 0;
  sb->value(nbl, h/12, 0, nbl);
  sb->callback(sb_cb, this);
  end();
  text = (char*) malloc(1);
  *text = 0;
  cursize = 0;
  ctext = 0;
  changed_textsize = 0;
  wt = 8;
}


FlTextOutput::~FlTextOutput()
{
  delete sb;
  delete o;
  free(l);
  free(text);
  if (ctext) free(ctext);
}

void FlTextOutput::add(const char* s)
{
  int olds = cursize, sz = strlen(s);
  cursize += sz;
  if (text) text = (char*) realloc(text, cursize+1);
  memcpy(text+olds, s, sz+1);
  const char* m = text;
  int n = cursize;
  if (nbl == 0)
    l[nbl++] = 0;
  for (int i=l[nbl-1]; i<n; i++)
    if (m[i] == '\12' && i+1<n) {
      if (nbl == szl) {
	szl *= 2;
	l = (int*) realloc(l, sizeof(int)*szl);
      }
      l[nbl++] = i+1;
    }
  if (nbl > MAX_LINES) {
    int n = nbl-MAX_LINES;
    nbl = MAX_LINES;
    memmove(l, l+n, nbl*sizeof(int));
    int i = l[0];
    memmove(text, text+i, cursize-i+1);
    cursize -= i;
    for (int j=0; j<nbl; j++) 
      l[j] -= i;
  }
  sb->value(nbl, h()/12, 0, nbl);
  //o->position(cursize);
  cesure();
  o->position(cursize);
  //  o->position(0);
}

void FlTextOutput::cesure()
{
#ifdef WIN32
  if (!changed_textsize) {
//    o->text_size(text_size()-1);
    o->textsize(FIXED_FONTSIZE);
    o->textfont(FIXED_FONT);
    changed_textsize = 1;
  }
#endif

  char* octext = ctext;
  ctext = (char*) malloc(cursize+1);
  memcpy(ctext, text, cursize+1);

  for (int i=0; i<nbl; i++) {
    char* m = ctext + l[i];
    int x = 0;
    int end = i+1<nbl? l[i+1]:cursize;
    char* lastw = m;
    while (m<ctext + end) {
      if (*m == ' ') lastw = m;
      m++;
      x++;
      if (x*wt > o->w()-10) {
	*lastw = '\12';
	m = lastw+1;
	int i = (o->w())/wt;
	lastw += i>0? i:1;
	x = 0;
      }
    }
  }

  int opos = o->position();
  if (o->static_value(ctext, cursize)) {
    if (octext) free(octext);
  } else {
    free(ctext);
    ctext = octext;
  }
  o->position(opos);
}

void FlTextOutput::resize(int x, int y, int w, int h)
{
  //  printf("LAYOUT !\n");
  Fl_Group::resize(x, y, w, h);
  cesure();
}

void FlTextOutput::clear()
{
  if (o->static_value("") && ctext) {
    free(ctext);
    ctext = 0;
  }
  free(text);
  text = (char*) malloc(1);
  *text = 0;
  cursize = 0;
  nbl = 0;
}


void FlTextOutput::no_scrollbar()
{
  sb->hide();
  o->resize(x(), y(), w(), h());
}

int FlTextOutput::handle(int event)
{
  switch(event) {
  case FL_FOCUS:
    return 0;
  default:
    return Fl_Group::handle(event);
  }
}
