#ifndef FL_TEXT_OUTPUT_H
#define FL_TEXT_OUTPUT_H

#include <FL/Fl_Multiline_Output.H>
#include <FL/Fl_Scrollbar.H>
#include <FL/Fl_Group.H>


class FlTextOutput : public Fl_Group {
  char* text;
  char* ctext;
  int wt;
  bool changed_textsize;
 public:
  int cursize;
  Fl_Scrollbar* sb;
  Fl_Multiline_Output* o;
  int nbl, szl;
  int* l;

  FlTextOutput(int x, int y, int w, int h, char* l=0);
  ~FlTextOutput();

  void resize(int, int, int, int);
  int handle(int event);

  void add(const char* s);
  void text_size(int size) { o->textsize(size); }
  void text_color(Fl_Color c) { o->textcolor(c); }
  void text_font(Fl_Font f) { o->textfont(f); }
  void text_background(Fl_Color c) { /*Fl_Group::text_background(c); o->text_background(c);*/ }
  void color(Fl_Color c) { Fl_Group::color(c); o->color(c); /*o->text_background(c);*/ }
  void box(Fl_Boxtype b) { Fl_Group::box(b); o->box(b); }
  void cesure();
  void clear();
  void no_scrollbar();
};

#endif
