#include "fox.cxx"

extern "C" {
#include <lua.h>
#include <lauxlib.h>
#include <lualib.h>
}


static lua_State * S;

#define LLR_LOCK

static int needlock;

#ifdef LLR_LOCK

extern "C" void llrnet_lua_lock();
extern "C" void llrnet_lua_unlock();
# define lock llrnet_lua_lock
# define unlock llrnet_lua_unlock

#else

static void dummy() { }
# define lock dummy
# define unlock dummy

#endif


// template<class parent> class FXDynamic : public class parent {
  
// };


#include "bind-fox.h"

#ifdef LUA5
#define lua_push_type(__S__,  v, type) _lua_push_class(__S__, v, &type__##type)

/// Macro to set up class declaration
#define FXLUADECL(classname) \
  public: \
   int overiden; \
   virtual long handle(FXObject* sender,FXSelector sel,void* ptr) { \
     if (1||overiden) { \
       int old_needlock = needlock; \
       if (old_needlock) { lock(); needlock = 0; } \
       lua_getglobal(S, "FXCallback"); \
       lua_push_type(S, this, classname); \
       lua_push_type(S, sender, FXObject); \
       lua_pushnumber(S, (double) (sel&0xffff)); \
       int rsel = sel>>16; \
       lua_pushnumber(S, rsel); \
       if (rsel >= SEL_KEYPRESS && rsel <= SEL_MOTION) { \
         FXEvent* event=(FXEvent*)ptr; \
         lua_pushnumber(S, event->root_x); \
         lua_pushnumber(S, event->root_y); \
         lua_pushnumber(S, event->state); \
         lua_pushnumber(S, event->code); \
         lua_call(S, 8, 1); \
       } else { \
         lua_pushnumber(S, (double) (long) ptr); \
         lua_call(S, 5, 1); \
       } \
       long res = (long) lua_tonumber(S, -1); \
       lua_pop(S, 1); \
       if (old_needlock) { needlock = 1; unlock(); } \
       return res || classname::handle(sender, sel, ptr); \
     } else \
       return classname::handle(sender, sel, ptr); \
   }
#else // ifdef LUA5
#define lua_push_type(__S__, __BS__,  v, type) \
   { void * __PTR__ = (void *) v; \
     if (__PTR__) \
       lua_pushusertag(__S__, __PTR__, __BS__->type__##type.tag); \
     else \
       lua_pushnil(__S__); \
   }

/// Macro to set up class declaration
#define FXLUADECL(classname) \
  public: \
   int overiden; \
   virtual long handle(FXObject* sender,FXSelector sel,void* ptr) { \
     if (1||overiden) { \
       lua_fox_State * __BS__ = get_lua_fox_State(S); \
       lua_getglobal(S, "FXCallback"); \
       lua_push_type(S, __BS__, this, classname); \
       lua_push_type(S, __BS__, sender, FXObject); \
       lua_pushnumber(S, (double) (sel&0xffff)); \
       lua_pushnumber(S, (double) (sel>>16)); \
       lua_call(S, 4, 1); \
       long res = (long) lua_tonumber(S, -1); \
       lua_pop(S, 1); \
       return res || classname::handle(sender, sel, ptr); \
     } else \
       return classname::handle(sender, sel, ptr); \
   }
#endif


#if 1

#include "bind-fox-overide.h"

class _bind_lua_foxFXApp2 : public FXApp {
public:
  _bind_lua_foxFXApp2(const class FXString & __ARG__1="Application", const class FXString & __ARG__2="FoxDefault") : 
    FXApp(__ARG__1, __ARG__2){ }
  
  FXint run() { FXint res; int ol = needlock; needlock = 1; unlock(); res = FXApp::run(); lock(); needlock = ol; return res; }
  FXint runModalWhileShown(FXWindow * w) { FXint res; int ol = needlock; needlock = 1; unlock(); res = FXApp::runModalWhileShown(w); lock(); needlock = ol; return res; }
#ifdef WIN32xxx
  static unsigned int msg;
  static unsigned int wparam;
  static long lparam;
  long dispatchEvent(FXID hwnd,unsigned int iMsg,unsigned int wParam,long lParam) 
  { 
//     printf("calling FXDispatchEvent iMsg=%d, wParam=%d, lParam=%x, hwnd=%x\n", iMsg, wParam, lParam, hwnd);
//     return FXApp::dispatchEvent(hwnd, iMsg, wParam, lParam);

#if 0
    if (iMsg != 333 && msg == 333) {
      //      msg = 0;
      printf("YEAH !!!!\n");
    }
    if (iMsg == 333) {
      msg=333;
      wparam=wParam;
      lparam=lParam;
    }
    return FXApp::dispatchEvent(hwnd, iMsg, wParam, lParam);
#endif
    
    if (iMsg < WM_USER)
      return FXApp::dispatchEvent(hwnd, iMsg, wParam, lParam);

    int old_needlock = needlock; 
    if (old_needlock) { lock(); needlock = 0; } 
    //lock();
    lua_getglobal(S, "FXDispatchEvent"); 
    lua_pushlightuserdata(S, hwnd);
    lua_pushnumber(S, iMsg);
    lua_pushnumber(S, wParam);
    lua_pushnumber(S, lParam);
    lua_call(S, 4, 1); 
    long res = (long) lua_tonumber(S, -1); 
    lua_pop(S, 1); 
    if (old_needlock) { needlock = 1; unlock(); }
    //unlock();
    //printf("--> %d\n", res);
    if (res) {
      //printf("QUOI ?!?!?!?!?!\n");
      return res;
      //return FXApp::dispatchEvent(hwnd, lParam, 0, 0);
    } else
      return FXApp::dispatchEvent(hwnd, iMsg, wParam, lParam);
  }
#endif
};
#define FXApp _bind_lua_foxFXApp2



class _bind_lua_foxFXDialogBox2 : public FXDialogBox {
public:
  _bind_lua_foxFXDialogBox2(class FXWindow * __ARG__1, const class FXString & __ARG__2, FXuint __ARG__3=DECOR_TITLE|DECOR_BORDER, FXint __ARG__4=0, FXint __ARG__5=0, FXint __ARG__6=0, FXint __ARG__7=0, FXint __ARG__8=10, FXint __ARG__9=10, FXint __ARG__10=10, FXint __ARG__11=10, FXint __ARG__12=4, FXint __ARG__13=4) : 
    FXDialogBox(__ARG__1, __ARG__2, __ARG__3, __ARG__4, __ARG__5, __ARG__6, __ARG__7, __ARG__8, __ARG__9, __ARG__10, __ARG__11, __ARG__12, __ARG__13){ }
  _bind_lua_foxFXDialogBox2(class FXApp * __ARG__1, const class FXString & __ARG__2, FXuint __ARG__3=DECOR_TITLE|DECOR_BORDER, FXint __ARG__4=0, FXint __ARG__5=0, FXint __ARG__6=0, FXint __ARG__7=0, FXint __ARG__8=10, FXint __ARG__9=10, FXint __ARG__10=10, FXint __ARG__11=10, FXint __ARG__12=4, FXint __ARG__13=4) : 
    FXDialogBox(__ARG__1, __ARG__2, __ARG__3, __ARG__4, __ARG__5, __ARG__6, __ARG__7, __ARG__8, __ARG__9, __ARG__10, __ARG__11, __ARG__12, __ARG__13){ }

  FXuint execute(FXuint placement=PLACEMENT_CURSOR) { FXuint res; int ol = needlock; needlock = 1; unlock(); res = FXDialogBox::execute(placement); lock(); needlock = ol; return res; }
  
};
#define FXDialogBox _bind_lua_foxFXDialogBox2


#else

class FXLWindow : public FXWindow {
  FXLUADECL(FXWindow)
  FXLWindow(FXComposite* p,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0) :
    FXWindow(p, opts, x, y, w, h) { }
};
#define FXWindow FXLWindow

class FXLMainWindow : public FXMainWindow {
  FXLUADECL(FXMainWindow)
  FXLMainWindow(FXApp* a,const FXString& name,FXIcon *ic=NULL,FXIcon *mi=NULL,FXuint opts=DECOR_ALL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=0,FXint pr=0,FXint pt=0,FXint pb=0,FXint hs=0,FXint vs=0) :
    FXMainWindow(a, name, ic, mi, opts, x, y, w, h, pl, pr, pt, pb, hs, vs) { }
};
#define FXMainWindow FXLMainWindow
#endif



#define init_lua_fox_State _init_lua_fox_State
#include "bind-fox.cxx"
#undef init_lua_fox_State



extern int g_argc;
extern char * * g_argv;
int lua_fox__FXApp__init(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
#ifndef LUA5
  lua_fox_State * __BS__ = get_lua_fox_State(__S__);
#endif
  int __ERROR__ = 0;
	
  FXApp * self;
#ifdef LUA5
  self = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
#else
  self = ( class FXApp * )lua_to_FXApp(__S__, __BS__, 1, &__ERROR__);
#endif
  
  if (__ERROR__)
    return 0;

  if (lua_isnil(__S__, 2))
    ; //self->callback(0);
  else {
    self->init(g_argc, g_argv);
  }

  return 0;
}


#ifdef LUA5
int lua_fox_SendCommand(lua_State * S)
{
  int err = 0;
  FXObject * obj = lua_to_FXObject(S, 1, &err);
  FXObject * sender = lua_to_FXObject(S, 2, &err);
  if (!err && obj)
    obj->handle(sender,MKUINT((int)lua_tonumber(S, 3), (int)lua_tonumber(S, 4)),(void *) (int)lua_tonumber(S, 5));
}

int lua_fox__FXObjectAddress(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXObject * object = lua_to_FXObject(__S__, 1, &__ERROR__);
  lua_settop(__S__, 0);
  if (!__ERROR__ && object) {
    lua_pushlightuserdata(__S__, object);
    return 1;
  } else
    return 0;
}

int lua_fox__FXGetId(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXId * object = lua_to_FXId(__S__, 1, &__ERROR__);
  lua_settop(__S__, 0);
  if (!__ERROR__ && object) {
    lua_pushlightuserdata(__S__, (void *) object->id());
    return 1;
  } else
    return 0;
}

#ifdef WIN32
extern "C" {
#include <winsock2.h>
}
int lua_fox_addEvent(lua_State * S)
{
  int err = 0;
  FXApp * app = lua_to_FXApp(S, 1, &err);
  int socket = (int) lua_tonumber(S, 2);
  int mode = (int)lua_tonumber(S, 3);
  if (err || !app)
    return 0;

  WSAEVENT event = WSACreateEvent();
  if (!event)
    return 0;

  if (WSAEventSelect(socket, event, ((mode&INPUT_READ)? FD_READ:0)|
		     ((mode&INPUT_EXCEPT)? FD_CLOSE:0)|
		     ((mode&INPUT_WRITE)? FD_WRITE:0))) {
    WSACloseEvent(event);
    return 0;
  }

  app->addInput(event, (int) lua_tonumber(S, 3), lua_to_FXObject(S, 4, &err), (int) lua_tonumber(S, 5));

  lua_pushlightuserdata(S, event);

  return 1;
}

int lua_fox_removeEvent(lua_State * S)
{
  int err = 0;
  FXApp * app = lua_to_FXApp(S, 1, &err);
  WSAEVENT event = lua_touserdata(S, 2);
  if (err || !app)
    return 0;

  app->removeInput(event, (int) lua_tonumber(S, 3));
  WSACloseEvent(event);
  return 0;
}

int lua_fox_enumEvent(lua_State * S)
{
  WSANETWORKEVENTS events;
  WSAEnumNetworkEvents((int)lua_tonumber(S, 1), lua_touserdata(S, 2), &events);
  return 0;
}

int lua_fox_selectEvent(lua_State * S)
{
  int socket = (int)lua_tonumber(S, 1);
  WSAEVENT event = lua_touserdata(S, 2);
  int mode = (int) lua_tonumber(S, 3);
  WSAEventSelect(socket, event, ((mode&INPUT_READ)? FD_READ:0)|
		 ((mode&INPUT_EXCEPT)? FD_CLOSE:0)|
		 ((mode&INPUT_WRITE)? FD_WRITE:0));
  if (!mode) {
    u_long mode = 0;
    ioctlsocket(socket, FIONBIO, &mode);
  }
  return 0;
}

int lua_fox_resetEvent(lua_State * S)
{
  WSAResetEvent(lua_touserdata(S, 1));
  return 0;
}
#endif

#endif

int init_lua_fox_State(lua_State * _S)
{
  S = _S;

#ifdef LUA5
  int BS = !_init_lua_fox_State(S);

  lua_register(S, "FXObjectAddress", lua_fox__FXObjectAddress);
  lua_register(S, "FXGetId", lua_fox__FXGetId);
  lua_register(S, "FXSendCommand", lua_fox_SendCommand);
# ifdef WIN32
  lua_register(S, "FXaddEvent", lua_fox_addEvent);
  lua_register(S, "FXremoveEvent", lua_fox_removeEvent);
  lua_register(S, "FXenumEvent", lua_fox_enumEvent);
  lua_register(S, "FXselectEvent", lua_fox_selectEvent);
  lua_register(S, "FXresetEvent", lua_fox_resetEvent);
# endif
#else
  lua_fox_State * BS = _init_lua_fox_State(S);
#endif

  lua_register(S, "fox_init", lua_fox__FXApp__init);
  lua_dostring(S, 
"bind_lua_addtovtable(FXApp, 'init', fox_init) \n"
"fox_init = nil \n"
);

  return BS? 0 : -1;
}

