/* Start of template START_BIND_CODE */


/* this exists in lua 5.1 but not lua 5.0 */
static void _lua_setfield(lua_State * __S__, int p, const char * idx)
{
  if (p < 0) p--;
  lua_pushstring(__S__, idx);
  lua_pushvalue(__S__, -2);
  lua_remove(__S__, -3);
  lua_settable(__S__, p);
}


void _lua_push_class(lua_State * __S__, 
			    void * __PTR__, lua_type_t * type)
{
  if (__PTR__) {
    void * * u = (void * *) lua_newuserdata(__S__, sizeof(void *));
    luaL_getmetatable(__S__, type->name);
    lua_setmetatable(__S__, -2);
    *u = __PTR__;
  } else
    lua_pushnil(__S__);
}

void * _lua_to_class(lua_State * __S__, int pos, int * __ERROR__, lua_type_t * wanted_type)
{
  int iscompat;
  {
    if (lua_isnil(__S__, pos))
	return 0;
    if (!lua_getmetatable(__S__, pos))
      goto error;
    lua_pushlightuserdata(__S__, wanted_type);
    lua_gettable(__S__, -2);
    iscompat = !lua_isnil(__S__, -1);
    lua_pop(__S__, 2);
    if (iscompat)
      return *(void * *)lua_touserdata(__S__, pos);
  error:
/*     printf("bind-lua : could not cast from %s to %s !\n",  */
/* 	   tn, wanted_type->name); */
    *__ERROR__ = -1;
    return 0;
  }
}

static int lua_settable_tagmethod(lua_State * S)
{
  lua_pushvalue(S, 2);
  lua_gettable(S, lua_upvalueindex(1));
  lua_pushvalue(S, 1);
  lua_pushvalue(S, 3);
  lua_call(S, 2, 0);
  return 0;
}

static int lua_gettable_tagmethod_f(lua_State * S)
{
  lua_remove(S, 1);
  lua_gettable(S, lua_upvalueindex(1));
  return 1;
}

static int lua_gettable_tagmethod_v(lua_State * S)
{
  lua_gettable(S, lua_upvalueindex(1));
  lua_pushvalue(S, 1);
  lua_remove(S, 1);
  lua_call(S, 1, 1);
  return 1;
}

static int lua_gettable_tagmethod_fv(lua_State * S)
{
  lua_pushvalue(S, 2);
  lua_gettable(S, lua_upvalueindex(2));
  if (lua_isnil(S, 3)) {
    lua_remove(S, 3);
    lua_gettable(S, lua_upvalueindex(1));
  } else {
    lua_remove(S, 2);
    lua_pushvalue(S, 1);
    lua_remove(S, 1);
    lua_call(S, 1, 1);
  }
  return 1;
}


/* End of template 2
 */
int lua_delete_FXDC(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDC * p = lua_to_FXDC(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXObject__FXMapEntry(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXObject__FXMapEntry(__S__, new FXObject::FXMapEntry);
  return 1;
}

int lua_delete_FXObject__FXMapEntry(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXObject::FXMapEntry * p = lua_to_FXObject__FXMapEntry(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXObject(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXObject(__S__, new FXObject);
  return 1;
}

int lua_delete_FXObject(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXObject * p = lua_to_FXObject(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXTablePos(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXTablePos(__S__, new FXTablePos);
  return 1;
}

int lua_delete_FXTablePos(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXTablePos * p = lua_to_FXTablePos(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDVec(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDVec * p = lua_to_FXDVec(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXPoint(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXPoint * p = lua_to_FXPoint(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXMaterial(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXMaterial(__S__, new FXMaterial);
  return 1;
}

int lua_delete_FXMaterial(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMaterial * p = lua_to_FXMaterial(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXVec(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXVec * p = lua_to_FXVec(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXRange(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXRange * p = lua_to_FXRange(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXArc(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXArc(__S__, new FXArc);
  return 1;
}

int lua_delete_FXArc(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXArc * p = lua_to_FXArc(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXTableRange(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXTableRange(__S__, new FXTableRange);
  return 1;
}

int lua_delete_FXTableRange(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXTableRange * p = lua_to_FXTableRange(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXRectangle(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXRectangle * p = lua_to_FXRectangle(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXRegion(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXRegion * p = lua_to_FXRegion(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXLfloat(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXLfloat * p = lua_to_FXLfloat(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXSize(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXSize * p = lua_to_FXSize(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXLint(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXLint * p = lua_to_FXLint(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXRawEvent(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXRawEvent(__S__, new FXRawEvent);
  return 1;
}

int lua_delete_FXRawEvent(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXRawEvent * p = lua_to_FXRawEvent(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXViewport(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXViewport(__S__, new FXViewport);
  return 1;
}

int lua_delete_FXViewport(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXViewport * p = lua_to_FXViewport(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXObjectList(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXObjectList * p = lua_to_FXObjectList(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXFontDesc(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXFontDesc(__S__, new FXFontDesc);
  return 1;
}

int lua_delete_FXFontDesc(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXFontDesc * p = lua_to_FXFontDesc(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXPSBounds(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXPSBounds(__S__, new FXPSBounds);
  return 1;
}

int lua_delete_FXPSBounds(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXPSBounds * p = lua_to_FXPSBounds(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXException(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXException * p = lua_to_FXException(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXCommand(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXCommand * p = lua_to_FXCommand(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDHVec(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDHVec * p = lua_to_FXDHVec(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXEvent(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXEvent(__S__, new FXEvent);
  return 1;
}

int lua_delete_FXEvent(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXEvent * p = lua_to_FXEvent(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDHMat(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDHMat * p = lua_to_FXDHMat(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXMetaClass(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXMetaClass(__S__, new FXMetaClass);
  return 1;
}

int lua_delete_FXMetaClass(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMetaClass * p = lua_to_FXMetaClass(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXLight(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXLight(__S__, new FXLight);
  return 1;
}

int lua_delete_FXLight(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXLight * p = lua_to_FXLight(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXFileAssoc(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXFileAssoc(__S__, new FXFileAssoc);
  return 1;
}

int lua_delete_FXFileAssoc(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXFileAssoc * p = lua_to_FXFileAssoc(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXPrinter(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXPrinter(__S__, new FXPrinter);
  return 1;
}

int lua_delete_FXPrinter(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXPrinter * p = lua_to_FXPrinter(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXStream(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXStream * p = lua_to_FXStream(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXHVec(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXHVec * p = lua_to_FXHVec(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXLdouble(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXLdouble * p = lua_to_FXLdouble(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXCharset(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXCharset * p = lua_to_FXCharset(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXSegment(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXSegment(__S__, new FXSegment);
  return 1;
}

int lua_delete_FXSegment(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXSegment * p = lua_to_FXSegment(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXStreamHashEntry(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXStreamHashEntry(__S__, new FXStreamHashEntry);
  return 1;
}

int lua_delete_FXStreamHashEntry(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXStreamHashEntry * p = lua_to_FXStreamHashEntry(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_new_FXHiliteStyle(lua_State * __S__)
{
  lua_settop(__S__, 0);
  lua_push_FXHiliteStyle(__S__, new FXHiliteStyle);
  return 1;
}

int lua_delete_FXHiliteStyle(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXHiliteStyle * p = lua_to_FXHiliteStyle(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXHMat(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXHMat * p = lua_to_FXHMat(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXFileStream(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXFileStream * p = lua_to_FXFileStream(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDict(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDict * p = lua_to_FXDict(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDebugTarget(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDebugTarget * p = lua_to_FXDebugTarget(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXId(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXId * p = lua_to_FXId(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDataTarget(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDataTarget * p = lua_to_FXDataTarget(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXErrorException(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXErrorException * p = lua_to_FXErrorException(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXIconItem(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXIconItem * p = lua_to_FXIconItem(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXUndoList(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXUndoList * p = lua_to_FXUndoList(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXRecentFiles(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXRecentFiles * p = lua_to_FXRecentFiles(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMemoryStream(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMemoryStream * p = lua_to_FXMemoryStream(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXListItem(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXListItem * p = lua_to_FXListItem(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXApp(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXApp * p = lua_to_FXApp(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDCWindow(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDCWindow * p = lua_to_FXDCWindow(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXTableItem(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXTableItem * p = lua_to_FXTableItem(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXAccelTable(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXAccelTable * p = lua_to_FXAccelTable(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXQuat(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXQuat * p = lua_to_FXQuat(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXHeaderItem(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXHeaderItem * p = lua_to_FXHeaderItem(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDelegator(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDelegator * p = lua_to_FXDelegator(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXResourceException(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXResourceException * p = lua_to_FXResourceException(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDocument(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDocument * p = lua_to_FXDocument(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXTreeItem(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXTreeItem * p = lua_to_FXTreeItem(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDCPrint(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDCPrint * p = lua_to_FXDCPrint(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDQuat(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDQuat * p = lua_to_FXDQuat(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDrawable(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDrawable * p = lua_to_FXDrawable(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXSettings(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXSettings * p = lua_to_FXSettings(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXLDataTarget(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXLDataTarget * p = lua_to_FXLDataTarget(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXFont(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXFont * p = lua_to_FXFont(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDirItem(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDirItem * p = lua_to_FXDirItem(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXPointerException(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXPointerException * p = lua_to_FXPointerException(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXRangeException(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXRangeException * p = lua_to_FXRangeException(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXFileItem(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXFileItem * p = lua_to_FXFileItem(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXCursor(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXCursor * p = lua_to_FXCursor(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXStringDict(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXStringDict * p = lua_to_FXStringDict(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXFileDict(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXFileDict * p = lua_to_FXFileDict(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMemoryException(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMemoryException * p = lua_to_FXMemoryException(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXVisual(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXVisual * p = lua_to_FXVisual(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXIconDict(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXIconDict * p = lua_to_FXIconDict(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXWindow(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXWindow * p = lua_to_FXWindow(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXImage(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXImage * p = lua_to_FXImage(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXBitmap(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXBitmap * p = lua_to_FXBitmap(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXRegistry(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXRegistry * p = lua_to_FXRegistry(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXGIFCursor(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXGIFCursor * p = lua_to_FXGIFCursor(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXFrame(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXFrame * p = lua_to_FXFrame(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXComposite(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXComposite * p = lua_to_FXComposite(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXIcon(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXIcon * p = lua_to_FXIcon(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDragCorner(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDragCorner * p = lua_to_FXDragCorner(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXBMPImage(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXBMPImage * p = lua_to_FXBMPImage(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMenuSeparator(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMenuSeparator * p = lua_to_FXMenuSeparator(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXCanvas(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXCanvas * p = lua_to_FXCanvas(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXTGAImage(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXTGAImage * p = lua_to_FXTGAImage(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXScrollCorner(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXScrollCorner * p = lua_to_FXScrollCorner(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXPCXImage(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXPCXImage * p = lua_to_FXPCXImage(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXScrollbar(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXScrollbar * p = lua_to_FXScrollbar(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMenuCaption(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMenuCaption * p = lua_to_FXMenuCaption(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXGIFImage(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXGIFImage * p = lua_to_FXGIFImage(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXToolbarGrip(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXToolbarGrip * p = lua_to_FXToolbarGrip(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXSlider(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXSlider * p = lua_to_FXSlider(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXShell(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXShell * p = lua_to_FXShell(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXHeader(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXHeader * p = lua_to_FXHeader(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXSplitter(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXSplitter * p = lua_to_FXSplitter(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMenuCascade(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMenuCascade * p = lua_to_FXMenuCascade(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXLabel(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXLabel * p = lua_to_FXLabel(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMenuCommand(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMenuCommand * p = lua_to_FXMenuCommand(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXColorWell(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXColorWell * p = lua_to_FXColorWell(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXArrowButton(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXArrowButton * p = lua_to_FXArrowButton(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMDIChild(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMDIChild * p = lua_to_FXMDIChild(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMenuTitle(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMenuTitle * p = lua_to_FXMenuTitle(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXToolbarTab(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXToolbarTab * p = lua_to_FXToolbarTab(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXGIFIcon(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXGIFIcon * p = lua_to_FXGIFIcon(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXColorBar(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXColorBar * p = lua_to_FXColorBar(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXVerticalSeparator(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXVerticalSeparator * p = lua_to_FXVerticalSeparator(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXTGAIcon(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXTGAIcon * p = lua_to_FXTGAIcon(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXColorWheel(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXColorWheel * p = lua_to_FXColorWheel(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXScrollArea(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXScrollArea * p = lua_to_FXScrollArea(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXRootWindow(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXRootWindow * p = lua_to_FXRootWindow(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXHorizontalSeparator(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXHorizontalSeparator * p = lua_to_FXHorizontalSeparator(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXPCXIcon(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXPCXIcon * p = lua_to_FXPCXIcon(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXPacker(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXPacker * p = lua_to_FXPacker(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXTextField(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXTextField * p = lua_to_FXTextField(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FX4Splitter(lua_State * __S__)
{
  int __ERROR__ = 0;
  FX4Splitter * p = lua_to_FX4Splitter(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXBMPIcon(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXBMPIcon * p = lua_to_FXBMPIcon(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXProgressBar(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXProgressBar * p = lua_to_FXProgressBar(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXStatusline(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXStatusline * p = lua_to_FXStatusline(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDial(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDial * p = lua_to_FXDial(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDirSelector(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDirSelector * p = lua_to_FXDirSelector(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXImageView(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXImageView * p = lua_to_FXImageView(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMenuButton(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMenuButton * p = lua_to_FXMenuButton(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXText(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXText * p = lua_to_FXText(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXHorizontalFrame(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXHorizontalFrame * p = lua_to_FXHorizontalFrame(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXRadioButton(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXRadioButton * p = lua_to_FXRadioButton(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXFontSelector(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXFontSelector * p = lua_to_FXFontSelector(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXTabBar(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXTabBar * p = lua_to_FXTabBar(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXGroupBox(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXGroupBox * p = lua_to_FXGroupBox(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXFileSelector(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXFileSelector * p = lua_to_FXFileSelector(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMatrix(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMatrix * p = lua_to_FXMatrix(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXListBox(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXListBox * p = lua_to_FXListBox(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXTable(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXTable * p = lua_to_FXTable(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXOption(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXOption * p = lua_to_FXOption(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXSwitcher(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXSwitcher * p = lua_to_FXSwitcher(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXComboBox(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXComboBox * p = lua_to_FXComboBox(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXTopWindow(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXTopWindow * p = lua_to_FXTopWindow(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXColorSelector(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXColorSelector * p = lua_to_FXColorSelector(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXSpinner(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXSpinner * p = lua_to_FXSpinner(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXOptionMenu(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXOptionMenu * p = lua_to_FXOptionMenu(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXCheckButton(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXCheckButton * p = lua_to_FXCheckButton(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXTreeList(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXTreeList * p = lua_to_FXTreeList(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXTabItem(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXTabItem * p = lua_to_FXTabItem(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXToolbar(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXToolbar * p = lua_to_FXToolbar(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXToggleButton(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXToggleButton * p = lua_to_FXToggleButton(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXList(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXList * p = lua_to_FXList(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMDIClient(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMDIClient * p = lua_to_FXMDIClient(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXPopup(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXPopup * p = lua_to_FXPopup(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXVerticalFrame(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXVerticalFrame * p = lua_to_FXVerticalFrame(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXTreeListBox(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXTreeListBox * p = lua_to_FXTreeListBox(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXButton(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXButton * p = lua_to_FXButton(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXTooltip(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXTooltip * p = lua_to_FXTooltip(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXScrollWindow(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXScrollWindow * p = lua_to_FXScrollWindow(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXIconList(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXIconList * p = lua_to_FXIconList(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMDIRestoreButton(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMDIRestoreButton * p = lua_to_FXMDIRestoreButton(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMDIDeleteButton(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMDIDeleteButton * p = lua_to_FXMDIDeleteButton(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDriveBox(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDriveBox * p = lua_to_FXDriveBox(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDialogBox(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDialogBox * p = lua_to_FXDialogBox(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXShutterItem(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXShutterItem * p = lua_to_FXShutterItem(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDirBox(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDirBox * p = lua_to_FXDirBox(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXToolbarShell(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXToolbarShell * p = lua_to_FXToolbarShell(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMenuPane(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMenuPane * p = lua_to_FXMenuPane(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDirList(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDirList * p = lua_to_FXDirList(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXFileList(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXFileList * p = lua_to_FXFileList(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXShutter(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXShutter * p = lua_to_FXShutter(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMenubar(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMenubar * p = lua_to_FXMenubar(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXPicker(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXPicker * p = lua_to_FXPicker(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXStatusbar(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXStatusbar * p = lua_to_FXStatusbar(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMainWindow(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMainWindow * p = lua_to_FXMainWindow(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMDIMaximizeButton(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMDIMaximizeButton * p = lua_to_FXMDIMaximizeButton(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXTabBook(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXTabBook * p = lua_to_FXTabBook(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMDIWindowButton(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMDIWindowButton * p = lua_to_FXMDIWindowButton(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMDIMinimizeButton(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMDIMinimizeButton * p = lua_to_FXMDIMinimizeButton(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXReplaceDialog(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXReplaceDialog * p = lua_to_FXReplaceDialog(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXPrintDialog(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXPrintDialog * p = lua_to_FXPrintDialog(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXProgressDialog(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXProgressDialog * p = lua_to_FXProgressDialog(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXFontDialog(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXFontDialog * p = lua_to_FXFontDialog(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXColorDialog(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXColorDialog * p = lua_to_FXColorDialog(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXDirDialog(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXDirDialog * p = lua_to_FXDirDialog(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXInputDialog(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXInputDialog * p = lua_to_FXInputDialog(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXFileDialog(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXFileDialog * p = lua_to_FXFileDialog(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMessageBox(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMessageBox * p = lua_to_FXMessageBox(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXMDIMenu(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXMDIMenu * p = lua_to_FXMDIMenu(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

int lua_delete_FXSearchDialog(lua_State * __S__)
{
  int __ERROR__ = 0;
  FXSearchDialog * p = lua_to_FXSearchDialog(__S__, 1, &__ERROR__);
  delete p;
  return 0;
}

/* const struct FXMetaClass * FXVerticalFrame::getMetaClass()const  */
int lua_call1_FXVerticalFrame__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXVerticalFrame * __self__;
    
    __self__ = ( class FXVerticalFrame * )lua_to_FXVerticalFrame(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXIconListSortFunc FXIconList::getSortFunc()const  */
/* SKIPPED (return type) */
/* void FXFileList::setCurrentFile(const class FXString & file) */
int lua_call1_FXFileList__setCurrentFile(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileList * __self__;
    
    __self__ = ( class FXFileList * )lua_to_FXFileList(__S__, 1, &__ERROR__);
    int __err__1; static FXString __cstr__1; FXString * __str__1 = lua_to_FXString(__S__, 2, &__err__1);  class FXString & file = ( class FXString & ) (__str__1? *__str__1 : (__cstr__1 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__1));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setCurrentFile(file);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXMDIRestoreButton::getMetaClass()const  */
int lua_call1_FXMDIRestoreButton__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIRestoreButton * __self__;
    
    __self__ = ( class FXMDIRestoreButton * )lua_to_FXMDIRestoreButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXVerticalSeparator::manufacture() */
int lua_call1_FXVerticalSeparator__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXVerticalSeparator::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXFontDialog::save(class FXStream & store)const  */
int lua_call1_FXFontDialog__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFontDialog * __self__;
    
    __self__ = ( class FXFontDialog * )lua_to_FXFontDialog(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXText::isModified()const  */
int lua_call1_FXText__isModified(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isModified());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXSpinner::onCmdSetValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXPrintDialog::onUpdNumCopies(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXPrintDialog::onCmdToFile(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXComboBox::setComboStyle(FXuint mode) */
int lua_call1_FXComboBox__setComboStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXComboBox * __self__;
     unsigned int mode;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    mode = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setComboStyle(mode);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTextField::makePositionVisible(FXint pos) */
int lua_call1_FXTextField__makePositionVisible(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTextField * __self__;
     int pos;
    
    __self__ = ( class FXTextField * )lua_to_FXTextField(__S__, 1, &__ERROR__);
    pos = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->makePositionVisible(pos);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXPacker::getVSpacing()const  */
int lua_call1_FXPacker__getVSpacing(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXPacker * __self__;
    
    __self__ = ( class FXPacker * )lua_to_FXPacker(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getVSpacing());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::translateCoordinatesFrom(FXint & tox, FXint & toy, const class FXWindow * fromwindow, FXint fromx, FXint fromy)const  */
int lua_call1_FXWindow__translateCoordinatesFrom(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 6) goto error;
  {
     class FXWindow * __self__;
     int tox;
     int toy;
     class FXWindow * fromwindow;
     int fromx;
     int fromy;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    tox = ( int )(int)lua_tonumber(__S__, 2);
    toy = ( int )(int)lua_tonumber(__S__, 3);
    fromwindow = ( class FXWindow * )lua_to_FXWindow(__S__, 4, &__ERROR__);
    fromx = ( int )(int)lua_tonumber(__S__, 5);
    fromy = ( int )(int)lua_tonumber(__S__, 6);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->translateCoordinatesFrom(tox, toy, fromwindow, fromx, fromy);
    lua_settop(__S__, 0);
    ;
    lua_pushnumber(__S__, tox);
    lua_pushnumber(__S__, toy);
    return 2;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::setTableSize(FXint nr, FXint nc, FXbool notify=0) */
int lua_call1_FXTable__setTableSize(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTable * __self__;
     int nr;
     int nc;
     unsigned char notify;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    nr = ( int )(int)lua_tonumber(__S__, 2);
    nc = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      __self__->setTableSize(nr, nc);
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 4);
      if (__ERROR__) goto error;
      
      __self__->setTableSize(nr, nc, notify);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXUndoList::onCmdRedoAll(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXSpinner::setIncrement(FXint increment) */
int lua_call1_FXSpinner__setIncrement(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXSpinner * __self__;
     int increment;
    
    __self__ = ( class FXSpinner * )lua_to_FXSpinner(__S__, 1, &__ERROR__);
    increment = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setIncrement(increment);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorWell::onFocusIn(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXWindow::raise() */
int lua_call1_FXWindow__raise(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->raise();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTextField::setSelTextColor(FXColor clr) */
int lua_call1_FXTextField__setSelTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTextField * __self__;
     unsigned int clr;
    
    __self__ = ( class FXTextField * )lua_to_FXTextField(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setSelTextColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTopWindow::setFocus() */
int lua_call1_FXTopWindow__setFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTopWindow * __self__;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setFocus();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXPopup * FXMenuCascade::getMenu()const  */
int lua_call1_FXMenuCascade__getMenu(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuCascade * __self__;
    
    __self__ = ( class FXMenuCascade * )lua_to_FXMenuCascade(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXPopup(__S__, __self__->getMenu());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXWindow * FXWindow::commonAncestor(class FXWindow * a, class FXWindow * b) */
int lua_call1_FXWindow__commonAncestor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXWindow * a;
     class FXWindow * b;
    
    a = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    b = ( class FXWindow * )lua_to_FXWindow(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXWindow(__S__, FXWindow::commonAncestor(a, b));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXComposite * FXToolbar::getWetDock()const  */
int lua_call1_FXToolbar__getWetDock(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbar * __self__;
    
    __self__ = ( class FXToolbar * )lua_to_FXToolbar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXComposite(__S__, __self__->getWetDock());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXProgressDialog::setMessage(const class FXString & msg) */
int lua_call1_FXProgressDialog__setMessage(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXProgressDialog * __self__;
    
    __self__ = ( class FXProgressDialog * )lua_to_FXProgressDialog(__S__, 1, &__ERROR__);
    int __err__2; static FXString __cstr__2; FXString * __str__2 = lua_to_FXString(__S__, 2, &__err__2);  class FXString & msg = ( class FXString & ) (__str__2? *__str__2 : (__cstr__2 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__2));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setMessage(msg);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXListBox::removeItem(FXint index) */
int lua_call1_FXListBox__removeItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXListBox * __self__;
     int index;
    
    __self__ = ( class FXListBox * )lua_to_FXListBox(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->removeItem(index);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMDIChild::minimize(FXbool notify=0) */
int lua_call1_FXMDIChild__minimize(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIChild * __self__;
     unsigned char notify;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->minimize();
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->minimize(notify);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDC::setFillRule(FXFillRule fillrule=RULE_EVEN_ODD) */
int lua_call1_FXDC__setFillRule(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDC * __self__;
     FXFillRule fillrule;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->setFillRule();
    } else {
      fillrule = ( FXFillRule )(FXFillRule)(int)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->setFillRule(fillrule);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXToolbar::getHeightForWidth(FXint w) */
int lua_call1_FXToolbar__getHeightForWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXToolbar * __self__;
     int w;
    
    __self__ = ( class FXToolbar * )lua_to_FXToolbar(__S__, 1, &__ERROR__);
    w = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getHeightForWidth(w));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXListBox::insertItem(FXint index, const class FXString & text, class FXIcon * icon=__null, void * ptr=__null) */
int lua_call1_FXListBox__insertItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXListBox * __self__;
     int index;
     class FXIcon * icon;
     void * ptr;
    
    __self__ = ( class FXListBox * )lua_to_FXListBox(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    int __err__3; static FXString __cstr__3; FXString * __str__3 = lua_to_FXString(__S__, 3, &__err__3);  class FXString & text = ( class FXString & ) (__str__3? *__str__3 : (__cstr__3 =(FXString) (char *)lua_tostring(__S__, 3), __cstr__3));
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      __self__->insertItem(index, text);
    } else {
      icon = ( class FXIcon * )lua_to_FXIcon(__S__, 4, &__ERROR__);
      if (nparam <= 4) {
        if (__ERROR__) goto error;
        
        __self__->insertItem(index, text, icon);
      } else {
        if (__ERROR__) goto error;
        
        __self__->insertItem(index, text, icon, ptr);
      }
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXScrollbar::getHiliteColor()const  */
int lua_call1_FXScrollbar__getHiliteColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXScrollbar * __self__;
    
    __self__ = ( class FXScrollbar * )lua_to_FXScrollbar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getHiliteColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTopWindow::onFocusLeft(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXTopWindow::getPadRight()const  */
int lua_call1_FXTopWindow__getPadRight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTopWindow * __self__;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getPadRight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXToolbarGrip::FXToolbarGrip(class FXToolbar * p, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=TOOLBARGRIP_SINGLE, FXint x=0, FXint y=0, FXint w=0, FXint h=0) */
int lua_call1_FXToolbarGrip__FXToolbarGrip(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXToolbar * p;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
    
    p = ( class FXToolbar * )lua_to_FXToolbar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXToolbarGrip(__S__, new FXToolbarGrip(p));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 2, &__ERROR__);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXToolbarGrip(__S__, new FXToolbarGrip(p, tgt));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXToolbarGrip(__S__, new FXToolbarGrip(p, tgt, sel));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXToolbarGrip(__S__, new FXToolbarGrip(p, tgt, sel, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXToolbarGrip(__S__, new FXToolbarGrip(p, tgt, sel, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 6);
              if (nparam <= 6) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXToolbarGrip(__S__, new FXToolbarGrip(p, tgt, sel, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 7);
                if (nparam <= 7) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXToolbarGrip(__S__, new FXToolbarGrip(p, tgt, sel, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 8);
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXToolbarGrip(__S__, new FXToolbarGrip(p, tgt, sel, opts, x, y, w, h));
                  return 1;
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXWindow * FXWindow::getFocus()const  */
int lua_call1_FXWindow__getFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXWindow(__S__, __self__->getFocus());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXButton::onKeyPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXMDIWindowButton::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXList::onCmdGetIntValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXMDIRestoreButton::manufacture() */
int lua_call1_FXMDIRestoreButton__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXMDIRestoreButton::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXStatusline::onUpdate(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXDirSelector::FXDirSelector(class FXComposite * p, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=0, FXint x=0, FXint y=0, FXint w=0, FXint h=0) */
int lua_call1_FXDirSelector__FXDirSelector(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXDirSelector(__S__, new FXDirSelector(p));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 2, &__ERROR__);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXDirSelector(__S__, new FXDirSelector(p, tgt));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXDirSelector(__S__, new FXDirSelector(p, tgt, sel));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXDirSelector(__S__, new FXDirSelector(p, tgt, sel, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXDirSelector(__S__, new FXDirSelector(p, tgt, sel, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 6);
              if (nparam <= 6) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXDirSelector(__S__, new FXDirSelector(p, tgt, sel, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 7);
                if (nparam <= 7) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXDirSelector(__S__, new FXDirSelector(p, tgt, sel, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 8);
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXDirSelector(__S__, new FXDirSelector(p, tgt, sel, opts, x, y, w, h));
                  return 1;
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXScrollArea::getViewportWidth() */
int lua_call1_FXScrollArea__getViewportWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXScrollArea * __self__;
    
    __self__ = ( class FXScrollArea * )lua_to_FXScrollArea(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getViewportWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FX4Splitter::getHSplit()const  */
int lua_call1_FX4Splitter__getHSplit(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FX4Splitter * __self__;
    
    __self__ = ( class FX4Splitter * )lua_to_FX4Splitter(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getHSplit());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCPrint::fillPolygonRel(const class FXPoint * points, FXuint npoints) */
int lua_call1_FXDCPrint__fillPolygonRel(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDCPrint * __self__;
     class FXPoint * points;
     unsigned int npoints;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    points = ( class FXPoint * )lua_to_FXPoint(__S__, 2, &__ERROR__);
    npoints = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->fillPolygonRel(points, npoints);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXSlider::onLeftBtnPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXButton::onUngrabbed(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXCheckButton::canFocus()const  */
int lua_call1_FXCheckButton__canFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXCheckButton * __self__;
    
    __self__ = ( class FXCheckButton * )lua_to_FXCheckButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->canFocus());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXTreeListBox::getHelpText()const  */
int lua_call1_FXTreeListBox__getHelpText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeListBox * __self__;
    
    __self__ = ( class FXTreeListBox * )lua_to_FXTreeListBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getHelpText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorWell::onCmdGetIntValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXObject::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXPopup::onButtonRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDC::setForeground(FXColor clr) */
int lua_call1_FXDC__setForeground(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDC * __self__;
     unsigned int clr;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setForeground(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const FXchar * FXException::what()const  */
int lua_call1_FXException__what(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXException * __self__;
    
    __self__ = ( class FXException * )lua_to_FXException(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, (const char * ) __self__->what());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString & FXString::vformat(const char * fmt, va_list args) */
/* SKIPPED (argument #3) */
/* long FXPrintDialog::onCmdGray(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXStatusline::manufacture() */
int lua_call1_FXStatusline__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXStatusline::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXToolbar::save(class FXStream & store)const  */
int lua_call1_FXToolbar__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXToolbar * __self__;
    
    __self__ = ( class FXToolbar * )lua_to_FXToolbar(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXReplaceDialog::onCmdDir(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXProgressBar::manufacture() */
int lua_call1_FXProgressBar__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXProgressBar::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTable::onCmdMovePageUp(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXFunction FXDC::getFunction()const  */
int lua_call1_FXDC__getFunction(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDC * __self__;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getFunction());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXShell::onConfigure(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXWindow::onLeftBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXOptionMenu::onKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXWindow::linkBefore(class FXWindow * sibling) */
int lua_call1_FXWindow__linkBefore(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXWindow * __self__;
     class FXWindow * sibling;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    sibling = ( class FXWindow * )lua_to_FXWindow(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->linkBefore(sibling);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXImageView::canFocus()const  */
int lua_call1_FXImageView__canFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXImageView * __self__;
    
    __self__ = ( class FXImageView * )lua_to_FXImageView(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->canFocus());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTopWindow::iconify() */
int lua_call1_FXTopWindow__iconify(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTopWindow * __self__;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->iconify();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTreeListBox::setHelpText(const class FXString & txt) */
int lua_call1_FXTreeListBox__setHelpText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeListBox * __self__;
    
    __self__ = ( class FXTreeListBox * )lua_to_FXTreeListBox(__S__, 1, &__ERROR__);
    int __err__4; static FXString __cstr__4; FXString * __str__4 = lua_to_FXString(__S__, 2, &__err__4);  class FXString & txt = ( class FXString & ) (__str__4? *__str__4 : (__cstr__4 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__4));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setHelpText(txt);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXColorBar::setHue(FXfloat h) */
int lua_call1_FXColorBar__setHue(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXColorBar * __self__;
     float h;
    
    __self__ = ( class FXColorBar * )lua_to_FXColorBar(__S__, 1, &__ERROR__);
    h = ( float )(float)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setHue(h);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTable::onCmdMoveBottom(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXList::ascending(const class FXListItem * a, const class FXListItem * b) */
int lua_call1_FXList__ascending(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXListItem * a;
     class FXListItem * b;
    
    a = ( class FXListItem * )lua_to_FXListItem(__S__, 1, &__ERROR__);
    b = ( class FXListItem * )lua_to_FXListItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, FXList::ascending(a, b));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXComboBox::setItemText(FXint index, const class FXString & text) */
int lua_call1_FXComboBox__setItemText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXComboBox * __self__;
     int index;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    int __err__5; static FXString __cstr__5; FXString * __str__5 = lua_to_FXString(__S__, 3, &__err__5);  class FXString & text = ( class FXString & ) (__str__5? *__str__5 : (__cstr__5 =(FXString) (char *)lua_tostring(__S__, 3), __cstr__5));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setItemText(index, text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXMDIChild * FXMDIClient::getActiveChild()const  */
int lua_call1_FXMDIClient__getActiveChild(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIClient * __self__;
    
    __self__ = ( class FXMDIClient * )lua_to_FXMDIClient(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMDIChild(__S__, __self__->getActiveChild());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXWindow * FXWindow::getFirst()const  */
int lua_call1_FXWindow__getFirst(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXWindow(__S__, __self__->getFirst());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTreeList::updateItem(class FXTreeItem * item) */
int lua_call1_FXTreeList__updateItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeList * __self__;
     class FXTreeItem * item;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->updateItem(item);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDial::getRange(FXint & lo, FXint & hi)const  */
int lua_call1_FXDial__getRange(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDial * __self__;
     int lo;
     int hi;
    
    __self__ = ( class FXDial * )lua_to_FXDial(__S__, 1, &__ERROR__);
    lo = ( int )(int)lua_tonumber(__S__, 2);
    hi = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->getRange(lo, hi);
    lua_settop(__S__, 0);
    ;
    lua_pushnumber(__S__, lo);
    lua_pushnumber(__S__, hi);
    return 2;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXText::getContentWidth() */
int lua_call1_FXText__getContentWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getContentWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const FXchar * FXStringDict::data(FXuint pos)const  */
int lua_call1_FXStringDict__data(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXStringDict * __self__;
     unsigned int pos;
    
    __self__ = ( class FXStringDict * )lua_to_FXStringDict(__S__, 1, &__ERROR__);
    pos = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, (const char * ) __self__->data(pos));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  ( FXDVec::operator FXdouble*)() */
/* SKIPPED (operator) */
/* FXint FXScrollArea::getYPosition()const  */
int lua_call1_FXScrollArea__getYPosition(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXScrollArea * __self__;
    
    __self__ = ( class FXScrollArea * )lua_to_FXScrollArea(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getYPosition());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onCmdCursorEnd(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* const struct FXMetaClass * FXDialogBox::getMetaClass()const  */
int lua_call1_FXDialogBox__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDialogBox * __self__;
    
    __self__ = ( class FXDialogBox * )lua_to_FXDialogBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXTabBar::getTabStyle()const  */
int lua_call1_FXTabBar__getTabStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTabBar * __self__;
    
    __self__ = ( class FXTabBar * )lua_to_FXTabBar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTabStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FX4Splitter::onFocusDown(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTextField::onQueryTip(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXMenuCommand::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDCPrint::fillComplexPolygon(const class FXPoint * points, FXuint npoints) */
int lua_call1_FXDCPrint__fillComplexPolygon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDCPrint * __self__;
     class FXPoint * points;
     unsigned int npoints;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    points = ( class FXPoint * )lua_to_FXPoint(__S__, 2, &__ERROR__);
    npoints = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->fillComplexPolygon(points, npoints);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXSpinner::onCmdSetIntValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXDHMat & FXDHMat::yrot(FXdouble phi) */
int lua_call1_FXDHMat__yrot(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDHMat * __self__;
     double phi;
    
    __self__ = ( class FXDHMat * )lua_to_FXDHMat(__S__, 1, &__ERROR__);
    phi = ( double )(double)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXDHMat(__S__, &(__self__->yrot(phi)));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXDHMat & FXDHMat::yrot(FXdouble c, FXdouble s) */
int lua_call2_FXDHMat__yrot(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDHMat * __self__;
     double c;
     double s;
    
    __self__ = ( class FXDHMat * )lua_to_FXDHMat(__S__, 1, &__ERROR__);
    c = ( double )(double)lua_tonumber(__S__, 2);
    s = ( double )(double)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXDHMat(__S__, &(__self__->yrot(c, s)));
    return 1;
  }
  
error:
  return lua_call1_FXDHMat__yrot(__S__);
}
/* FXbool FXMDIChild::isMaximized()const  */
int lua_call1_FXMDIChild__isMaximized(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIChild * __self__;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isMaximized());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXComboBox::detach() */
int lua_call1_FXComboBox__detach(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXComboBox * __self__;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->detach();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXCheckButton::onUngrabbed(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXToolbarTab::onKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXDHMat & FXDHMat::trans(const class FXDVec & v) */
int lua_call1_FXDHMat__trans(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDHMat * __self__;
    
    __self__ = ( class FXDHMat * )lua_to_FXDHMat(__S__, 1, &__ERROR__);
     class FXDVec & v = ( class FXDVec & )(*lua_to_FXDVec(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXDHMat(__S__, &(__self__->trans(v)));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXDHMat & FXDHMat::trans(FXdouble tx, FXdouble ty, FXdouble tz) */
int lua_call2_FXDHMat__trans(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXDHMat * __self__;
     double tx;
     double ty;
     double tz;
    
    __self__ = ( class FXDHMat * )lua_to_FXDHMat(__S__, 1, &__ERROR__);
    tx = ( double )(double)lua_tonumber(__S__, 2);
    ty = ( double )(double)lua_tonumber(__S__, 3);
    tz = ( double )(double)lua_tonumber(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXDHMat(__S__, &(__self__->trans(tx, ty, tz)));
    return 1;
  }
  
error:
  return lua_call1_FXDHMat__trans(__S__);
}
/* void FXProgressBar::setProgress(FXuint value) */
int lua_call1_FXProgressBar__setProgress(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXProgressBar * __self__;
     unsigned int value;
    
    __self__ = ( class FXProgressBar * )lua_to_FXProgressBar(__S__, 1, &__ERROR__);
    value = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setProgress(value);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXString::extract(FXint part, FXchar delim)const  */
int lua_call1_FXString__extract(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXString * __self__;
     int part;
     char delim;
    
    __self__ = ( class FXString * )lua_to_FXString(__S__, 1, &__ERROR__);
    part = ( int )(int)lua_tonumber(__S__, 2);
    delim = ( char )(char)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->extract(part, delim).text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXString::extract(FXint part, FXchar delim, FXchar esc)const  */
int lua_call2_FXString__extract(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXString * __self__;
     int part;
     char delim;
     char esc;
    
    __self__ = ( class FXString * )lua_to_FXString(__S__, 1, &__ERROR__);
    part = ( int )(int)lua_tonumber(__S__, 2);
    delim = ( char )(char)lua_tonumber(__S__, 3);
    esc = ( char )(char)lua_tonumber(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->extract(part, delim, esc).text());
    return 1;
  }
  
error:
  return lua_call1_FXString__extract(__S__);
}
/* long FXWindow::onDNDMotion(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* const FXchar * FXDict::key(FXuint pos)const  */
int lua_call1_FXDict__key(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDict * __self__;
     unsigned int pos;
    
    __self__ = ( class FXDict * )lua_to_FXDict(__S__, 1, &__ERROR__);
    pos = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, (const char * ) __self__->key(pos));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXMDIMenu::getMetaClass()const  */
int lua_call1_FXMDIMenu__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIMenu * __self__;
    
    __self__ = ( class FXMDIMenu * )lua_to_FXMDIMenu(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXIconList::onLeftBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXCursor::load(class FXStream & store) */
int lua_call1_FXCursor__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXCursor * __self__;
    
    __self__ = ( class FXCursor * )lua_to_FXCursor(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onCmdScrollUp(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXApp::stopModal(FXint value=0) */
int lua_call1_FXApp__stopModal(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
     int value;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->stopModal();
    } else {
      value = ( int )(int)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->stopModal(value);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXApp::stopModal(class FXWindow * window, FXint value=0) */
int lua_call2_FXApp__stopModal(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXApp * __self__;
     class FXWindow * window;
     int value;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    window = ( class FXWindow * )lua_to_FXWindow(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      __self__->stopModal(window);
    } else {
      value = ( int )(int)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      __self__->stopModal(window, value);
    }
    ;
    return 0;
  }
  
error:
  return lua_call1_FXApp__stopModal(__S__);
}
/* FXuint FX4Splitter::getSplitterStyle()const  */
int lua_call1_FX4Splitter__getSplitterStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FX4Splitter * __self__;
    
    __self__ = ( class FX4Splitter * )lua_to_FX4Splitter(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getSplitterStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onRightBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTextField::onLeftBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXImage::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXToggleButton::setAltTipText(const class FXString & text) */
int lua_call1_FXToggleButton__setAltTipText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXToggleButton * __self__;
    
    __self__ = ( class FXToggleButton * )lua_to_FXToggleButton(__S__, 1, &__ERROR__);
    int __err__6; static FXString __cstr__6; FXString * __str__6 = lua_to_FXString(__S__, 2, &__err__6);  class FXString & text = ( class FXString & ) (__str__6? *__str__6 : (__cstr__6 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__6));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setAltTipText(text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMenuCaption::onUpdate(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXMenuCommand::getDefaultHeight() */
int lua_call1_FXMenuCommand__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuCommand * __self__;
    
    __self__ = ( class FXMenuCommand * )lua_to_FXMenuCommand(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXText::getTextColor()const  */
int lua_call1_FXText__getTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTextColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXWindow::onMouseWheel(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXMenuCaption::getDefaultHeight() */
int lua_call1_FXMenuCaption__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuCaption * __self__;
    
    __self__ = ( class FXMenuCaption * )lua_to_FXMenuCaption(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXHMat & ( FXHMat::operator /=)(FXfloat w) */
/* SKIPPED (operator) */
/* FXint FXMDIChild::getNormalY()const  */
int lua_call1_FXMDIChild__getNormalY(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIChild * __self__;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getNormalY());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXList::onKeyPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* struct FXFileAssoc * FXFileList::getItemAssoc(FXint index)const  */
int lua_call1_FXFileList__getItemAssoc(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileList * __self__;
     int index;
    
    __self__ = ( class FXFileList * )lua_to_FXFileList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXFileAssoc(__S__, __self__->getItemAssoc(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXFont::getMaxChar()const  */
int lua_call1_FXFont__getMaxChar(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFont * __self__;
    
    __self__ = ( class FXFont * )lua_to_FXFont(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getMaxChar());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXFileList::setMatchMode(FXuint mode) */
int lua_call1_FXFileList__setMatchMode(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileList * __self__;
     unsigned int mode;
    
    __self__ = ( class FXFileList * )lua_to_FXFileList(__S__, 1, &__ERROR__);
    mode = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setMatchMode(mode);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXIconList::disableItem(FXint index) */
int lua_call1_FXIconList__disableItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconList * __self__;
     int index;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->disableItem(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXBMPIcon::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXTabItem::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* FXint FXMatrix::colOfChild(class FXWindow * child)const  */
int lua_call1_FXMatrix__colOfChild(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMatrix * __self__;
     class FXWindow * child;
    
    __self__ = ( class FXMatrix * )lua_to_FXMatrix(__S__, 1, &__ERROR__);
    child = ( class FXWindow * )lua_to_FXWindow(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->colOfChild(child));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXIconList::onCmdDeselectAll(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXTreeListBox::setTipText(const class FXString & txt) */
int lua_call1_FXTreeListBox__setTipText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeListBox * __self__;
    
    __self__ = ( class FXTreeListBox * )lua_to_FXTreeListBox(__S__, 1, &__ERROR__);
    int __err__7; static FXString __cstr__7; FXString * __str__7 = lua_to_FXString(__S__, 2, &__err__7);  class FXString & txt = ( class FXString & ) (__str__7? *__str__7 : (__cstr__7 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__7));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTipText(txt);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXSpinner::isCyclic()const  */
int lua_call1_FXSpinner__isCyclic(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSpinner * __self__;
    
    __self__ = ( class FXSpinner * )lua_to_FXSpinner(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isCyclic());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXIconList::manufacture() */
int lua_call1_FXIconList__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXIconList::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXApp::setDragDelta(FXint delta) */
int lua_call1_FXApp__setDragDelta(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXApp * __self__;
     int delta;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    delta = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setDragDelta(delta);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIconItem::setData(void * ptr) */
/* SKIPPED (argument #2) */
/*  FXFrame::FXFrame(class FXComposite * p, FXuint opts=FRAME_NORMAL, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=2, FXint pr=2, FXint pt=2, FXint pb=2) */
int lua_call1_FXFrame__FXFrame(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXFrame(__S__, new FXFrame(p));
      return 1;
    } else {
      opts = ( unsigned int )(int)lua_tonumber(__S__, 2);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXFrame(__S__, new FXFrame(p, opts));
        return 1;
      } else {
        x = ( int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXFrame(__S__, new FXFrame(p, opts, x));
          return 1;
        } else {
          y = ( int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXFrame(__S__, new FXFrame(p, opts, x, y));
            return 1;
          } else {
            w = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXFrame(__S__, new FXFrame(p, opts, x, y, w));
              return 1;
            } else {
              h = ( int )(int)lua_tonumber(__S__, 6);
              if (nparam <= 6) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXFrame(__S__, new FXFrame(p, opts, x, y, w, h));
                return 1;
              } else {
                pl = ( int )(int)lua_tonumber(__S__, 7);
                if (nparam <= 7) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXFrame(__S__, new FXFrame(p, opts, x, y, w, h, pl));
                  return 1;
                } else {
                  pr = ( int )(int)lua_tonumber(__S__, 8);
                  if (nparam <= 8) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXFrame(__S__, new FXFrame(p, opts, x, y, w, h, pl, pr));
                    return 1;
                  } else {
                    pt = ( int )(int)lua_tonumber(__S__, 9);
                    if (nparam <= 9) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXFrame(__S__, new FXFrame(p, opts, x, y, w, h, pl, pr, pt));
                      return 1;
                    } else {
                      pb = ( int )(int)lua_tonumber(__S__, 10);
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXFrame(__S__, new FXFrame(p, opts, x, y, w, h, pl, pr, pt, pb));
                      return 1;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTopWindow::killFocus() */
int lua_call1_FXTopWindow__killFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTopWindow * __self__;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->killFocus();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void * FXComboBox::getItemData(FXint index)const  */
/* SKIPPED (return type) */
/* FXbool FXTreeList::extendSelection(class FXTreeItem * item, FXbool notify=0) */
int lua_call1_FXTreeList__extendSelection(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeList * __self__;
     class FXTreeItem * item;
     unsigned char notify;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->extendSelection(item));
      return 1;
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->extendSelection(item, notify));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXBMPImage::savePixels(class FXStream & store)const  */
int lua_call1_FXBMPImage__savePixels(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXBMPImage * __self__;
    
    __self__ = ( class FXBMPImage * )lua_to_FXBMPImage(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->savePixels(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::setItemText(FXint r, FXint c, const class FXString & text) */
int lua_call1_FXTable__setItemText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXTable * __self__;
     int r;
     int c;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    r = ( int )(int)lua_tonumber(__S__, 2);
    c = ( int )(int)lua_tonumber(__S__, 3);
    int __err__8; static FXString __cstr__8; FXString * __str__8 = lua_to_FXString(__S__, 4, &__err__8);  class FXString & text = ( class FXString & ) (__str__8? *__str__8 : (__cstr__8 =(FXString) (char *)lua_tostring(__S__, 4), __cstr__8));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setItemText(r, c, text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXTableItem::isButton()const  */
int lua_call1_FXTableItem__isButton(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTableItem * __self__;
    
    __self__ = ( class FXTableItem * )lua_to_FXTableItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isButton());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDragCorner::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXTreeList::setFocus() */
int lua_call1_FXTreeList__setFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeList * __self__;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setFocus();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXBitmap * FXDC::getStippleBitmap()const  */
int lua_call1_FXDC__getStippleBitmap(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDC * __self__;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXBitmap(__S__, __self__->getStippleBitmap());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXPopup::setBorderColor(FXColor clr) */
int lua_call1_FXPopup__setBorderColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXPopup * __self__;
     unsigned int clr;
    
    __self__ = ( class FXPopup * )lua_to_FXPopup(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBorderColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXShell::onFocusNext(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDCPrint::setFunction(FXFunction func=BLT_SRC) */
int lua_call1_FXDCPrint__setFunction(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDCPrint * __self__;
     FXFunction func;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->setFunction();
    } else {
      func = ( FXFunction )(FXFunction)(int)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->setFunction(func);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMDIClient::moveContents(FXint x, FXint y) */
int lua_call1_FXMDIClient__moveContents(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXMDIClient * __self__;
     int x;
     int y;
    
    __self__ = ( class FXMDIClient * )lua_to_FXMDIClient(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->moveContents(x, y);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMenuCascade::setFocus() */
int lua_call1_FXMenuCascade__setFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuCascade * __self__;
    
    __self__ = ( class FXMenuCascade * )lua_to_FXMenuCascade(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setFocus();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXWindow::onRightBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDCWindow::clipChildren(FXbool yes) */
int lua_call1_FXDCWindow__clipChildren(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDCWindow * __self__;
     unsigned char yes;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    yes = ( unsigned char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->clipChildren(yes);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXObjectList::clear() */
int lua_call1_FXObjectList__clear(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXObjectList * __self__;
    
    __self__ = ( class FXObjectList * )lua_to_FXObjectList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->clear();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXFrame::setPadLeft(FXint pl) */
int lua_call1_FXFrame__setPadLeft(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFrame * __self__;
     int pl;
    
    __self__ = ( class FXFrame * )lua_to_FXFrame(__S__, 1, &__ERROR__);
    pl = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setPadLeft(pl);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXTGAImage::getMetaClass()const  */
int lua_call1_FXTGAImage__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTGAImage * __self__;
    
    __self__ = ( class FXTGAImage * )lua_to_FXTGAImage(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onCmdCursorLeft(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXTreeListBox::getNumItems()const  */
int lua_call1_FXTreeListBox__getNumItems(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeListBox * __self__;
    
    __self__ = ( class FXTreeListBox * )lua_to_FXTreeListBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getNumItems());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::setRowY(FXint row, FXint y) */
int lua_call1_FXTable__setRowY(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTable * __self__;
     int row;
     int y;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    row = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setRowY(row, y);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTextField::onCmdToggleEditable(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXTextField::manufacture() */
int lua_call1_FXTextField__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXTextField::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXApp::beep() */
int lua_call1_FXApp__beep(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->beep();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXSpinner::onCmdEntry(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTextField::onSelectionRequest(class FXObject * , FXSelector , void * ptr) */
/* SKIPPED (argument #4) */
/* FXint FXComboBox::getNumVisible()const  */
int lua_call1_FXComboBox__getNumVisible(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXComboBox * __self__;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getNumVisible());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMDIChild::setBaseColor(FXColor clr) */
int lua_call1_FXMDIChild__setBaseColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMDIChild * __self__;
     unsigned int clr;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBaseColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::setCellBorderColor(FXColor clr) */
int lua_call1_FXTable__setCellBorderColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTable * __self__;
     unsigned int clr;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setCellBorderColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXShutter::onTimeout(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* struct FXFileAssoc * FXFileDict::find(const FXchar * ext) */
int lua_call1_FXFileDict__find(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileDict * __self__;
     char * ext;
    
    __self__ = ( class FXFileDict * )lua_to_FXFileDict(__S__, 1, &__ERROR__);
    ext = ( char * )(char  *)lua_tostring(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXFileAssoc(__S__, __self__->find(ext));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXPacker::getHiliteColor()const  */
int lua_call1_FXPacker__getHiliteColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXPacker * __self__;
    
    __self__ = ( class FXPacker * )lua_to_FXPacker(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getHiliteColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXShell::setFocus() */
int lua_call1_FXShell__setFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXShell * __self__;
    
    __self__ = ( class FXShell * )lua_to_FXShell(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setFocus();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXWindow * FXApp::findWindowAt(FXint rx, FXint ry, FXID window=0)const  */
int lua_call1_FXApp__findWindowAt(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXApp * __self__;
     int rx;
     int ry;
     void * window;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    rx = ( int )(int)lua_tonumber(__S__, 2);
    ry = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXWindow(__S__, __self__->findWindowAt(rx, ry));
      return 1;
    } else {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXWindow(__S__, __self__->findWindowAt(rx, ry, window));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIClient::onUpdActivateNext(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXTableItem * FXTable::getItem(FXint row, FXint col)const  */
int lua_call1_FXTable__getItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTable * __self__;
     int row;
     int col;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    row = ( int )(int)lua_tonumber(__S__, 2);
    col = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXTableItem(__S__, __self__->getItem(row, col));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXUndoList::cut() */
int lua_call1_FXUndoList__cut(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXUndoList * __self__;
    
    __self__ = ( class FXUndoList * )lua_to_FXUndoList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->cut();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPicker::onLeftBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXuint FXApp::getTooltipTime()const  */
int lua_call1_FXApp__getTooltipTime(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTooltipTime());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXList::setNumVisible(FXint nvis) */
int lua_call1_FXList__setNumVisible(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXList * __self__;
     int nvis;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    nvis = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setNumVisible(nvis);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXLabel::load(class FXStream & store) */
int lua_call1_FXLabel__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXLabel * __self__;
    
    __self__ = ( class FXLabel * )lua_to_FXLabel(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIChild::onCmdDelete(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXText::onCmdToggleEditable(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXShutter::FXShutter(class FXComposite * p, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=0, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=4, FXint pr=4, FXint pt=4, FXint pb=4, FXint hs=4, FXint vs=4) */
int lua_call1_FXShutter__FXShutter(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
     int hs;
     int vs;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXShutter(__S__, new FXShutter(p));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 2, &__ERROR__);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXShutter(__S__, new FXShutter(p, tgt));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXShutter(__S__, new FXShutter(p, tgt, sel));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXShutter(__S__, new FXShutter(p, tgt, sel, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXShutter(__S__, new FXShutter(p, tgt, sel, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 6);
              if (nparam <= 6) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXShutter(__S__, new FXShutter(p, tgt, sel, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 7);
                if (nparam <= 7) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXShutter(__S__, new FXShutter(p, tgt, sel, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 8);
                  if (nparam <= 8) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXShutter(__S__, new FXShutter(p, tgt, sel, opts, x, y, w, h));
                    return 1;
                  } else {
                    pl = ( int )(int)lua_tonumber(__S__, 9);
                    if (nparam <= 9) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXShutter(__S__, new FXShutter(p, tgt, sel, opts, x, y, w, h, pl));
                      return 1;
                    } else {
                      pr = ( int )(int)lua_tonumber(__S__, 10);
                      if (nparam <= 10) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXShutter(__S__, new FXShutter(p, tgt, sel, opts, x, y, w, h, pl, pr));
                        return 1;
                      } else {
                        pt = ( int )(int)lua_tonumber(__S__, 11);
                        if (nparam <= 11) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXShutter(__S__, new FXShutter(p, tgt, sel, opts, x, y, w, h, pl, pr, pt));
                          return 1;
                        } else {
                          pb = ( int )(int)lua_tonumber(__S__, 12);
                          if (nparam <= 12) {
                            if (__ERROR__) goto error;
                            
                            lua_settop(__S__, 0);
                            lua_push_FXShutter(__S__, new FXShutter(p, tgt, sel, opts, x, y, w, h, pl, pr, pt, pb));
                            return 1;
                          } else {
                            hs = ( int )(int)lua_tonumber(__S__, 13);
                            if (nparam <= 13) {
                              if (__ERROR__) goto error;
                              
                              lua_settop(__S__, 0);
                              lua_push_FXShutter(__S__, new FXShutter(p, tgt, sel, opts, x, y, w, h, pl, pr, pt, pb, hs));
                              return 1;
                            } else {
                              vs = ( int )(int)lua_tonumber(__S__, 14);
                              if (__ERROR__) goto error;
                              
                              lua_settop(__S__, 0);
                              lua_push_FXShutter(__S__, new FXShutter(p, tgt, sel, opts, x, y, w, h, pl, pr, pt, pb, hs, vs));
                              return 1;
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXInputDialog::setNumColumns(FXint num) */
int lua_call1_FXInputDialog__setNumColumns(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXInputDialog * __self__;
     int num;
    
    __self__ = ( class FXInputDialog * )lua_to_FXInputDialog(__S__, 1, &__ERROR__);
    num = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setNumColumns(num);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXString::mid(FXint pos, FXint n)const  */
int lua_call1_FXString__mid(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXString * __self__;
     int pos;
     int n;
    
    __self__ = ( class FXString * )lua_to_FXString(__S__, 1, &__ERROR__);
    pos = ( int )(int)lua_tonumber(__S__, 2);
    n = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->mid(pos, n).text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXFileList::onCmdSortByUser(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXFileDict::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXInputDialog::setLimits(FXdouble lo, FXdouble hi) */
int lua_call1_FXInputDialog__setLimits(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXInputDialog * __self__;
     double lo;
     double hi;
    
    __self__ = ( class FXInputDialog * )lua_to_FXInputDialog(__S__, 1, &__ERROR__);
    lo = ( double )(double)lua_tonumber(__S__, 2);
    hi = ( double )(double)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setLimits(lo, hi);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXCursor::savePixels(class FXStream & store)const  */
int lua_call1_FXCursor__savePixels(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXCursor * __self__;
    
    __self__ = ( class FXCursor * )lua_to_FXCursor(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->savePixels(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXTable::FXTable(class FXComposite * p, FXint nr, FXint nc, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=0, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=2, FXint pr=2, FXint pt=2, FXint pb=2) */
int lua_call1_FXTable__FXTable(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 3) goto error;
  {
     class FXComposite * p;
     int nr;
     int nc;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    nr = ( int )(int)lua_tonumber(__S__, 2);
    nc = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXTable(__S__, new FXTable(p, nr, nc));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 4, &__ERROR__);
      if (nparam <= 4) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXTable(__S__, new FXTable(p, nr, nc, tgt));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 5);
        if (nparam <= 5) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXTable(__S__, new FXTable(p, nr, nc, tgt, sel));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 6);
          if (nparam <= 6) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXTable(__S__, new FXTable(p, nr, nc, tgt, sel, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 7);
            if (nparam <= 7) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXTable(__S__, new FXTable(p, nr, nc, tgt, sel, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 8);
              if (nparam <= 8) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXTable(__S__, new FXTable(p, nr, nc, tgt, sel, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 9);
                if (nparam <= 9) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXTable(__S__, new FXTable(p, nr, nc, tgt, sel, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 10);
                  if (nparam <= 10) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXTable(__S__, new FXTable(p, nr, nc, tgt, sel, opts, x, y, w, h));
                    return 1;
                  } else {
                    pl = ( int )(int)lua_tonumber(__S__, 11);
                    if (nparam <= 11) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXTable(__S__, new FXTable(p, nr, nc, tgt, sel, opts, x, y, w, h, pl));
                      return 1;
                    } else {
                      pr = ( int )(int)lua_tonumber(__S__, 12);
                      if (nparam <= 12) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXTable(__S__, new FXTable(p, nr, nc, tgt, sel, opts, x, y, w, h, pl, pr));
                        return 1;
                      } else {
                        pt = ( int )(int)lua_tonumber(__S__, 13);
                        if (nparam <= 13) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXTable(__S__, new FXTable(p, nr, nc, tgt, sel, opts, x, y, w, h, pl, pr, pt));
                          return 1;
                        } else {
                          pb = ( int )(int)lua_tonumber(__S__, 14);
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXTable(__S__, new FXTable(p, nr, nc, tgt, sel, opts, x, y, w, h, pl, pr, pt, pb));
                          return 1;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPrintDialog::onCmdPages(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXImageView::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXScrollbar::onMiddleBtnPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXHorizontalSeparator::getDefaultWidth() */
int lua_call1_FXHorizontalSeparator__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXHorizontalSeparator * __self__;
    
    __self__ = ( class FXHorizontalSeparator * )lua_to_FXHorizontalSeparator(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXGroupBox::setTextColor(FXColor clr) */
int lua_call1_FXGroupBox__setTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXGroupBox * __self__;
     unsigned int clr;
    
    __self__ = ( class FXGroupBox * )lua_to_FXGroupBox(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTextColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTabBar::onCmdOpenItem(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXuint FXSettings::readUnsignedEntry(const FXchar * section, const FXchar * key, FXuint def=0) */
int lua_call1_FXSettings__readUnsignedEntry(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXSettings * __self__;
     char * section;
     char * key;
     unsigned int def;
    
    __self__ = ( class FXSettings * )lua_to_FXSettings(__S__, 1, &__ERROR__);
    section = ( char * )(char  *)lua_tostring(__S__, 2);
    key = ( char * )(char  *)lua_tostring(__S__, 3);
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->readUnsignedEntry(section, key));
      return 1;
    } else {
      def = ( unsigned int )(int)lua_tonumber(__S__, 4);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->readUnsignedEntry(section, key, def));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXToolbarShell::getBaseColor()const  */
int lua_call1_FXToolbarShell__getBaseColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbarShell * __self__;
    
    __self__ = ( class FXToolbarShell * )lua_to_FXToolbarShell(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBaseColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCPrint::drawIcon(const class FXIcon * icon, FXint dx, FXint dy) */
int lua_call1_FXDCPrint__drawIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXDCPrint * __self__;
     class FXIcon * icon;
     int dx;
     int dy;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    icon = ( class FXIcon * )lua_to_FXIcon(__S__, 2, &__ERROR__);
    dx = ( int )(int)lua_tonumber(__S__, 3);
    dy = ( int )(int)lua_tonumber(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawIcon(icon, dx, dy);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXCharset & ( FXCharset::operator -=)(FXchar ch) */
/* SKIPPED (operator) */
/* class FXCharset & ( FXCharset::operator -=)(const class FXString & characters) */
/* SKIPPED (operator) */
/* class FXCharset & ( FXCharset::operator -=)(const class FXCharset & a) */
/* SKIPPED (operator) */
/* FXuint FXInputDialog::execute(FXuint placement=PLACEMENT_CURSOR) */
int lua_call1_FXInputDialog__execute(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXInputDialog * __self__;
     unsigned int placement;
    
    __self__ = ( class FXInputDialog * )lua_to_FXInputDialog(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->execute());
      return 1;
    } else {
      placement = ( unsigned int )(int)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->execute(placement));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXTable::deselectItem(FXint r, FXint c, FXbool notify=0) */
int lua_call1_FXTable__deselectItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTable * __self__;
     int r;
     int c;
     unsigned char notify;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    r = ( int )(int)lua_tonumber(__S__, 2);
    c = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->deselectItem(r, c));
      return 1;
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 4);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->deselectItem(r, c, notify));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXToolbarShell::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXSpinner::setTextVisible(FXbool shown) */
int lua_call1_FXSpinner__setTextVisible(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXSpinner * __self__;
     unsigned char shown;
    
    __self__ = ( class FXSpinner * )lua_to_FXSpinner(__S__, 1, &__ERROR__);
    shown = ( unsigned char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTextVisible(shown);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIRestoreButton::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXIconList::setFocus() */
int lua_call1_FXIconList__setFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconList * __self__;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setFocus();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXWindow::acquireClipboard(const FXDragType * types, FXuint numtypes) */
/* SKIPPED (argument #2) */
/* FXColor FXPacker::getBorderColor()const  */
int lua_call1_FXPacker__getBorderColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXPacker * __self__;
    
    __self__ = ( class FXPacker * )lua_to_FXPacker(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBorderColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXFileSelector::onCmdLink(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXGIFImage::manufacture() */
int lua_call1_FXGIFImage__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXGIFImage::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPrintDialog::onCmdCollateReversed(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXOption::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/*  FXTableItem::FXTableItem(const class FXString & text, class FXIcon * ic=__null, void * ptr=__null) */
int lua_call1_FXTableItem__FXTableItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXIcon * ic;
     void * ptr;
    
    int __err__9; static FXString __cstr__9; FXString * __str__9 = lua_to_FXString(__S__, 1, &__err__9);  class FXString & text = ( class FXString & ) (__str__9? *__str__9 : (__cstr__9 =(FXString) (char *)lua_tostring(__S__, 1), __cstr__9));
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXTableItem(__S__, new FXTableItem(text));
      return 1;
    } else {
      ic = ( class FXIcon * )lua_to_FXIcon(__S__, 2, &__ERROR__);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXTableItem(__S__, new FXTableItem(text, ic));
        return 1;
      } else {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXTableItem(__S__, new FXTableItem(text, ic, ptr));
        return 1;
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXFileSelector::onCmdMove(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXTable::insertRows(FXint row, FXint nr=1, FXbool notify=0) */
int lua_call1_FXTable__insertRows(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTable * __self__;
     int row;
     int nr;
     unsigned char notify;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    row = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      __self__->insertRows(row);
    } else {
      nr = ( int )(int)lua_tonumber(__S__, 3);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        __self__->insertRows(row, nr);
      } else {
        notify = ( unsigned char )(char)lua_tonumber(__S__, 4);
        if (__ERROR__) goto error;
        
        __self__->insertRows(row, nr, notify);
      }
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXWindow::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* class FXWindow * FXWindow::getNext()const  */
int lua_call1_FXWindow__getNext(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXWindow(__S__, __self__->getNext());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXScrollbar::getDefaultHeight() */
int lua_call1_FXScrollbar__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXScrollbar * __self__;
    
    __self__ = ( class FXScrollbar * )lua_to_FXScrollbar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXTreeItem * FXTreeList::getCursorItem()const  */
int lua_call1_FXTreeList__getCursorItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeList * __self__;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXTreeItem(__S__, __self__->getCursorItem());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXOption::onLeftBtnPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTextField::onCmdBackspace(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXTreeList::ascending(const class FXTreeItem * a, const class FXTreeItem * b) */
int lua_call1_FXTreeList__ascending(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXTreeItem * a;
     class FXTreeItem * b;
    
    a = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 1, &__ERROR__);
    b = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, FXTreeList::ascending(a, b));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXToggleButton::onFocusOut(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXCheckButton::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXPopup::onFocusUp(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDirSelector::setDirBoxStyle(FXuint style) */
int lua_call1_FXDirSelector__setDirBoxStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDirSelector * __self__;
     unsigned int style;
    
    __self__ = ( class FXDirSelector * )lua_to_FXDirSelector(__S__, 1, &__ERROR__);
    style = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setDirBoxStyle(style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXToolbar::load(class FXStream & store) */
int lua_call1_FXToolbar__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXToolbar * __self__;
    
    __self__ = ( class FXToolbar * )lua_to_FXToolbar(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::setItemIcon(FXint r, FXint c, class FXIcon * icon) */
int lua_call1_FXTable__setItemIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXTable * __self__;
     int r;
     int c;
     class FXIcon * icon;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    r = ( int )(int)lua_tonumber(__S__, 2);
    c = ( int )(int)lua_tonumber(__S__, 3);
    icon = ( class FXIcon * )lua_to_FXIcon(__S__, 4, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setItemIcon(r, c, icon);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXText::getCursorPos()const  */
int lua_call1_FXText__getCursorPos(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getCursorPos());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXSettings::manufacture() */
int lua_call1_FXSettings__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXSettings::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDataTarget::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXFileList::onEndDrag(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXTreeItem * FXTreeList::getCurrentItem()const  */
int lua_call1_FXTreeList__getCurrentItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeList * __self__;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXTreeItem(__S__, __self__->getCurrentItem());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMDIChild::position(FXint x, FXint y, FXint w, FXint h) */
int lua_call1_FXMDIChild__position(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXMDIChild * __self__;
     int x;
     int y;
     int w;
     int h;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    w = ( int )(int)lua_tonumber(__S__, 4);
    h = ( int )(int)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->position(x, y, w, h);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXComboBox::insertItem(FXint index, const class FXString & text, void * ptr=__null) */
int lua_call1_FXComboBox__insertItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXComboBox * __self__;
     int index;
     void * ptr;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    int __err__10; static FXString __cstr__10; FXString * __str__10 = lua_to_FXString(__S__, 3, &__err__10);  class FXString & text = ( class FXString & ) (__str__10? *__str__10 : (__cstr__10 =(FXString) (char *)lua_tostring(__S__, 3), __cstr__10));
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      __self__->insertItem(index, text);
    } else {
      if (__ERROR__) goto error;
      
      __self__->insertItem(index, text, ptr);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMDIChild::setTitleColor(FXColor clr) */
int lua_call1_FXMDIChild__setTitleColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMDIChild * __self__;
     unsigned int clr;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTitleColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXStream::swapBytes()const  */
int lua_call1_FXStream__swapBytes(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXStream * __self__;
    
    __self__ = ( class FXStream * )lua_to_FXStream(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->swapBytes());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXStream::swapBytes(FXbool s) */
int lua_call2_FXStream__swapBytes(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXStream * __self__;
     unsigned char s;
    
    __self__ = ( class FXStream * )lua_to_FXStream(__S__, 1, &__ERROR__);
    s = ( unsigned char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->swapBytes(s);
    ;
    return 0;
  }
  
error:
  return lua_call1_FXStream__swapBytes(__S__);
}
/* long FXFileList::onUpdSortByType(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXTableItem::setBorders(FXuint borders) */
int lua_call1_FXTableItem__setBorders(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTableItem * __self__;
     unsigned int borders;
    
    __self__ = ( class FXTableItem * )lua_to_FXTableItem(__S__, 1, &__ERROR__);
    borders = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBorders(borders);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXTreeList::isItemEnabled(const class FXTreeItem * item)const  */
int lua_call1_FXTreeList__isItemEnabled(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeList * __self__;
     class FXTreeItem * item;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isItemEnabled(item));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXProgressBar::getTotal()const  */
int lua_call1_FXProgressBar__getTotal(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXProgressBar * __self__;
    
    __self__ = ( class FXProgressBar * )lua_to_FXProgressBar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTotal());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXComposite::getMetaClass()const  */
int lua_call1_FXComposite__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXComposite * __self__;
    
    __self__ = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXTable::getSelTextColor()const  */
int lua_call1_FXTable__getSelTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getSelTextColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXArrowButton::onKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXColor FXIconList::getSelBackColor()const  */
int lua_call1_FXIconList__getSelBackColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconList * __self__;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getSelBackColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDC::setDashes(FXuint dashoffset, const FXchar * dashpattern, FXuint dashlength) */
int lua_call1_FXDC__setDashes(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXDC * __self__;
     unsigned int dashoffset;
     char * dashpattern;
     unsigned int dashlength;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    dashoffset = ( unsigned int )(int)lua_tonumber(__S__, 2);
    dashpattern = ( char * )(char  *)lua_tostring(__S__, 3);
    dashlength = ( unsigned int )(int)lua_tonumber(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setDashes(dashoffset, dashpattern, dashlength);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXFileSelector::getItemSpace()const  */
int lua_call1_FXFileSelector__getItemSpace(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileSelector * __self__;
    
    __self__ = ( class FXFileSelector * )lua_to_FXFileSelector(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getItemSpace());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIClient::onUpdCascade(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDCWindow::fillPolygon(const class FXPoint * points, FXuint npoints) */
int lua_call1_FXDCWindow__fillPolygon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDCWindow * __self__;
     class FXPoint * points;
     unsigned int npoints;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    points = ( class FXPoint * )lua_to_FXPoint(__S__, 2, &__ERROR__);
    npoints = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->fillPolygon(points, npoints);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXRadioButton::setRadioButtonStyle(FXuint style) */
int lua_call1_FXRadioButton__setRadioButtonStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXRadioButton * __self__;
     unsigned int style;
    
    __self__ = ( class FXRadioButton * )lua_to_FXRadioButton(__S__, 1, &__ERROR__);
    style = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setRadioButtonStyle(style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXList::getItemAt(FXint x, FXint y)const  */
int lua_call1_FXList__getItemAt(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXList * __self__;
     int x;
     int y;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getItemAt(x, y));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXWindow::getKey()const  */
int lua_call1_FXWindow__getKey(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getKey());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCPrint::drawRectangle(FXint x, FXint y, FXint w, FXint h) */
int lua_call1_FXDCPrint__drawRectangle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXDCPrint * __self__;
     int x;
     int y;
     int w;
     int h;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    w = ( int )(int)lua_tonumber(__S__, 4);
    h = ( int )(int)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawRectangle(x, y, w, h);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDirSelector::load(class FXStream & store) */
int lua_call1_FXDirSelector__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDirSelector * __self__;
    
    __self__ = ( class FXDirSelector * )lua_to_FXDirSelector(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXComboBox::setEditable(FXbool edit=1) */
int lua_call1_FXComboBox__setEditable(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXComboBox * __self__;
     unsigned char edit;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->setEditable();
    } else {
      edit = ( unsigned char )(char)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->setEditable(edit);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTable::getAnchorRow()const  */
int lua_call1_FXTable__getAnchorRow(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getAnchorRow());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorSelector::onCmdCMYText(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXMDIClient::onUpdMenuRestore(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXSpinner::getValue()const  */
int lua_call1_FXSpinner__getValue(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSpinner * __self__;
    
    __self__ = ( class FXSpinner * )lua_to_FXSpinner(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getValue());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTextField::setCursorPos(FXint pos) */
int lua_call1_FXTextField__setCursorPos(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTextField * __self__;
     int pos;
    
    __self__ = ( class FXTextField * )lua_to_FXTextField(__S__, 1, &__ERROR__);
    pos = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setCursorPos(pos);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDial::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXListBox::onFieldButton(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXColor FXApp::getSelbackColor()const  */
int lua_call1_FXApp__getSelbackColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getSelbackColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXApp * FXIconDict::getApp()const  */
int lua_call1_FXIconDict__getApp(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconDict * __self__;
    
    __self__ = ( class FXIconDict * )lua_to_FXIconDict(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXApp(__S__, __self__->getApp());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXFileList::cmpRName(const class FXIconItem * pa, const class FXIconItem * pb) */
int lua_call1_FXFileList__cmpRName(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXIconItem * pa;
     class FXIconItem * pb;
    
    pa = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
    pb = ( class FXIconItem * )lua_to_FXIconItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, FXFileList::cmpRName(pa, pb));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::setBorderColor(FXColor clr) */
int lua_call1_FXTable__setBorderColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTable * __self__;
     unsigned int clr;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBorderColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXFont::listFonts(struct FXFontDesc * & fonts, FXuint & numfonts, const class FXString & face, FXuint wt=FONTWEIGHT_DONTCARE, FXuint sl=FONTSLANT_DONTCARE, FXuint sw=FONTSETWIDTH_DONTCARE, FXuint en=FONTENCODING_DEFAULT, FXuint h=0) */
/* SKIPPED (argument #1) */
/*  FXStream::FXStream(const class FXObject * cont=__null) */
int lua_call1_FXStream__FXStream(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  {
     class FXObject * cont;
    
    
    /* Actual call */
    if (nparam <= 0) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXStream(__S__, new FXStream());
      return 1;
    } else {
      cont = ( class FXObject * )lua_to_FXObject(__S__, 1, &__ERROR__);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXStream(__S__, new FXStream(cont));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXIconList::extendSelection(FXint index, FXbool notify=0) */
int lua_call1_FXIconList__extendSelection(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconList * __self__;
     int index;
     unsigned char notify;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->extendSelection(index));
      return 1;
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->extendSelection(index, notify));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXDict::FXDict() */
int lua_call1_FXDict__FXDict(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXDict(__S__, new FXDict());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTable::getTrailingCols()const  */
int lua_call1_FXTable__getTrailingCols(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTrailingCols());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDirList::onCmdHideHidden(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXWindow::getWidthForHeight(FXint givenheight) */
int lua_call1_FXWindow__getWidthForHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXWindow * __self__;
     int givenheight;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    givenheight = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getWidthForHeight(givenheight));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXSettings::isModified()const  */
int lua_call1_FXSettings__isModified(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSettings * __self__;
    
    __self__ = ( class FXSettings * )lua_to_FXSettings(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isModified());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXSlider::getTickDelta()const  */
int lua_call1_FXSlider__getTickDelta(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSlider * __self__;
    
    __self__ = ( class FXSlider * )lua_to_FXSlider(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTickDelta());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIChild::onUpdMenuMinimize(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXWindow * FXPopup::getGrabOwner()const  */
int lua_call1_FXPopup__getGrabOwner(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXPopup * __self__;
    
    __self__ = ( class FXPopup * )lua_to_FXPopup(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXWindow(__S__, __self__->getGrabOwner());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXIconList::hitItem(FXint index, FXint x, FXint y, FXint ww=1, FXint hh=1)const  */
int lua_call1_FXIconList__hitItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXIconList * __self__;
     int index;
     int x;
     int y;
     int ww;
     int hh;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    x = ( int )(int)lua_tonumber(__S__, 3);
    y = ( int )(int)lua_tonumber(__S__, 4);
    
    /* Actual call */
    if (nparam <= 4) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->hitItem(index, x, y));
      return 1;
    } else {
      ww = ( int )(int)lua_tonumber(__S__, 5);
      if (nparam <= 5) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_pushnumber(__S__, __self__->hitItem(index, x, y, ww));
        return 1;
      } else {
        hh = ( int )(int)lua_tonumber(__S__, 6);
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_pushnumber(__S__, __self__->hitItem(index, x, y, ww, hh));
        return 1;
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIClient::onUpdActivatePrev(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXComposite::onKeyPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXHMat & FXHMat::left() */
int lua_call1_FXHMat__left(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXHMat * __self__;
    
    __self__ = ( class FXHMat * )lua_to_FXHMat(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXHMat(__S__, &(__self__->left()));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXDVec & ( FXDVec::operator +=)(const class FXDVec & a) */
/* SKIPPED (operator) */
/* long FXFileList::onOpenTimer(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXDragCorner * FXStatusbar::getDragCorner()const  */
int lua_call1_FXStatusbar__getDragCorner(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXStatusbar * __self__;
    
    __self__ = ( class FXStatusbar * )lua_to_FXStatusbar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXDragCorner(__S__, __self__->getDragCorner());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXStatusline::save(class FXStream & store)const  */
int lua_call1_FXStatusline__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXStatusline * __self__;
    
    __self__ = ( class FXStatusline * )lua_to_FXStatusline(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXProgressBar::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDC::fillRectangle(FXint x, FXint y, FXint w, FXint h) */
int lua_call1_FXDC__fillRectangle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXDC * __self__;
     int x;
     int y;
     int w;
     int h;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    w = ( int )(int)lua_tonumber(__S__, 4);
    h = ( int )(int)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->fillRectangle(x, y, w, h);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXStringDict::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXText::onCmdCursorParEnd(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXHorizontalFrame::getDefaultHeight() */
int lua_call1_FXHorizontalFrame__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXHorizontalFrame * __self__;
    
    __self__ = ( class FXHorizontalFrame * )lua_to_FXHorizontalFrame(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXDirItem::isSocket()const  */
int lua_call1_FXDirItem__isSocket(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDirItem * __self__;
    
    __self__ = ( class FXDirItem * )lua_to_FXDirItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isSocket());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXFileList::getDirectory()const  */
int lua_call1_FXFileList__getDirectory(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileList * __self__;
    
    __self__ = ( class FXFileList * )lua_to_FXFileList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getDirectory().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPopup::onFocusNext(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXMDIChild::onMotion(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXTreeList::manufacture() */
int lua_call1_FXTreeList__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXTreeList::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXScrollbar::setScrollbarStyle(FXuint style) */
int lua_call1_FXScrollbar__setScrollbarStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXScrollbar * __self__;
     unsigned int style;
    
    __self__ = ( class FXScrollbar * )lua_to_FXScrollbar(__S__, 1, &__ERROR__);
    style = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setScrollbarStyle(style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::translateCoordinatesTo(FXint & tox, FXint & toy, const class FXWindow * towindow, FXint fromx, FXint fromy)const  */
int lua_call1_FXWindow__translateCoordinatesTo(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 6) goto error;
  {
     class FXWindow * __self__;
     int tox;
     int toy;
     class FXWindow * towindow;
     int fromx;
     int fromy;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    tox = ( int )(int)lua_tonumber(__S__, 2);
    toy = ( int )(int)lua_tonumber(__S__, 3);
    towindow = ( class FXWindow * )lua_to_FXWindow(__S__, 4, &__ERROR__);
    fromx = ( int )(int)lua_tonumber(__S__, 5);
    fromy = ( int )(int)lua_tonumber(__S__, 6);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->translateCoordinatesTo(tox, toy, towindow, fromx, fromy);
    lua_settop(__S__, 0);
    ;
    lua_pushnumber(__S__, tox);
    lua_pushnumber(__S__, toy);
    return 2;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void * FXList::getItemData(FXint index)const  */
/* SKIPPED (return type) */
/* long FXSpinner::onCmdGetIntRange(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXGroupBox::manufacture() */
int lua_call1_FXGroupBox__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXGroupBox::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const class FXString & FXRegistry::getVendorKey()const  */
int lua_call1_FXRegistry__getVendorKey(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXRegistry * __self__;
    
    __self__ = ( class FXRegistry * )lua_to_FXRegistry(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getVendorKey().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXScrollbar::onCmdGetIntValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXColorWheel::setTipText(const class FXString & text) */
int lua_call1_FXColorWheel__setTipText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXColorWheel * __self__;
    
    __self__ = ( class FXColorWheel * )lua_to_FXColorWheel(__S__, 1, &__ERROR__);
    int __err__11; static FXString __cstr__11; FXString * __str__11 = lua_to_FXString(__S__, 2, &__err__11);  class FXString & text = ( class FXString & ) (__str__11? *__str__11 : (__cstr__11 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__11));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTipText(text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXDocument::manufacture() */
int lua_call1_FXDocument__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXDocument::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXPrintDialog::save(class FXStream & store)const  */
int lua_call1_FXPrintDialog__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXPrintDialog * __self__;
    
    __self__ = ( class FXPrintDialog * )lua_to_FXPrintDialog(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXFileSelector::setPattern(const class FXString & ptrn) */
int lua_call1_FXFileSelector__setPattern(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileSelector * __self__;
    
    __self__ = ( class FXFileSelector * )lua_to_FXFileSelector(__S__, 1, &__ERROR__);
    int __err__12; static FXString __cstr__12; FXString * __str__12 = lua_to_FXString(__S__, 2, &__err__12);  class FXString & ptrn = ( class FXString & ) (__str__12? *__str__12 : (__cstr__12 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__12));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setPattern(ptrn);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXTreeItem::getMetaClass()const  */
int lua_call1_FXTreeItem__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeItem * __self__;
    
    __self__ = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXMessageBox::error(class FXWindow * owner, FXuint opts, const char * caption, const char * message, ...) */
int lua_call1_FXMessageBox__error(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 4) goto error;
  {
     class FXWindow * owner;
     unsigned int opts;
     char * caption;
     char * message;
    
    owner = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    opts = ( unsigned int )(int)lua_tonumber(__S__, 2);
    caption = ( char * )(char  *)lua_tostring(__S__, 3);
    message = ( char * )(char  *)lua_tostring(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, FXMessageBox::error(owner, opts, caption, message));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXTGAImage::manufacture() */
int lua_call1_FXTGAImage__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXTGAImage::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXDataTarget::getType()const  */
int lua_call1_FXDataTarget__getType(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDataTarget * __self__;
    
    __self__ = ( class FXDataTarget * )lua_to_FXDataTarget(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getType());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXfloat FXColorBar::getHue()const  */
int lua_call1_FXColorBar__getHue(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorBar * __self__;
    
    __self__ = ( class FXColorBar * )lua_to_FXColorBar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getHue());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXText::replaceText(FXint pos, FXint m, const FXchar * text, FXint n, FXbool notify=0) */
int lua_call1_FXText__replaceText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXText * __self__;
     int pos;
     int m;
     char * text;
     int n;
     unsigned char notify;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    pos = ( int )(int)lua_tonumber(__S__, 2);
    m = ( int )(int)lua_tonumber(__S__, 3);
    text = ( char * )(char  *)lua_tostring(__S__, 4);
    n = ( int )(int)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (nparam <= 5) {
      if (__ERROR__) goto error;
      
      __self__->replaceText(pos, m, text, n);
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 6);
      if (__ERROR__) goto error;
      
      __self__->replaceText(pos, m, text, n, notify);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTabItem::onHotKeyPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXVisual * FXDrawable::getVisual()const  */
int lua_call1_FXDrawable__getVisual(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDrawable * __self__;
    
    __self__ = ( class FXDrawable * )lua_to_FXDrawable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXVisual(__S__, __self__->getVisual());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXFrame::load(class FXStream & store) */
int lua_call1_FXFrame__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFrame * __self__;
    
    __self__ = ( class FXFrame * )lua_to_FXFrame(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXScrollCorner::FXScrollCorner(class FXComposite * p) */
int lua_call1_FXScrollCorner__FXScrollCorner(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXScrollCorner(__S__, new FXScrollCorner(p));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXComposite::manufacture() */
int lua_call1_FXComposite__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXComposite::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXDial::getTipText()const  */
int lua_call1_FXDial__getTipText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDial * __self__;
    
    __self__ = ( class FXDial * )lua_to_FXDial(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getTipText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXProgressDialog::getMetaClass()const  */
int lua_call1_FXProgressDialog__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXProgressDialog * __self__;
    
    __self__ = ( class FXProgressDialog * )lua_to_FXProgressDialog(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCPrint::fillRectangle(FXint x, FXint y, FXint w, FXint h) */
int lua_call1_FXDCPrint__fillRectangle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXDCPrint * __self__;
     int x;
     int y;
     int w;
     int h;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    w = ( int )(int)lua_tonumber(__S__, 4);
    h = ( int )(int)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->fillRectangle(x, y, w, h);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMenuCascade::onEnter(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXListBox::manufacture() */
int lua_call1_FXListBox__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXListBox::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDial::setTipText(const class FXString & text) */
int lua_call1_FXDial__setTipText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDial * __self__;
    
    __self__ = ( class FXDial * )lua_to_FXDial(__S__, 1, &__ERROR__);
    int __err__13; static FXString __cstr__13; FXString * __str__13 = lua_to_FXString(__S__, 2, &__err__13);  class FXString & text = ( class FXString & ) (__str__13? *__str__13 : (__cstr__13 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__13));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTipText(text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXTable::getItemText(FXint r, FXint c)const  */
int lua_call1_FXTable__getItemText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTable * __self__;
     int r;
     int c;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    r = ( int )(int)lua_tonumber(__S__, 2);
    c = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getItemText(r, c).text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorSelector::onUpdAlphaLabel(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXTable::setMarginTop(FXint pt) */
int lua_call1_FXTable__setMarginTop(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTable * __self__;
     int pt;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    pt = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setMarginTop(pt);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTextField::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDC::drawLineSegments(const struct FXSegment * segments, FXuint nsegments) */
int lua_call1_FXDC__drawLineSegments(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDC * __self__;
     struct FXSegment * segments;
     unsigned int nsegments;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    segments = ( struct FXSegment * )lua_to_FXSegment(__S__, 2, &__ERROR__);
    nsegments = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawLineSegments(segments, nsegments);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMenuTitle::load(class FXStream & store) */
int lua_call1_FXMenuTitle__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMenuTitle * __self__;
    
    __self__ = ( class FXMenuTitle * )lua_to_FXMenuTitle(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXToolbarShell::getShadowColor()const  */
int lua_call1_FXToolbarShell__getShadowColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbarShell * __self__;
    
    __self__ = ( class FXToolbarShell * )lua_to_FXToolbarShell(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getShadowColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPrintDialog::onUpdCollateNormal(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXTabItem::manufacture() */
int lua_call1_FXTabItem__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXTabItem::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXIconItem::manufacture() */
int lua_call1_FXIconItem__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXIconItem::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXGroupBox::create() */
int lua_call1_FXGroupBox__create(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXGroupBox * __self__;
    
    __self__ = ( class FXGroupBox * )lua_to_FXGroupBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->create();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXOption::onKeyPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXuint FXTopWindow::getPackingHints()const  */
int lua_call1_FXTopWindow__getPackingHints(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTopWindow * __self__;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getPackingHints());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPopup::onCmdChoice(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXOptionMenu::onCmdSetIntValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXListBox::getDefaultWidth() */
int lua_call1_FXListBox__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXListBox * __self__;
    
    __self__ = ( class FXListBox * )lua_to_FXListBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXCharset & FXCharset::clear() */
int lua_call1_FXCharset__clear(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXCharset * __self__;
    
    __self__ = ( class FXCharset * )lua_to_FXCharset(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXCharset(__S__, &(__self__->clear()));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXText::getText()const  */
int lua_call1_FXText__getText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXText::getText(FXchar * text, FXint n)const  */
int lua_call2_FXText__getText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXText * __self__;
     char * text;
     int n;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    text = ( char * )(char  *)lua_tostring(__S__, 2);
    n = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->getText(text, n);
    ;
    return 0;
  }
  
error:
  return lua_call1_FXText__getText(__S__);
}
/* void FXTextField::killFocus() */
int lua_call1_FXTextField__killFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTextField * __self__;
    
    __self__ = ( class FXTextField * )lua_to_FXTextField(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->killFocus();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXToggleButton::onUncheck(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXPopup::onButtonPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXFileList::isItemFile(FXint index)const  */
int lua_call1_FXFileList__isItemFile(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileList * __self__;
     int index;
    
    __self__ = ( class FXFileList * )lua_to_FXFileList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isItemFile(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDataTarget::connect() */
int lua_call1_FXDataTarget__connect(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDataTarget * __self__;
    
    __self__ = ( class FXDataTarget * )lua_to_FXDataTarget(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->connect();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDataTarget::connect(FXshort & value) */
int lua_call2_FXDataTarget__connect(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDataTarget * __self__;
     short value;
    
    __self__ = ( class FXDataTarget * )lua_to_FXDataTarget(__S__, 1, &__ERROR__);
    value = ( short )(short)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->connect(value);
    lua_settop(__S__, 0);
    ;
    lua_pushnumber(__S__, value);
    return 1;
  }
  
error:
  return lua_call1_FXDataTarget__connect(__S__);
}
/* void FXDataTarget::connect(FXdouble & value) */
int lua_call3_FXDataTarget__connect(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDataTarget * __self__;
     double value;
    
    __self__ = ( class FXDataTarget * )lua_to_FXDataTarget(__S__, 1, &__ERROR__);
    value = ( double )(double)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->connect(value);
    lua_settop(__S__, 0);
    ;
    lua_pushnumber(__S__, value);
    return 1;
  }
  
error:
  return lua_call2_FXDataTarget__connect(__S__);
}
/* void FXDataTarget::connect(FXchar & value) */
int lua_call4_FXDataTarget__connect(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDataTarget * __self__;
     char value;
    
    __self__ = ( class FXDataTarget * )lua_to_FXDataTarget(__S__, 1, &__ERROR__);
    value = ( char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->connect(value);
    lua_settop(__S__, 0);
    ;
    lua_pushnumber(__S__, value);
    return 1;
  }
  
error:
  return lua_call3_FXDataTarget__connect(__S__);
}
/* void FXDataTarget::connect(FXuchar & value) */
int lua_call5_FXDataTarget__connect(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDataTarget * __self__;
     unsigned char value;
    
    __self__ = ( class FXDataTarget * )lua_to_FXDataTarget(__S__, 1, &__ERROR__);
    value = ( unsigned char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->connect(value);
    lua_settop(__S__, 0);
    ;
    lua_pushnumber(__S__, value);
    return 1;
  }
  
error:
  return lua_call4_FXDataTarget__connect(__S__);
}
/* void FXDataTarget::connect(FXushort & value) */
int lua_call6_FXDataTarget__connect(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDataTarget * __self__;
     unsigned short value;
    
    __self__ = ( class FXDataTarget * )lua_to_FXDataTarget(__S__, 1, &__ERROR__);
    value = ( unsigned short )(short)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->connect(value);
    lua_settop(__S__, 0);
    ;
    lua_pushnumber(__S__, value);
    return 1;
  }
  
error:
  return lua_call5_FXDataTarget__connect(__S__);
}
/* void FXDataTarget::connect(FXuint & value) */
int lua_call7_FXDataTarget__connect(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDataTarget * __self__;
     unsigned int value;
    
    __self__ = ( class FXDataTarget * )lua_to_FXDataTarget(__S__, 1, &__ERROR__);
    value = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->connect(value);
    lua_settop(__S__, 0);
    ;
    lua_pushnumber(__S__, value);
    return 1;
  }
  
error:
  return lua_call6_FXDataTarget__connect(__S__);
}
/* void FXDataTarget::connect(FXint & value) */
int lua_call8_FXDataTarget__connect(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDataTarget * __self__;
     int value;
    
    __self__ = ( class FXDataTarget * )lua_to_FXDataTarget(__S__, 1, &__ERROR__);
    value = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->connect(value);
    lua_settop(__S__, 0);
    ;
    lua_pushnumber(__S__, value);
    return 1;
  }
  
error:
  return lua_call7_FXDataTarget__connect(__S__);
}
/* void FXDataTarget::connect(FXfloat & value) */
int lua_call9_FXDataTarget__connect(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDataTarget * __self__;
     float value;
    
    __self__ = ( class FXDataTarget * )lua_to_FXDataTarget(__S__, 1, &__ERROR__);
    value = ( float )(float)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->connect(value);
    lua_settop(__S__, 0);
    ;
    lua_pushnumber(__S__, value);
    return 1;
  }
  
error:
  return lua_call8_FXDataTarget__connect(__S__);
}
/* void FXDataTarget::connect(class FXString & value) */
int lua_call10_FXDataTarget__connect(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDataTarget * __self__;
    
    __self__ = ( class FXDataTarget * )lua_to_FXDataTarget(__S__, 1, &__ERROR__);
    int __err__14; static FXString __cstr__14; FXString * __str__14 = lua_to_FXString(__S__, 2, &__err__14);  class FXString & value = ( class FXString & ) (__str__14? *__str__14 : (__cstr__14 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__14));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->connect(value);
    ;
    return 0;
  }
  
error:
  return lua_call9_FXDataTarget__connect(__S__);
}
/*  FXPCXIcon::FXPCXIcon(class FXApp * a, const void * pix=__null, FXColor clr=( ( ( FXuint ) ( FXuchar ) ( 192 ) )|( ( FXuint ) ( FXuchar ) ( 192 )<<8 )|( ( FXuint ) ( FXuchar ) ( 192 )<<16 )|0xff000000 ), FXuint opts=0, FXint w=1, FXint h=1) */
int lua_call1_FXPCXIcon__FXPCXIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXApp * a;
     void * pix;
     unsigned int clr;
     unsigned int opts;
     int w;
     int h;
    
    a = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXPCXIcon(__S__, new FXPCXIcon(a));
      return 1;
    } else {
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXPCXIcon(__S__, new FXPCXIcon(a, pix));
        return 1;
      } else {
        clr = ( unsigned int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXPCXIcon(__S__, new FXPCXIcon(a, pix, clr));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXPCXIcon(__S__, new FXPCXIcon(a, pix, clr, opts));
            return 1;
          } else {
            w = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXPCXIcon(__S__, new FXPCXIcon(a, pix, clr, opts, w));
              return 1;
            } else {
              h = ( int )(int)lua_tonumber(__S__, 6);
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXPCXIcon(__S__, new FXPCXIcon(a, pix, clr, opts, w, h));
              return 1;
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMessageBox::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* FXbool FXWindow::endDrag(FXbool drop=1) */
int lua_call1_FXWindow__endDrag(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
     unsigned char drop;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->endDrag());
      return 1;
    } else {
      drop = ( unsigned char )(char)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->endDrag(drop));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXObjectList::load(class FXStream & store) */
int lua_call1_FXObjectList__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXObjectList * __self__;
    
    __self__ = ( class FXObjectList * )lua_to_FXObjectList(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXListBox::getBackColor()const  */
int lua_call1_FXListBox__getBackColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXListBox * __self__;
    
    __self__ = ( class FXListBox * )lua_to_FXListBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBackColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXCheckButton::getDefaultWidth() */
int lua_call1_FXCheckButton__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXCheckButton * __self__;
    
    __self__ = ( class FXCheckButton * )lua_to_FXCheckButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIconList::setItemBigIcon(FXint index, class FXIcon * icon) */
int lua_call1_FXIconList__setItemBigIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXIconList * __self__;
     int index;
     class FXIcon * icon;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    icon = ( class FXIcon * )lua_to_FXIcon(__S__, 3, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setItemBigIcon(index, icon);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXSlider::getHeadSize()const  */
int lua_call1_FXSlider__getHeadSize(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSlider * __self__;
    
    __self__ = ( class FXSlider * )lua_to_FXSlider(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getHeadSize());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXToggleButton::FXToggleButton(class FXComposite * p, const class FXString & text1, const class FXString & text2, class FXIcon * icon1=__null, class FXIcon * icon2=__null, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=TOGGLEBUTTON_NORMAL, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=2, FXint pr=2, FXint pt=2, FXint pb=2) */
int lua_call1_FXToggleButton__FXToggleButton(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 3) goto error;
  {
     class FXComposite * p;
    int __err__15; static FXString __cstr__15; FXString * __str__15 = lua_to_FXString(__S__, 2, &__err__15);  class FXString & text1 = ( class FXString & ) (__str__15? *__str__15 : (__cstr__15 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__15));
     class FXIcon * icon1;
     class FXIcon * icon2;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    int __err__16; static FXString __cstr__16; FXString * __str__16 = lua_to_FXString(__S__, 3, &__err__16);  class FXString & text2 = ( class FXString & ) (__str__16? *__str__16 : (__cstr__16 =(FXString) (char *)lua_tostring(__S__, 3), __cstr__16));
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXToggleButton(__S__, new FXToggleButton(p, text1, text2));
      lua_pushstring(__S__, text1.text());
      return 2;
    } else {
      icon1 = ( class FXIcon * )lua_to_FXIcon(__S__, 4, &__ERROR__);
      if (nparam <= 4) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXToggleButton(__S__, new FXToggleButton(p, text1, text2, icon1));
        lua_pushstring(__S__, text1.text());
        return 2;
      } else {
        icon2 = ( class FXIcon * )lua_to_FXIcon(__S__, 5, &__ERROR__);
        if (nparam <= 5) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXToggleButton(__S__, new FXToggleButton(p, text1, text2, icon1, icon2));
          lua_pushstring(__S__, text1.text());
          return 2;
        } else {
          tgt = ( class FXObject * )lua_to_FXObject(__S__, 6, &__ERROR__);
          if (nparam <= 6) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXToggleButton(__S__, new FXToggleButton(p, text1, text2, icon1, icon2, tgt));
            lua_pushstring(__S__, text1.text());
            return 2;
          } else {
            sel = ( unsigned int )(int)lua_tonumber(__S__, 7);
            if (nparam <= 7) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXToggleButton(__S__, new FXToggleButton(p, text1, text2, icon1, icon2, tgt, sel));
              lua_pushstring(__S__, text1.text());
              return 2;
            } else {
              opts = ( unsigned int )(int)lua_tonumber(__S__, 8);
              if (nparam <= 8) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXToggleButton(__S__, new FXToggleButton(p, text1, text2, icon1, icon2, tgt, sel, opts));
                lua_pushstring(__S__, text1.text());
                return 2;
              } else {
                x = ( int )(int)lua_tonumber(__S__, 9);
                if (nparam <= 9) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXToggleButton(__S__, new FXToggleButton(p, text1, text2, icon1, icon2, tgt, sel, opts, x));
                  lua_pushstring(__S__, text1.text());
                  return 2;
                } else {
                  y = ( int )(int)lua_tonumber(__S__, 10);
                  if (nparam <= 10) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXToggleButton(__S__, new FXToggleButton(p, text1, text2, icon1, icon2, tgt, sel, opts, x, y));
                    lua_pushstring(__S__, text1.text());
                    return 2;
                  } else {
                    w = ( int )(int)lua_tonumber(__S__, 11);
                    if (nparam <= 11) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXToggleButton(__S__, new FXToggleButton(p, text1, text2, icon1, icon2, tgt, sel, opts, x, y, w));
                      lua_pushstring(__S__, text1.text());
                      return 2;
                    } else {
                      h = ( int )(int)lua_tonumber(__S__, 12);
                      if (nparam <= 12) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXToggleButton(__S__, new FXToggleButton(p, text1, text2, icon1, icon2, tgt, sel, opts, x, y, w, h));
                        lua_pushstring(__S__, text1.text());
                        return 2;
                      } else {
                        pl = ( int )(int)lua_tonumber(__S__, 13);
                        if (nparam <= 13) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXToggleButton(__S__, new FXToggleButton(p, text1, text2, icon1, icon2, tgt, sel, opts, x, y, w, h, pl));
                          lua_pushstring(__S__, text1.text());
                          return 2;
                        } else {
                          pr = ( int )(int)lua_tonumber(__S__, 14);
                          if (nparam <= 14) {
                            if (__ERROR__) goto error;
                            
                            lua_settop(__S__, 0);
                            lua_push_FXToggleButton(__S__, new FXToggleButton(p, text1, text2, icon1, icon2, tgt, sel, opts, x, y, w, h, pl, pr));
                            lua_pushstring(__S__, text1.text());
                            return 2;
                          } else {
                            pt = ( int )(int)lua_tonumber(__S__, 15);
                            if (nparam <= 15) {
                              if (__ERROR__) goto error;
                              
                              lua_settop(__S__, 0);
                              lua_push_FXToggleButton(__S__, new FXToggleButton(p, text1, text2, icon1, icon2, tgt, sel, opts, x, y, w, h, pl, pr, pt));
                              lua_pushstring(__S__, text1.text());
                              return 2;
                            } else {
                              pb = ( int )(int)lua_tonumber(__S__, 16);
                              if (__ERROR__) goto error;
                              
                              lua_settop(__S__, 0);
                              lua_push_FXToggleButton(__S__, new FXToggleButton(p, text1, text2, icon1, icon2, tgt, sel, opts, x, y, w, h, pl, pr, pt, pb));
                              lua_pushstring(__S__, text1.text());
                              return 2;
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMDIChild::setShadowColor(FXColor clr) */
int lua_call1_FXMDIChild__setShadowColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMDIChild * __self__;
     unsigned int clr;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setShadowColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXIcon * FXHeader::getItemIcon(FXint index)const  */
int lua_call1_FXHeader__getItemIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXHeader * __self__;
     int index;
    
    __self__ = ( class FXHeader * )lua_to_FXHeader(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXIcon(__S__, __self__->getItemIcon(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMenuCascade::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXColor FXTextField::getSelTextColor()const  */
int lua_call1_FXTextField__getSelTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTextField * __self__;
    
    __self__ = ( class FXTextField * )lua_to_FXTextField(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getSelTextColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXMetaClass::getBaseClass()const  */
int lua_call1_FXMetaClass__getBaseClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     struct FXMetaClass * __self__;
    
    __self__ = ( struct FXMetaClass * )lua_to_FXMetaClass(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getBaseClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTopWindow::getPadTop()const  */
int lua_call1_FXTopWindow__getPadTop(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTopWindow * __self__;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getPadTop());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPopup::onFocusPrev(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* struct FXFileAssoc * FXFileDict::findFileBinding(const FXchar * pathname) */
int lua_call1_FXFileDict__findFileBinding(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileDict * __self__;
     char * pathname;
    
    __self__ = ( class FXFileDict * )lua_to_FXFileDict(__S__, 1, &__ERROR__);
    pathname = ( char * )(char  *)lua_tostring(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXFileAssoc(__S__, __self__->findFileBinding(pathname));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXDragCorner::getMetaClass()const  */
int lua_call1_FXDragCorner__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDragCorner * __self__;
    
    __self__ = ( class FXDragCorner * )lua_to_FXDragCorner(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMDIChild::setTitle(const class FXString & name) */
int lua_call1_FXMDIChild__setTitle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMDIChild * __self__;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    int __err__17; static FXString __cstr__17; FXString * __str__17 = lua_to_FXString(__S__, 2, &__err__17);  class FXString & name = ( class FXString & ) (__str__17? *__str__17 : (__cstr__17 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__17));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTitle(name);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXScrollbar::getLine()const  */
int lua_call1_FXScrollbar__getLine(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXScrollbar * __self__;
    
    __self__ = ( class FXScrollbar * )lua_to_FXScrollbar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getLine());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const class FXHVec & ( FXHMat::operator [])(FXint i)const  */
/* SKIPPED (operator) */
/* void FXBMPIcon::savePixels(class FXStream & store)const  */
int lua_call1_FXBMPIcon__savePixels(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXBMPIcon * __self__;
    
    __self__ = ( class FXBMPIcon * )lua_to_FXBMPIcon(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->savePixels(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXWindow::isDropEnabled()const  */
int lua_call1_FXWindow__isDropEnabled(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isDropEnabled());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXSplitter::onFocusUp(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXDC::getClipX()const  */
int lua_call1_FXDC__getClipX(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDC * __self__;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getClipX());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::setX(FXint x) */
int lua_call1_FXWindow__setX(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXWindow * __self__;
     int x;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setX(x);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXToolbarShell::create() */
int lua_call1_FXToolbarShell__create(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbarShell * __self__;
    
    __self__ = ( class FXToolbarShell * )lua_to_FXToolbarShell(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->create();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCPrint::fillArc(FXint x, FXint y, FXint w, FXint h, FXint ang1, FXint ang2) */
int lua_call1_FXDCPrint__fillArc(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 7) goto error;
  {
     class FXDCPrint * __self__;
     int x;
     int y;
     int w;
     int h;
     int ang1;
     int ang2;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    w = ( int )(int)lua_tonumber(__S__, 4);
    h = ( int )(int)lua_tonumber(__S__, 5);
    ang1 = ( int )(int)lua_tonumber(__S__, 6);
    ang2 = ( int )(int)lua_tonumber(__S__, 7);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->fillArc(x, y, w, h, ang1, ang2);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXPopup::getDefaultHeight() */
int lua_call1_FXPopup__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXPopup * __self__;
    
    __self__ = ( class FXPopup * )lua_to_FXPopup(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXFont::rightBearing(FXchar ch)const  */
int lua_call1_FXFont__rightBearing(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFont * __self__;
     char ch;
    
    __self__ = ( class FXFont * )lua_to_FXFont(__S__, 1, &__ERROR__);
    ch = ( char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->rightBearing(ch));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorWell::onEndDrag(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXFont * FXStatusline::getFont()const  */
int lua_call1_FXStatusline__getFont(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXStatusline * __self__;
    
    __self__ = ( class FXStatusline * )lua_to_FXStatusline(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXFont(__S__, __self__->getFont());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPCXImage::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXArrowButton::onUngrabbed(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXIconItem::destroy() */
int lua_call1_FXIconItem__destroy(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconItem * __self__;
    
    __self__ = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->destroy();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIChild::onLeftBtnPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXColorBar::detach() */
int lua_call1_FXColorBar__detach(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorBar * __self__;
    
    __self__ = ( class FXColorBar * )lua_to_FXColorBar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->detach();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIChild::onMiddleBtnPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXFont * FXTooltip::getFont()const  */
int lua_call1_FXTooltip__getFont(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTooltip * __self__;
    
    __self__ = ( class FXTooltip * )lua_to_FXTooltip(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXFont(__S__, __self__->getFont());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTable::onCmdSelectAll(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXToolbarShell::getDefaultWidth() */
int lua_call1_FXToolbarShell__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbarShell * __self__;
    
    __self__ = ( class FXToolbarShell * )lua_to_FXToolbarShell(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXToolbarShell::getDefaultHeight() */
int lua_call1_FXToolbarShell__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbarShell * __self__;
    
    __self__ = ( class FXToolbarShell * )lua_to_FXToolbarShell(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXList::setItemIcon(FXint index, class FXIcon * icon) */
int lua_call1_FXList__setItemIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXList * __self__;
     int index;
     class FXIcon * icon;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    icon = ( class FXIcon * )lua_to_FXIcon(__S__, 3, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setItemIcon(index, icon);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXApp::setBlinkSpeed(FXuint speed) */
int lua_call1_FXApp__setBlinkSpeed(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXApp * __self__;
     unsigned int speed;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    speed = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBlinkSpeed(speed);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXDirItem::isBlockdev()const  */
int lua_call1_FXDirItem__isBlockdev(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDirItem * __self__;
    
    __self__ = ( class FXDirItem * )lua_to_FXDirItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isBlockdev());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCPrint::setForeground(FXColor clr) */
int lua_call1_FXDCPrint__setForeground(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDCPrint * __self__;
     unsigned int clr;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setForeground(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMenuSeparator::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXTreeItem::setIconOwned(FXuint owned=( OPENICONOWNED|CLOSEDICONOWNED )) */
int lua_call1_FXTreeItem__setIconOwned(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeItem * __self__;
     unsigned int owned;
    
    __self__ = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->setIconOwned();
    } else {
      owned = ( unsigned int )(int)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->setIconOwned(owned);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDrawable::resize(FXint w, FXint h) */
int lua_call1_FXDrawable__resize(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDrawable * __self__;
     int w;
     int h;
    
    __self__ = ( class FXDrawable * )lua_to_FXDrawable(__S__, 1, &__ERROR__);
    w = ( int )(int)lua_tonumber(__S__, 2);
    h = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->resize(w, h);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXSpinner::getHelpText()const  */
int lua_call1_FXSpinner__getHelpText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSpinner * __self__;
    
    __self__ = ( class FXSpinner * )lua_to_FXSpinner(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getHelpText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTabBar::save(class FXStream & store)const  */
int lua_call1_FXTabBar__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTabBar * __self__;
    
    __self__ = ( class FXTabBar * )lua_to_FXTabBar(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXText::setFocus() */
int lua_call1_FXText__setFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setFocus();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXDirBox::getDirectory()const  */
int lua_call1_FXDirBox__getDirectory(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDirBox * __self__;
    
    __self__ = ( class FXDirBox * )lua_to_FXDirBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getDirectory().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMenuCaption::setShadowColor(FXColor clr) */
int lua_call1_FXMenuCaption__setShadowColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMenuCaption * __self__;
     unsigned int clr;
    
    __self__ = ( class FXMenuCaption * )lua_to_FXMenuCaption(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setShadowColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXFileList::showOnlyDirectories()const  */
int lua_call1_FXFileList__showOnlyDirectories(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileList * __self__;
    
    __self__ = ( class FXFileList * )lua_to_FXFileList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->showOnlyDirectories());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXFileList::showOnlyDirectories(FXbool shown) */
int lua_call2_FXFileList__showOnlyDirectories(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileList * __self__;
     unsigned char shown;
    
    __self__ = ( class FXFileList * )lua_to_FXFileList(__S__, 1, &__ERROR__);
    shown = ( unsigned char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->showOnlyDirectories(shown);
    ;
    return 0;
  }
  
error:
  return lua_call1_FXFileList__showOnlyDirectories(__S__);
}
/*  FXListBox::FXListBox(class FXComposite * p, FXint nvis, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=FRAME_SUNKEN|FRAME_THICK|LISTBOX_NORMAL, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=2, FXint pr=2, FXint pt=2, FXint pb=2) */
int lua_call1_FXListBox__FXListBox(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXComposite * p;
     int nvis;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    nvis = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXListBox(__S__, new FXListBox(p, nvis));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 3, &__ERROR__);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXListBox(__S__, new FXListBox(p, nvis, tgt));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 4);
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXListBox(__S__, new FXListBox(p, nvis, tgt, sel));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 5);
          if (nparam <= 5) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXListBox(__S__, new FXListBox(p, nvis, tgt, sel, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 6);
            if (nparam <= 6) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXListBox(__S__, new FXListBox(p, nvis, tgt, sel, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 7);
              if (nparam <= 7) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXListBox(__S__, new FXListBox(p, nvis, tgt, sel, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 8);
                if (nparam <= 8) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXListBox(__S__, new FXListBox(p, nvis, tgt, sel, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 9);
                  if (nparam <= 9) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXListBox(__S__, new FXListBox(p, nvis, tgt, sel, opts, x, y, w, h));
                    return 1;
                  } else {
                    pl = ( int )(int)lua_tonumber(__S__, 10);
                    if (nparam <= 10) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXListBox(__S__, new FXListBox(p, nvis, tgt, sel, opts, x, y, w, h, pl));
                      return 1;
                    } else {
                      pr = ( int )(int)lua_tonumber(__S__, 11);
                      if (nparam <= 11) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXListBox(__S__, new FXListBox(p, nvis, tgt, sel, opts, x, y, w, h, pl, pr));
                        return 1;
                      } else {
                        pt = ( int )(int)lua_tonumber(__S__, 12);
                        if (nparam <= 12) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXListBox(__S__, new FXListBox(p, nvis, tgt, sel, opts, x, y, w, h, pl, pr, pt));
                          return 1;
                        } else {
                          pb = ( int )(int)lua_tonumber(__S__, 13);
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXListBox(__S__, new FXListBox(p, nvis, tgt, sel, opts, x, y, w, h, pl, pr, pt, pb));
                          return 1;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXAccelTable::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* FXint FXTable::getLeadingRows()const  */
int lua_call1_FXTable__getLeadingRows(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getLeadingRows());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCPrint::drawRectangles(const class FXRectangle * rectangles, FXuint nrectangles) */
int lua_call1_FXDCPrint__drawRectangles(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDCPrint * __self__;
     class FXRectangle * rectangles;
     unsigned int nrectangles;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    rectangles = ( class FXRectangle * )lua_to_FXRectangle(__S__, 2, &__ERROR__);
    nrectangles = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawRectangles(rectangles, nrectangles);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPacker::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXImage::resize(FXint w, FXint h) */
int lua_call1_FXImage__resize(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXImage * __self__;
     int w;
     int h;
    
    __self__ = ( class FXImage * )lua_to_FXImage(__S__, 1, &__ERROR__);
    w = ( int )(int)lua_tonumber(__S__, 2);
    h = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->resize(w, h);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXText::getChar(FXint pos)const  */
int lua_call1_FXText__getChar(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXText * __self__;
     int pos;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    pos = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getChar(pos));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXTime FXFileItem::getDate()const  */
int lua_call1_FXFileItem__getDate(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileItem * __self__;
    
    __self__ = ( class FXFileItem * )lua_to_FXFileItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDate());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIMaximizeButton::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXWindow::ungrabKeyboard() */
int lua_call1_FXWindow__ungrabKeyboard(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->ungrabKeyboard();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIconList::removeItem(FXint index, FXbool notify=0) */
int lua_call1_FXIconList__removeItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconList * __self__;
     int index;
     unsigned char notify;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      __self__->removeItem(index);
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      __self__->removeItem(index, notify);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXStatusbar::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXPopup::setOrientation(FXuint orient) */
int lua_call1_FXPopup__setOrientation(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXPopup * __self__;
     unsigned int orient;
    
    __self__ = ( class FXPopup * )lua_to_FXPopup(__S__, 1, &__ERROR__);
    orient = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setOrientation(orient);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXDC::getBackground()const  */
int lua_call1_FXDC__getBackground(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDC * __self__;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBackground());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTopWindow::place(FXuint placement) */
int lua_call1_FXTopWindow__place(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTopWindow * __self__;
     unsigned int placement;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    placement = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->place(placement);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMDIClient::save(class FXStream & store)const  */
int lua_call1_FXMDIClient__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMDIClient * __self__;
    
    __self__ = ( class FXMDIClient * )lua_to_FXMDIClient(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXWindow::acquireSelection(const FXDragType * types, FXuint numtypes) */
/* SKIPPED (argument #2) */
/* FXFillRule FXDC::getFillRule()const  */
int lua_call1_FXDC__getFillRule(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDC * __self__;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getFillRule());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXCheckButton::onFocusIn(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXuint FXVisual::getMaxColors()const  */
int lua_call1_FXVisual__getMaxColors(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXVisual * __self__;
    
    __self__ = ( class FXVisual * )lua_to_FXVisual(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getMaxColors());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXComboBox::setSortFunc(FXListSortFunc func) */
/* SKIPPED (argument #2) */
/* void FXDCPrint::drawArcs(const struct FXArc * arcs, FXuint narcs) */
int lua_call1_FXDCPrint__drawArcs(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDCPrint * __self__;
     struct FXArc * arcs;
     unsigned int narcs;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    arcs = ( struct FXArc * )lua_to_FXArc(__S__, 2, &__ERROR__);
    narcs = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawArcs(arcs, narcs);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXCanvas::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/*  FXHVec::operator FXColor()const  */
/* SKIPPED (operator) */
/* void FXDCPrint::drawPoint(FXint x, FXint y) */
int lua_call1_FXDCPrint__drawPoint(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDCPrint * __self__;
     int x;
     int y;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawPoint(x, y);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXRootWindow::move(FXint x, FXint y) */
int lua_call1_FXRootWindow__move(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXRootWindow * __self__;
     int x;
     int y;
    
    __self__ = ( class FXRootWindow * )lua_to_FXRootWindow(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->move(x, y);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDirList::setPattern(const class FXString & ptrn) */
int lua_call1_FXDirList__setPattern(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDirList * __self__;
    
    __self__ = ( class FXDirList * )lua_to_FXDirList(__S__, 1, &__ERROR__);
    int __err__18; static FXString __cstr__18; FXString * __str__18 = lua_to_FXString(__S__, 2, &__err__18);  class FXString & ptrn = ( class FXString & ) (__str__18? *__str__18 : (__cstr__18 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__18));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setPattern(ptrn);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXTGAIcon::getMetaClass()const  */
int lua_call1_FXTGAIcon__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTGAIcon * __self__;
    
    __self__ = ( class FXTGAIcon * )lua_to_FXTGAIcon(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXLabel::enable() */
int lua_call1_FXLabel__enable(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXLabel * __self__;
    
    __self__ = ( class FXLabel * )lua_to_FXLabel(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->enable();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* unsigned long FXDirItem::getSize()const  */
int lua_call1_FXDirItem__getSize(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDirItem * __self__;
    
    __self__ = ( class FXDirItem * )lua_to_FXDirItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getSize());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXMainWindow::manufacture() */
int lua_call1_FXMainWindow__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXMainWindow::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXStatusline::getDefaultHeight() */
int lua_call1_FXStatusline__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXStatusline * __self__;
    
    __self__ = ( class FXStatusline * )lua_to_FXStatusline(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXFont * FXGroupBox::getFont()const  */
int lua_call1_FXGroupBox__getFont(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXGroupBox * __self__;
    
    __self__ = ( class FXGroupBox * )lua_to_FXGroupBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXFont(__S__, __self__->getFont());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXText::setBarColor(FXColor clr) */
int lua_call1_FXText__setBarColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXText * __self__;
     unsigned int clr;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBarColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXWindow::onDestroy(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXWindow::onDNDEnter(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXuint FXProgressDialog::getProgress()const  */
int lua_call1_FXProgressDialog__getProgress(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXProgressDialog * __self__;
    
    __self__ = ( class FXProgressDialog * )lua_to_FXProgressDialog(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getProgress());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXArrowButton::setTipText(const class FXString & text) */
int lua_call1_FXArrowButton__setTipText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXArrowButton * __self__;
    
    __self__ = ( class FXArrowButton * )lua_to_FXArrowButton(__S__, 1, &__ERROR__);
    int __err__19; static FXString __cstr__19; FXString * __str__19 = lua_to_FXString(__S__, 2, &__err__19);  class FXString & text = ( class FXString & ) (__str__19? *__str__19 : (__cstr__19 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__19));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTipText(text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::destroy() */
int lua_call1_FXWindow__destroy(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->destroy();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTextField::onKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXColorSelector::onCmdColor(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXTabBar::getDefaultWidth() */
int lua_call1_FXTabBar__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTabBar * __self__;
    
    __self__ = ( class FXTabBar * )lua_to_FXTabBar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXCanvas::FXCanvas(class FXComposite * p, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=FRAME_NORMAL, FXint x=0, FXint y=0, FXint w=0, FXint h=0) */
int lua_call1_FXCanvas__FXCanvas(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXCanvas(__S__, new FXCanvas(p));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 2, &__ERROR__);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXCanvas(__S__, new FXCanvas(p, tgt));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXCanvas(__S__, new FXCanvas(p, tgt, sel));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXCanvas(__S__, new FXCanvas(p, tgt, sel, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXCanvas(__S__, new FXCanvas(p, tgt, sel, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 6);
              if (nparam <= 6) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXCanvas(__S__, new FXCanvas(p, tgt, sel, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 7);
                if (nparam <= 7) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXCanvas(__S__, new FXCanvas(p, tgt, sel, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 8);
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXCanvas(__S__, new FXCanvas(p, tgt, sel, opts, x, y, w, h));
                  return 1;
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTableItem::setJustify(FXuint justify) */
int lua_call1_FXTableItem__setJustify(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTableItem * __self__;
     unsigned int justify;
    
    __self__ = ( class FXTableItem * )lua_to_FXTableItem(__S__, 1, &__ERROR__);
    justify = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setJustify(justify);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMDIChild::restore(FXbool notify=0) */
int lua_call1_FXMDIChild__restore(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIChild * __self__;
     unsigned char notify;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->restore();
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->restore(notify);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXStreamStatus FXStream::status()const  */
int lua_call1_FXStream__status(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXStream * __self__;
    
    __self__ = ( class FXStream * )lua_to_FXStream(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->status());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXToolbarTab::disable() */
int lua_call1_FXToolbarTab__disable(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbarTab * __self__;
    
    __self__ = ( class FXToolbarTab * )lua_to_FXToolbarTab(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->disable();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXTreeItem * FXTreeListBox::addItemFirst(class FXTreeItem * p, class FXTreeItem * item) */
int lua_call1_FXTreeListBox__addItemFirst(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTreeListBox * __self__;
     class FXTreeItem * p;
     class FXTreeItem * item;
    
    __self__ = ( class FXTreeListBox * )lua_to_FXTreeListBox(__S__, 1, &__ERROR__);
    p = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 3, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXTreeItem(__S__, __self__->addItemFirst(p, item));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXTreeItem * FXTreeListBox::addItemFirst(class FXTreeItem * p, const class FXString & text, class FXIcon * oi=__null, class FXIcon * ci=__null, void * ptr=__null) */
int lua_call2_FXTreeListBox__addItemFirst(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTreeListBox * __self__;
     class FXTreeItem * p;
     class FXIcon * oi;
     class FXIcon * ci;
     void * ptr;
    
    __self__ = ( class FXTreeListBox * )lua_to_FXTreeListBox(__S__, 1, &__ERROR__);
    p = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    int __err__20; static FXString __cstr__20; FXString * __str__20 = lua_to_FXString(__S__, 3, &__err__20);  class FXString & text = ( class FXString & ) (__str__20? *__str__20 : (__cstr__20 =(FXString) (char *)lua_tostring(__S__, 3), __cstr__20));
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXTreeItem(__S__, __self__->addItemFirst(p, text));
      return 1;
    } else {
      oi = ( class FXIcon * )lua_to_FXIcon(__S__, 4, &__ERROR__);
      if (nparam <= 4) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXTreeItem(__S__, __self__->addItemFirst(p, text, oi));
        return 1;
      } else {
        ci = ( class FXIcon * )lua_to_FXIcon(__S__, 5, &__ERROR__);
        if (nparam <= 5) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXTreeItem(__S__, __self__->addItemFirst(p, text, oi, ci));
          return 1;
        } else {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXTreeItem(__S__, __self__->addItemFirst(p, text, oi, ci, ptr));
          return 1;
        }
      }
    }
  }
  
error:
  return lua_call1_FXTreeListBox__addItemFirst(__S__);
}
/* long FXProgressBar::onCmdSetIntValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FX4Splitter::load(class FXStream & store) */
int lua_call1_FX4Splitter__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FX4Splitter * __self__;
    
    __self__ = ( class FX4Splitter * )lua_to_FX4Splitter(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXColorWell::getHelpText()const  */
int lua_call1_FXColorWell__getHelpText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorWell * __self__;
    
    __self__ = ( class FXColorWell * )lua_to_FXColorWell(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getHelpText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCPrint::drawArc(FXint x, FXint y, FXint w, FXint h, FXint ang1, FXint ang2) */
int lua_call1_FXDCPrint__drawArc(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 7) goto error;
  {
     class FXDCPrint * __self__;
     int x;
     int y;
     int w;
     int h;
     int ang1;
     int ang2;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    w = ( int )(int)lua_tonumber(__S__, 4);
    h = ( int )(int)lua_tonumber(__S__, 5);
    ang1 = ( int )(int)lua_tonumber(__S__, 6);
    ang2 = ( int )(int)lua_tonumber(__S__, 7);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawArc(x, y, w, h, ang1, ang2);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXSettings::setModified(FXbool mdfy=1) */
int lua_call1_FXSettings__setModified(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSettings * __self__;
     unsigned char mdfy;
    
    __self__ = ( class FXSettings * )lua_to_FXSettings(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->setModified();
    } else {
      mdfy = ( unsigned char )(char)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->setModified(mdfy);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTreeList::setSelTextColor(FXColor clr) */
int lua_call1_FXTreeList__setSelTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeList * __self__;
     unsigned int clr;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setSelTextColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXSpinner::decrement() */
int lua_call1_FXSpinner__decrement(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSpinner * __self__;
    
    __self__ = ( class FXSpinner * )lua_to_FXSpinner(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->decrement();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXSpinner::onCmdIncrement(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXDirList::onUpdHideHidden(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXListBox::setHelpText(const class FXString & txt) */
int lua_call1_FXListBox__setHelpText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXListBox * __self__;
    
    __self__ = ( class FXListBox * )lua_to_FXListBox(__S__, 1, &__ERROR__);
    int __err__21; static FXString __cstr__21; FXString * __str__21 = lua_to_FXString(__S__, 2, &__err__21);  class FXString & txt = ( class FXString & ) (__str__21? *__str__21 : (__cstr__21 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__21));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setHelpText(txt);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMenuButton::onFocusOut(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXColorSelector::onCmdWheel(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXWindow::isDefault()const  */
int lua_call1_FXWindow__isDefault(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isDefault());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXImageView::load(class FXStream & store) */
int lua_call1_FXImageView__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXImageView * __self__;
    
    __self__ = ( class FXImageView * )lua_to_FXImageView(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXQuat::setRollPitchYaw(FXfloat roll, FXfloat pitch, FXfloat yaw) */
int lua_call1_FXQuat__setRollPitchYaw(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXQuat * __self__;
     float roll;
     float pitch;
     float yaw;
    
    __self__ = ( class FXQuat * )lua_to_FXQuat(__S__, 1, &__ERROR__);
    roll = ( float )(float)lua_tonumber(__S__, 2);
    pitch = ( float )(float)lua_tonumber(__S__, 3);
    yaw = ( float )(float)lua_tonumber(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setRollPitchYaw(roll, pitch, yaw);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXColorBar::getBarStyle()const  */
int lua_call1_FXColorBar__getBarStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorBar * __self__;
    
    __self__ = ( class FXColorBar * )lua_to_FXColorBar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBarStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTabItem::onFocusIn(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXString FXDirDialog::getDirectory()const  */
int lua_call1_FXDirDialog__getDirectory(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDirDialog * __self__;
    
    __self__ = ( class FXDirDialog * )lua_to_FXDirDialog(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getDirectory().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXMDIChild::getBaseColor()const  */
int lua_call1_FXMDIChild__getBaseColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIChild * __self__;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBaseColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXText::getWrapColumns()const  */
int lua_call1_FXText__getWrapColumns(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getWrapColumns());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXIcon * FXListItem::getIcon()const  */
int lua_call1_FXListItem__getIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXListItem * __self__;
    
    __self__ = ( class FXListItem * )lua_to_FXListItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXIcon(__S__, __self__->getIcon());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXProgressDialog::increment(FXuint value) */
int lua_call1_FXProgressDialog__increment(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXProgressDialog * __self__;
     unsigned int value;
    
    __self__ = ( class FXProgressDialog * )lua_to_FXProgressDialog(__S__, 1, &__ERROR__);
    value = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->increment(value);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onCmdCursorColumn(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXFontSelector::load(class FXStream & store) */
int lua_call1_FXFontSelector__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFontSelector * __self__;
    
    __self__ = ( class FXFontSelector * )lua_to_FXFontSelector(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXReplaceDialog::onSearchKey(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXColorBar::manufacture() */
int lua_call1_FXColorBar__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXColorBar::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDragCorner::onLeftBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXDirBox::onCmdSetStringValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXuint FXArrowButton::getJustify()const  */
int lua_call1_FXArrowButton__getJustify(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXArrowButton * __self__;
    
    __self__ = ( class FXArrowButton * )lua_to_FXArrowButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getJustify());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTopWindow::setMiniIcon(class FXIcon * ic) */
int lua_call1_FXTopWindow__setMiniIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTopWindow * __self__;
     class FXIcon * ic;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    ic = ( class FXIcon * )lua_to_FXIcon(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setMiniIcon(ic);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTGAImage::loadPixels(class FXStream & store) */
int lua_call1_FXTGAImage__loadPixels(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTGAImage * __self__;
    
    __self__ = ( class FXTGAImage * )lua_to_FXTGAImage(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->loadPixels(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXSlider::FXSlider(class FXComposite * p, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=SLIDER_NORMAL, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=0, FXint pr=0, FXint pt=0, FXint pb=0) */
int lua_call1_FXSlider__FXSlider(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXSlider(__S__, new FXSlider(p));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 2, &__ERROR__);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXSlider(__S__, new FXSlider(p, tgt));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXSlider(__S__, new FXSlider(p, tgt, sel));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXSlider(__S__, new FXSlider(p, tgt, sel, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXSlider(__S__, new FXSlider(p, tgt, sel, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 6);
              if (nparam <= 6) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXSlider(__S__, new FXSlider(p, tgt, sel, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 7);
                if (nparam <= 7) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXSlider(__S__, new FXSlider(p, tgt, sel, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 8);
                  if (nparam <= 8) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXSlider(__S__, new FXSlider(p, tgt, sel, opts, x, y, w, h));
                    return 1;
                  } else {
                    pl = ( int )(int)lua_tonumber(__S__, 9);
                    if (nparam <= 9) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXSlider(__S__, new FXSlider(p, tgt, sel, opts, x, y, w, h, pl));
                      return 1;
                    } else {
                      pr = ( int )(int)lua_tonumber(__S__, 10);
                      if (nparam <= 10) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXSlider(__S__, new FXSlider(p, tgt, sel, opts, x, y, w, h, pl, pr));
                        return 1;
                      } else {
                        pt = ( int )(int)lua_tonumber(__S__, 11);
                        if (nparam <= 11) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXSlider(__S__, new FXSlider(p, tgt, sel, opts, x, y, w, h, pl, pr, pt));
                          return 1;
                        } else {
                          pb = ( int )(int)lua_tonumber(__S__, 12);
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXSlider(__S__, new FXSlider(p, tgt, sel, opts, x, y, w, h, pl, pr, pt, pb));
                          return 1;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXIconList::selectItem(FXint index, FXbool notify=0) */
int lua_call1_FXIconList__selectItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconList * __self__;
     int index;
     unsigned char notify;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->selectItem(index));
      return 1;
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->selectItem(index, notify));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXShutter::onFocusDown(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXDirItem::isExecutable()const  */
int lua_call1_FXDirItem__isExecutable(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDirItem * __self__;
    
    __self__ = ( class FXDirItem * )lua_to_FXDirItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isExecutable());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXGIFIcon::manufacture() */
int lua_call1_FXGIFIcon__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXGIFIcon::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXMenuCaption::FXMenuCaption(class FXComposite * p, const class FXString & text, class FXIcon * ic=__null, FXuint opts=0) */
int lua_call1_FXMenuCaption__FXMenuCaption(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXComposite * p;
     class FXIcon * ic;
     unsigned int opts;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    int __err__22; static FXString __cstr__22; FXString * __str__22 = lua_to_FXString(__S__, 2, &__err__22);  class FXString & text = ( class FXString & ) (__str__22? *__str__22 : (__cstr__22 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__22));
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXMenuCaption(__S__, new FXMenuCaption(p, text));
      return 1;
    } else {
      ic = ( class FXIcon * )lua_to_FXIcon(__S__, 3, &__ERROR__);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXMenuCaption(__S__, new FXMenuCaption(p, text, ic));
        return 1;
      } else {
        opts = ( unsigned int )(int)lua_tonumber(__S__, 4);
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXMenuCaption(__S__, new FXMenuCaption(p, text, ic, opts));
        return 1;
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXColorWheel::getDefaultHeight() */
int lua_call1_FXColorWheel__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorWheel * __self__;
    
    __self__ = ( class FXColorWheel * )lua_to_FXColorWheel(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMenuCommand::setFocus() */
int lua_call1_FXMenuCommand__setFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuCommand * __self__;
    
    __self__ = ( class FXMenuCommand * )lua_to_FXMenuCommand(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setFocus();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXImage * FXImageView::getImage()const  */
int lua_call1_FXImageView__getImage(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXImageView * __self__;
    
    __self__ = ( class FXImageView * )lua_to_FXImageView(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXImage(__S__, __self__->getImage());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXComboBox::FXComboBox(class FXComposite * p, FXint cols, FXint nvis, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=COMBOBOX_NORMAL, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=2, FXint pr=2, FXint pt=2, FXint pb=2) */
int lua_call1_FXComboBox__FXComboBox(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 3) goto error;
  {
     class FXComposite * p;
     int cols;
     int nvis;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    cols = ( int )(int)lua_tonumber(__S__, 2);
    nvis = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXComboBox(__S__, new FXComboBox(p, cols, nvis));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 4, &__ERROR__);
      if (nparam <= 4) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXComboBox(__S__, new FXComboBox(p, cols, nvis, tgt));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 5);
        if (nparam <= 5) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXComboBox(__S__, new FXComboBox(p, cols, nvis, tgt, sel));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 6);
          if (nparam <= 6) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXComboBox(__S__, new FXComboBox(p, cols, nvis, tgt, sel, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 7);
            if (nparam <= 7) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXComboBox(__S__, new FXComboBox(p, cols, nvis, tgt, sel, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 8);
              if (nparam <= 8) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXComboBox(__S__, new FXComboBox(p, cols, nvis, tgt, sel, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 9);
                if (nparam <= 9) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXComboBox(__S__, new FXComboBox(p, cols, nvis, tgt, sel, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 10);
                  if (nparam <= 10) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXComboBox(__S__, new FXComboBox(p, cols, nvis, tgt, sel, opts, x, y, w, h));
                    return 1;
                  } else {
                    pl = ( int )(int)lua_tonumber(__S__, 11);
                    if (nparam <= 11) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXComboBox(__S__, new FXComboBox(p, cols, nvis, tgt, sel, opts, x, y, w, h, pl));
                      return 1;
                    } else {
                      pr = ( int )(int)lua_tonumber(__S__, 12);
                      if (nparam <= 12) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXComboBox(__S__, new FXComboBox(p, cols, nvis, tgt, sel, opts, x, y, w, h, pl, pr));
                        return 1;
                      } else {
                        pt = ( int )(int)lua_tonumber(__S__, 13);
                        if (nparam <= 13) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXComboBox(__S__, new FXComboBox(p, cols, nvis, tgt, sel, opts, x, y, w, h, pl, pr, pt));
                          return 1;
                        } else {
                          pb = ( int )(int)lua_tonumber(__S__, 14);
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXComboBox(__S__, new FXComboBox(p, cols, nvis, tgt, sel, opts, x, y, w, h, pl, pr, pt, pb));
                          return 1;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXCursor::loadPixels(class FXStream & store) */
int lua_call1_FXCursor__loadPixels(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXCursor * __self__;
    
    __self__ = ( class FXCursor * )lua_to_FXCursor(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->loadPixels(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXTGAImage::FXTGAImage(class FXApp * a, const void * pix=__null, FXuint opts=0, FXint w=1, FXint h=1) */
int lua_call1_FXTGAImage__FXTGAImage(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXApp * a;
     void * pix;
     unsigned int opts;
     int w;
     int h;
    
    a = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXTGAImage(__S__, new FXTGAImage(a));
      return 1;
    } else {
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXTGAImage(__S__, new FXTGAImage(a, pix));
        return 1;
      } else {
        opts = ( unsigned int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXTGAImage(__S__, new FXTGAImage(a, pix, opts));
          return 1;
        } else {
          w = ( int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXTGAImage(__S__, new FXTGAImage(a, pix, opts, w));
            return 1;
          } else {
            h = ( int )(int)lua_tonumber(__S__, 5);
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXTGAImage(__S__, new FXTGAImage(a, pix, opts, w, h));
            return 1;
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXPCXImage::getMetaClass()const  */
int lua_call1_FXPCXImage__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXPCXImage * __self__;
    
    __self__ = ( class FXPCXImage * )lua_to_FXPCXImage(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXRecentFiles::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXColorWheel::create() */
int lua_call1_FXColorWheel__create(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorWheel * __self__;
    
    __self__ = ( class FXColorWheel * )lua_to_FXColorWheel(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->create();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXObjectList::replace(FXint pos, class FXObject * p) */
int lua_call1_FXObjectList__replace(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXObjectList * __self__;
     int pos;
     class FXObject * p;
    
    __self__ = ( class FXObjectList * )lua_to_FXObjectList(__S__, 1, &__ERROR__);
    pos = ( int )(int)lua_tonumber(__S__, 2);
    p = ( class FXObject * )lua_to_FXObject(__S__, 3, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->replace(pos, p);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXComboBox::getItemText(FXint index)const  */
int lua_call1_FXComboBox__getItemText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXComboBox * __self__;
     int index;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getItemText(index).text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXRadioButton::getCheck()const  */
int lua_call1_FXRadioButton__getCheck(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXRadioButton * __self__;
    
    __self__ = ( class FXRadioButton * )lua_to_FXRadioButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getCheck());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXProgressBar::getDefaultHeight() */
int lua_call1_FXProgressBar__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXProgressBar * __self__;
    
    __self__ = ( class FXProgressBar * )lua_to_FXProgressBar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXGIFImage::loadPixels(class FXStream & store) */
int lua_call1_FXGIFImage__loadPixels(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXGIFImage * __self__;
    
    __self__ = ( class FXGIFImage * )lua_to_FXGIFImage(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->loadPixels(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXComboBox::setNumVisible(FXint nvis) */
int lua_call1_FXComboBox__setNumVisible(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXComboBox * __self__;
     int nvis;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    nvis = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setNumVisible(nvis);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXDirList::isItemDirectory(const class FXTreeItem * item)const  */
int lua_call1_FXDirList__isItemDirectory(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDirList * __self__;
     class FXTreeItem * item;
    
    __self__ = ( class FXDirList * )lua_to_FXDirList(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isItemDirectory(item));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXWindow * FXWindow::getChildAt(FXint x, FXint y)const  */
int lua_call1_FXWindow__getChildAt(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXWindow * __self__;
     int x;
     int y;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXWindow(__S__, __self__->getChildAt(x, y));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDirList::onDragged(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXHeader * FXIconList::getHeader()const  */
int lua_call1_FXIconList__getHeader(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconList * __self__;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXHeader(__S__, __self__->getHeader());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXApp::peekEvent() */
int lua_call1_FXApp__peekEvent(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->peekEvent());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPicker::onEnter(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXMenuButton::setButtonStyle(FXuint style) */
int lua_call1_FXMenuButton__setButtonStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMenuButton * __self__;
     unsigned int style;
    
    __self__ = ( class FXMenuButton * )lua_to_FXMenuButton(__S__, 1, &__ERROR__);
    style = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setButtonStyle(style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCPrint::drawPoints(const class FXPoint * points, FXuint npoints) */
int lua_call1_FXDCPrint__drawPoints(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDCPrint * __self__;
     class FXPoint * points;
     unsigned int npoints;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    points = ( class FXPoint * )lua_to_FXPoint(__S__, 2, &__ERROR__);
    npoints = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawPoints(points, npoints);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTable::onCmdMovePageDown(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTabBar::onCmdSetIntValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXSize & ( FXSize::operator =)(const class FXSize & s) */
/* SKIPPED (operator) */
/* void FXFileDialog::setSelectMode(FXuint mode) */
int lua_call1_FXFileDialog__setSelectMode(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileDialog * __self__;
     unsigned int mode;
    
    __self__ = ( class FXFileDialog * )lua_to_FXFileDialog(__S__, 1, &__ERROR__);
    mode = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setSelectMode(mode);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTextField::onUpdToggleOverstrike(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXFileList::setDirectory(const class FXString & path) */
int lua_call1_FXFileList__setDirectory(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileList * __self__;
    
    __self__ = ( class FXFileList * )lua_to_FXFileList(__S__, 1, &__ERROR__);
    int __err__23; static FXString __cstr__23; FXString * __str__23 = lua_to_FXString(__S__, 2, &__err__23);  class FXString & path = ( class FXString & ) (__str__23? *__str__23 : (__cstr__23 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__23));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setDirectory(path);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXToolbarTab::onUngrabbed(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTable::onCmdMoveUp(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXDirList::onDNDDrop(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXColor FXPopup::getBorderColor()const  */
int lua_call1_FXPopup__getBorderColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXPopup * __self__;
    
    __self__ = ( class FXPopup * )lua_to_FXPopup(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBorderColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXToolbarShell::manufacture() */
int lua_call1_FXToolbarShell__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXToolbarShell::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXList::setSortFunc(FXListSortFunc func) */
/* SKIPPED (argument #2) */
/* long FXColorSelector::onCmdColorPick(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXTopWindow::hide() */
int lua_call1_FXTopWindow__hide(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTopWindow * __self__;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->hide();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXHeader::getDefaultHeight() */
int lua_call1_FXHeader__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXHeader * __self__;
    
    __self__ = ( class FXHeader * )lua_to_FXHeader(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTreeList::onClicked(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* const class FXString & FXRegistry::getAppKey()const  */
int lua_call1_FXRegistry__getAppKey(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXRegistry * __self__;
    
    __self__ = ( class FXRegistry * )lua_to_FXRegistry(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getAppKey().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXHeaderItem::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXText::onCmdOverstString(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXMDIChild::setNormalX(FXint x) */
int lua_call1_FXMDIChild__setNormalX(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMDIChild * __self__;
     int x;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setNormalX(x);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIMenu::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXListBox::setNumVisible(FXint nvis) */
int lua_call1_FXListBox__setNumVisible(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXListBox * __self__;
     int nvis;
    
    __self__ = ( class FXListBox * )lua_to_FXListBox(__S__, 1, &__ERROR__);
    nvis = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setNumVisible(nvis);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorSelector::onUpdHSVText(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTextField::onCmdDelete(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXListItem::setIcon(class FXIcon * icn) */
int lua_call1_FXListItem__setIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXListItem * __self__;
     class FXIcon * icn;
    
    __self__ = ( class FXListItem * )lua_to_FXListItem(__S__, 1, &__ERROR__);
    icn = ( class FXIcon * )lua_to_FXIcon(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setIcon(icn);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXList::onTripleClicked(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXTabBook::getDefaultHeight() */
int lua_call1_FXTabBook__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTabBook * __self__;
    
    __self__ = ( class FXTabBook * )lua_to_FXTabBook(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXPCXIcon::manufacture() */
int lua_call1_FXPCXIcon__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXPCXIcon::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::update() */
int lua_call1_FXWindow__update(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->update();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::update(FXint x, FXint y, FXint w, FXint h) */
int lua_call2_FXWindow__update(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXWindow * __self__;
     int x;
     int y;
     int w;
     int h;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    w = ( int )(int)lua_tonumber(__S__, 4);
    h = ( int )(int)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->update(x, y, w, h);
    ;
    return 0;
  }
  
error:
  return lua_call1_FXWindow__update(__S__);
}
/* void FXSlider::getRange(FXint & lo, FXint & hi)const  */
int lua_call1_FXSlider__getRange(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXSlider * __self__;
     int lo;
     int hi;
    
    __self__ = ( class FXSlider * )lua_to_FXSlider(__S__, 1, &__ERROR__);
    lo = ( int )(int)lua_tonumber(__S__, 2);
    hi = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->getRange(lo, hi);
    lua_settop(__S__, 0);
    ;
    lua_pushnumber(__S__, lo);
    lua_pushnumber(__S__, hi);
    return 2;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXMenuPane::FXMenuPane(class FXWindow * owner, FXuint opts=0) */
int lua_call1_FXMenuPane__FXMenuPane(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXWindow * owner;
     unsigned int opts;
    
    owner = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXMenuPane(__S__, new FXMenuPane(owner));
      return 1;
    } else {
      opts = ( unsigned int )(int)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXMenuPane(__S__, new FXMenuPane(owner, opts));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXApp::setSelbackColor(FXColor color) */
int lua_call1_FXApp__setSelbackColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXApp * __self__;
     unsigned int color;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    color = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setSelbackColor(color);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXComboBox::setHelpText(const class FXString & txt) */
int lua_call1_FXComboBox__setHelpText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXComboBox * __self__;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    int __err__24; static FXString __cstr__24; FXString * __str__24 = lua_to_FXString(__S__, 2, &__err__24);  class FXString & txt = ( class FXString & ) (__str__24? *__str__24 : (__cstr__24 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__24));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setHelpText(txt);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXMenuCaption::getSelTextColor()const  */
int lua_call1_FXMenuCaption__getSelTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuCaption * __self__;
    
    __self__ = ( class FXMenuCaption * )lua_to_FXMenuCaption(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getSelTextColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXFileSelector::save(class FXStream & store)const  */
int lua_call1_FXFileSelector__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileSelector * __self__;
    
    __self__ = ( class FXFileSelector * )lua_to_FXFileSelector(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXLabel::setHelpText(const class FXString & text) */
int lua_call1_FXLabel__setHelpText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXLabel * __self__;
    
    __self__ = ( class FXLabel * )lua_to_FXLabel(__S__, 1, &__ERROR__);
    int __err__25; static FXString __cstr__25; FXString * __str__25 = lua_to_FXString(__S__, 2, &__err__25);  class FXString & text = ( class FXString & ) (__str__25? *__str__25 : (__cstr__25 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__25));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setHelpText(text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDirList::load(class FXStream & store) */
int lua_call1_FXDirList__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDirList * __self__;
    
    __self__ = ( class FXDirList * )lua_to_FXDirList(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXUndoList::redo() */
int lua_call1_FXUndoList__redo(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXUndoList * __self__;
    
    __self__ = ( class FXUndoList * )lua_to_FXUndoList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->redo());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXfloat FXColorWheel::getHue()const  */
int lua_call1_FXColorWheel__getHue(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorWheel * __self__;
    
    __self__ = ( class FXColorWheel * )lua_to_FXColorWheel(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getHue());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTable::onUpdHorzGrid(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXMenuCommand::onButtonPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* const struct FXMetaClass * FXApp::getMetaClass()const  */
int lua_call1_FXApp__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXTextField::isEditable()const  */
int lua_call1_FXTextField__isEditable(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTextField * __self__;
    
    __self__ = ( class FXTextField * )lua_to_FXTextField(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isEditable());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::reparent(class FXWindow * newparent) */
int lua_call1_FXWindow__reparent(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXWindow * __self__;
     class FXWindow * newparent;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    newparent = ( class FXWindow * )lua_to_FXWindow(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->reparent(newparent);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXStatusline::detach() */
int lua_call1_FXStatusline__detach(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXStatusline * __self__;
    
    __self__ = ( class FXStatusline * )lua_to_FXStatusline(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->detach();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXTopWindow::getMetaClass()const  */
int lua_call1_FXTopWindow__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTopWindow * __self__;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FX4Splitter::onFocusUp(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTextField::onLeftBtnPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXMenuButton::onLeftBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDCWindow::setBackground(FXColor clr) */
int lua_call1_FXDCWindow__setBackground(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDCWindow * __self__;
     unsigned int clr;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBackground(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXText::getBottomLine()const  */
int lua_call1_FXText__getBottomLine(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBottomLine());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTreeList::getContentWidth() */
int lua_call1_FXTreeList__getContentWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeList * __self__;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getContentWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXFileDialog::getOpenDirectory(class FXWindow * owner, const class FXString & caption, const class FXString & path) */
int lua_call1_FXFileDialog__getOpenDirectory(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 3) goto error;
  {
     class FXWindow * owner;
    int __err__26; static FXString __cstr__26; FXString * __str__26 = lua_to_FXString(__S__, 2, &__err__26);  class FXString & caption = ( class FXString & ) (__str__26? *__str__26 : (__cstr__26 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__26));
    
    owner = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    int __err__27; static FXString __cstr__27; FXString * __str__27 = lua_to_FXString(__S__, 3, &__err__27);  class FXString & path = ( class FXString & ) (__str__27? *__str__27 : (__cstr__27 =(FXString) (char *)lua_tostring(__S__, 3), __cstr__27));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, FXFileDialog::getOpenDirectory(owner, caption, path).text());
    lua_pushstring(__S__, caption.text());
    return 2;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXTable::getGridColor()const  */
int lua_call1_FXTable__getGridColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getGridColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXFileSelector::onCmdDirTree(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXOption::getDefaultWidth() */
int lua_call1_FXOption__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXOption * __self__;
    
    __self__ = ( class FXOption * )lua_to_FXOption(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXScrollArea::getContentWidth() */
int lua_call1_FXScrollArea__getContentWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXScrollArea * __self__;
    
    __self__ = ( class FXScrollArea * )lua_to_FXScrollArea(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getContentWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorWheel::onLeftBtnPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXRectangle & FXRectangle::grow(FXshort margin) */
int lua_call1_FXRectangle__grow(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXRectangle * __self__;
     short margin;
    
    __self__ = ( class FXRectangle * )lua_to_FXRectangle(__S__, 1, &__ERROR__);
    margin = ( short )(short)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXRectangle(__S__, &(__self__->grow(margin)));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXRectangle & FXRectangle::grow(FXshort hormargin, FXshort vermargin) */
int lua_call2_FXRectangle__grow(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXRectangle * __self__;
     short hormargin;
     short vermargin;
    
    __self__ = ( class FXRectangle * )lua_to_FXRectangle(__S__, 1, &__ERROR__);
    hormargin = ( short )(short)lua_tonumber(__S__, 2);
    vermargin = ( short )(short)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXRectangle(__S__, &(__self__->grow(hormargin, vermargin)));
    return 1;
  }
  
error:
  return lua_call1_FXRectangle__grow(__S__);
}
/* class FXRectangle & FXRectangle::grow(FXshort leftmargin, FXshort rightmargin, FXshort topmargin, FXshort bottommargin) */
int lua_call3_FXRectangle__grow(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXRectangle * __self__;
     short leftmargin;
     short rightmargin;
     short topmargin;
     short bottommargin;
    
    __self__ = ( class FXRectangle * )lua_to_FXRectangle(__S__, 1, &__ERROR__);
    leftmargin = ( short )(short)lua_tonumber(__S__, 2);
    rightmargin = ( short )(short)lua_tonumber(__S__, 3);
    topmargin = ( short )(short)lua_tonumber(__S__, 4);
    bottommargin = ( short )(short)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXRectangle(__S__, &(__self__->grow(leftmargin, rightmargin, topmargin, bottommargin)));
    return 1;
  }
  
error:
  return lua_call2_FXRectangle__grow(__S__);
}
/* long FXMenuCommand::onCmdSetValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTabBar::onFocusNext(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXSlider::setHeadSize(FXint hs) */
int lua_call1_FXSlider__setHeadSize(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXSlider * __self__;
     int hs;
    
    __self__ = ( class FXSlider * )lua_to_FXSlider(__S__, 1, &__ERROR__);
    hs = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setHeadSize(hs);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIChild::onFocusSelf(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTabBar::onCmdOpen(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXFontSelector::onUpdCharset(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXList::onQueryTip(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXWindow::ungrab() */
int lua_call1_FXWindow__ungrab(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->ungrab();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXMessageBox::question(class FXWindow * owner, FXuint opts, const char * caption, const char * message, ...) */
int lua_call1_FXMessageBox__question(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 4) goto error;
  {
     class FXWindow * owner;
     unsigned int opts;
     char * caption;
     char * message;
    
    owner = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    opts = ( unsigned int )(int)lua_tonumber(__S__, 2);
    caption = ( char * )(char  *)lua_tostring(__S__, 3);
    message = ( char * )(char  *)lua_tostring(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, FXMessageBox::question(owner, opts, caption, message));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIChild::onDeselected(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  ( FXDHMat::operator constFXdouble*)()const  */
/* SKIPPED (operator) */
/* void FXDCWindow::drawPointsRel(const class FXPoint * points, FXuint npoints) */
int lua_call1_FXDCWindow__drawPointsRel(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDCWindow * __self__;
     class FXPoint * points;
     unsigned int npoints;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    points = ( class FXPoint * )lua_to_FXPoint(__S__, 2, &__ERROR__);
    npoints = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawPointsRel(points, npoints);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onDragged(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXToggleButton::onCheck(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXTreeList::killSelection(FXbool notify=0) */
int lua_call1_FXTreeList__killSelection(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeList * __self__;
     unsigned char notify;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->killSelection());
      return 1;
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->killSelection(notify));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXHVec & ( FXHVec::operator *=)(FXfloat n) */
/* SKIPPED (operator) */
/* long FXToolbarTab::onUpdUncollapse(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXMatrix::onFocusUp(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXArrowButton::getState()const  */
int lua_call1_FXArrowButton__getState(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXArrowButton * __self__;
    
    __self__ = ( class FXArrowButton * )lua_to_FXArrowButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getState());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXTreeList::enableItem(class FXTreeItem * item) */
int lua_call1_FXTreeList__enableItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeList * __self__;
     class FXTreeItem * item;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->enableItem(item));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXIconList::getNumCols()const  */
int lua_call1_FXIconList__getNumCols(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconList * __self__;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getNumCols());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onFlash(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXFontSelector::onCmdWeight(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXToolbarShell::setFrameStyle(FXuint style) */
int lua_call1_FXToolbarShell__setFrameStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXToolbarShell * __self__;
     unsigned int style;
    
    __self__ = ( class FXToolbarShell * )lua_to_FXToolbarShell(__S__, 1, &__ERROR__);
    style = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setFrameStyle(style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIChild::onLeftBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXPacker::onFocusLeft(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXColor FXDragCorner::getHiliteColor()const  */
int lua_call1_FXDragCorner__getHiliteColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDragCorner * __self__;
    
    __self__ = ( class FXDragCorner * )lua_to_FXDragCorner(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getHiliteColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXProgressBar::save(class FXStream & store)const  */
int lua_call1_FXProgressBar__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXProgressBar * __self__;
    
    __self__ = ( class FXProgressBar * )lua_to_FXProgressBar(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXShutter::onFocusUp(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXHeader::getItemAt(FXint offset)const  */
int lua_call1_FXHeader__getItemAt(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXHeader * __self__;
     int offset;
    
    __self__ = ( class FXHeader * )lua_to_FXHeader(__S__, 1, &__ERROR__);
    offset = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getItemAt(offset));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXRegion::empty()const  */
int lua_call1_FXRegion__empty(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXRegion * __self__;
    
    __self__ = ( class FXRegion * )lua_to_FXRegion(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->empty());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::setBaseColor(FXColor clr) */
int lua_call1_FXTable__setBaseColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTable * __self__;
     unsigned int clr;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBaseColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIClient::onCmdActivatePrev(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXCursor::detach() */
int lua_call1_FXCursor__detach(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXCursor * __self__;
    
    __self__ = ( class FXCursor * )lua_to_FXCursor(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->detach();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXImage::scale(FXint w, FXint h) */
int lua_call1_FXImage__scale(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXImage * __self__;
     int w;
     int h;
    
    __self__ = ( class FXImage * )lua_to_FXImage(__S__, 1, &__ERROR__);
    w = ( int )(int)lua_tonumber(__S__, 2);
    h = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->scale(w, h);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXTooltip::getText()const  */
int lua_call1_FXTooltip__getText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTooltip * __self__;
    
    __self__ = ( class FXTooltip * )lua_to_FXTooltip(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTextField::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void * FXListItem::getData()const  */
/* SKIPPED (return type) */
/* void FXTopWindow::setPadRight(FXint pr) */
int lua_call1_FXTopWindow__setPadRight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTopWindow * __self__;
     int pr;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    pr = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setPadRight(pr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXComboBox::prependItem(const class FXString & text, void * ptr=__null) */
int lua_call1_FXComboBox__prependItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXComboBox * __self__;
     void * ptr;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    int __err__28; static FXString __cstr__28; FXString * __str__28 = lua_to_FXString(__S__, 2, &__err__28);  class FXString & text = ( class FXString & ) (__str__28? *__str__28 : (__cstr__28 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__28));
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      __self__->prependItem(text);
    } else {
      if (__ERROR__) goto error;
      
      __self__->prependItem(text, ptr);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXImage::destroy() */
int lua_call1_FXImage__destroy(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXImage * __self__;
    
    __self__ = ( class FXImage * )lua_to_FXImage(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->destroy();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDC::setTextFont(class FXFont * fnt) */
int lua_call1_FXDC__setTextFont(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDC * __self__;
     class FXFont * fnt;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    fnt = ( class FXFont * )lua_to_FXFont(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTextFont(fnt);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXProgressDialog::onCmdSetStringValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXColorWheel::load(class FXStream & store) */
int lua_call1_FXColorWheel__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXColorWheel * __self__;
    
    __self__ = ( class FXColorWheel * )lua_to_FXColorWheel(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTopWindow::getDefaultHeight() */
int lua_call1_FXTopWindow__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTopWindow * __self__;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTreeList::setSortFunc(FXTreeListSortFunc func) */
/* SKIPPED (argument #2) */
/* FXint FXDrawable::getWidth()const  */
int lua_call1_FXDrawable__getWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDrawable * __self__;
    
    __self__ = ( class FXDrawable * )lua_to_FXDrawable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXArrowButton::onUpdate(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXCheckButton::onEnter(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXFont * FXComboBox::getFont()const  */
int lua_call1_FXComboBox__getFont(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXComboBox * __self__;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXFont(__S__, __self__->getFont());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onCmdSearchSel(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FX4Splitter::getDefaultWidth() */
int lua_call1_FX4Splitter__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FX4Splitter * __self__;
    
    __self__ = ( class FX4Splitter * )lua_to_FX4Splitter(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXApp::getAnimSpeed()const  */
int lua_call1_FXApp__getAnimSpeed(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getAnimSpeed());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXLdouble::set(double v) */
int lua_call1_FXLdouble__set(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXLdouble * __self__;
     double v;
    
    __self__ = ( class FXLdouble * )lua_to_FXLdouble(__S__, 1, &__ERROR__);
    v = ( double )(double)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->set(v);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTable::getDefRowHeight()const  */
int lua_call1_FXTable__getDefRowHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefRowHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXBitmap::getPixel(FXint x, FXint y)const  */
int lua_call1_FXBitmap__getPixel(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXBitmap * __self__;
     int x;
     int y;
    
    __self__ = ( class FXBitmap * )lua_to_FXBitmap(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getPixel(x, y));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXListItem::getWidth(const class FXList * list)const  */
int lua_call1_FXListItem__getWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXListItem * __self__;
     class FXList * list;
    
    __self__ = ( class FXListItem * )lua_to_FXListItem(__S__, 1, &__ERROR__);
    list = ( class FXList * )lua_to_FXList(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getWidth(list));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXIcon * FXIconItem::getBigIcon()const  */
int lua_call1_FXIconItem__getBigIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconItem * __self__;
    
    __self__ = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXIcon(__S__, __self__->getBigIcon());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FX4Splitter::getMetaClass()const  */
int lua_call1_FX4Splitter__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FX4Splitter * __self__;
    
    __self__ = ( class FX4Splitter * )lua_to_FX4Splitter(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::repaint() */
int lua_call1_FXWindow__repaint(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->repaint();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::repaint(FXint x, FXint y, FXint w, FXint h) */
int lua_call2_FXWindow__repaint(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXWindow * __self__;
     int x;
     int y;
     int w;
     int h;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    w = ( int )(int)lua_tonumber(__S__, 4);
    h = ( int )(int)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->repaint(x, y, w, h);
    ;
    return 0;
  }
  
error:
  return lua_call1_FXWindow__repaint(__S__);
}
/* void FXToolbarTab::enable() */
int lua_call1_FXToolbarTab__enable(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbarTab * __self__;
    
    __self__ = ( class FXToolbarTab * )lua_to_FXToolbarTab(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->enable();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXColorBar::create() */
int lua_call1_FXColorBar__create(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorBar * __self__;
    
    __self__ = ( class FXColorBar * )lua_to_FXColorBar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->create();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXDVec & ( FXDVec::operator -=)(const class FXDVec & a) */
/* SKIPPED (operator) */
/* const struct FXMetaClass * FXIconItem::getMetaClass()const  */
int lua_call1_FXIconItem__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconItem * __self__;
    
    __self__ = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCWindow::setStipple(class FXBitmap * stipple, FXint dx=0, FXint dy=0) */
int lua_call1_FXDCWindow__setStipple(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDCWindow * __self__;
     class FXBitmap * stipple;
     int dx;
     int dy;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    stipple = ( class FXBitmap * )lua_to_FXBitmap(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      __self__->setStipple(stipple);
    } else {
      dx = ( int )(int)lua_tonumber(__S__, 3);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        __self__->setStipple(stipple, dx);
      } else {
        dy = ( int )(int)lua_tonumber(__S__, 4);
        if (__ERROR__) goto error;
        
        __self__->setStipple(stipple, dx, dy);
      }
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCWindow::setStipple(FXStipplePattern stipple, FXint dx=0, FXint dy=0) */
int lua_call2_FXDCWindow__setStipple(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDCWindow * __self__;
     FXStipplePattern stipple;
     int dx;
     int dy;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    stipple = ( FXStipplePattern )(FXStipplePattern)(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      __self__->setStipple(stipple);
    } else {
      dx = ( int )(int)lua_tonumber(__S__, 3);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        __self__->setStipple(stipple, dx);
      } else {
        dy = ( int )(int)lua_tonumber(__S__, 4);
        if (__ERROR__) goto error;
        
        __self__->setStipple(stipple, dx, dy);
      }
    }
    ;
    return 0;
  }
  
error:
  return lua_call1_FXDCWindow__setStipple(__S__);
}
/* void FXTable::showHorzGrid(FXbool on=1) */
int lua_call1_FXTable__showHorzGrid(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
     unsigned char on;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->showHorzGrid();
    } else {
      on = ( unsigned char )(char)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->showHorzGrid(on);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXDCPrint::FXDCPrint(class FXApp * a) */
int lua_call1_FXDCPrint__FXDCPrint(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXApp * a;
    
    a = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXDCPrint(__S__, new FXDCPrint(a));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXRadioButton::onUncheck(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXToolbar::setWetDock(class FXComposite * wet) */
int lua_call1_FXToolbar__setWetDock(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXToolbar * __self__;
     class FXComposite * wet;
    
    __self__ = ( class FXToolbar * )lua_to_FXToolbar(__S__, 1, &__ERROR__);
    wet = ( class FXComposite * )lua_to_FXComposite(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setWetDock(wet);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTextField::onUpdToggleEditable(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXShutterItem::setHelpText(const class FXString & text) */
int lua_call1_FXShutterItem__setHelpText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXShutterItem * __self__;
    
    __self__ = ( class FXShutterItem * )lua_to_FXShutterItem(__S__, 1, &__ERROR__);
    int __err__29; static FXString __cstr__29; FXString * __str__29 = lua_to_FXString(__S__, 2, &__err__29);  class FXString & text = ( class FXString & ) (__str__29? *__str__29 : (__cstr__29 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__29));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setHelpText(text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* struct FXFileAssoc * FXFileDict::associate(const FXchar * key) */
int lua_call1_FXFileDict__associate(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileDict * __self__;
     char * key;
    
    __self__ = ( class FXFileDict * )lua_to_FXFileDict(__S__, 1, &__ERROR__);
    key = ( char * )(char  *)lua_tostring(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXFileAssoc(__S__, __self__->associate(key));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIcon::render() */
int lua_call1_FXIcon__render(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIcon * __self__;
    
    __self__ = ( class FXIcon * )lua_to_FXIcon(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->render();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXInputDialog::setText(const class FXString & text) */
int lua_call1_FXInputDialog__setText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXInputDialog * __self__;
    
    __self__ = ( class FXInputDialog * )lua_to_FXInputDialog(__S__, 1, &__ERROR__);
    int __err__30; static FXString __cstr__30; FXString * __str__30 = lua_to_FXString(__S__, 2, &__err__30);  class FXString & text = ( class FXString & ) (__str__30? *__str__30 : (__cstr__30 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__30));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setText(text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDelegator::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* FXfloat FXColorWheel::getSat()const  */
int lua_call1_FXColorWheel__getSat(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorWheel * __self__;
    
    __self__ = ( class FXColorWheel * )lua_to_FXColorWheel(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getSat());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTable::onLeftBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXMDIChild::onUpdClose(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* const struct FXMetaClass * FXScrollWindow::getMetaClass()const  */
int lua_call1_FXScrollWindow__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXScrollWindow * __self__;
    
    __self__ = ( class FXScrollWindow * )lua_to_FXScrollWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTable::onCmdMoveEnd(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXVec & ( FXVec::operator +=)(const class FXVec & a) */
/* SKIPPED (operator) */
/* long FXColorWell::onKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXuint FXCheckButton::getCheckButtonStyle()const  */
int lua_call1_FXCheckButton__getCheckButtonStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXCheckButton * __self__;
    
    __self__ = ( class FXCheckButton * )lua_to_FXCheckButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getCheckButtonStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXSpinner::getRange(FXint & lo, FXint & hi)const  */
int lua_call1_FXSpinner__getRange(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXSpinner * __self__;
     int lo;
     int hi;
    
    __self__ = ( class FXSpinner * )lua_to_FXSpinner(__S__, 1, &__ERROR__);
    lo = ( int )(int)lua_tonumber(__S__, 2);
    hi = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->getRange(lo, hi);
    lua_settop(__S__, 0);
    ;
    lua_pushnumber(__S__, lo);
    lua_pushnumber(__S__, hi);
    return 2;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const FXchar * FXStringDict::replace(const FXchar * ky, const FXchar * str, FXbool mrk=0) */
int lua_call1_FXStringDict__replace(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXStringDict * __self__;
     char * ky;
     char * str;
     unsigned char mrk;
    
    __self__ = ( class FXStringDict * )lua_to_FXStringDict(__S__, 1, &__ERROR__);
    ky = ( char * )(char  *)lua_tostring(__S__, 2);
    str = ( char * )(char  *)lua_tostring(__S__, 3);
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushstring(__S__, (const char * ) __self__->replace(ky, str));
      return 1;
    } else {
      mrk = ( unsigned char )(char)lua_tonumber(__S__, 4);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushstring(__S__, (const char * ) __self__->replace(ky, str, mrk));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXScrollbar::getRange()const  */
int lua_call1_FXScrollbar__getRange(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXScrollbar * __self__;
    
    __self__ = ( class FXScrollbar * )lua_to_FXScrollbar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getRange());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXSlider::onTimeInc(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXMainWindow::FXMainWindow(class FXApp * a, const class FXString & name, class FXIcon * ic=__null, class FXIcon * mi=__null, FXuint opts=DECOR_ALL, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=0, FXint pr=0, FXint pt=0, FXint pb=0, FXint hs=0, FXint vs=0) */
int lua_call1_FXMainWindow__FXMainWindow(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXApp * a;
     class FXIcon * ic;
     class FXIcon * mi;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
     int hs;
     int vs;
    
    a = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    int __err__31; static FXString __cstr__31; FXString * __str__31 = lua_to_FXString(__S__, 2, &__err__31);  class FXString & name = ( class FXString & ) (__str__31? *__str__31 : (__cstr__31 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__31));
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXMainWindow(__S__, new FXMainWindow(a, name));
      return 1;
    } else {
      ic = ( class FXIcon * )lua_to_FXIcon(__S__, 3, &__ERROR__);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXMainWindow(__S__, new FXMainWindow(a, name, ic));
        return 1;
      } else {
        mi = ( class FXIcon * )lua_to_FXIcon(__S__, 4, &__ERROR__);
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXMainWindow(__S__, new FXMainWindow(a, name, ic, mi));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 5);
          if (nparam <= 5) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXMainWindow(__S__, new FXMainWindow(a, name, ic, mi, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 6);
            if (nparam <= 6) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXMainWindow(__S__, new FXMainWindow(a, name, ic, mi, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 7);
              if (nparam <= 7) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXMainWindow(__S__, new FXMainWindow(a, name, ic, mi, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 8);
                if (nparam <= 8) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXMainWindow(__S__, new FXMainWindow(a, name, ic, mi, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 9);
                  if (nparam <= 9) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXMainWindow(__S__, new FXMainWindow(a, name, ic, mi, opts, x, y, w, h));
                    return 1;
                  } else {
                    pl = ( int )(int)lua_tonumber(__S__, 10);
                    if (nparam <= 10) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXMainWindow(__S__, new FXMainWindow(a, name, ic, mi, opts, x, y, w, h, pl));
                      return 1;
                    } else {
                      pr = ( int )(int)lua_tonumber(__S__, 11);
                      if (nparam <= 11) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXMainWindow(__S__, new FXMainWindow(a, name, ic, mi, opts, x, y, w, h, pl, pr));
                        return 1;
                      } else {
                        pt = ( int )(int)lua_tonumber(__S__, 12);
                        if (nparam <= 12) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXMainWindow(__S__, new FXMainWindow(a, name, ic, mi, opts, x, y, w, h, pl, pr, pt));
                          return 1;
                        } else {
                          pb = ( int )(int)lua_tonumber(__S__, 13);
                          if (nparam <= 13) {
                            if (__ERROR__) goto error;
                            
                            lua_settop(__S__, 0);
                            lua_push_FXMainWindow(__S__, new FXMainWindow(a, name, ic, mi, opts, x, y, w, h, pl, pr, pt, pb));
                            return 1;
                          } else {
                            hs = ( int )(int)lua_tonumber(__S__, 14);
                            if (nparam <= 14) {
                              if (__ERROR__) goto error;
                              
                              lua_settop(__S__, 0);
                              lua_push_FXMainWindow(__S__, new FXMainWindow(a, name, ic, mi, opts, x, y, w, h, pl, pr, pt, pb, hs));
                              return 1;
                            } else {
                              vs = ( int )(int)lua_tonumber(__S__, 15);
                              if (__ERROR__) goto error;
                              
                              lua_settop(__S__, 0);
                              lua_push_FXMainWindow(__S__, new FXMainWindow(a, name, ic, mi, opts, x, y, w, h, pl, pr, pt, pb, hs, vs));
                              return 1;
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXTooltip::getTextColor()const  */
int lua_call1_FXTooltip__getTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTooltip * __self__;
    
    __self__ = ( class FXTooltip * )lua_to_FXTooltip(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTextColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXList::isItemCurrent(FXint index)const  */
int lua_call1_FXList__isItemCurrent(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXList * __self__;
     int index;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isItemCurrent(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXIcon * FXList::getItemIcon(FXint index)const  */
int lua_call1_FXList__getItemIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXList * __self__;
     int index;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXIcon(__S__, __self__->getItemIcon(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXList::recalc() */
int lua_call1_FXList__recalc(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXList * __self__;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->recalc();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXUndoList::canRevert()const  */
int lua_call1_FXUndoList__canRevert(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXUndoList * __self__;
    
    __self__ = ( class FXUndoList * )lua_to_FXUndoList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->canRevert());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const class FXRectangle & FXDC::getClipRectangle()const  */
int lua_call1_FXDC__getClipRectangle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDC * __self__;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXRectangle(__S__, &(__self__->getClipRectangle()));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXFileList::isItemExecutable(FXint index)const  */
int lua_call1_FXFileList__isItemExecutable(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileList * __self__;
     int index;
    
    __self__ = ( class FXFileList * )lua_to_FXFileList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isItemExecutable(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXScrollArea::getContentHeight() */
int lua_call1_FXScrollArea__getContentHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXScrollArea * __self__;
    
    __self__ = ( class FXScrollArea * )lua_to_FXScrollArea(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getContentHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTabBook::onFocusRight(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXuint FXRadioButton::getRadioButtonStyle()const  */
int lua_call1_FXRadioButton__getRadioButtonStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXRadioButton * __self__;
    
    __self__ = ( class FXRadioButton * )lua_to_FXRadioButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getRadioButtonStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTreeList::setItemData(class FXTreeItem * item, void * ptr)const  */
/* SKIPPED (argument #3) */
/* void FXApp::setWheelLines(FXint lines) */
int lua_call1_FXApp__setWheelLines(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXApp * __self__;
     int lines;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    lines = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setWheelLines(lines);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXPacker::getPackingHints()const  */
int lua_call1_FXPacker__getPackingHints(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXPacker * __self__;
    
    __self__ = ( class FXPacker * )lua_to_FXPacker(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getPackingHints());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXHeader::prependItem(class FXHeaderItem * item, FXbool notify=0) */
int lua_call1_FXHeader__prependItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXHeader * __self__;
     class FXHeaderItem * item;
     unsigned char notify;
    
    __self__ = ( class FXHeader * )lua_to_FXHeader(__S__, 1, &__ERROR__);
    item = ( class FXHeaderItem * )lua_to_FXHeaderItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->prependItem(item));
      return 1;
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->prependItem(item, notify));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXHeader::prependItem(const class FXString & text, class FXIcon * icon=__null, FXint size=0, void * ptr=__null, FXbool notify=0) */
int lua_call2_FXHeader__prependItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXHeader * __self__;
     class FXIcon * icon;
     int size;
     void * ptr;
     unsigned char notify;
    
    __self__ = ( class FXHeader * )lua_to_FXHeader(__S__, 1, &__ERROR__);
    int __err__32; static FXString __cstr__32; FXString * __str__32 = lua_to_FXString(__S__, 2, &__err__32);  class FXString & text = ( class FXString & ) (__str__32? *__str__32 : (__cstr__32 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__32));
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->prependItem(text));
      return 1;
    } else {
      icon = ( class FXIcon * )lua_to_FXIcon(__S__, 3, &__ERROR__);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_pushnumber(__S__, __self__->prependItem(text, icon));
        return 1;
      } else {
        size = ( int )(int)lua_tonumber(__S__, 4);
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_pushnumber(__S__, __self__->prependItem(text, icon, size));
          return 1;
        } else {
          if (nparam <= 5) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_pushnumber(__S__, __self__->prependItem(text, icon, size, ptr));
            return 1;
          } else {
            notify = ( unsigned char )(char)lua_tonumber(__S__, 6);
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_pushnumber(__S__, __self__->prependItem(text, icon, size, ptr, notify));
            return 1;
          }
        }
      }
    }
  }
  
error:
  return lua_call1_FXHeader__prependItem(__S__);
}
/* long FXToolbar::onCmdDockLeft(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXFont::isFontMono()const  */
int lua_call1_FXFont__isFontMono(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFont * __self__;
    
    __self__ = ( class FXFont * )lua_to_FXFont(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isFontMono());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXMDIMinimizeButton::getDefaultHeight() */
int lua_call1_FXMDIMinimizeButton__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIMinimizeButton * __self__;
    
    __self__ = ( class FXMDIMinimizeButton * )lua_to_FXMDIMinimizeButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXDriveBox::setDrive(const class FXString & drive) */
int lua_call1_FXDriveBox__setDrive(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDriveBox * __self__;
    
    __self__ = ( class FXDriveBox * )lua_to_FXDriveBox(__S__, 1, &__ERROR__);
    int __err__33; static FXString __cstr__33; FXString * __str__33 = lua_to_FXString(__S__, 2, &__err__33);  class FXString & drive = ( class FXString & ) (__str__33? *__str__33 : (__cstr__33 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__33));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->setDrive(drive));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXRegion & ( FXRegion::operator +=)(const class FXRegion & r) */
/* SKIPPED (operator) */
/* void FXUndoList::trimSize(FXuint sz) */
int lua_call1_FXUndoList__trimSize(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXUndoList * __self__;
     unsigned int sz;
    
    __self__ = ( class FXUndoList * )lua_to_FXUndoList(__S__, 1, &__ERROR__);
    sz = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->trimSize(sz);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXMDIChild::getHiliteColor()const  */
int lua_call1_FXMDIChild__getHiliteColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIChild * __self__;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getHiliteColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXList::load(class FXStream & store) */
int lua_call1_FXList__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXList * __self__;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTable::onCmdExtend(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXMenuCommand::manufacture() */
int lua_call1_FXMenuCommand__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXMenuCommand::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCWindow::setFunction(FXFunction func=BLT_SRC) */
int lua_call1_FXDCWindow__setFunction(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDCWindow * __self__;
     FXFunction func;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->setFunction();
    } else {
      func = ( FXFunction )(FXFunction)(int)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->setFunction(func);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXHMat::FXHMat() */
int lua_call1_FXHMat__FXHMat(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXHMat(__S__, new FXHMat());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXHMat::FXHMat(const class FXHMat & other) */
int lua_call2_FXHMat__FXHMat(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
    
     class FXHMat & other = ( class FXHMat & )(*lua_to_FXHMat(__S__, 1, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXHMat(__S__, new FXHMat(other));
    return 1;
  }
  
error:
  return lua_call1_FXHMat__FXHMat(__S__);
}
/*  FXHMat::FXHMat(FXfloat w) */
int lua_call3_FXHMat__FXHMat(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     float w;
    
    w = ( float )(float)lua_tonumber(__S__, 1);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXHMat(__S__, new FXHMat(w));
    return 1;
  }
  
error:
  return lua_call2_FXHMat__FXHMat(__S__);
}
/*  FXHMat::FXHMat(const class FXHVec & a, const class FXHVec & b, const class FXHVec & c, const class FXHVec & d) */
int lua_call4_FXHMat__FXHMat(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 4) goto error;
  {
     class FXHVec & a = ( class FXHVec & )(*lua_to_FXHVec(__S__, 1, &__ERROR__));
     class FXHVec & b = ( class FXHVec & )(*lua_to_FXHVec(__S__, 2, &__ERROR__));
     class FXHVec & c = ( class FXHVec & )(*lua_to_FXHVec(__S__, 3, &__ERROR__));
    
     class FXHVec & d = ( class FXHVec & )(*lua_to_FXHVec(__S__, 4, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXHMat(__S__, new FXHMat(a, b, c, d));
    lua_push_FXHVec(__S__, &(a));
    lua_push_FXHVec(__S__, &(b));
    lua_push_FXHVec(__S__, &(c));
    return 4;
  }
  
error:
  return lua_call3_FXHMat__FXHMat(__S__);
}
/*  FXHMat::FXHMat(FXfloat a00, FXfloat a01, FXfloat a02, FXfloat a03, FXfloat a10, FXfloat a11, FXfloat a12, FXfloat a13, FXfloat a20, FXfloat a21, FXfloat a22, FXfloat a23, FXfloat a30, FXfloat a31, FXfloat a32, FXfloat a33) */
int lua_call5_FXHMat__FXHMat(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 16) goto error;
  {
     float a00;
     float a01;
     float a02;
     float a03;
     float a10;
     float a11;
     float a12;
     float a13;
     float a20;
     float a21;
     float a22;
     float a23;
     float a30;
     float a31;
     float a32;
     float a33;
    
    a00 = ( float )(float)lua_tonumber(__S__, 1);
    a01 = ( float )(float)lua_tonumber(__S__, 2);
    a02 = ( float )(float)lua_tonumber(__S__, 3);
    a03 = ( float )(float)lua_tonumber(__S__, 4);
    a10 = ( float )(float)lua_tonumber(__S__, 5);
    a11 = ( float )(float)lua_tonumber(__S__, 6);
    a12 = ( float )(float)lua_tonumber(__S__, 7);
    a13 = ( float )(float)lua_tonumber(__S__, 8);
    a20 = ( float )(float)lua_tonumber(__S__, 9);
    a21 = ( float )(float)lua_tonumber(__S__, 10);
    a22 = ( float )(float)lua_tonumber(__S__, 11);
    a23 = ( float )(float)lua_tonumber(__S__, 12);
    a30 = ( float )(float)lua_tonumber(__S__, 13);
    a31 = ( float )(float)lua_tonumber(__S__, 14);
    a32 = ( float )(float)lua_tonumber(__S__, 15);
    a33 = ( float )(float)lua_tonumber(__S__, 16);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXHMat(__S__, new FXHMat(a00, a01, a02, a03, a10, a11, a12, a13, a20, a21, a22, a23, a30, a31, a32, a33));
    return 1;
  }
  
error:
  return lua_call4_FXHMat__FXHMat(__S__);
}
/* long FXProgressBar::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXDirList::onExpanded(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXTabBook::manufacture() */
int lua_call1_FXTabBook__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXTabBook::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXDHMat & FXDHMat::scale(FXdouble s) */
int lua_call1_FXDHMat__scale(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDHMat * __self__;
     double s;
    
    __self__ = ( class FXDHMat * )lua_to_FXDHMat(__S__, 1, &__ERROR__);
    s = ( double )(double)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXDHMat(__S__, &(__self__->scale(s)));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXDHMat & FXDHMat::scale(const class FXDVec & v) */
int lua_call2_FXDHMat__scale(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDHMat * __self__;
    
    __self__ = ( class FXDHMat * )lua_to_FXDHMat(__S__, 1, &__ERROR__);
     class FXDVec & v = ( class FXDVec & )(*lua_to_FXDVec(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXDHMat(__S__, &(__self__->scale(v)));
    return 1;
  }
  
error:
  return lua_call1_FXDHMat__scale(__S__);
}
/* class FXDHMat & FXDHMat::scale(FXdouble sx, FXdouble sy, FXdouble sz) */
int lua_call3_FXDHMat__scale(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXDHMat * __self__;
     double sx;
     double sy;
     double sz;
    
    __self__ = ( class FXDHMat * )lua_to_FXDHMat(__S__, 1, &__ERROR__);
    sx = ( double )(double)lua_tonumber(__S__, 2);
    sy = ( double )(double)lua_tonumber(__S__, 3);
    sz = ( double )(double)lua_tonumber(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXDHMat(__S__, &(__self__->scale(sx, sy, sz)));
    return 1;
  }
  
error:
  return lua_call2_FXDHMat__scale(__S__);
}
/* void FXProgressBar::increment(FXuint value) */
int lua_call1_FXProgressBar__increment(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXProgressBar * __self__;
     unsigned int value;
    
    __self__ = ( class FXProgressBar * )lua_to_FXProgressBar(__S__, 1, &__ERROR__);
    value = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->increment(value);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXDHMat & FXDHMat::frustum(FXdouble left, FXdouble right, FXdouble bottom, FXdouble top, FXdouble hither, FXdouble yon) */
int lua_call1_FXDHMat__frustum(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 7) goto error;
  {
     class FXDHMat * __self__;
     double left;
     double right;
     double bottom;
     double top;
     double hither;
     double yon;
    
    __self__ = ( class FXDHMat * )lua_to_FXDHMat(__S__, 1, &__ERROR__);
    left = ( double )(double)lua_tonumber(__S__, 2);
    right = ( double )(double)lua_tonumber(__S__, 3);
    bottom = ( double )(double)lua_tonumber(__S__, 4);
    top = ( double )(double)lua_tonumber(__S__, 5);
    hither = ( double )(double)lua_tonumber(__S__, 6);
    yon = ( double )(double)lua_tonumber(__S__, 7);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXDHMat(__S__, &(__self__->frustum(left, right, bottom, top, hither, yon)));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXSpinner::onUpdIncrement(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXListItem * FXList::retrieveItem(FXint index)const  */
int lua_call1_FXList__retrieveItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXList * __self__;
     int index;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXListItem(__S__, __self__->retrieveItem(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXTreeList::selectItem(class FXTreeItem * item, FXbool notify=0) */
int lua_call1_FXTreeList__selectItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeList * __self__;
     class FXTreeItem * item;
     unsigned char notify;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->selectItem(item));
      return 1;
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->selectItem(item, notify));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXScrollArea::onAutoScroll(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXOptionMenu::canFocus()const  */
int lua_call1_FXOptionMenu__canFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXOptionMenu * __self__;
    
    __self__ = ( class FXOptionMenu * )lua_to_FXOptionMenu(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->canFocus());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXText::setTopLine(FXint pos) */
int lua_call1_FXText__setTopLine(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXText * __self__;
     int pos;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    pos = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTopLine(pos);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::setHelpText(const class FXString & text) */
int lua_call1_FXTable__setHelpText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    int __err__34; static FXString __cstr__34; FXString * __str__34 = lua_to_FXString(__S__, 2, &__err__34);  class FXString & text = ( class FXString & ) (__str__34? *__str__34 : (__cstr__34 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__34));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setHelpText(text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXLabel::setText(const class FXString & text) */
int lua_call1_FXLabel__setText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXLabel * __self__;
    
    __self__ = ( class FXLabel * )lua_to_FXLabel(__S__, 1, &__ERROR__);
    int __err__35; static FXString __cstr__35; FXString * __str__35 = lua_to_FXString(__S__, 2, &__err__35);  class FXString & text = ( class FXString & ) (__str__35? *__str__35 : (__cstr__35 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__35));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setText(text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMenuTitle::onCmdUnpost(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXComboBox::setItemData(FXint index, void * ptr)const  */
/* SKIPPED (argument #3) */
/* class FXIcon * FXIconDict::find(const FXchar * name) */
int lua_call1_FXIconDict__find(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconDict * __self__;
     char * name;
    
    __self__ = ( class FXIconDict * )lua_to_FXIconDict(__S__, 1, &__ERROR__);
    name = ( char * )(char  *)lua_tostring(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXIcon(__S__, __self__->find(name));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIconList::setTextColor(FXColor clr) */
int lua_call1_FXIconList__setTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconList * __self__;
     unsigned int clr;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTextColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXList::getCurrentItem()const  */
int lua_call1_FXList__getCurrentItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXList * __self__;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getCurrentItem());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXComboBox::setBackColor(FXColor clr) */
int lua_call1_FXComboBox__setBackColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXComboBox * __self__;
     unsigned int clr;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBackColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FX4Splitter::onUpdExpand(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXFont * FXMDIChild::getFont()const  */
int lua_call1_FXMDIChild__getFont(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIChild * __self__;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXFont(__S__, __self__->getFont());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMenuCascade::destroy() */
int lua_call1_FXMenuCascade__destroy(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuCascade * __self__;
    
    __self__ = ( class FXMenuCascade * )lua_to_FXMenuCascade(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->destroy();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorWell::onChgColorWell(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* const struct FXMetaClass * FXSplitter::getMetaClass()const  */
int lua_call1_FXSplitter__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSplitter * __self__;
    
    __self__ = ( class FXSplitter * )lua_to_FXSplitter(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXTable::manufacture() */
int lua_call1_FXTable__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXTable::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXSwitcher::onUpdOpen(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXJoinStyle FXDC::getLineJoin()const  */
int lua_call1_FXDC__getLineJoin(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDC * __self__;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getLineJoin());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMDIChild::setIconY(FXint y) */
int lua_call1_FXMDIChild__setIconY(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMDIChild * __self__;
     int y;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    y = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setIconY(y);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXToggleButton::onLeftBtnPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTooltip::onCmdGetStringValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTooltip::onTipHide(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDCWindow::drawPoint(FXint x, FXint y) */
int lua_call1_FXDCWindow__drawPoint(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDCWindow * __self__;
     int x;
     int y;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawPoint(x, y);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDriveBox::onCmdSetStringValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* const FXchar & ( FXString::operator [])(FXint i)const  */
/* SKIPPED (operator) */
/* void FXIconItem::setBigIcon(class FXIcon * icn) */
int lua_call1_FXIconItem__setBigIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconItem * __self__;
     class FXIcon * icn;
    
    __self__ = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
    icn = ( class FXIcon * )lua_to_FXIcon(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBigIcon(icn);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDial::onQueryTip(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXSize & ( FXSize::operator /=)(FXshort c) */
/* SKIPPED (operator) */
/* long FXMDIClient::onCmdTileVertical(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXListBox::detach() */
int lua_call1_FXListBox__detach(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXListBox * __self__;
    
    __self__ = ( class FXListBox * )lua_to_FXListBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->detach();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXScrollbar::onLeftBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* const struct FXMetaClass * FXImageView::getMetaClass()const  */
int lua_call1_FXImageView__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXImageView * __self__;
    
    __self__ = ( class FXImageView * )lua_to_FXImageView(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXArrowButton::getArrowStyle()const  */
int lua_call1_FXArrowButton__getArrowStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXArrowButton * __self__;
    
    __self__ = ( class FXArrowButton * )lua_to_FXArrowButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getArrowStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXIconList::onCmdSelectAll(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXComboBox::setFont(class FXFont * fnt) */
int lua_call1_FXComboBox__setFont(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXComboBox * __self__;
     class FXFont * fnt;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    fnt = ( class FXFont * )lua_to_FXFont(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setFont(fnt);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXDirList::getPattern()const  */
int lua_call1_FXDirList__getPattern(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDirList * __self__;
    
    __self__ = ( class FXDirList * )lua_to_FXDirList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getPattern().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXVerticalFrame::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXToolbarTab::load(class FXStream & store) */
int lua_call1_FXToolbarTab__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXToolbarTab * __self__;
    
    __self__ = ( class FXToolbarTab * )lua_to_FXToolbarTab(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXFontSelector::save(class FXStream & store)const  */
int lua_call1_FXFontSelector__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFontSelector * __self__;
    
    __self__ = ( class FXFontSelector * )lua_to_FXFontSelector(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMenuTitle::onHotKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXButton::onUpdate(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXProgressBar::onCmdGetIntValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXIconList::onLeave(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXCheckButton::onCmdGetIntValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* const struct FXMetaClass * FXTabBar::getMetaClass()const  */
int lua_call1_FXTabBar__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTabBar * __self__;
    
    __self__ = ( class FXTabBar * )lua_to_FXTabBar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCPrint::setTile(class FXImage * tile, FXint dx=0, FXint dy=0) */
int lua_call1_FXDCPrint__setTile(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDCPrint * __self__;
     class FXImage * tile;
     int dx;
     int dy;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    tile = ( class FXImage * )lua_to_FXImage(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      __self__->setTile(tile);
    } else {
      dx = ( int )(int)lua_tonumber(__S__, 3);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        __self__->setTile(tile, dx);
      } else {
        dy = ( int )(int)lua_tonumber(__S__, 4);
        if (__ERROR__) goto error;
        
        __self__->setTile(tile, dx, dy);
      }
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTable::onCmdMoveTop(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXList::setAnchorItem(FXint index) */
int lua_call1_FXList__setAnchorItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXList * __self__;
     int index;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setAnchorItem(index);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onKeyPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXDial::getNotchOffset()const  */
int lua_call1_FXDial__getNotchOffset(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDial * __self__;
    
    __self__ = ( class FXDial * )lua_to_FXDial(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getNotchOffset());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXTreeItem * FXTreeItem::getBelow()const  */
int lua_call1_FXTreeItem__getBelow(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeItem * __self__;
    
    __self__ = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXTreeItem(__S__, __self__->getBelow());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXGIFCursor::FXGIFCursor(class FXApp * a, const void * pix, FXint hx=-1, FXint hy=-1) */
/* SKIPPED (argument #2) */
/* void FXLabel::setIcon(class FXIcon * ic) */
int lua_call1_FXLabel__setIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXLabel * __self__;
     class FXIcon * ic;
    
    __self__ = ( class FXLabel * )lua_to_FXLabel(__S__, 1, &__ERROR__);
    ic = ( class FXIcon * )lua_to_FXIcon(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setIcon(ic);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onCmdScrollDown(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXUndoList::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* FXint FXSettings::writeFormatEntry(const FXchar * section, const FXchar * key, const FXchar * fmt, ...) */
int lua_call1_FXSettings__writeFormatEntry(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXSettings * __self__;
     char * section;
     char * key;
     char * fmt;
    
    __self__ = ( class FXSettings * )lua_to_FXSettings(__S__, 1, &__ERROR__);
    section = ( char * )(char  *)lua_tostring(__S__, 2);
    key = ( char * )(char  *)lua_tostring(__S__, 3);
    fmt = ( char * )(char  *)lua_tostring(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->writeFormatEntry(section, key, fmt));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXSettings::parseFile(const class FXString & filename, FXbool mark) */
int lua_call1_FXSettings__parseFile(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXSettings * __self__;
    int __err__36; static FXString __cstr__36; FXString * __str__36 = lua_to_FXString(__S__, 2, &__err__36);  class FXString & filename = ( class FXString & ) (__str__36? *__str__36 : (__cstr__36 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__36));
     unsigned char mark;
    
    __self__ = ( class FXSettings * )lua_to_FXSettings(__S__, 1, &__ERROR__);
    mark = ( unsigned char )(char)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->parseFile(filename, mark));
    lua_pushstring(__S__, filename.text());
    return 2;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXList::manufacture() */
int lua_call1_FXList__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXList::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::linkAfter(class FXWindow * sibling) */
int lua_call1_FXWindow__linkAfter(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXWindow * __self__;
     class FXWindow * sibling;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    sibling = ( class FXWindow * )lua_to_FXWindow(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->linkAfter(sibling);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXFileDialog::manufacture() */
int lua_call1_FXFileDialog__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXFileDialog::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTextField::disable() */
int lua_call1_FXTextField__disable(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTextField * __self__;
    
    __self__ = ( class FXTextField * )lua_to_FXTextField(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->disable();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCWindow::drawLinesRel(const class FXPoint * points, FXuint npoints) */
int lua_call1_FXDCWindow__drawLinesRel(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDCWindow * __self__;
     class FXPoint * points;
     unsigned int npoints;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    points = ( class FXPoint * )lua_to_FXPoint(__S__, 2, &__ERROR__);
    npoints = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawLinesRel(points, npoints);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTable::onCmdSelectColumn(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXHorizontalSeparator::FXHorizontalSeparator(class FXComposite * p, FXuint opts=SEPARATOR_GROOVE|LAYOUT_FILL_X, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=1, FXint pr=1, FXint pt=0, FXint pb=0) */
int lua_call1_FXHorizontalSeparator__FXHorizontalSeparator(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXHorizontalSeparator(__S__, new FXHorizontalSeparator(p));
      return 1;
    } else {
      opts = ( unsigned int )(int)lua_tonumber(__S__, 2);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXHorizontalSeparator(__S__, new FXHorizontalSeparator(p, opts));
        return 1;
      } else {
        x = ( int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXHorizontalSeparator(__S__, new FXHorizontalSeparator(p, opts, x));
          return 1;
        } else {
          y = ( int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXHorizontalSeparator(__S__, new FXHorizontalSeparator(p, opts, x, y));
            return 1;
          } else {
            w = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXHorizontalSeparator(__S__, new FXHorizontalSeparator(p, opts, x, y, w));
              return 1;
            } else {
              h = ( int )(int)lua_tonumber(__S__, 6);
              if (nparam <= 6) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXHorizontalSeparator(__S__, new FXHorizontalSeparator(p, opts, x, y, w, h));
                return 1;
              } else {
                pl = ( int )(int)lua_tonumber(__S__, 7);
                if (nparam <= 7) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXHorizontalSeparator(__S__, new FXHorizontalSeparator(p, opts, x, y, w, h, pl));
                  return 1;
                } else {
                  pr = ( int )(int)lua_tonumber(__S__, 8);
                  if (nparam <= 8) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXHorizontalSeparator(__S__, new FXHorizontalSeparator(p, opts, x, y, w, h, pl, pr));
                    return 1;
                  } else {
                    pt = ( int )(int)lua_tonumber(__S__, 9);
                    if (nparam <= 9) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXHorizontalSeparator(__S__, new FXHorizontalSeparator(p, opts, x, y, w, h, pl, pr, pt));
                      return 1;
                    } else {
                      pb = ( int )(int)lua_tonumber(__S__, 10);
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXHorizontalSeparator(__S__, new FXHorizontalSeparator(p, opts, x, y, w, h, pl, pr, pt, pb));
                      return 1;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMenuCommand::onButtonRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXTableItem::setIcon(class FXIcon * icn) */
int lua_call1_FXTableItem__setIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTableItem * __self__;
     class FXIcon * icn;
    
    __self__ = ( class FXTableItem * )lua_to_FXTableItem(__S__, 1, &__ERROR__);
    icn = ( class FXIcon * )lua_to_FXIcon(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setIcon(icn);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FX4Splitter::save(class FXStream & store)const  */
int lua_call1_FX4Splitter__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FX4Splitter * __self__;
    
    __self__ = ( class FX4Splitter * )lua_to_FX4Splitter(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXDirDialog::FXDirDialog(class FXWindow * owner, const class FXString & name, FXuint opts=0, FXint x=0, FXint y=0, FXint w=500, FXint h=300) */
int lua_call1_FXDirDialog__FXDirDialog(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXWindow * owner;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
    
    owner = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    int __err__37; static FXString __cstr__37; FXString * __str__37 = lua_to_FXString(__S__, 2, &__err__37);  class FXString & name = ( class FXString & ) (__str__37? *__str__37 : (__cstr__37 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__37));
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXDirDialog(__S__, new FXDirDialog(owner, name));
      return 1;
    } else {
      opts = ( unsigned int )(int)lua_tonumber(__S__, 3);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXDirDialog(__S__, new FXDirDialog(owner, name, opts));
        return 1;
      } else {
        x = ( int )(int)lua_tonumber(__S__, 4);
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXDirDialog(__S__, new FXDirDialog(owner, name, opts, x));
          return 1;
        } else {
          y = ( int )(int)lua_tonumber(__S__, 5);
          if (nparam <= 5) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXDirDialog(__S__, new FXDirDialog(owner, name, opts, x, y));
            return 1;
          } else {
            w = ( int )(int)lua_tonumber(__S__, 6);
            if (nparam <= 6) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXDirDialog(__S__, new FXDirDialog(owner, name, opts, x, y, w));
              return 1;
            } else {
              h = ( int )(int)lua_tonumber(__S__, 7);
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXDirDialog(__S__, new FXDirDialog(owner, name, opts, x, y, w, h));
              return 1;
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXObject::onDefault(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXuint FXToolbarGrip::getDoubleBar()const  */
int lua_call1_FXToolbarGrip__getDoubleBar(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbarGrip * __self__;
    
    __self__ = ( class FXToolbarGrip * )lua_to_FXToolbarGrip(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDoubleBar());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDC::fillPolygonRel(const class FXPoint * points, FXuint npoints) */
int lua_call1_FXDC__fillPolygonRel(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDC * __self__;
     class FXPoint * points;
     unsigned int npoints;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    points = ( class FXPoint * )lua_to_FXPoint(__S__, 2, &__ERROR__);
    npoints = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->fillPolygonRel(points, npoints);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTreeList::getDefaultWidth() */
int lua_call1_FXTreeList__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeList * __self__;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXText::getTabColumns()const  */
int lua_call1_FXText__getTabColumns(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTabColumns());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXToolbarTab::canFocus()const  */
int lua_call1_FXToolbarTab__canFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbarTab * __self__;
    
    __self__ = ( class FXToolbarTab * )lua_to_FXToolbarTab(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->canFocus());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXFont * FXList::getFont()const  */
int lua_call1_FXList__getFont(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXList * __self__;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXFont(__S__, __self__->getFont());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXRootWindow::position(FXint x, FXint y, FXint w, FXint h) */
int lua_call1_FXRootWindow__position(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXRootWindow * __self__;
     int x;
     int y;
     int w;
     int h;
    
    __self__ = ( class FXRootWindow * )lua_to_FXRootWindow(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    w = ( int )(int)lua_tonumber(__S__, 4);
    h = ( int )(int)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->position(x, y, w, h);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXRecentFiles::appendFile(const class FXString & filename) */
int lua_call1_FXRecentFiles__appendFile(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXRecentFiles * __self__;
    
    __self__ = ( class FXRecentFiles * )lua_to_FXRecentFiles(__S__, 1, &__ERROR__);
    int __err__38; static FXString __cstr__38; FXString * __str__38 = lua_to_FXString(__S__, 2, &__err__38);  class FXString & filename = ( class FXString & ) (__str__38? *__str__38 : (__cstr__38 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__38));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->appendFile(filename);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXToggleButton::getMetaClass()const  */
int lua_call1_FXToggleButton__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToggleButton * __self__;
    
    __self__ = ( class FXToggleButton * )lua_to_FXToggleButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::lower() */
int lua_call1_FXWindow__lower(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->lower();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXPopup::setShrinkWrap(FXbool sw) */
int lua_call1_FXPopup__setShrinkWrap(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXPopup * __self__;
     unsigned char sw;
    
    __self__ = ( class FXPopup * )lua_to_FXPopup(__S__, 1, &__ERROR__);
    sw = ( unsigned char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setShrinkWrap(sw);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXText::getTopLine()const  */
int lua_call1_FXText__getTopLine(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTopLine());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMemoryStream::takeBuffer(FXuchar * & buffer, FXuint & sp) */
/* SKIPPED (argument #2) */
/* class FXObject * FXColorWell::manufacture() */
int lua_call1_FXColorWell__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXColorWell::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXRootWindow::resize(FXint w, FXint h) */
int lua_call1_FXRootWindow__resize(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXRootWindow * __self__;
     int w;
     int h;
    
    __self__ = ( class FXRootWindow * )lua_to_FXRootWindow(__S__, 1, &__ERROR__);
    w = ( int )(int)lua_tonumber(__S__, 2);
    h = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->resize(w, h);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTable::getContentWidth() */
int lua_call1_FXTable__getContentWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getContentWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXTable::getBaseColor()const  */
int lua_call1_FXTable__getBaseColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBaseColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXApp::endWaitCursor() */
int lua_call1_FXApp__endWaitCursor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->endWaitCursor();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXColorWell::FXColorWell(class FXComposite * p, FXColor clr=0, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=COLORWELL_NORMAL, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=2, FXint pr=2, FXint pt=2, FXint pb=2) */
int lua_call1_FXColorWell__FXColorWell(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     unsigned int clr;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXColorWell(__S__, new FXColorWell(p));
      return 1;
    } else {
      clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXColorWell(__S__, new FXColorWell(p, clr));
        return 1;
      } else {
        tgt = ( class FXObject * )lua_to_FXObject(__S__, 3, &__ERROR__);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXColorWell(__S__, new FXColorWell(p, clr, tgt));
          return 1;
        } else {
          sel = ( unsigned int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXColorWell(__S__, new FXColorWell(p, clr, tgt, sel));
            return 1;
          } else {
            opts = ( unsigned int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXColorWell(__S__, new FXColorWell(p, clr, tgt, sel, opts));
              return 1;
            } else {
              x = ( int )(int)lua_tonumber(__S__, 6);
              if (nparam <= 6) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXColorWell(__S__, new FXColorWell(p, clr, tgt, sel, opts, x));
                return 1;
              } else {
                y = ( int )(int)lua_tonumber(__S__, 7);
                if (nparam <= 7) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXColorWell(__S__, new FXColorWell(p, clr, tgt, sel, opts, x, y));
                  return 1;
                } else {
                  w = ( int )(int)lua_tonumber(__S__, 8);
                  if (nparam <= 8) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXColorWell(__S__, new FXColorWell(p, clr, tgt, sel, opts, x, y, w));
                    return 1;
                  } else {
                    h = ( int )(int)lua_tonumber(__S__, 9);
                    if (nparam <= 9) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXColorWell(__S__, new FXColorWell(p, clr, tgt, sel, opts, x, y, w, h));
                      return 1;
                    } else {
                      pl = ( int )(int)lua_tonumber(__S__, 10);
                      if (nparam <= 10) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXColorWell(__S__, new FXColorWell(p, clr, tgt, sel, opts, x, y, w, h, pl));
                        return 1;
                      } else {
                        pr = ( int )(int)lua_tonumber(__S__, 11);
                        if (nparam <= 11) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXColorWell(__S__, new FXColorWell(p, clr, tgt, sel, opts, x, y, w, h, pl, pr));
                          return 1;
                        } else {
                          pt = ( int )(int)lua_tonumber(__S__, 12);
                          if (nparam <= 12) {
                            if (__ERROR__) goto error;
                            
                            lua_settop(__S__, 0);
                            lua_push_FXColorWell(__S__, new FXColorWell(p, clr, tgt, sel, opts, x, y, w, h, pl, pr, pt));
                            return 1;
                          } else {
                            pb = ( int )(int)lua_tonumber(__S__, 13);
                            if (__ERROR__) goto error;
                            
                            lua_settop(__S__, 0);
                            lua_push_FXColorWell(__S__, new FXColorWell(p, clr, tgt, sel, opts, x, y, w, h, pl, pr, pt, pb));
                            return 1;
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXToggleButton::onCmdSetIntValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDial::setRange(FXint lo, FXint hi) */
int lua_call1_FXDial__setRange(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDial * __self__;
     int lo;
     int hi;
    
    __self__ = ( class FXDial * )lua_to_FXDial(__S__, 1, &__ERROR__);
    lo = ( int )(int)lua_tonumber(__S__, 2);
    hi = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setRange(lo, hi);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXRecentFiles::save(class FXStream & store)const  */
int lua_call1_FXRecentFiles__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXRecentFiles * __self__;
    
    __self__ = ( class FXRecentFiles * )lua_to_FXRecentFiles(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXText::create() */
int lua_call1_FXText__create(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->create();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXHVec & ( FXHVec::operator /=)(FXfloat n) */
/* SKIPPED (operator) */
/* FXbool FXIconList::toggleItem(FXint index, FXbool notify=0) */
int lua_call1_FXIconList__toggleItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconList * __self__;
     int index;
     unsigned char notify;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->toggleItem(index));
      return 1;
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->toggleItem(index, notify));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCWindow::drawLine(FXint x1, FXint y1, FXint x2, FXint y2) */
int lua_call1_FXDCWindow__drawLine(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXDCWindow * __self__;
     int x1;
     int y1;
     int x2;
     int y2;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    x1 = ( int )(int)lua_tonumber(__S__, 2);
    y1 = ( int )(int)lua_tonumber(__S__, 3);
    x2 = ( int )(int)lua_tonumber(__S__, 4);
    y2 = ( int )(int)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawLine(x1, y1, x2, y2);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXWindow::onDNDDrop(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXWindow::canFocus()const  */
int lua_call1_FXWindow__canFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->canFocus());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXScrollWindow::FXScrollWindow(class FXComposite * p, FXuint opts=0, FXint x=0, FXint y=0, FXint w=0, FXint h=0) */
int lua_call1_FXScrollWindow__FXScrollWindow(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXScrollWindow(__S__, new FXScrollWindow(p));
      return 1;
    } else {
      opts = ( unsigned int )(int)lua_tonumber(__S__, 2);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXScrollWindow(__S__, new FXScrollWindow(p, opts));
        return 1;
      } else {
        x = ( int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXScrollWindow(__S__, new FXScrollWindow(p, opts, x));
          return 1;
        } else {
          y = ( int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXScrollWindow(__S__, new FXScrollWindow(p, opts, x, y));
            return 1;
          } else {
            w = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXScrollWindow(__S__, new FXScrollWindow(p, opts, x, y, w));
              return 1;
            } else {
              h = ( int )(int)lua_tonumber(__S__, 6);
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXScrollWindow(__S__, new FXScrollWindow(p, opts, x, y, w, h));
              return 1;
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXFileList::cmpRTime(const class FXIconItem * pa, const class FXIconItem * pb) */
int lua_call1_FXFileList__cmpRTime(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXIconItem * pa;
     class FXIconItem * pb;
    
    pa = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
    pb = ( class FXIconItem * )lua_to_FXIconItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, FXFileList::cmpRTime(pa, pb));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCWindow::fillArc(FXint x, FXint y, FXint w, FXint h, FXint ang1, FXint ang2) */
int lua_call1_FXDCWindow__fillArc(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 7) goto error;
  {
     class FXDCWindow * __self__;
     int x;
     int y;
     int w;
     int h;
     int ang1;
     int ang2;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    w = ( int )(int)lua_tonumber(__S__, 4);
    h = ( int )(int)lua_tonumber(__S__, 5);
    ang1 = ( int )(int)lua_tonumber(__S__, 6);
    ang2 = ( int )(int)lua_tonumber(__S__, 7);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->fillArc(x, y, w, h, ang1, ang2);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXList::setItemText(FXint index, const class FXString & text) */
int lua_call1_FXList__setItemText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXList * __self__;
     int index;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    int __err__39; static FXString __cstr__39; FXString * __str__39 = lua_to_FXString(__S__, 3, &__err__39);  class FXString & text = ( class FXString & ) (__str__39? *__str__39 : (__cstr__39 =(FXString) (char *)lua_tostring(__S__, 3), __cstr__39));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setItemText(index, text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXQuat::FXQuat() */
int lua_call1_FXQuat__FXQuat(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXQuat(__S__, new FXQuat());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXQuat::FXQuat(const class FXVec & axis, FXfloat phi=0.0) */
int lua_call2_FXQuat__FXQuat(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     float phi;
    
     class FXVec & axis = ( class FXVec & )(*lua_to_FXVec(__S__, 1, &__ERROR__));
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXQuat(__S__, new FXQuat(axis));
      return 1;
    } else {
      phi = ( float )(float)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXQuat(__S__, new FXQuat(axis, phi));
      return 1;
    }
  }
  
error:
  return lua_call1_FXQuat__FXQuat(__S__);
}
/*  FXQuat::FXQuat(FXfloat roll, FXfloat pitch, FXfloat yaw) */
int lua_call3_FXQuat__FXQuat(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 3) goto error;
  {
     float roll;
     float pitch;
     float yaw;
    
    roll = ( float )(float)lua_tonumber(__S__, 1);
    pitch = ( float )(float)lua_tonumber(__S__, 2);
    yaw = ( float )(float)lua_tonumber(__S__, 3);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXQuat(__S__, new FXQuat(roll, pitch, yaw));
    return 1;
  }
  
error:
  return lua_call2_FXQuat__FXQuat(__S__);
}
/*  FXQuat::FXQuat(FXfloat x, FXfloat y, FXfloat z, FXfloat w) */
int lua_call4_FXQuat__FXQuat(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 4) goto error;
  {
     float x;
     float y;
     float z;
     float w;
    
    x = ( float )(float)lua_tonumber(__S__, 1);
    y = ( float )(float)lua_tonumber(__S__, 2);
    z = ( float )(float)lua_tonumber(__S__, 3);
    w = ( float )(float)lua_tonumber(__S__, 4);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXQuat(__S__, new FXQuat(x, y, z, w));
    return 1;
  }
  
error:
  return lua_call3_FXQuat__FXQuat(__S__);
}
/* long FXMenuPane::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* FXint FXUndoList::undoCount()const  */
int lua_call1_FXUndoList__undoCount(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXUndoList * __self__;
    
    __self__ = ( class FXUndoList * )lua_to_FXUndoList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->undoCount());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIconList::setCurrentItem(FXint index, FXbool notify=0) */
int lua_call1_FXIconList__setCurrentItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconList * __self__;
     int index;
     unsigned char notify;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      __self__->setCurrentItem(index);
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      __self__->setCurrentItem(index, notify);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXFileList::getMetaClass()const  */
int lua_call1_FXFileList__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileList * __self__;
    
    __self__ = ( class FXFileList * )lua_to_FXFileList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTable::onKeyPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXCursor * FXWindow::getDragCursor()const  */
int lua_call1_FXWindow__getDragCursor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXCursor(__S__, __self__->getDragCursor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::setTextColor(FXColor clr) */
int lua_call1_FXTable__setTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTable * __self__;
     unsigned int clr;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTextColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXRadioButton::onLeave(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXWindow::onCmdToggleShown(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXIcon * FXLabel::getIcon()const  */
int lua_call1_FXLabel__getIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXLabel * __self__;
    
    __self__ = ( class FXLabel * )lua_to_FXLabel(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXIcon(__S__, __self__->getIcon());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXApp::getBorderColor()const  */
int lua_call1_FXApp__getBorderColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBorderColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXMenuSeparator::getMetaClass()const  */
int lua_call1_FXMenuSeparator__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuSeparator * __self__;
    
    __self__ = ( class FXMenuSeparator * )lua_to_FXMenuSeparator(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXComboBox::isPaneShown()const  */
int lua_call1_FXComboBox__isPaneShown(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXComboBox * __self__;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isPaneShown());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTreeList::onFocusIn(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXFileItem::isSymlink()const  */
int lua_call1_FXFileItem__isSymlink(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileItem * __self__;
    
    __self__ = ( class FXFileItem * )lua_to_FXFileItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isSymlink());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCWindow::fillRectangles(const class FXRectangle * rectangles, FXuint nrectangles) */
int lua_call1_FXDCWindow__fillRectangles(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDCWindow * __self__;
     class FXRectangle * rectangles;
     unsigned int nrectangles;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    rectangles = ( class FXRectangle * )lua_to_FXRectangle(__S__, 2, &__ERROR__);
    nrectangles = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->fillRectangles(rectangles, nrectangles);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXMDIClient::getContentWidth() */
int lua_call1_FXMDIClient__getContentWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIClient * __self__;
    
    __self__ = ( class FXMDIClient * )lua_to_FXMDIClient(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getContentWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXList::makeItemVisible(FXint index) */
int lua_call1_FXList__makeItemVisible(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXList * __self__;
     int index;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->makeItemVisible(index);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* struct FXFileAssoc * FXFileDict::findDirBinding(const FXchar * pathname) */
int lua_call1_FXFileDict__findDirBinding(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileDict * __self__;
     char * pathname;
    
    __self__ = ( class FXFileDict * )lua_to_FXFileDict(__S__, 1, &__ERROR__);
    pathname = ( char * )(char  *)lua_tostring(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXFileAssoc(__S__, __self__->findDirBinding(pathname));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTreeListBox::setNumVisible(FXint nvis) */
int lua_call1_FXTreeListBox__setNumVisible(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeListBox * __self__;
     int nvis;
    
    __self__ = ( class FXTreeListBox * )lua_to_FXTreeListBox(__S__, 1, &__ERROR__);
    nvis = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setNumVisible(nvis);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXList::selectItem(FXint index, FXbool notify=0) */
int lua_call1_FXList__selectItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXList * __self__;
     int index;
     unsigned char notify;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->selectItem(index));
      return 1;
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->selectItem(index, notify));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTable::getNumRows()const  */
int lua_call1_FXTable__getNumRows(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getNumRows());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTopWindow::create() */
int lua_call1_FXTopWindow__create(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTopWindow * __self__;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->create();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXLabel::getTipText()const  */
int lua_call1_FXLabel__getTipText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXLabel * __self__;
    
    __self__ = ( class FXLabel * )lua_to_FXLabel(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getTipText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXTreeListBox::isItemCurrent(const class FXTreeItem * item)const  */
int lua_call1_FXTreeListBox__isItemCurrent(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeListBox * __self__;
     class FXTreeItem * item;
    
    __self__ = ( class FXTreeListBox * )lua_to_FXTreeListBox(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isItemCurrent(item));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXSplitter::load(class FXStream & store) */
int lua_call1_FXSplitter__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXSplitter * __self__;
    
    __self__ = ( class FXSplitter * )lua_to_FXSplitter(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXScrollbar::load(class FXStream & store) */
int lua_call1_FXScrollbar__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXScrollbar * __self__;
    
    __self__ = ( class FXScrollbar * )lua_to_FXScrollbar(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXIconItem::isSelected()const  */
int lua_call1_FXIconItem__isSelected(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconItem * __self__;
    
    __self__ = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isSelected());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXRadioButton::setRadioColor(FXColor clr) */
int lua_call1_FXRadioButton__setRadioColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXRadioButton * __self__;
     unsigned int clr;
    
    __self__ = ( class FXRadioButton * )lua_to_FXRadioButton(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setRadioColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMDIChild::save(class FXStream & store)const  */
int lua_call1_FXMDIChild__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMDIChild * __self__;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXDial::manufacture() */
int lua_call1_FXDial__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXDial::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXFileList::onCmdHeader(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* const struct FXMetaClass * FXText::getMetaClass()const  */
int lua_call1_FXText__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXMDIMaximizeButton::getDefaultHeight() */
int lua_call1_FXMDIMaximizeButton__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIMaximizeButton * __self__;
    
    __self__ = ( class FXMDIMaximizeButton * )lua_to_FXMDIMaximizeButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXRegion & ( FXRegion::operator *=)(const class FXRegion & r) */
/* SKIPPED (operator) */
/* long FXIconList::onMotion(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXMenuButton::onLeftBtnPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXStream & ( FXStream::operator <<)(const FXlong & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator <<)(const FXulong & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator <<)(const FXuchar & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator <<)(const FXchar & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator <<)(const FXdouble & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator <<)(const FXfloat & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator <<)(const FXshort & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator <<)(const FXint & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator <<)(const FXuint & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator <<)(const FXushort & v) */
/* SKIPPED (operator) */
/* FXbool FXTreeList::expandTree(class FXTreeItem * tree, FXbool notify=0) */
int lua_call1_FXTreeList__expandTree(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeList * __self__;
     class FXTreeItem * tree;
     unsigned char notify;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    tree = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->expandTree(tree));
      return 1;
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->expandTree(tree, notify));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXFileSelector::onCmdItemSelected(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXFileSelector::setPatternText(FXint patno, const class FXString & text) */
int lua_call1_FXFileSelector__setPatternText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXFileSelector * __self__;
     int patno;
    
    __self__ = ( class FXFileSelector * )lua_to_FXFileSelector(__S__, 1, &__ERROR__);
    patno = ( int )(int)lua_tonumber(__S__, 2);
    int __err__40; static FXString __cstr__40; FXString * __str__40 = lua_to_FXString(__S__, 3, &__err__40);  class FXString & text = ( class FXString & ) (__str__40? *__str__40 : (__cstr__40 =(FXString) (char *)lua_tostring(__S__, 3), __cstr__40));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setPatternText(patno, text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onQueryTip(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXMenuTitle::onFocusDown(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXRegion & ( FXRegion::operator -=)(const class FXRegion & r) */
/* SKIPPED (operator) */
/* const struct FXMetaClass * FXFontSelector::getMetaClass()const  */
int lua_call1_FXFontSelector__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFontSelector * __self__;
    
    __self__ = ( class FXFontSelector * )lua_to_FXFontSelector(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDC::drawArea(const class FXDrawable * source, FXint sx, FXint sy, FXint sw, FXint sh, FXint dx, FXint dy) */
int lua_call1_FXDC__drawArea(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 8) goto error;
  {
     class FXDC * __self__;
     class FXDrawable * source;
     int sx;
     int sy;
     int sw;
     int sh;
     int dx;
     int dy;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    source = ( class FXDrawable * )lua_to_FXDrawable(__S__, 2, &__ERROR__);
    sx = ( int )(int)lua_tonumber(__S__, 3);
    sy = ( int )(int)lua_tonumber(__S__, 4);
    sw = ( int )(int)lua_tonumber(__S__, 5);
    sh = ( int )(int)lua_tonumber(__S__, 6);
    dx = ( int )(int)lua_tonumber(__S__, 7);
    dy = ( int )(int)lua_tonumber(__S__, 8);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawArea(source, sx, sy, sw, sh, dx, dy);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXListSortFunc FXList::getSortFunc()const  */
/* SKIPPED (return type) */
/* long FXPrintDialog::onCmdLandscape(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* const struct FXMetaClass * FXFontDialog::getMetaClass()const  */
int lua_call1_FXFontDialog__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFontDialog * __self__;
    
    __self__ = ( class FXFontDialog * )lua_to_FXFontDialog(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPopup::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDC::setClipMask(class FXBitmap * bitmap, FXint dx=0, FXint dy=0) */
int lua_call1_FXDC__setClipMask(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDC * __self__;
     class FXBitmap * bitmap;
     int dx;
     int dy;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    bitmap = ( class FXBitmap * )lua_to_FXBitmap(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      __self__->setClipMask(bitmap);
    } else {
      dx = ( int )(int)lua_tonumber(__S__, 3);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        __self__->setClipMask(bitmap, dx);
      } else {
        dy = ( int )(int)lua_tonumber(__S__, 4);
        if (__ERROR__) goto error;
        
        __self__->setClipMask(bitmap, dx, dy);
      }
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXOptionMenu::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXTreeListBox::getDefaultHeight() */
int lua_call1_FXTreeListBox__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeListBox * __self__;
    
    __self__ = ( class FXTreeListBox * )lua_to_FXTreeListBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXProgressBar::getBarBGColor()const  */
int lua_call1_FXProgressBar__getBarBGColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXProgressBar * __self__;
    
    __self__ = ( class FXProgressBar * )lua_to_FXProgressBar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBarBGColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDirList::setAssociations(class FXFileDict * assoc) */
int lua_call1_FXDirList__setAssociations(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDirList * __self__;
     class FXFileDict * assoc;
    
    __self__ = ( class FXDirList * )lua_to_FXDirList(__S__, 1, &__ERROR__);
    assoc = ( class FXFileDict * )lua_to_FXFileDict(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setAssociations(assoc);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXFileSelector::getSelectMode()const  */
int lua_call1_FXFileSelector__getSelectMode(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileSelector * __self__;
    
    __self__ = ( class FXFileSelector * )lua_to_FXFileSelector(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getSelectMode());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMenubar::onButtonPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTable::onSelectionLost(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXuint FXApp::getScrollSpeed()const  */
int lua_call1_FXApp__getScrollSpeed(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getScrollSpeed());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIconItem::setFocus(FXbool focus) */
int lua_call1_FXIconItem__setFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconItem * __self__;
     unsigned char focus;
    
    __self__ = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
    focus = ( unsigned char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setFocus(focus);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXStream & FXStream::load(FXlong * p, FXuint n) */
/* SKIPPED (argument #2) */
/* class FXStream & FXStream::load(FXdouble * p, FXuint n) */
/* SKIPPED (argument #2) */
/* class FXStream & FXStream::load(FXint * p, FXuint n) */
/* SKIPPED (argument #2) */
/* class FXStream & FXStream::load(FXulong * p, FXuint n) */
/* SKIPPED (argument #2) */
/* class FXStream & FXStream::load(FXfloat * p, FXuint n) */
/* SKIPPED (argument #2) */
/* class FXStream & FXStream::load(FXshort * p, FXuint n) */
/* SKIPPED (argument #2) */
/* class FXStream & FXStream::load(FXchar * p, FXuint n) */
int lua_call7_FXStream__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXStream * __self__;
     char * p;
     unsigned int n;
    
    __self__ = ( class FXStream * )lua_to_FXStream(__S__, 1, &__ERROR__);
    p = ( char * )(char  *)lua_tostring(__S__, 2);
    n = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXStream(__S__, &(__self__->load(p, n)));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXStream & FXStream::load(FXushort * p, FXuint n) */
/* SKIPPED (argument #2) */
/* class FXStream & FXStream::load(FXuchar * p, FXuint n) */
int lua_call9_FXStream__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXStream * __self__;
     unsigned char * p;
     unsigned int n;
    
    __self__ = ( class FXStream * )lua_to_FXStream(__S__, 1, &__ERROR__);
    p = ( unsigned char * )(char  *)lua_tostring(__S__, 2);
    n = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXStream(__S__, &(__self__->load(p, n)));
    return 1;
  }
  
error:
  return lua_call7_FXStream__load(__S__);
}
/* class FXStream & FXStream::load(FXuint * p, FXuint n) */
/* SKIPPED (argument #2) */
/* long FXToggleButton::onUpdate(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXIconList::ascending(const class FXIconItem * a, const class FXIconItem * b) */
int lua_call1_FXIconList__ascending(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXIconItem * a;
     class FXIconItem * b;
    
    a = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
    b = ( class FXIconItem * )lua_to_FXIconItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, FXIconList::ascending(a, b));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXPacker::setPadTop(FXint pt) */
int lua_call1_FXPacker__setPadTop(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXPacker * __self__;
     int pt;
    
    __self__ = ( class FXPacker * )lua_to_FXPacker(__S__, 1, &__ERROR__);
    pt = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setPadTop(pt);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorWell::onDNDEnter(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXColor FXText::getBarColor()const  */
int lua_call1_FXText__getBarColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBarColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXFileList::onCmdSetDirectory(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXText::isPosVisible(FXint pos)const  */
int lua_call1_FXText__isPosVisible(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXText * __self__;
     int pos;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    pos = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isPosVisible(pos));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXIcon * FXListBox::getItemIcon(FXint index)const  */
int lua_call1_FXListBox__getItemIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXListBox * __self__;
     int index;
    
    __self__ = ( class FXListBox * )lua_to_FXListBox(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXIcon(__S__, __self__->getItemIcon(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXAccelTable::addAccel(FXHotKey hotkey, class FXObject * target=__null, FXSelector seldn=0, FXSelector selup=0) */
int lua_call1_FXAccelTable__addAccel(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXAccelTable * __self__;
     unsigned int hotkey;
     class FXObject * target;
     unsigned int seldn;
     unsigned int selup;
    
    __self__ = ( class FXAccelTable * )lua_to_FXAccelTable(__S__, 1, &__ERROR__);
    hotkey = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      __self__->addAccel(hotkey);
    } else {
      target = ( class FXObject * )lua_to_FXObject(__S__, 3, &__ERROR__);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        __self__->addAccel(hotkey, target);
      } else {
        seldn = ( unsigned int )(int)lua_tonumber(__S__, 4);
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          __self__->addAccel(hotkey, target, seldn);
        } else {
          selup = ( unsigned int )(int)lua_tonumber(__S__, 5);
          if (__ERROR__) goto error;
          
          __self__->addAccel(hotkey, target, seldn, selup);
        }
      }
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorSelector::onCmdHSVText(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXColorBar::getDefaultHeight() */
int lua_call1_FXColorBar__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorBar * __self__;
    
    __self__ = ( class FXColorBar * )lua_to_FXColorBar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXHeaderItem * FXHeader::retrieveItem(FXint index)const  */
int lua_call1_FXHeader__retrieveItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXHeader * __self__;
     int index;
    
    __self__ = ( class FXHeader * )lua_to_FXHeader(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXHeaderItem(__S__, __self__->retrieveItem(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXList::onLookupTimer(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXuint FXHeader::getHeaderStyle()const  */
int lua_call1_FXHeader__getHeaderStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXHeader * __self__;
    
    __self__ = ( class FXHeader * )lua_to_FXHeader(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getHeaderStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDocument::load(class FXStream & store) */
int lua_call1_FXDocument__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDocument * __self__;
    
    __self__ = ( class FXDocument * )lua_to_FXDocument(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXTable::getMetaClass()const  */
int lua_call1_FXTable__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCWindow::drawRectangles(const class FXRectangle * rectangles, FXuint nrectangles) */
int lua_call1_FXDCWindow__drawRectangles(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDCWindow * __self__;
     class FXRectangle * rectangles;
     unsigned int nrectangles;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    rectangles = ( class FXRectangle * )lua_to_FXRectangle(__S__, 2, &__ERROR__);
    nrectangles = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawRectangles(rectangles, nrectangles);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXFileSelector::onUpdNew(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXComboBox::setText(const class FXString & text) */
int lua_call1_FXComboBox__setText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXComboBox * __self__;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    int __err__41; static FXString __cstr__41; FXString * __str__41 = lua_to_FXString(__S__, 2, &__err__41);  class FXString & text = ( class FXString & ) (__str__41? *__str__41 : (__cstr__41 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__41));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setText(text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXMDIChild * FXMDIClient::getMDIChildFirst()const  */
int lua_call1_FXMDIClient__getMDIChildFirst(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIClient * __self__;
    
    __self__ = ( class FXMDIClient * )lua_to_FXMDIClient(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMDIChild(__S__, __self__->getMDIChildFirst());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXString::FXString() */
int lua_call1_FXString__FXString(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXString(__S__, new FXString());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXString::FXString(const class FXString & s) */
int lua_call2_FXString__FXString(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
    
    int __err__42; static FXString __cstr__42; FXString * __str__42 = lua_to_FXString(__S__, 1, &__err__42);  class FXString & s = ( class FXString & ) (__str__42? *__str__42 : (__cstr__42 =(FXString) (char *)lua_tostring(__S__, 1), __cstr__42));
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXString(__S__, new FXString(s));
    return 1;
  }
  
error:
  return lua_call1_FXString__FXString(__S__);
}
/*  FXString::FXString(const FXchar * s) */
int lua_call3_FXString__FXString(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     char * s;
    
    s = ( char * )(char  *)lua_tostring(__S__, 1);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXString(__S__, new FXString(s));
    return 1;
  }
  
error:
  return lua_call2_FXString__FXString(__S__);
}
/*  FXString::FXString(FXchar c, FXint n) */
int lua_call4_FXString__FXString(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     char c;
     int n;
    
    c = ( char )(char)lua_tonumber(__S__, 1);
    n = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXString(__S__, new FXString(c, n));
    return 1;
  }
  
error:
  return lua_call3_FXString__FXString(__S__);
}
/*  FXString::FXString(const FXchar * s, FXint n) */
int lua_call5_FXString__FXString(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     char * s;
     int n;
    
    s = ( char * )(char  *)lua_tostring(__S__, 1);
    n = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXString(__S__, new FXString(s, n));
    return 1;
  }
  
error:
  return lua_call4_FXString__FXString(__S__);
}
/*  FXString::FXString(const FXchar * s1, const FXchar * s2) */
int lua_call6_FXString__FXString(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     char * s1;
     char * s2;
    
    s1 = ( char * )(char  *)lua_tostring(__S__, 1);
    s2 = ( char * )(char  *)lua_tostring(__S__, 2);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXString(__S__, new FXString(s1, s2));
    return 1;
  }
  
error:
  return lua_call5_FXString__FXString(__S__);
}
/* void FXIconList::setHeaderText(FXint index, const class FXString & text) */
int lua_call1_FXIconList__setHeaderText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXIconList * __self__;
     int index;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    int __err__43; static FXString __cstr__43; FXString * __str__43 = lua_to_FXString(__S__, 3, &__err__43);  class FXString & text = ( class FXString & ) (__str__43? *__str__43 : (__cstr__43 =(FXString) (char *)lua_tostring(__S__, 3), __cstr__43));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setHeaderText(index, text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTable::getNumCols()const  */
int lua_call1_FXTable__getNumCols(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getNumCols());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXStream::close() */
int lua_call1_FXStream__close(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXStream * __self__;
    
    __self__ = ( class FXStream * )lua_to_FXStream(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->close());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXToolbarGrip::onLeave(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXFileList::onUpdToggleHidden(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXString & FXString::trimBegin() */
int lua_call1_FXString__trimBegin(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXString * __self__;
    
    __self__ = ( class FXString * )lua_to_FXString(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->trimBegin().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTreeListBox::setItemData(class FXTreeItem * item, void * ptr)const  */
/* SKIPPED (argument #3) */
/* void FXMDIChild::resize(FXint w, FXint h) */
int lua_call1_FXMDIChild__resize(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXMDIChild * __self__;
     int w;
     int h;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    w = ( int )(int)lua_tonumber(__S__, 2);
    h = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->resize(w, h);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onLeftBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXString FXDocument::getTitle()const  */
int lua_call1_FXDocument__getTitle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDocument * __self__;
    
    __self__ = ( class FXDocument * )lua_to_FXDocument(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getTitle().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXPacker::setPackingHints(FXuint ph) */
int lua_call1_FXPacker__setPackingHints(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXPacker * __self__;
     unsigned int ph;
    
    __self__ = ( class FXPacker * )lua_to_FXPacker(__S__, 1, &__ERROR__);
    ph = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setPackingHints(ph);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXMDIClient::manufacture() */
int lua_call1_FXMDIClient__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXMDIClient::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDragCorner::onLeftBtnPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXUndoList::canRedo()const  */
int lua_call1_FXUndoList__canRedo(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXUndoList * __self__;
    
    __self__ = ( class FXUndoList * )lua_to_FXUndoList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->canRedo());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* struct FXFileAssoc * FXFileDict::findExecBinding(const FXchar * pathname) */
int lua_call1_FXFileDict__findExecBinding(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileDict * __self__;
     char * pathname;
    
    __self__ = ( class FXFileDict * )lua_to_FXFileDict(__S__, 1, &__ERROR__);
    pathname = ( char * )(char  *)lua_tostring(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXFileAssoc(__S__, __self__->findExecBinding(pathname));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMenuTitle::onEnter(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXDialogBox::manufacture() */
int lua_call1_FXDialogBox__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXDialogBox::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPicker::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/*  FXColorSelector::FXColorSelector(class FXComposite * p, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=0, FXint x=0, FXint y=0, FXint w=0, FXint h=0) */
int lua_call1_FXColorSelector__FXColorSelector(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXColorSelector(__S__, new FXColorSelector(p));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 2, &__ERROR__);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXColorSelector(__S__, new FXColorSelector(p, tgt));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXColorSelector(__S__, new FXColorSelector(p, tgt, sel));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXColorSelector(__S__, new FXColorSelector(p, tgt, sel, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXColorSelector(__S__, new FXColorSelector(p, tgt, sel, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 6);
              if (nparam <= 6) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXColorSelector(__S__, new FXColorSelector(p, tgt, sel, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 7);
                if (nparam <= 7) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXColorSelector(__S__, new FXColorSelector(p, tgt, sel, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 8);
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXColorSelector(__S__, new FXColorSelector(p, tgt, sel, opts, x, y, w, h));
                  return 1;
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXSpinner::disable() */
int lua_call1_FXSpinner__disable(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSpinner * __self__;
    
    __self__ = ( class FXSpinner * )lua_to_FXSpinner(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->disable();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onCmdShiftText(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXOption::FXOption(class FXComposite * p, const class FXString & text, class FXIcon * ic=__null, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=JUSTIFY_NORMAL|ICON_BEFORE_TEXT|MENUBUTTON_DOWN, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=2, FXint pr=2, FXint pt=2, FXint pb=2) */
int lua_call1_FXOption__FXOption(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXComposite * p;
     class FXIcon * ic;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    int __err__44; static FXString __cstr__44; FXString * __str__44 = lua_to_FXString(__S__, 2, &__err__44);  class FXString & text = ( class FXString & ) (__str__44? *__str__44 : (__cstr__44 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__44));
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXOption(__S__, new FXOption(p, text));
      return 1;
    } else {
      ic = ( class FXIcon * )lua_to_FXIcon(__S__, 3, &__ERROR__);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXOption(__S__, new FXOption(p, text, ic));
        return 1;
      } else {
        tgt = ( class FXObject * )lua_to_FXObject(__S__, 4, &__ERROR__);
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXOption(__S__, new FXOption(p, text, ic, tgt));
          return 1;
        } else {
          sel = ( unsigned int )(int)lua_tonumber(__S__, 5);
          if (nparam <= 5) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXOption(__S__, new FXOption(p, text, ic, tgt, sel));
            return 1;
          } else {
            opts = ( unsigned int )(int)lua_tonumber(__S__, 6);
            if (nparam <= 6) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXOption(__S__, new FXOption(p, text, ic, tgt, sel, opts));
              return 1;
            } else {
              x = ( int )(int)lua_tonumber(__S__, 7);
              if (nparam <= 7) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXOption(__S__, new FXOption(p, text, ic, tgt, sel, opts, x));
                return 1;
              } else {
                y = ( int )(int)lua_tonumber(__S__, 8);
                if (nparam <= 8) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXOption(__S__, new FXOption(p, text, ic, tgt, sel, opts, x, y));
                  return 1;
                } else {
                  w = ( int )(int)lua_tonumber(__S__, 9);
                  if (nparam <= 9) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXOption(__S__, new FXOption(p, text, ic, tgt, sel, opts, x, y, w));
                    return 1;
                  } else {
                    h = ( int )(int)lua_tonumber(__S__, 10);
                    if (nparam <= 10) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXOption(__S__, new FXOption(p, text, ic, tgt, sel, opts, x, y, w, h));
                      return 1;
                    } else {
                      pl = ( int )(int)lua_tonumber(__S__, 11);
                      if (nparam <= 11) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXOption(__S__, new FXOption(p, text, ic, tgt, sel, opts, x, y, w, h, pl));
                        return 1;
                      } else {
                        pr = ( int )(int)lua_tonumber(__S__, 12);
                        if (nparam <= 12) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXOption(__S__, new FXOption(p, text, ic, tgt, sel, opts, x, y, w, h, pl, pr));
                          return 1;
                        } else {
                          pt = ( int )(int)lua_tonumber(__S__, 13);
                          if (nparam <= 13) {
                            if (__ERROR__) goto error;
                            
                            lua_settop(__S__, 0);
                            lua_push_FXOption(__S__, new FXOption(p, text, ic, tgt, sel, opts, x, y, w, h, pl, pr, pt));
                            return 1;
                          } else {
                            pb = ( int )(int)lua_tonumber(__S__, 14);
                            if (__ERROR__) goto error;
                            
                            lua_settop(__S__, 0);
                            lua_push_FXOption(__S__, new FXOption(p, text, ic, tgt, sel, opts, x, y, w, h, pl, pr, pt, pb));
                            return 1;
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXSlider::onCmdSetRealRange(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTreeListBox::onFocusUp(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXIconList::enableItem(FXint index) */
int lua_call1_FXIconList__enableItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconList * __self__;
     int index;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->enableItem(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDC::clipChildren(FXbool yes) */
int lua_call1_FXDC__clipChildren(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDC * __self__;
     unsigned char yes;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    yes = ( unsigned char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->clipChildren(yes);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXPacker::setPadLeft(FXint pl) */
int lua_call1_FXPacker__setPadLeft(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXPacker * __self__;
     int pl;
    
    __self__ = ( class FXPacker * )lua_to_FXPacker(__S__, 1, &__ERROR__);
    pl = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setPadLeft(pl);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXList::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXIcon::resize(FXint w, FXint h) */
int lua_call1_FXIcon__resize(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXIcon * __self__;
     int w;
     int h;
    
    __self__ = ( class FXIcon * )lua_to_FXIcon(__S__, 1, &__ERROR__);
    w = ( int )(int)lua_tonumber(__S__, 2);
    h = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->resize(w, h);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXFrame::save(class FXStream & store)const  */
int lua_call1_FXFrame__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFrame * __self__;
    
    __self__ = ( class FXFrame * )lua_to_FXFrame(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXTreeList::disableItem(class FXTreeItem * item) */
int lua_call1_FXTreeList__disableItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeList * __self__;
     class FXTreeItem * item;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->disableItem(item));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::setDefColumnWidth(FXint cwidth) */
int lua_call1_FXTable__setDefColumnWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTable * __self__;
     int cwidth;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    cwidth = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setDefColumnWidth(cwidth);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTreeItem::setClosedIcon(class FXIcon * icn) */
int lua_call1_FXTreeItem__setClosedIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeItem * __self__;
     class FXIcon * icn;
    
    __self__ = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 1, &__ERROR__);
    icn = ( class FXIcon * )lua_to_FXIcon(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setClosedIcon(icn);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXFileDialog::getMetaClass()const  */
int lua_call1_FXFileDialog__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileDialog * __self__;
    
    __self__ = ( class FXFileDialog * )lua_to_FXFileDialog(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPrintDialog::onUpdFileName(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXText::onCmdCursorRow(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXVerticalFrame::getDefaultHeight() */
int lua_call1_FXVerticalFrame__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXVerticalFrame * __self__;
    
    __self__ = ( class FXVerticalFrame * )lua_to_FXVerticalFrame(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXHorizontalSeparator::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDCWindow::fillComplexPolygon(const class FXPoint * points, FXuint npoints) */
int lua_call1_FXDCWindow__fillComplexPolygon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDCWindow * __self__;
     class FXPoint * points;
     unsigned int npoints;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    points = ( class FXPoint * )lua_to_FXPoint(__S__, 2, &__ERROR__);
    npoints = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->fillComplexPolygon(points, npoints);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXToolbarGrip::getActiveColor()const  */
int lua_call1_FXToolbarGrip__getActiveColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbarGrip * __self__;
    
    __self__ = ( class FXToolbarGrip * )lua_to_FXToolbarGrip(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getActiveColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXStringDict::FXStringDict() */
int lua_call1_FXStringDict__FXStringDict(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXStringDict(__S__, new FXStringDict());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXCheckButton::manufacture() */
int lua_call1_FXCheckButton__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXCheckButton::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXGroupBox::disable() */
int lua_call1_FXGroupBox__disable(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXGroupBox * __self__;
    
    __self__ = ( class FXGroupBox * )lua_to_FXGroupBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->disable();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXScrollbar::getPosition()const  */
int lua_call1_FXScrollbar__getPosition(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXScrollbar * __self__;
    
    __self__ = ( class FXScrollbar * )lua_to_FXScrollbar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getPosition());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXPopup::popdown() */
int lua_call1_FXPopup__popdown(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXPopup * __self__;
    
    __self__ = ( class FXPopup * )lua_to_FXPopup(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->popdown();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXReplaceDialog::onCmdAll(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* unsigned long FXStream::position()const  */
int lua_call1_FXStream__position(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXStream * __self__;
    
    __self__ = ( class FXStream * )lua_to_FXStream(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->position());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXStream::position(unsigned long p) */
int lua_call2_FXStream__position(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXStream * __self__;
     unsigned long p;
    
    __self__ = ( class FXStream * )lua_to_FXStream(__S__, 1, &__ERROR__);
    p = ( unsigned long )(long)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->position(p));
    return 1;
  }
  
error:
  return lua_call1_FXStream__position(__S__);
}
/* long FXMatrix::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* class FXTreeItem * FXTreeList::addItemLast(class FXTreeItem * p, class FXTreeItem * item, FXbool notify=0) */
int lua_call1_FXTreeList__addItemLast(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTreeList * __self__;
     class FXTreeItem * p;
     class FXTreeItem * item;
     unsigned char notify;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    p = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 3, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXTreeItem(__S__, __self__->addItemLast(p, item));
      return 1;
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 4);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXTreeItem(__S__, __self__->addItemLast(p, item, notify));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXTreeItem * FXTreeList::addItemLast(class FXTreeItem * p, const class FXString & text, class FXIcon * oi=__null, class FXIcon * ci=__null, void * ptr=__null, FXbool notify=0) */
int lua_call2_FXTreeList__addItemLast(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTreeList * __self__;
     class FXTreeItem * p;
     class FXIcon * oi;
     class FXIcon * ci;
     void * ptr;
     unsigned char notify;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    p = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    int __err__45; static FXString __cstr__45; FXString * __str__45 = lua_to_FXString(__S__, 3, &__err__45);  class FXString & text = ( class FXString & ) (__str__45? *__str__45 : (__cstr__45 =(FXString) (char *)lua_tostring(__S__, 3), __cstr__45));
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXTreeItem(__S__, __self__->addItemLast(p, text));
      return 1;
    } else {
      oi = ( class FXIcon * )lua_to_FXIcon(__S__, 4, &__ERROR__);
      if (nparam <= 4) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXTreeItem(__S__, __self__->addItemLast(p, text, oi));
        return 1;
      } else {
        ci = ( class FXIcon * )lua_to_FXIcon(__S__, 5, &__ERROR__);
        if (nparam <= 5) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXTreeItem(__S__, __self__->addItemLast(p, text, oi, ci));
          return 1;
        } else {
          if (nparam <= 6) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXTreeItem(__S__, __self__->addItemLast(p, text, oi, ci, ptr));
            return 1;
          } else {
            notify = ( unsigned char )(char)lua_tonumber(__S__, 7);
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXTreeItem(__S__, __self__->addItemLast(p, text, oi, ci, ptr, notify));
            return 1;
          }
        }
      }
    }
  }
  
error:
  return lua_call1_FXTreeList__addItemLast(__S__);
}
/* long FXTable::onCmdHorzGrid(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXToolbarTab::manufacture() */
int lua_call1_FXToolbarTab__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXToolbarTab::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* int & FXLint::get() */
int lua_call1_FXLint__get(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXLint * __self__;
    
    __self__ = ( class FXLint * )lua_to_FXLint(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->get());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTable::getTrailingRows()const  */
int lua_call1_FXTable__getTrailingRows(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTrailingRows());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXScrollWindow::getContentWidth() */
int lua_call1_FXScrollWindow__getContentWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXScrollWindow * __self__;
    
    __self__ = ( class FXScrollWindow * )lua_to_FXScrollWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getContentWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXListItem::destroy() */
int lua_call1_FXListItem__destroy(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXListItem * __self__;
    
    __self__ = ( class FXListItem * )lua_to_FXListItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->destroy();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::clearDragRectangle() */
int lua_call1_FXWindow__clearDragRectangle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->clearDragRectangle();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXfloat FXColorWheel::getVal()const  */
int lua_call1_FXColorWheel__getVal(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorWheel * __self__;
    
    __self__ = ( class FXColorWheel * )lua_to_FXColorWheel(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getVal());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXDragCorner::FXDragCorner(class FXComposite * p) */
int lua_call1_FXDragCorner__FXDragCorner(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXDragCorner(__S__, new FXDragCorner(p));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const FXchar * FXDC::getDashPattern()const  */
int lua_call1_FXDC__getDashPattern(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDC * __self__;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, (const char * ) __self__->getDashPattern());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXRecentFiles::setMaxFiles(FXint mx) */
int lua_call1_FXRecentFiles__setMaxFiles(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXRecentFiles * __self__;
     int mx;
    
    __self__ = ( class FXRecentFiles * )lua_to_FXRecentFiles(__S__, 1, &__ERROR__);
    mx = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setMaxFiles(mx);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXSpinner::onCmdDecrement(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXDHMat & FXDHMat::eye() */
int lua_call1_FXDHMat__eye(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDHMat * __self__;
    
    __self__ = ( class FXDHMat * )lua_to_FXDHMat(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXDHMat(__S__, &(__self__->eye()));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTextField::setAnchorPos(FXint pos) */
int lua_call1_FXTextField__setAnchorPos(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTextField * __self__;
     int pos;
    
    __self__ = ( class FXTextField * )lua_to_FXTextField(__S__, 1, &__ERROR__);
    pos = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setAnchorPos(pos);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXOptionMenu::contains(FXint parentx, FXint parenty)const  */
int lua_call1_FXOptionMenu__contains(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXOptionMenu * __self__;
     int parentx;
     int parenty;
    
    __self__ = ( class FXOptionMenu * )lua_to_FXOptionMenu(__S__, 1, &__ERROR__);
    parentx = ( int )(int)lua_tonumber(__S__, 2);
    parenty = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->contains(parentx, parenty));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDirList::onDNDMotion(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXWindow * FXApp::getCursorWindow()const  */
int lua_call1_FXApp__getCursorWindow(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXWindow(__S__, __self__->getCursorWindow());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTopWindow::getPadLeft()const  */
int lua_call1_FXTopWindow__getPadLeft(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTopWindow * __self__;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getPadLeft());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXHeader::save(class FXStream & store)const  */
int lua_call1_FXHeader__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXHeader * __self__;
    
    __self__ = ( class FXHeader * )lua_to_FXHeader(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorWheel::onMotion(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXFont::hasChar(FXint ch)const  */
int lua_call1_FXFont__hasChar(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFont * __self__;
     int ch;
    
    __self__ = ( class FXFont * )lua_to_FXFont(__S__, 1, &__ERROR__);
    ch = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->hasChar(ch));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTableItem::detach() */
int lua_call1_FXTableItem__detach(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTableItem * __self__;
    
    __self__ = ( class FXTableItem * )lua_to_FXTableItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->detach();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXFileSelector::setFileBoxStyle(FXuint style) */
int lua_call1_FXFileSelector__setFileBoxStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileSelector * __self__;
     unsigned int style;
    
    __self__ = ( class FXFileSelector * )lua_to_FXFileSelector(__S__, 1, &__ERROR__);
    style = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setFileBoxStyle(style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXSlider::getSliderStyle()const  */
int lua_call1_FXSlider__getSliderStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSlider * __self__;
    
    __self__ = ( class FXSlider * )lua_to_FXSlider(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getSliderStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMenuTitle::detach() */
int lua_call1_FXMenuTitle__detach(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuTitle * __self__;
    
    __self__ = ( class FXMenuTitle * )lua_to_FXMenuTitle(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->detach();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXWindow::onCmdEnable(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXTreeListBox::sortChildItems(class FXTreeItem * item) */
int lua_call1_FXTreeListBox__sortChildItems(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeListBox * __self__;
     class FXTreeItem * item;
    
    __self__ = ( class FXTreeListBox * )lua_to_FXTreeListBox(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->sortChildItems(item);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXVerticalSeparator::getDefaultHeight() */
int lua_call1_FXVerticalSeparator__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXVerticalSeparator * __self__;
    
    __self__ = ( class FXVerticalSeparator * )lua_to_FXVerticalSeparator(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXWindow::isInitial()const  */
int lua_call1_FXWindow__isInitial(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isInitial());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXFileSelector::getPatternList()const  */
int lua_call1_FXFileSelector__getPatternList(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileSelector * __self__;
    
    __self__ = ( class FXFileSelector * )lua_to_FXFileSelector(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getPatternList().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXText::setActiveBackColor(FXColor clr) */
int lua_call1_FXText__setActiveBackColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXText * __self__;
     unsigned int clr;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setActiveBackColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXColorBar::load(class FXStream & store) */
int lua_call1_FXColorBar__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXColorBar * __self__;
    
    __self__ = ( class FXColorBar * )lua_to_FXColorBar(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onUpdToggleEditable(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXColor FXTable::getStippleColor()const  */
int lua_call1_FXTable__getStippleColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getStippleColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCPrint::setStipple(class FXBitmap * stipple, FXint dx=0, FXint dy=0) */
int lua_call1_FXDCPrint__setStipple(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDCPrint * __self__;
     class FXBitmap * stipple;
     int dx;
     int dy;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    stipple = ( class FXBitmap * )lua_to_FXBitmap(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      __self__->setStipple(stipple);
    } else {
      dx = ( int )(int)lua_tonumber(__S__, 3);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        __self__->setStipple(stipple, dx);
      } else {
        dy = ( int )(int)lua_tonumber(__S__, 4);
        if (__ERROR__) goto error;
        
        __self__->setStipple(stipple, dx, dy);
      }
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCPrint::setStipple(FXStipplePattern stipple, FXint dx=0, FXint dy=0) */
int lua_call2_FXDCPrint__setStipple(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDCPrint * __self__;
     FXStipplePattern stipple;
     int dx;
     int dy;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    stipple = ( FXStipplePattern )(FXStipplePattern)(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      __self__->setStipple(stipple);
    } else {
      dx = ( int )(int)lua_tonumber(__S__, 3);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        __self__->setStipple(stipple, dx);
      } else {
        dy = ( int )(int)lua_tonumber(__S__, 4);
        if (__ERROR__) goto error;
        
        __self__->setStipple(stipple, dx, dy);
      }
    }
    ;
    return 0;
  }
  
error:
  return lua_call1_FXDCPrint__setStipple(__S__);
}
/* long FXColorSelector::onUpdHSVSlider(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDriveBox::detach() */
int lua_call1_FXDriveBox__detach(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDriveBox * __self__;
    
    __self__ = ( class FXDriveBox * )lua_to_FXDriveBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->detach();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXToolbar::FXToolbar(class FXComposite * p, FXuint opts=LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=2, FXint pr=3, FXint pt=3, FXint pb=2, FXint hs=4, FXint vs=4) */
int lua_call1_FXToolbar__FXToolbar(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
     int hs;
     int vs;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXToolbar(__S__, new FXToolbar(p));
      return 1;
    } else {
      opts = ( unsigned int )(int)lua_tonumber(__S__, 2);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXToolbar(__S__, new FXToolbar(p, opts));
        return 1;
      } else {
        x = ( int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXToolbar(__S__, new FXToolbar(p, opts, x));
          return 1;
        } else {
          y = ( int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXToolbar(__S__, new FXToolbar(p, opts, x, y));
            return 1;
          } else {
            w = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXToolbar(__S__, new FXToolbar(p, opts, x, y, w));
              return 1;
            } else {
              h = ( int )(int)lua_tonumber(__S__, 6);
              if (nparam <= 6) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXToolbar(__S__, new FXToolbar(p, opts, x, y, w, h));
                return 1;
              } else {
                pl = ( int )(int)lua_tonumber(__S__, 7);
                if (nparam <= 7) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXToolbar(__S__, new FXToolbar(p, opts, x, y, w, h, pl));
                  return 1;
                } else {
                  pr = ( int )(int)lua_tonumber(__S__, 8);
                  if (nparam <= 8) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXToolbar(__S__, new FXToolbar(p, opts, x, y, w, h, pl, pr));
                    return 1;
                  } else {
                    pt = ( int )(int)lua_tonumber(__S__, 9);
                    if (nparam <= 9) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXToolbar(__S__, new FXToolbar(p, opts, x, y, w, h, pl, pr, pt));
                      return 1;
                    } else {
                      pb = ( int )(int)lua_tonumber(__S__, 10);
                      if (nparam <= 10) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXToolbar(__S__, new FXToolbar(p, opts, x, y, w, h, pl, pr, pt, pb));
                        return 1;
                      } else {
                        hs = ( int )(int)lua_tonumber(__S__, 11);
                        if (nparam <= 11) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXToolbar(__S__, new FXToolbar(p, opts, x, y, w, h, pl, pr, pt, pb, hs));
                          return 1;
                        } else {
                          vs = ( int )(int)lua_tonumber(__S__, 12);
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXToolbar(__S__, new FXToolbar(p, opts, x, y, w, h, pl, pr, pt, pb, hs, vs));
                          return 1;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXToolbar::FXToolbar(class FXComposite * p, class FXComposite * q, FXuint opts=LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=3, FXint pr=3, FXint pt=2, FXint pb=2, FXint hs=4, FXint vs=4) */
int lua_call2_FXToolbar__FXToolbar(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXComposite * p;
     class FXComposite * q;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
     int hs;
     int vs;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    q = ( class FXComposite * )lua_to_FXComposite(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXToolbar(__S__, new FXToolbar(p, q));
      return 1;
    } else {
      opts = ( unsigned int )(int)lua_tonumber(__S__, 3);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXToolbar(__S__, new FXToolbar(p, q, opts));
        return 1;
      } else {
        x = ( int )(int)lua_tonumber(__S__, 4);
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXToolbar(__S__, new FXToolbar(p, q, opts, x));
          return 1;
        } else {
          y = ( int )(int)lua_tonumber(__S__, 5);
          if (nparam <= 5) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXToolbar(__S__, new FXToolbar(p, q, opts, x, y));
            return 1;
          } else {
            w = ( int )(int)lua_tonumber(__S__, 6);
            if (nparam <= 6) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXToolbar(__S__, new FXToolbar(p, q, opts, x, y, w));
              return 1;
            } else {
              h = ( int )(int)lua_tonumber(__S__, 7);
              if (nparam <= 7) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXToolbar(__S__, new FXToolbar(p, q, opts, x, y, w, h));
                return 1;
              } else {
                pl = ( int )(int)lua_tonumber(__S__, 8);
                if (nparam <= 8) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXToolbar(__S__, new FXToolbar(p, q, opts, x, y, w, h, pl));
                  return 1;
                } else {
                  pr = ( int )(int)lua_tonumber(__S__, 9);
                  if (nparam <= 9) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXToolbar(__S__, new FXToolbar(p, q, opts, x, y, w, h, pl, pr));
                    return 1;
                  } else {
                    pt = ( int )(int)lua_tonumber(__S__, 10);
                    if (nparam <= 10) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXToolbar(__S__, new FXToolbar(p, q, opts, x, y, w, h, pl, pr, pt));
                      return 1;
                    } else {
                      pb = ( int )(int)lua_tonumber(__S__, 11);
                      if (nparam <= 11) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXToolbar(__S__, new FXToolbar(p, q, opts, x, y, w, h, pl, pr, pt, pb));
                        return 1;
                      } else {
                        hs = ( int )(int)lua_tonumber(__S__, 12);
                        if (nparam <= 12) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXToolbar(__S__, new FXToolbar(p, q, opts, x, y, w, h, pl, pr, pt, pb, hs));
                          return 1;
                        } else {
                          vs = ( int )(int)lua_tonumber(__S__, 13);
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXToolbar(__S__, new FXToolbar(p, q, opts, x, y, w, h, pl, pr, pt, pb, hs, vs));
                          return 1;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  return lua_call1_FXToolbar__FXToolbar(__S__);
}
/* long FXFontSelector::onCmdSize(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXFrame::getDefaultHeight() */
int lua_call1_FXFrame__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFrame * __self__;
    
    __self__ = ( class FXFrame * )lua_to_FXFrame(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXPopup::getDefaultWidth() */
int lua_call1_FXPopup__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXPopup * __self__;
    
    __self__ = ( class FXPopup * )lua_to_FXPopup(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXHeader::getArrowDir(FXint index)const  */
int lua_call1_FXHeader__getArrowDir(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXHeader * __self__;
     int index;
    
    __self__ = ( class FXHeader * )lua_to_FXHeader(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getArrowDir(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FX4Splitter::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXMDIChild::onUpdMenuWindow(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXList::prependItem(class FXListItem * item, FXbool notify=0) */
int lua_call1_FXList__prependItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXList * __self__;
     class FXListItem * item;
     unsigned char notify;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    item = ( class FXListItem * )lua_to_FXListItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->prependItem(item));
      return 1;
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->prependItem(item, notify));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXList::prependItem(const class FXString & text, class FXIcon * icon=__null, void * ptr=__null, FXbool notify=0) */
int lua_call2_FXList__prependItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXList * __self__;
     class FXIcon * icon;
     void * ptr;
     unsigned char notify;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    int __err__46; static FXString __cstr__46; FXString * __str__46 = lua_to_FXString(__S__, 2, &__err__46);  class FXString & text = ( class FXString & ) (__str__46? *__str__46 : (__cstr__46 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__46));
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->prependItem(text));
      return 1;
    } else {
      icon = ( class FXIcon * )lua_to_FXIcon(__S__, 3, &__ERROR__);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_pushnumber(__S__, __self__->prependItem(text, icon));
        return 1;
      } else {
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_pushnumber(__S__, __self__->prependItem(text, icon, ptr));
          return 1;
        } else {
          notify = ( unsigned char )(char)lua_tonumber(__S__, 5);
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_pushnumber(__S__, __self__->prependItem(text, icon, ptr, notify));
          return 1;
        }
      }
    }
  }
  
error:
  return lua_call1_FXList__prependItem(__S__);
}
/* void FXComboBox::setNumColumns(FXint cols) */
int lua_call1_FXComboBox__setNumColumns(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXComboBox * __self__;
     int cols;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    cols = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setNumColumns(cols);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXApp::create() */
int lua_call1_FXApp__create(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->create();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXApp::getBackColor()const  */
int lua_call1_FXApp__getBackColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBackColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXFileDialog::getSelectMode()const  */
int lua_call1_FXFileDialog__getSelectMode(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileDialog * __self__;
    
    __self__ = ( class FXFileDialog * )lua_to_FXFileDialog(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getSelectMode());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTreeItem::getHeight(const class FXTreeList * list)const  */
int lua_call1_FXTreeItem__getHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeItem * __self__;
     class FXTreeList * list;
    
    __self__ = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 1, &__ERROR__);
    list = ( class FXTreeList * )lua_to_FXTreeList(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getHeight(list));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTreeList::setIndent(FXint in) */
int lua_call1_FXTreeList__setIndent(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeList * __self__;
     int in;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    in = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setIndent(in);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXToggleButton::getToggleStyle()const  */
int lua_call1_FXToggleButton__getToggleStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToggleButton * __self__;
    
    __self__ = ( class FXToggleButton * )lua_to_FXToggleButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getToggleStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXArrowButton::setArrowStyle(FXuint style) */
int lua_call1_FXArrowButton__setArrowStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXArrowButton * __self__;
     unsigned int style;
    
    __self__ = ( class FXArrowButton * )lua_to_FXArrowButton(__S__, 1, &__ERROR__);
    style = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setArrowStyle(style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXTable::isHorzGridShown()const  */
int lua_call1_FXTable__isHorzGridShown(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isHorzGridShown());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXAccelTable * FXWindow::getAccelTable()const  */
int lua_call1_FXWindow__getAccelTable(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXAccelTable(__S__, __self__->getAccelTable());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTopWindow::getDefaultWidth() */
int lua_call1_FXTopWindow__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTopWindow * __self__;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXPacker::getDefaultHeight() */
int lua_call1_FXPacker__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXPacker * __self__;
    
    __self__ = ( class FXPacker * )lua_to_FXPacker(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXColorWheel::getMetaClass()const  */
int lua_call1_FXColorWheel__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorWheel * __self__;
    
    __self__ = ( class FXColorWheel * )lua_to_FXColorWheel(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onCmdCutSel(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXApp::setTooltipPause(FXuint pause) */
int lua_call1_FXApp__setTooltipPause(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXApp * __self__;
     unsigned int pause;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    pause = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTooltipPause(pause);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMenubar::onMotion(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXCheckButton::setCheck(FXbool state=1) */
int lua_call1_FXCheckButton__setCheck(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXCheckButton * __self__;
     unsigned char state;
    
    __self__ = ( class FXCheckButton * )lua_to_FXCheckButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->setCheck();
    } else {
      state = ( unsigned char )(char)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->setCheck(state);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXToggleButton::detach() */
int lua_call1_FXToggleButton__detach(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToggleButton * __self__;
    
    __self__ = ( class FXToggleButton * )lua_to_FXToggleButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->detach();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXTreeList::getListStyle()const  */
int lua_call1_FXTreeList__getListStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeList * __self__;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getListStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXListBox::onCmdSetValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXApp::manufacture() */
int lua_call1_FXApp__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXApp::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXFileSelector::onCmdWork(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTextField::onCmdCopySel(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* const struct FXMetaClass * FXRegistry::getMetaClass()const  */
int lua_call1_FXRegistry__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXRegistry * __self__;
    
    __self__ = ( class FXRegistry * )lua_to_FXRegistry(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::killFocus() */
int lua_call1_FXTable__killFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->killFocus();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPrintDialog::onCmdFirstPage(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXProgressBar::setTextAltColor(FXColor clr) */
int lua_call1_FXProgressBar__setTextAltColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXProgressBar * __self__;
     unsigned int clr;
    
    __self__ = ( class FXProgressBar * )lua_to_FXProgressBar(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTextAltColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTreeListBox::destroy() */
int lua_call1_FXTreeListBox__destroy(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeListBox * __self__;
    
    __self__ = ( class FXTreeListBox * )lua_to_FXTreeListBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->destroy();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXImage::render() */
int lua_call1_FXImage__render(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXImage * __self__;
    
    __self__ = ( class FXImage * )lua_to_FXImage(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->render();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorBar::onLeftBtnPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXList::toggleItem(FXint index, FXbool notify=0) */
int lua_call1_FXList__toggleItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXList * __self__;
     int index;
     unsigned char notify;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->toggleItem(index));
      return 1;
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->toggleItem(index, notify));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXIconList::canFocus()const  */
int lua_call1_FXIconList__canFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconList * __self__;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->canFocus());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXComposite::create() */
int lua_call1_FXComposite__create(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXComposite * __self__;
    
    __self__ = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->create();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXHeaderItem::setIcon(class FXIcon * icn) */
int lua_call1_FXHeaderItem__setIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXHeaderItem * __self__;
     class FXIcon * icn;
    
    __self__ = ( class FXHeaderItem * )lua_to_FXHeaderItem(__S__, 1, &__ERROR__);
    icn = ( class FXIcon * )lua_to_FXIcon(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setIcon(icn);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::recalc() */
int lua_call1_FXWindow__recalc(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->recalc();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMessageBox::onCmdClicked(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXPopup::popup(class FXWindow * grabto, FXint x, FXint y, FXint w=0, FXint h=0) */
int lua_call1_FXPopup__popup(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXPopup * __self__;
     class FXWindow * grabto;
     int x;
     int y;
     int w;
     int h;
    
    __self__ = ( class FXPopup * )lua_to_FXPopup(__S__, 1, &__ERROR__);
    grabto = ( class FXWindow * )lua_to_FXWindow(__S__, 2, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 3);
    y = ( int )(int)lua_tonumber(__S__, 4);
    
    /* Actual call */
    if (nparam <= 4) {
      if (__ERROR__) goto error;
      
      __self__->popup(grabto, x, y);
    } else {
      w = ( int )(int)lua_tonumber(__S__, 5);
      if (nparam <= 5) {
        if (__ERROR__) goto error;
        
        __self__->popup(grabto, x, y, w);
      } else {
        h = ( int )(int)lua_tonumber(__S__, 6);
        if (__ERROR__) goto error;
        
        __self__->popup(grabto, x, y, w, h);
      }
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXScrollbar::setBorderColor(FXColor clr) */
int lua_call1_FXScrollbar__setBorderColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXScrollbar * __self__;
     unsigned int clr;
    
    __self__ = ( class FXScrollbar * )lua_to_FXScrollbar(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBorderColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXList::onRightBtnPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDCWindow::fillRectangle(FXint x, FXint y, FXint w, FXint h) */
int lua_call1_FXDCWindow__fillRectangle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXDCWindow * __self__;
     int x;
     int y;
     int w;
     int h;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    w = ( int )(int)lua_tonumber(__S__, 4);
    h = ( int )(int)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->fillRectangle(x, y, w, h);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTextField::getDefaultHeight() */
int lua_call1_FXTextField__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTextField * __self__;
    
    __self__ = ( class FXTextField * )lua_to_FXTextField(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXSlider::setSliderStyle(FXuint style) */
int lua_call1_FXSlider__setSliderStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXSlider * __self__;
     unsigned int style;
    
    __self__ = ( class FXSlider * )lua_to_FXSlider(__S__, 1, &__ERROR__);
    style = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setSliderStyle(style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXShutterItem::getTipText()const  */
int lua_call1_FXShutterItem__getTipText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXShutterItem * __self__;
    
    __self__ = ( class FXShutterItem * )lua_to_FXShutterItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getTipText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXFontSelector::manufacture() */
int lua_call1_FXFontSelector__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXFontSelector::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDC::setBackground(FXColor clr) */
int lua_call1_FXDC__setBackground(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDC * __self__;
     unsigned int clr;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBackground(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXStatusbar::load(class FXStream & store) */
int lua_call1_FXStatusbar__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXStatusbar * __self__;
    
    __self__ = ( class FXStatusbar * )lua_to_FXStatusbar(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::setY(FXint y) */
int lua_call1_FXWindow__setY(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXWindow * __self__;
     int y;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    y = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setY(y);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTreeList::onUngrabbed(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXStream & ( FXFileStream::operator >>)(FXuchar & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXFileStream::operator >>)(FXchar & v) */
/* SKIPPED (operator) */
/* void FXListBox::setSelBackColor(FXColor clr) */
int lua_call1_FXListBox__setSelBackColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXListBox * __self__;
     unsigned int clr;
    
    __self__ = ( class FXListBox * )lua_to_FXListBox(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setSelBackColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTreeListBox::onTreeClicked(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXList::getDefaultWidth() */
int lua_call1_FXList__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXList * __self__;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXToolbarGrip::onLeftBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXFontSelector::FXFontSelector(class FXComposite * p, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=0, FXint x=0, FXint y=0, FXint w=0, FXint h=0) */
int lua_call1_FXFontSelector__FXFontSelector(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXFontSelector(__S__, new FXFontSelector(p));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 2, &__ERROR__);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXFontSelector(__S__, new FXFontSelector(p, tgt));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXFontSelector(__S__, new FXFontSelector(p, tgt, sel));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXFontSelector(__S__, new FXFontSelector(p, tgt, sel, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXFontSelector(__S__, new FXFontSelector(p, tgt, sel, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 6);
              if (nparam <= 6) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXFontSelector(__S__, new FXFontSelector(p, tgt, sel, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 7);
                if (nparam <= 7) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXFontSelector(__S__, new FXFontSelector(p, tgt, sel, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 8);
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXFontSelector(__S__, new FXFontSelector(p, tgt, sel, opts, x, y, w, h));
                  return 1;
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXIconItem::hasFocus()const  */
int lua_call1_FXIconItem__hasFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconItem * __self__;
    
    __self__ = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->hasFocus());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXComposite::getDefaultHeight() */
int lua_call1_FXComposite__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXComposite * __self__;
    
    __self__ = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXWindow::onDragged(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXHeaderItem::FXHeaderItem(const class FXString & text, class FXIcon * ic=__null, FXint s=0, void * ptr=__null) */
int lua_call1_FXHeaderItem__FXHeaderItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXIcon * ic;
     int s;
     void * ptr;
    
    int __err__47; static FXString __cstr__47; FXString * __str__47 = lua_to_FXString(__S__, 1, &__err__47);  class FXString & text = ( class FXString & ) (__str__47? *__str__47 : (__cstr__47 =(FXString) (char *)lua_tostring(__S__, 1), __cstr__47));
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXHeaderItem(__S__, new FXHeaderItem(text));
      return 1;
    } else {
      ic = ( class FXIcon * )lua_to_FXIcon(__S__, 2, &__ERROR__);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXHeaderItem(__S__, new FXHeaderItem(text, ic));
        return 1;
      } else {
        s = ( int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXHeaderItem(__S__, new FXHeaderItem(text, ic, s));
          return 1;
        } else {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXHeaderItem(__S__, new FXHeaderItem(text, ic, s, ptr));
          return 1;
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXCursor::save(class FXStream & store)const  */
int lua_call1_FXCursor__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXCursor * __self__;
    
    __self__ = ( class FXCursor * )lua_to_FXCursor(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPrintDialog::onCmdColor(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXDirItem::isFifo()const  */
int lua_call1_FXDirItem__isFifo(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDirItem * __self__;
    
    __self__ = ( class FXDirItem * )lua_to_FXDirItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isFifo());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMenubar::onFocusRight(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXDHVec::FXDHVec() */
int lua_call1_FXDHVec__FXDHVec(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXDHVec(__S__, new FXDHVec());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXDHVec::FXDHVec(FXColor color) */
int lua_call2_FXDHVec__FXDHVec(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     unsigned int color;
    
    color = ( unsigned int )(int)lua_tonumber(__S__, 1);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXDHVec(__S__, new FXDHVec(color));
    return 1;
  }
  
error:
  return lua_call1_FXDHVec__FXDHVec(__S__);
}
/*  FXDHVec::FXDHVec(const class FXDHVec & w) */
int lua_call3_FXDHVec__FXDHVec(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
    
     class FXDHVec & w = ( class FXDHVec & )(*lua_to_FXDHVec(__S__, 1, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXDHVec(__S__, new FXDHVec(w));
    return 1;
  }
  
error:
  return lua_call2_FXDHVec__FXDHVec(__S__);
}
/*  FXDHVec::FXDHVec(const class FXDVec & w) */
int lua_call4_FXDHVec__FXDHVec(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
    
     class FXDVec & w = ( class FXDVec & )(*lua_to_FXDVec(__S__, 1, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXDHVec(__S__, new FXDHVec(w));
    return 1;
  }
  
error:
  return lua_call3_FXDHVec__FXDHVec(__S__);
}
/*  FXDHVec::FXDHVec(FXdouble x, FXdouble y, FXdouble z, FXdouble w=1.0) */
int lua_call5_FXDHVec__FXDHVec(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 3) goto error;
  {
     double x;
     double y;
     double z;
     double w;
    
    x = ( double )(double)lua_tonumber(__S__, 1);
    y = ( double )(double)lua_tonumber(__S__, 2);
    z = ( double )(double)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (nparam <= 3) {
      lua_settop(__S__, 0);
      lua_push_FXDHVec(__S__, new FXDHVec(x, y, z));
      return 1;
    } else {
      w = ( double )(double)lua_tonumber(__S__, 4);
      lua_settop(__S__, 0);
      lua_push_FXDHVec(__S__, new FXDHVec(x, y, z, w));
      return 1;
    }
  }
  
error:
  return lua_call4_FXDHVec__FXDHVec(__S__);
}
/* void FXDial::setHelpText(const class FXString & text) */
int lua_call1_FXDial__setHelpText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDial * __self__;
    
    __self__ = ( class FXDial * )lua_to_FXDial(__S__, 1, &__ERROR__);
    int __err__48; static FXString __cstr__48; FXString * __str__48 = lua_to_FXString(__S__, 2, &__err__48);  class FXString & text = ( class FXString & ) (__str__48? *__str__48 : (__cstr__48 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__48));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setHelpText(text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXListItem::setIconOwned(FXuint owned=ICONOWNED) */
int lua_call1_FXListItem__setIconOwned(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXListItem * __self__;
     unsigned int owned;
    
    __self__ = ( class FXListItem * )lua_to_FXListItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->setIconOwned();
    } else {
      owned = ( unsigned int )(int)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->setIconOwned(owned);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXSlider::getHelpText()const  */
int lua_call1_FXSlider__getHelpText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSlider * __self__;
    
    __self__ = ( class FXSlider * )lua_to_FXSlider(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getHelpText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXMenuButton::FXMenuButton(class FXComposite * p, const class FXString & text, class FXIcon * ic=__null, class FXPopup * pup=__null, FXuint opts=JUSTIFY_NORMAL|ICON_BEFORE_TEXT|MENUBUTTON_DOWN, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=2, FXint pr=2, FXint pt=2, FXint pb=2) */
int lua_call1_FXMenuButton__FXMenuButton(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXComposite * p;
     class FXIcon * ic;
     class FXPopup * pup;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    int __err__49; static FXString __cstr__49; FXString * __str__49 = lua_to_FXString(__S__, 2, &__err__49);  class FXString & text = ( class FXString & ) (__str__49? *__str__49 : (__cstr__49 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__49));
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXMenuButton(__S__, new FXMenuButton(p, text));
      return 1;
    } else {
      ic = ( class FXIcon * )lua_to_FXIcon(__S__, 3, &__ERROR__);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXMenuButton(__S__, new FXMenuButton(p, text, ic));
        return 1;
      } else {
        pup = ( class FXPopup * )lua_to_FXPopup(__S__, 4, &__ERROR__);
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXMenuButton(__S__, new FXMenuButton(p, text, ic, pup));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 5);
          if (nparam <= 5) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXMenuButton(__S__, new FXMenuButton(p, text, ic, pup, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 6);
            if (nparam <= 6) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXMenuButton(__S__, new FXMenuButton(p, text, ic, pup, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 7);
              if (nparam <= 7) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXMenuButton(__S__, new FXMenuButton(p, text, ic, pup, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 8);
                if (nparam <= 8) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXMenuButton(__S__, new FXMenuButton(p, text, ic, pup, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 9);
                  if (nparam <= 9) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXMenuButton(__S__, new FXMenuButton(p, text, ic, pup, opts, x, y, w, h));
                    return 1;
                  } else {
                    pl = ( int )(int)lua_tonumber(__S__, 10);
                    if (nparam <= 10) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXMenuButton(__S__, new FXMenuButton(p, text, ic, pup, opts, x, y, w, h, pl));
                      return 1;
                    } else {
                      pr = ( int )(int)lua_tonumber(__S__, 11);
                      if (nparam <= 11) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXMenuButton(__S__, new FXMenuButton(p, text, ic, pup, opts, x, y, w, h, pl, pr));
                        return 1;
                      } else {
                        pt = ( int )(int)lua_tonumber(__S__, 12);
                        if (nparam <= 12) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXMenuButton(__S__, new FXMenuButton(p, text, ic, pup, opts, x, y, w, h, pl, pr, pt));
                          return 1;
                        } else {
                          pb = ( int )(int)lua_tonumber(__S__, 13);
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXMenuButton(__S__, new FXMenuButton(p, text, ic, pup, opts, x, y, w, h, pl, pr, pt, pb));
                          return 1;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDialogBox::onCmdAccept(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXMenubar::onFocusLeft(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXColor FXList::getSelTextColor()const  */
int lua_call1_FXList__getSelTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXList * __self__;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getSelTextColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::insertColumns(FXint col, FXint nc=1, FXbool notify=0) */
int lua_call1_FXTable__insertColumns(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTable * __self__;
     int col;
     int nc;
     unsigned char notify;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    col = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      __self__->insertColumns(col);
    } else {
      nc = ( int )(int)lua_tonumber(__S__, 3);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        __self__->insertColumns(col, nc);
      } else {
        notify = ( unsigned char )(char)lua_tonumber(__S__, 4);
        if (__ERROR__) goto error;
        
        __self__->insertColumns(col, nc, notify);
      }
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDataTarget::setTarget(class FXObject * t) */
int lua_call1_FXDataTarget__setTarget(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDataTarget * __self__;
     class FXObject * t;
    
    __self__ = ( class FXDataTarget * )lua_to_FXDataTarget(__S__, 1, &__ERROR__);
    t = ( class FXObject * )lua_to_FXObject(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTarget(t);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXRectangle & FXRectangle::shrink(FXshort margin) */
int lua_call1_FXRectangle__shrink(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXRectangle * __self__;
     short margin;
    
    __self__ = ( class FXRectangle * )lua_to_FXRectangle(__S__, 1, &__ERROR__);
    margin = ( short )(short)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXRectangle(__S__, &(__self__->shrink(margin)));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXRectangle & FXRectangle::shrink(FXshort hormargin, FXshort vermargin) */
int lua_call2_FXRectangle__shrink(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXRectangle * __self__;
     short hormargin;
     short vermargin;
    
    __self__ = ( class FXRectangle * )lua_to_FXRectangle(__S__, 1, &__ERROR__);
    hormargin = ( short )(short)lua_tonumber(__S__, 2);
    vermargin = ( short )(short)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXRectangle(__S__, &(__self__->shrink(hormargin, vermargin)));
    return 1;
  }
  
error:
  return lua_call1_FXRectangle__shrink(__S__);
}
/* class FXRectangle & FXRectangle::shrink(FXshort leftmargin, FXshort rightmargin, FXshort topmargin, FXshort bottommargin) */
int lua_call3_FXRectangle__shrink(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXRectangle * __self__;
     short leftmargin;
     short rightmargin;
     short topmargin;
     short bottommargin;
    
    __self__ = ( class FXRectangle * )lua_to_FXRectangle(__S__, 1, &__ERROR__);
    leftmargin = ( short )(short)lua_tonumber(__S__, 2);
    rightmargin = ( short )(short)lua_tonumber(__S__, 3);
    topmargin = ( short )(short)lua_tonumber(__S__, 4);
    bottommargin = ( short )(short)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXRectangle(__S__, &(__self__->shrink(leftmargin, rightmargin, topmargin, bottommargin)));
    return 1;
  }
  
error:
  return lua_call2_FXRectangle__shrink(__S__);
}
/* long FXIconList::onTipTimer(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXStatusbar::FXStatusbar(class FXComposite * p, FXuint opts=0, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=3, FXint pr=3, FXint pt=2, FXint pb=2, FXint hs=4, FXint vs=0) */
int lua_call1_FXStatusbar__FXStatusbar(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
     int hs;
     int vs;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXStatusbar(__S__, new FXStatusbar(p));
      return 1;
    } else {
      opts = ( unsigned int )(int)lua_tonumber(__S__, 2);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXStatusbar(__S__, new FXStatusbar(p, opts));
        return 1;
      } else {
        x = ( int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXStatusbar(__S__, new FXStatusbar(p, opts, x));
          return 1;
        } else {
          y = ( int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXStatusbar(__S__, new FXStatusbar(p, opts, x, y));
            return 1;
          } else {
            w = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXStatusbar(__S__, new FXStatusbar(p, opts, x, y, w));
              return 1;
            } else {
              h = ( int )(int)lua_tonumber(__S__, 6);
              if (nparam <= 6) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXStatusbar(__S__, new FXStatusbar(p, opts, x, y, w, h));
                return 1;
              } else {
                pl = ( int )(int)lua_tonumber(__S__, 7);
                if (nparam <= 7) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXStatusbar(__S__, new FXStatusbar(p, opts, x, y, w, h, pl));
                  return 1;
                } else {
                  pr = ( int )(int)lua_tonumber(__S__, 8);
                  if (nparam <= 8) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXStatusbar(__S__, new FXStatusbar(p, opts, x, y, w, h, pl, pr));
                    return 1;
                  } else {
                    pt = ( int )(int)lua_tonumber(__S__, 9);
                    if (nparam <= 9) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXStatusbar(__S__, new FXStatusbar(p, opts, x, y, w, h, pl, pr, pt));
                      return 1;
                    } else {
                      pb = ( int )(int)lua_tonumber(__S__, 10);
                      if (nparam <= 10) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXStatusbar(__S__, new FXStatusbar(p, opts, x, y, w, h, pl, pr, pt, pb));
                        return 1;
                      } else {
                        hs = ( int )(int)lua_tonumber(__S__, 11);
                        if (nparam <= 11) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXStatusbar(__S__, new FXStatusbar(p, opts, x, y, w, h, pl, pr, pt, pb, hs));
                          return 1;
                        } else {
                          vs = ( int )(int)lua_tonumber(__S__, 12);
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXStatusbar(__S__, new FXStatusbar(p, opts, x, y, w, h, pl, pr, pt, pb, hs, vs));
                          return 1;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTable::onRightBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTooltip::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXColorSelector::onChgColor(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXTopWindow::save(class FXStream & store)const  */
int lua_call1_FXTopWindow__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTopWindow * __self__;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXListBox::clearItems() */
int lua_call1_FXListBox__clearItems(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXListBox * __self__;
    
    __self__ = ( class FXListBox * )lua_to_FXListBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->clearItems();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXColorWheel::setVal(FXfloat v) */
int lua_call1_FXColorWheel__setVal(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXColorWheel * __self__;
     float v;
    
    __self__ = ( class FXColorWheel * )lua_to_FXColorWheel(__S__, 1, &__ERROR__);
    v = ( float )(float)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setVal(v);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXRadioButton::onHotKeyPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXRegion & ( FXRegion::operator =)(const class FXRegion & r) */
/* SKIPPED (operator) */
/* void FXList::create() */
int lua_call1_FXList__create(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXList * __self__;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->create();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXSlider::setRange(FXint lo, FXint hi) */
int lua_call1_FXSlider__setRange(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXSlider * __self__;
     int lo;
     int hi;
    
    __self__ = ( class FXSlider * )lua_to_FXSlider(__S__, 1, &__ERROR__);
    lo = ( int )(int)lua_tonumber(__S__, 2);
    hi = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setRange(lo, hi);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXDC::getForeground()const  */
int lua_call1_FXDC__getForeground(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDC * __self__;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getForeground());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTable::getCellBorderWidth()const  */
int lua_call1_FXTable__getCellBorderWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getCellBorderWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTreeList::setListStyle(FXuint style) */
int lua_call1_FXTreeList__setListStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeList * __self__;
     unsigned int style;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    style = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setListStyle(style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXfloat FXRange::longest()const  */
int lua_call1_FXRange__longest(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXRange * __self__;
    
    __self__ = ( class FXRange * )lua_to_FXRange(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->longest());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorSelector::onCmdList(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXText::onAutoScroll(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXToolbarShell::FXToolbarShell(class FXWindow * owner, FXuint opts=FRAME_RAISED|FRAME_THICK, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint hs=4, FXint vs=4) */
int lua_call1_FXToolbarShell__FXToolbarShell(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXWindow * owner;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int hs;
     int vs;
    
    owner = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXToolbarShell(__S__, new FXToolbarShell(owner));
      return 1;
    } else {
      opts = ( unsigned int )(int)lua_tonumber(__S__, 2);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXToolbarShell(__S__, new FXToolbarShell(owner, opts));
        return 1;
      } else {
        x = ( int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXToolbarShell(__S__, new FXToolbarShell(owner, opts, x));
          return 1;
        } else {
          y = ( int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXToolbarShell(__S__, new FXToolbarShell(owner, opts, x, y));
            return 1;
          } else {
            w = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXToolbarShell(__S__, new FXToolbarShell(owner, opts, x, y, w));
              return 1;
            } else {
              h = ( int )(int)lua_tonumber(__S__, 6);
              if (nparam <= 6) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXToolbarShell(__S__, new FXToolbarShell(owner, opts, x, y, w, h));
                return 1;
              } else {
                hs = ( int )(int)lua_tonumber(__S__, 7);
                if (nparam <= 7) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXToolbarShell(__S__, new FXToolbarShell(owner, opts, x, y, w, h, hs));
                  return 1;
                } else {
                  vs = ( int )(int)lua_tonumber(__S__, 8);
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXToolbarShell(__S__, new FXToolbarShell(owner, opts, x, y, w, h, hs, vs));
                  return 1;
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXListItem::isSelected()const  */
int lua_call1_FXListItem__isSelected(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXListItem * __self__;
    
    __self__ = ( class FXListItem * )lua_to_FXListItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isSelected());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXImage::save(class FXStream & store)const  */
int lua_call1_FXImage__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXImage * __self__;
    
    __self__ = ( class FXImage * )lua_to_FXImage(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXDVec::FXDVec() */
int lua_call1_FXDVec__FXDVec(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXDVec(__S__, new FXDVec());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXDVec::FXDVec(const class FXDVec & w) */
int lua_call2_FXDVec__FXDVec(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
    
     class FXDVec & w = ( class FXDVec & )(*lua_to_FXDVec(__S__, 1, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXDVec(__S__, new FXDVec(w));
    return 1;
  }
  
error:
  return lua_call1_FXDVec__FXDVec(__S__);
}
/*  FXDVec::FXDVec(FXColor color) */
int lua_call3_FXDVec__FXDVec(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     unsigned int color;
    
    color = ( unsigned int )(int)lua_tonumber(__S__, 1);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXDVec(__S__, new FXDVec(color));
    return 1;
  }
  
error:
  return lua_call2_FXDVec__FXDVec(__S__);
}
/*  FXDVec::FXDVec(FXdouble x, FXdouble y, FXdouble z) */
int lua_call4_FXDVec__FXDVec(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 3) goto error;
  {
     double x;
     double y;
     double z;
    
    x = ( double )(double)lua_tonumber(__S__, 1);
    y = ( double )(double)lua_tonumber(__S__, 2);
    z = ( double )(double)lua_tonumber(__S__, 3);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXDVec(__S__, new FXDVec(x, y, z));
    return 1;
  }
  
error:
  return lua_call3_FXDVec__FXDVec(__S__);
}
/* void FXTableItem::setEnabled(FXbool enabled) */
int lua_call1_FXTableItem__setEnabled(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTableItem * __self__;
     unsigned char enabled;
    
    __self__ = ( class FXTableItem * )lua_to_FXTableItem(__S__, 1, &__ERROR__);
    enabled = ( unsigned char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setEnabled(enabled);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXStatusline::getTextColor()const  */
int lua_call1_FXStatusline__getTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXStatusline * __self__;
    
    __self__ = ( class FXStatusline * )lua_to_FXStatusline(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTextColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXTabBar::manufacture() */
int lua_call1_FXTabBar__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXTabBar::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXPopup * FXMenuTitle::getMenu()const  */
int lua_call1_FXMenuTitle__getMenu(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuTitle * __self__;
    
    __self__ = ( class FXMenuTitle * )lua_to_FXMenuTitle(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXPopup(__S__, __self__->getMenu());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXDHMat & ( FXDHMat::operator -=)(const class FXDHMat & w) */
/* SKIPPED (operator) */
/* void FXMenuCommand::uncheck() */
int lua_call1_FXMenuCommand__uncheck(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuCommand * __self__;
    
    __self__ = ( class FXMenuCommand * )lua_to_FXMenuCommand(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->uncheck();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXMemoryStream::FXMemoryStream(const class FXObject * cont=__null) */
int lua_call1_FXMemoryStream__FXMemoryStream(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  {
     class FXObject * cont;
    
    
    /* Actual call */
    if (nparam <= 0) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXMemoryStream(__S__, new FXMemoryStream());
      return 1;
    } else {
      cont = ( class FXObject * )lua_to_FXObject(__S__, 1, &__ERROR__);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXMemoryStream(__S__, new FXMemoryStream(cont));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXMenuCaption::getSelBackColor()const  */
int lua_call1_FXMenuCaption__getSelBackColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuCaption * __self__;
    
    __self__ = ( class FXMenuCaption * )lua_to_FXMenuCaption(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getSelBackColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTooltip::save(class FXStream & store)const  */
int lua_call1_FXTooltip__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTooltip * __self__;
    
    __self__ = ( class FXTooltip * )lua_to_FXTooltip(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXIconList::onKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXHorizontalSeparator::manufacture() */
int lua_call1_FXHorizontalSeparator__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXHorizontalSeparator::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXTreeItem * FXTreeItem::getNext()const  */
int lua_call1_FXTreeItem__getNext(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeItem * __self__;
    
    __self__ = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXTreeItem(__S__, __self__->getNext());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXPCXImage::savePixels(class FXStream & store)const  */
int lua_call1_FXPCXImage__savePixels(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXPCXImage * __self__;
    
    __self__ = ( class FXPCXImage * )lua_to_FXPCXImage(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->savePixels(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTooltip::getDefaultWidth() */
int lua_call1_FXTooltip__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTooltip * __self__;
    
    __self__ = ( class FXTooltip * )lua_to_FXTooltip(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXButton * FXColorSelector::cancelButton()const  */
int lua_call1_FXColorSelector__cancelButton(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorSelector * __self__;
    
    __self__ = ( class FXColorSelector * )lua_to_FXColorSelector(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXButton(__S__, __self__->cancelButton());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXTable::getTableStyle()const  */
int lua_call1_FXTable__getTableStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTableStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXVisual::getColor(FXPixel pix) */
int lua_call1_FXVisual__getColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXVisual * __self__;
     unsigned long pix;
    
    __self__ = ( class FXVisual * )lua_to_FXVisual(__S__, 1, &__ERROR__);
    pix = ( unsigned long )(long)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getColor(pix));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXMatrix::getDefaultHeight() */
int lua_call1_FXMatrix__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMatrix * __self__;
    
    __self__ = ( class FXMatrix * )lua_to_FXMatrix(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::setMarginLeft(FXint pl) */
int lua_call1_FXTable__setMarginLeft(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTable * __self__;
     int pl;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    pl = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setMarginLeft(pl);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTopWindow::setIcon(class FXIcon * ic) */
int lua_call1_FXTopWindow__setIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTopWindow * __self__;
     class FXIcon * ic;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    ic = ( class FXIcon * )lua_to_FXIcon(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setIcon(ic);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void * FXTreeItem::getData()const  */
/* SKIPPED (return type) */
/* FXint FXMDIClient::getCascadeY()const  */
int lua_call1_FXMDIClient__getCascadeY(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIClient * __self__;
    
    __self__ = ( class FXMDIClient * )lua_to_FXMDIClient(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getCascadeY());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXProgressBar::setBarColor(FXColor clr) */
int lua_call1_FXProgressBar__setBarColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXProgressBar * __self__;
     unsigned int clr;
    
    __self__ = ( class FXProgressBar * )lua_to_FXProgressBar(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBarColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXIconList::onTripleClicked(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXText::save(class FXStream & store)const  */
int lua_call1_FXText__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXImage::restore() */
int lua_call1_FXImage__restore(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXImage * __self__;
    
    __self__ = ( class FXImage * )lua_to_FXImage(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->restore();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTable::getVisibleCols()const  */
int lua_call1_FXTable__getVisibleCols(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getVisibleCols());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXFileItem::isFifo()const  */
int lua_call1_FXFileItem__isFifo(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileItem * __self__;
    
    __self__ = ( class FXFileItem * )lua_to_FXFileItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isFifo());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXCharset FXText::getDelimiters()const  */
int lua_call1_FXText__getDelimiters(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXCharset(__S__, &(__self__->getDelimiters()));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTreeList::getContentHeight() */
int lua_call1_FXTreeList__getContentHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeList * __self__;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getContentHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXInputDialog::getText()const  */
int lua_call1_FXInputDialog__getText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXInputDialog * __self__;
    
    __self__ = ( class FXInputDialog * )lua_to_FXInputDialog(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXHorizontalFrame::manufacture() */
int lua_call1_FXHorizontalFrame__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXHorizontalFrame::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXPoint & ( FXPoint::operator +=)(const class FXPoint & p) */
/* SKIPPED (operator) */
/* class FXPoint & ( FXPoint::operator +=)(const class FXSize & s) */
/* SKIPPED (operator) */
/* void FXTopWindow::position(FXint x, FXint y, FXint w, FXint h) */
int lua_call1_FXTopWindow__position(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXTopWindow * __self__;
     int x;
     int y;
     int w;
     int h;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    w = ( int )(int)lua_tonumber(__S__, 4);
    h = ( int )(int)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->position(x, y, w, h);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIconDict::load(class FXStream & store) */
int lua_call1_FXIconDict__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconDict * __self__;
    
    __self__ = ( class FXIconDict * )lua_to_FXIconDict(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXSwitcher::save(class FXStream & store)const  */
int lua_call1_FXSwitcher__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXSwitcher * __self__;
    
    __self__ = ( class FXSwitcher * )lua_to_FXSwitcher(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXScrollWindow::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXStatusline::setText(const class FXString & text) */
int lua_call1_FXStatusline__setText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXStatusline * __self__;
    
    __self__ = ( class FXStatusline * )lua_to_FXStatusline(__S__, 1, &__ERROR__);
    int __err__50; static FXString __cstr__50; FXString * __str__50 = lua_to_FXString(__S__, 2, &__err__50);  class FXString & text = ( class FXString & ) (__str__50? *__str__50 : (__cstr__50 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__50));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setText(text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTopWindow::setHSpacing(FXint hs) */
int lua_call1_FXTopWindow__setHSpacing(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTopWindow * __self__;
     int hs;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    hs = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setHSpacing(hs);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXRadioButton::onFocusOut(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXTreeList::load(class FXStream & store) */
int lua_call1_FXTreeList__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeList * __self__;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIClient::onUpdTileVertical(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXPrintDialog::onUpdPrinterName(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXTreeList::toggleItem(class FXTreeItem * item, FXbool notify=0) */
int lua_call1_FXTreeList__toggleItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeList * __self__;
     class FXTreeItem * item;
     unsigned char notify;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->toggleItem(item));
      return 1;
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->toggleItem(item, notify));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXRegistry & FXApp::reg() */
int lua_call1_FXApp__reg(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXRegistry(__S__, &(__self__->reg()));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXRootWindow::create() */
int lua_call1_FXRootWindow__create(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXRootWindow * __self__;
    
    __self__ = ( class FXRootWindow * )lua_to_FXRootWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->create();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXToolbarTab::onLeftBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTable::onUpdVertGrid(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXFileSelector::shownReadOnly()const  */
int lua_call1_FXFileSelector__shownReadOnly(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileSelector * __self__;
    
    __self__ = ( class FXFileSelector * )lua_to_FXFileSelector(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->shownReadOnly());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXSwitcher::onCmdSetIntValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDCWindow::drawHashBox(FXint x, FXint y, FXint w, FXint h, FXint b=1) */
int lua_call1_FXDCWindow__drawHashBox(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXDCWindow * __self__;
     int x;
     int y;
     int w;
     int h;
     int b;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    w = ( int )(int)lua_tonumber(__S__, 4);
    h = ( int )(int)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (nparam <= 5) {
      if (__ERROR__) goto error;
      
      __self__->drawHashBox(x, y, w, h);
    } else {
      b = ( int )(int)lua_tonumber(__S__, 6);
      if (__ERROR__) goto error;
      
      __self__->drawHashBox(x, y, w, h, b);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXCharset::FXCharset() */
int lua_call1_FXCharset__FXCharset(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXCharset(__S__, new FXCharset());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXCharset::FXCharset(const class FXString & characters) */
int lua_call2_FXCharset__FXCharset(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
    
    int __err__51; static FXString __cstr__51; FXString * __str__51 = lua_to_FXString(__S__, 1, &__err__51);  class FXString & characters = ( class FXString & ) (__str__51? *__str__51 : (__cstr__51 =(FXString) (char *)lua_tostring(__S__, 1), __cstr__51));
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXCharset(__S__, new FXCharset(characters));
    return 1;
  }
  
error:
  return lua_call1_FXCharset__FXCharset(__S__);
}
/*  FXCharset::FXCharset(FXchar ch) */
int lua_call3_FXCharset__FXCharset(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     char ch;
    
    ch = ( char )(char)lua_tonumber(__S__, 1);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXCharset(__S__, new FXCharset(ch));
    return 1;
  }
  
error:
  return lua_call2_FXCharset__FXCharset(__S__);
}
/*  FXCharset::FXCharset(const class FXCharset & a) */
int lua_call4_FXCharset__FXCharset(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
    
     class FXCharset & a = ( class FXCharset & )(*lua_to_FXCharset(__S__, 1, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXCharset(__S__, new FXCharset(a));
    return 1;
  }
  
error:
  return lua_call3_FXCharset__FXCharset(__S__);
}
/* long FXText::onDNDDrop(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXUndoList::onCmdRevert(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXTopWindow::move(FXint x, FXint y) */
int lua_call1_FXTopWindow__move(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTopWindow * __self__;
     int x;
     int y;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->move(x, y);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTooltip::detach() */
int lua_call1_FXTooltip__detach(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTooltip * __self__;
    
    __self__ = ( class FXTooltip * )lua_to_FXTooltip(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->detach();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXPixel FXVisual::getPixel(FXColor clr) */
int lua_call1_FXVisual__getPixel(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXVisual * __self__;
     unsigned int clr;
    
    __self__ = ( class FXVisual * )lua_to_FXVisual(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getPixel(clr));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIWindowButton::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXComboBox::setTipText(const class FXString & txt) */
int lua_call1_FXComboBox__setTipText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXComboBox * __self__;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    int __err__52; static FXString __cstr__52; FXString * __str__52 = lua_to_FXString(__S__, 2, &__err__52);  class FXString & txt = ( class FXString & ) (__str__52? *__str__52 : (__cstr__52 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__52));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTipText(txt);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::killFocus() */
int lua_call1_FXWindow__killFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->killFocus();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXOptionMenu::create() */
int lua_call1_FXOptionMenu__create(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXOptionMenu * __self__;
    
    __self__ = ( class FXOptionMenu * )lua_to_FXOptionMenu(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->create();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPrintDialog::onCmdNumCopies(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTreeList::onAutoScroll(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXSettings::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/*  FXVisual::FXVisual(class FXApp * a, FXuint flgs, FXuint d=32) */
int lua_call1_FXVisual__FXVisual(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXApp * a;
     unsigned int flgs;
     unsigned int d;
    
    a = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    flgs = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXVisual(__S__, new FXVisual(a, flgs));
      return 1;
    } else {
      d = ( unsigned int )(int)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXVisual(__S__, new FXVisual(a, flgs, d));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXTextField::getTextColor()const  */
int lua_call1_FXTextField__getTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTextField * __self__;
    
    __self__ = ( class FXTextField * )lua_to_FXTextField(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTextColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXException::FXException() */
int lua_call1_FXException__FXException(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXException(__S__, new FXException());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXException::FXException(const FXchar * msg) */
int lua_call2_FXException__FXException(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     char * msg;
    
    msg = ( char * )(char  *)lua_tostring(__S__, 1);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXException(__S__, new FXException(msg));
    return 1;
  }
  
error:
  return lua_call1_FXException__FXException(__S__);
}
/* void FXFrame::setBaseColor(FXColor clr) */
int lua_call1_FXFrame__setBaseColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFrame * __self__;
     unsigned int clr;
    
    __self__ = ( class FXFrame * )lua_to_FXFrame(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBaseColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXGroupBox::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXWindow * FXApp::modalWindow()const  */
int lua_call1_FXApp__modalWindow(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXWindow(__S__, __self__->modalWindow());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIChild::onSelected(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXFontSelector::onUpdScalable(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXfloat FXColorBar::getVal()const  */
int lua_call1_FXColorBar__getVal(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorBar * __self__;
    
    __self__ = ( class FXColorBar * )lua_to_FXColorBar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getVal());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::setStippleColor(FXColor clr) */
int lua_call1_FXTable__setStippleColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTable * __self__;
     unsigned int clr;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setStippleColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXListItem::save(class FXStream & store)const  */
int lua_call1_FXListItem__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXListItem * __self__;
    
    __self__ = ( class FXListItem * )lua_to_FXListItem(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXScrollbar::onTimeWheel(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXFont * FXDC::getTextFont()const  */
int lua_call1_FXDC__getTextFont(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDC * __self__;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXFont(__S__, __self__->getTextFont());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXToggleButton::onHotKeyPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXApp::setDefaultCursor(FXDefaultCursor which, class FXCursor * cur) */
int lua_call1_FXApp__setDefaultCursor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXApp * __self__;
     FXDefaultCursor which;
     class FXCursor * cur;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    which = ( FXDefaultCursor )(FXDefaultCursor)(int)lua_tonumber(__S__, 2);
    cur = ( class FXCursor * )lua_to_FXCursor(__S__, 3, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setDefaultCursor(which, cur);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorWell::onDoubleClicked(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXColor FXColorWell::getRGBA()const  */
int lua_call1_FXColorWell__getRGBA(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorWell * __self__;
    
    __self__ = ( class FXColorWell * )lua_to_FXColorWell(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getRGBA());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::setMarginBottom(FXint pb) */
int lua_call1_FXTable__setMarginBottom(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTable * __self__;
     int pb;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    pb = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setMarginBottom(pb);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onSelectionLost(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXScrollbar::onTimeIncPix(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXToolbarGrip::getDefaultHeight() */
int lua_call1_FXToolbarGrip__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbarGrip * __self__;
    
    __self__ = ( class FXToolbarGrip * )lua_to_FXToolbarGrip(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorWheel::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/*  FXProgressBar::FXProgressBar(class FXComposite * p, class FXObject * target=__null, FXSelector sel=0, FXuint opts=PROGRESSBAR_NORMAL, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=2, FXint pr=2, FXint pt=2, FXint pb=2) */
int lua_call1_FXProgressBar__FXProgressBar(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     class FXObject * target;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXProgressBar(__S__, new FXProgressBar(p));
      return 1;
    } else {
      target = ( class FXObject * )lua_to_FXObject(__S__, 2, &__ERROR__);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXProgressBar(__S__, new FXProgressBar(p, target));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXProgressBar(__S__, new FXProgressBar(p, target, sel));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXProgressBar(__S__, new FXProgressBar(p, target, sel, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXProgressBar(__S__, new FXProgressBar(p, target, sel, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 6);
              if (nparam <= 6) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXProgressBar(__S__, new FXProgressBar(p, target, sel, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 7);
                if (nparam <= 7) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXProgressBar(__S__, new FXProgressBar(p, target, sel, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 8);
                  if (nparam <= 8) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXProgressBar(__S__, new FXProgressBar(p, target, sel, opts, x, y, w, h));
                    return 1;
                  } else {
                    pl = ( int )(int)lua_tonumber(__S__, 9);
                    if (nparam <= 9) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXProgressBar(__S__, new FXProgressBar(p, target, sel, opts, x, y, w, h, pl));
                      return 1;
                    } else {
                      pr = ( int )(int)lua_tonumber(__S__, 10);
                      if (nparam <= 10) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXProgressBar(__S__, new FXProgressBar(p, target, sel, opts, x, y, w, h, pl, pr));
                        return 1;
                      } else {
                        pt = ( int )(int)lua_tonumber(__S__, 11);
                        if (nparam <= 11) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXProgressBar(__S__, new FXProgressBar(p, target, sel, opts, x, y, w, h, pl, pr, pt));
                          return 1;
                        } else {
                          pb = ( int )(int)lua_tonumber(__S__, 12);
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXProgressBar(__S__, new FXProgressBar(p, target, sel, opts, x, y, w, h, pl, pr, pt, pb));
                          return 1;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXCheckButton::getBoxColor()const  */
int lua_call1_FXCheckButton__getBoxColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXCheckButton * __self__;
    
    __self__ = ( class FXCheckButton * )lua_to_FXCheckButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBoxColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXId::getMetaClass()const  */
int lua_call1_FXId__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXId * __self__;
    
    __self__ = ( class FXId * )lua_to_FXId(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXListItem::isEnabled()const  */
int lua_call1_FXListItem__isEnabled(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXListItem * __self__;
    
    __self__ = ( class FXListItem * )lua_to_FXListItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isEnabled());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXSplitter::onFocusLeft(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXDialogBox::onClose(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXText::onCmdCursorPageUp(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXFrame::getPadTop()const  */
int lua_call1_FXFrame__getPadTop(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFrame * __self__;
    
    __self__ = ( class FXFrame * )lua_to_FXFrame(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getPadTop());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXButton * FXColorSelector::acceptButton()const  */
int lua_call1_FXColorSelector__acceptButton(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorSelector * __self__;
    
    __self__ = ( class FXColorSelector * )lua_to_FXColorSelector(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXButton(__S__, __self__->acceptButton());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTreeList::onDoubleClicked(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXWindow::contains(FXint parentx, FXint parenty)const  */
int lua_call1_FXWindow__contains(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXWindow * __self__;
     int parentx;
     int parenty;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    parentx = ( int )(int)lua_tonumber(__S__, 2);
    parenty = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->contains(parentx, parenty));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDocument::setTitle(const class FXString & name) */
int lua_call1_FXDocument__setTitle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDocument * __self__;
    
    __self__ = ( class FXDocument * )lua_to_FXDocument(__S__, 1, &__ERROR__);
    int __err__53; static FXString __cstr__53; FXString * __str__53 = lua_to_FXString(__S__, 2, &__err__53);  class FXString & name = ( class FXString & ) (__str__53? *__str__53 : (__cstr__53 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__53));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTitle(name);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXMenuCommand::canFocus()const  */
int lua_call1_FXMenuCommand__canFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuCommand * __self__;
    
    __self__ = ( class FXMenuCommand * )lua_to_FXMenuCommand(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->canFocus());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIconList::clearItems(FXbool notify=0) */
int lua_call1_FXIconList__clearItems(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconList * __self__;
     unsigned char notify;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->clearItems();
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->clearItems(notify);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXText::setVisCols(FXint cols) */
int lua_call1_FXText__setVisCols(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXText * __self__;
     int cols;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    cols = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setVisCols(cols);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXMenuTitle::getDefaultHeight() */
int lua_call1_FXMenuTitle__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuTitle * __self__;
    
    __self__ = ( class FXMenuTitle * )lua_to_FXMenuTitle(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXApp::exit(FXint code=0) */
int lua_call1_FXApp__exit(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
     int code;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->exit();
    } else {
      code = ( int )(int)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->exit(code);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDragCorner::setHiliteColor(FXColor clr) */
int lua_call1_FXDragCorner__setHiliteColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDragCorner * __self__;
     unsigned int clr;
    
    __self__ = ( class FXDragCorner * )lua_to_FXDragCorner(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setHiliteColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXMenuCaption::getMetaClass()const  */
int lua_call1_FXMenuCaption__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuCaption * __self__;
    
    __self__ = ( class FXMenuCaption * )lua_to_FXMenuCaption(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXTreeItem::getText()const  */
int lua_call1_FXTreeItem__getText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeItem * __self__;
    
    __self__ = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDC::setClipRectangle(const class FXRectangle & rectangle) */
int lua_call1_FXDC__setClipRectangle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDC * __self__;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
     class FXRectangle & rectangle = ( class FXRectangle & )(*lua_to_FXRectangle(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setClipRectangle(rectangle);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDC::setClipRectangle(FXint x, FXint y, FXint w, FXint h) */
int lua_call2_FXDC__setClipRectangle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXDC * __self__;
     int x;
     int y;
     int w;
     int h;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    w = ( int )(int)lua_tonumber(__S__, 4);
    h = ( int )(int)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setClipRectangle(x, y, w, h);
    ;
    return 0;
  }
  
error:
  return lua_call1_FXDC__setClipRectangle(__S__);
}
/* FXint FXComposite::getDefaultWidth() */
int lua_call1_FXComposite__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXComposite * __self__;
    
    __self__ = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXFont::destroy() */
int lua_call1_FXFont__destroy(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFont * __self__;
    
    __self__ = ( class FXFont * )lua_to_FXFont(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->destroy();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTable::getDefColumnWidth()const  */
int lua_call1_FXTable__getDefColumnWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefColumnWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXTreeList::getHelpText()const  */
int lua_call1_FXTreeList__getHelpText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeList * __self__;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getHelpText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXPacker::manufacture() */
int lua_call1_FXPacker__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXPacker::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXInputDialog::getMetaClass()const  */
int lua_call1_FXInputDialog__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXInputDialog * __self__;
    
    __self__ = ( class FXInputDialog * )lua_to_FXInputDialog(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXSplitter::save(class FXStream & store)const  */
int lua_call1_FXSplitter__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXSplitter * __self__;
    
    __self__ = ( class FXSplitter * )lua_to_FXSplitter(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXReplaceDialog::setSearchText(const class FXString & text) */
int lua_call1_FXReplaceDialog__setSearchText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXReplaceDialog * __self__;
    
    __self__ = ( class FXReplaceDialog * )lua_to_FXReplaceDialog(__S__, 1, &__ERROR__);
    int __err__54; static FXString __cstr__54; FXString * __str__54 = lua_to_FXString(__S__, 2, &__err__54);  class FXString & text = ( class FXString & ) (__str__54? *__str__54 : (__cstr__54 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__54));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setSearchText(text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXFileDialog::getFileBoxStyle()const  */
int lua_call1_FXFileDialog__getFileBoxStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileDialog * __self__;
    
    __self__ = ( class FXFileDialog * )lua_to_FXFileDialog(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getFileBoxStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXRange::contains(FXfloat x, FXfloat y, FXfloat z)const  */
int lua_call1_FXRange__contains(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXRange * __self__;
     float x;
     float y;
     float z;
    
    __self__ = ( class FXRange * )lua_to_FXRange(__S__, 1, &__ERROR__);
    x = ( float )(float)lua_tonumber(__S__, 2);
    y = ( float )(float)lua_tonumber(__S__, 3);
    z = ( float )(float)lua_tonumber(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->contains(x, y, z));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXLabel::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDial::setNotchOffset(FXint offset) */
int lua_call1_FXDial__setNotchOffset(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDial * __self__;
     int offset;
    
    __self__ = ( class FXDial * )lua_to_FXDial(__S__, 1, &__ERROR__);
    offset = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setNotchOffset(offset);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIChild::onRestore(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXuint FXApp::getBlinkSpeed()const  */
int lua_call1_FXApp__getBlinkSpeed(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBlinkSpeed());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXSwitcher::onCmdOpen(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXFileDialog::setDirectory(const class FXString & path) */
int lua_call1_FXFileDialog__setDirectory(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileDialog * __self__;
    
    __self__ = ( class FXFileDialog * )lua_to_FXFileDialog(__S__, 1, &__ERROR__);
    int __err__55; static FXString __cstr__55; FXString * __str__55 = lua_to_FXString(__S__, 2, &__err__55);  class FXString & path = ( class FXString & ) (__str__55? *__str__55 : (__cstr__55 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__55));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setDirectory(path);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXReplaceDialog::getMetaClass()const  */
int lua_call1_FXReplaceDialog__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXReplaceDialog * __self__;
    
    __self__ = ( class FXReplaceDialog * )lua_to_FXReplaceDialog(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXGroupBox::getDefaultHeight() */
int lua_call1_FXGroupBox__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXGroupBox * __self__;
    
    __self__ = ( class FXGroupBox * )lua_to_FXGroupBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXText::setCursorColor(FXColor clr) */
int lua_call1_FXText__setCursorColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXText * __self__;
     unsigned int clr;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setCursorColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::setDragRectangle(FXint x, FXint y, FXint w, FXint h, FXbool wantupdates=1) */
int lua_call1_FXWindow__setDragRectangle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXWindow * __self__;
     int x;
     int y;
     int w;
     int h;
     unsigned char wantupdates;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    w = ( int )(int)lua_tonumber(__S__, 4);
    h = ( int )(int)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (nparam <= 5) {
      if (__ERROR__) goto error;
      
      __self__->setDragRectangle(x, y, w, h);
    } else {
      wantupdates = ( unsigned char )(char)lua_tonumber(__S__, 6);
      if (__ERROR__) goto error;
      
      __self__->setDragRectangle(x, y, w, h, wantupdates);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXDC::getClipWidth()const  */
int lua_call1_FXDC__getClipWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDC * __self__;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getClipWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXDragCorner::getShadowColor()const  */
int lua_call1_FXDragCorner__getShadowColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDragCorner * __self__;
    
    __self__ = ( class FXDragCorner * )lua_to_FXDragCorner(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getShadowColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMenuCascade::onKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXList::clearItems(FXbool notify=0) */
int lua_call1_FXList__clearItems(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXList * __self__;
     unsigned char notify;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->clearItems();
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->clearItems(notify);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXVisual::destroy() */
int lua_call1_FXVisual__destroy(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXVisual * __self__;
    
    __self__ = ( class FXVisual * )lua_to_FXVisual(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->destroy();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXOptionMenu::onCmdGetIntValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXPoint::FXPoint() */
int lua_call1_FXPoint__FXPoint(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXPoint(__S__, new FXPoint());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXPoint::FXPoint(const class FXSize & s) */
int lua_call2_FXPoint__FXPoint(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
    
     class FXSize & s = ( class FXSize & )(*lua_to_FXSize(__S__, 1, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXPoint(__S__, new FXPoint(s));
    return 1;
  }
  
error:
  return lua_call1_FXPoint__FXPoint(__S__);
}
/*  FXPoint::FXPoint(const class FXPoint & p) */
int lua_call3_FXPoint__FXPoint(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
    
     class FXPoint & p = ( class FXPoint & )(*lua_to_FXPoint(__S__, 1, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXPoint(__S__, new FXPoint(p));
    return 1;
  }
  
error:
  return lua_call2_FXPoint__FXPoint(__S__);
}
/*  FXPoint::FXPoint(FXshort xx, FXshort yy) */
int lua_call4_FXPoint__FXPoint(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     short xx;
     short yy;
    
    xx = ( short )(short)lua_tonumber(__S__, 1);
    yy = ( short )(short)lua_tonumber(__S__, 2);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXPoint(__S__, new FXPoint(xx, yy));
    return 1;
  }
  
error:
  return lua_call3_FXPoint__FXPoint(__S__);
}
/* void FXDCWindow::setLineStyle(FXLineStyle linestyle=LINE_SOLID) */
int lua_call1_FXDCWindow__setLineStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDCWindow * __self__;
     FXLineStyle linestyle;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->setLineStyle();
    } else {
      linestyle = ( FXLineStyle )(FXLineStyle)(int)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->setLineStyle(linestyle);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXDirDialog::getDirBoxStyle()const  */
int lua_call1_FXDirDialog__getDirBoxStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDirDialog * __self__;
    
    __self__ = ( class FXDirDialog * )lua_to_FXDirDialog(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDirBoxStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTreeList::onCommand(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXPrintDialog::FXPrintDialog(class FXWindow * owner, const class FXString & name, FXuint opts=0, FXint x=0, FXint y=0, FXint w=0, FXint h=0) */
int lua_call1_FXPrintDialog__FXPrintDialog(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXWindow * owner;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
    
    owner = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    int __err__56; static FXString __cstr__56; FXString * __str__56 = lua_to_FXString(__S__, 2, &__err__56);  class FXString & name = ( class FXString & ) (__str__56? *__str__56 : (__cstr__56 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__56));
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXPrintDialog(__S__, new FXPrintDialog(owner, name));
      return 1;
    } else {
      opts = ( unsigned int )(int)lua_tonumber(__S__, 3);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXPrintDialog(__S__, new FXPrintDialog(owner, name, opts));
        return 1;
      } else {
        x = ( int )(int)lua_tonumber(__S__, 4);
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXPrintDialog(__S__, new FXPrintDialog(owner, name, opts, x));
          return 1;
        } else {
          y = ( int )(int)lua_tonumber(__S__, 5);
          if (nparam <= 5) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXPrintDialog(__S__, new FXPrintDialog(owner, name, opts, x, y));
            return 1;
          } else {
            w = ( int )(int)lua_tonumber(__S__, 6);
            if (nparam <= 6) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXPrintDialog(__S__, new FXPrintDialog(owner, name, opts, x, y, w));
              return 1;
            } else {
              h = ( int )(int)lua_tonumber(__S__, 7);
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXPrintDialog(__S__, new FXPrintDialog(owner, name, opts, x, y, w, h));
              return 1;
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXWindow::getTarget()const  */
int lua_call1_FXWindow__getTarget(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, __self__->getTarget());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXSpinner::getDefaultWidth() */
int lua_call1_FXSpinner__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSpinner * __self__;
    
    __self__ = ( class FXSpinner * )lua_to_FXSpinner(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXMenuButton::getDefaultHeight() */
int lua_call1_FXMenuButton__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuButton * __self__;
    
    __self__ = ( class FXMenuButton * )lua_to_FXMenuButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTabBar::setTabStyle(FXuint style) */
int lua_call1_FXTabBar__setTabStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTabBar * __self__;
     unsigned int style;
    
    __self__ = ( class FXTabBar * )lua_to_FXTabBar(__S__, 1, &__ERROR__);
    style = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTabStyle(style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXToggleButton::manufacture() */
int lua_call1_FXToggleButton__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXToggleButton::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::create() */
int lua_call1_FXTable__create(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->create();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FX4Splitter::onFocusLeft(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXRegistry::getAsciiMode()const  */
int lua_call1_FXRegistry__getAsciiMode(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXRegistry * __self__;
    
    __self__ = ( class FXRegistry * )lua_to_FXRegistry(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getAsciiMode());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const FXdouble & ( FXDVec::operator [])(FXint i)const  */
/* SKIPPED (operator) */
/* void FXTable::setVisibleCols(FXint nvcols) */
int lua_call1_FXTable__setVisibleCols(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTable * __self__;
     int nvcols;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    nvcols = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setVisibleCols(nvcols);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXArrowButton::setJustify(FXuint mode) */
int lua_call1_FXArrowButton__setJustify(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXArrowButton * __self__;
     unsigned int mode;
    
    __self__ = ( class FXArrowButton * )lua_to_FXArrowButton(__S__, 1, &__ERROR__);
    mode = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setJustify(mode);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDC::fillComplexPolygonRel(const class FXPoint * points, FXuint npoints) */
int lua_call1_FXDC__fillComplexPolygonRel(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDC * __self__;
     class FXPoint * points;
     unsigned int npoints;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    points = ( class FXPoint * )lua_to_FXPoint(__S__, 2, &__ERROR__);
    npoints = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->fillComplexPolygonRel(points, npoints);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXSelector FXWindow::getSelector()const  */
int lua_call1_FXWindow__getSelector(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getSelector());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXFont * FXTextField::getFont()const  */
int lua_call1_FXTextField__getFont(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTextField * __self__;
    
    __self__ = ( class FXTextField * )lua_to_FXTextField(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXFont(__S__, __self__->getFont());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXFileDialog::getOpenFilename(class FXWindow * owner, const class FXString & caption, const class FXString & path, const class FXString & patterns="*", FXint initial=0) */
int lua_call1_FXFileDialog__getOpenFilename(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 3) goto error;
  {
     class FXWindow * owner;
    int __err__57; static FXString __cstr__57; FXString * __str__57 = lua_to_FXString(__S__, 2, &__err__57);  class FXString & caption = ( class FXString & ) (__str__57? *__str__57 : (__cstr__57 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__57));
     int initial;
    
    owner = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    int __err__58; static FXString __cstr__58; FXString * __str__58 = lua_to_FXString(__S__, 3, &__err__58);  class FXString & path = ( class FXString & ) (__str__58? *__str__58 : (__cstr__58 =(FXString) (char *)lua_tostring(__S__, 3), __cstr__58));
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushstring(__S__, FXFileDialog::getOpenFilename(owner, caption, path).text());
      lua_pushstring(__S__, caption.text());
      return 2;
    } else {
      int __err__59; static FXString __cstr__59; FXString * __str__59 = lua_to_FXString(__S__, 4, &__err__59);  class FXString & patterns = ( class FXString & ) (__str__59? *__str__59 : (__cstr__59 =(FXString) (char *)lua_tostring(__S__, 4), __cstr__59));
      if (nparam <= 4) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_pushstring(__S__, FXFileDialog::getOpenFilename(owner, caption, path, patterns).text());
        lua_pushstring(__S__, caption.text());
        lua_pushstring(__S__, patterns.text());
        return 3;
      } else {
        initial = ( int )(int)lua_tonumber(__S__, 5);
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_pushstring(__S__, FXFileDialog::getOpenFilename(owner, caption, path, patterns, initial).text());
        lua_pushstring(__S__, caption.text());
        lua_pushstring(__S__, patterns.text());
        return 3;
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPacker::onFocusUp(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXTGAIcon::FXTGAIcon(class FXApp * a, const void * pix=__null, FXColor clr=( ( ( FXuint ) ( FXuchar ) ( 192 ) )|( ( FXuint ) ( FXuchar ) ( 192 )<<8 )|( ( FXuint ) ( FXuchar ) ( 192 )<<16 )|0xff000000 ), FXuint opts=0, FXint w=1, FXint h=1) */
int lua_call1_FXTGAIcon__FXTGAIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXApp * a;
     void * pix;
     unsigned int clr;
     unsigned int opts;
     int w;
     int h;
    
    a = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXTGAIcon(__S__, new FXTGAIcon(a));
      return 1;
    } else {
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXTGAIcon(__S__, new FXTGAIcon(a, pix));
        return 1;
      } else {
        clr = ( unsigned int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXTGAIcon(__S__, new FXTGAIcon(a, pix, clr));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXTGAIcon(__S__, new FXTGAIcon(a, pix, clr, opts));
            return 1;
          } else {
            w = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXTGAIcon(__S__, new FXTGAIcon(a, pix, clr, opts, w));
              return 1;
            } else {
              h = ( int )(int)lua_tonumber(__S__, 6);
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXTGAIcon(__S__, new FXTGAIcon(a, pix, clr, opts, w, h));
              return 1;
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXComboBox::setSelBackColor(FXColor clr) */
int lua_call1_FXComboBox__setSelBackColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXComboBox * __self__;
     unsigned int clr;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setSelBackColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXUndoList::onUpdUndo(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXMDIChild::maximize(FXbool notify=0) */
int lua_call1_FXMDIChild__maximize(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIChild * __self__;
     unsigned char notify;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->maximize();
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->maximize(notify);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXString::before(FXchar ch, FXint n=1)const  */
int lua_call1_FXString__before(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXString * __self__;
     char ch;
     int n;
    
    __self__ = ( class FXString * )lua_to_FXString(__S__, 1, &__ERROR__);
    ch = ( char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushstring(__S__, __self__->before(ch).text());
      return 1;
    } else {
      n = ( int )(int)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushstring(__S__, __self__->before(ch, n).text());
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXProgressDialog::onCmdSetValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDCPrint::drawHashBox(FXint x, FXint y, FXint w, FXint h, FXint b=1) */
int lua_call1_FXDCPrint__drawHashBox(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXDCPrint * __self__;
     int x;
     int y;
     int w;
     int h;
     int b;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    w = ( int )(int)lua_tonumber(__S__, 4);
    h = ( int )(int)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (nparam <= 5) {
      if (__ERROR__) goto error;
      
      __self__->drawHashBox(x, y, w, h);
    } else {
      b = ( int )(int)lua_tonumber(__S__, 6);
      if (__ERROR__) goto error;
      
      __self__->drawHashBox(x, y, w, h, b);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::show() */
int lua_call1_FXWindow__show(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->show();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXDict::no()const  */
int lua_call1_FXDict__no(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDict * __self__;
    
    __self__ = ( class FXDict * )lua_to_FXDict(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->no());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::setRowHeight(FXint row, FXint rheight) */
int lua_call1_FXTable__setRowHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTable * __self__;
     int row;
     int rheight;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    row = ( int )(int)lua_tonumber(__S__, 2);
    rheight = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setRowHeight(row, rheight);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMDIChild::setIconX(FXint x) */
int lua_call1_FXMDIChild__setIconX(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMDIChild * __self__;
     int x;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setIconX(x);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXFileSelector::getReadOnly()const  */
int lua_call1_FXFileSelector__getReadOnly(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileSelector * __self__;
    
    __self__ = ( class FXFileSelector * )lua_to_FXFileSelector(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getReadOnly());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXColorSelector::save(class FXStream & store)const  */
int lua_call1_FXColorSelector__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXColorSelector * __self__;
    
    __self__ = ( class FXColorSelector * )lua_to_FXColorSelector(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXGroupBox::getGroupBoxStyle()const  */
int lua_call1_FXGroupBox__getGroupBoxStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXGroupBox * __self__;
    
    __self__ = ( class FXGroupBox * )lua_to_FXGroupBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getGroupBoxStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXToggleButton::onFocusIn(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXToolbarShell::setBaseColor(FXColor clr) */
int lua_call1_FXToolbarShell__setBaseColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXToolbarShell * __self__;
     unsigned int clr;
    
    __self__ = ( class FXToolbarShell * )lua_to_FXToolbarShell(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBaseColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXFontSelector::onCmdSetWidth(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXText::getLength()const  */
int lua_call1_FXText__getLength(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getLength());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXIconList::isItemCurrent(FXint index)const  */
int lua_call1_FXIconList__isItemCurrent(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconList * __self__;
     int index;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isItemCurrent(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMDIClient::setCascadeX(FXint off) */
int lua_call1_FXMDIClient__setCascadeX(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMDIClient * __self__;
     int off;
    
    __self__ = ( class FXMDIClient * )lua_to_FXMDIClient(__S__, 1, &__ERROR__);
    off = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setCascadeX(off);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXWindow::getCursorPosition(FXint & x, FXint & y, FXuint & buttons)const  */
int lua_call1_FXWindow__getCursorPosition(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXWindow * __self__;
     int x;
     int y;
     unsigned int buttons;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    buttons = ( unsigned int )(int)lua_tonumber(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getCursorPosition(x, y, buttons));
    lua_pushnumber(__S__, x);
    lua_pushnumber(__S__, y);
    lua_pushnumber(__S__, buttons);
    return 4;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPCXIcon::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXFontSelector::onCmdStyleText(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXComboBox::getCurrentItem()const  */
int lua_call1_FXComboBox__getCurrentItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXComboBox * __self__;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getCurrentItem());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDirList::onCmdGetStringValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXString FXIconDict::getIconPath()const  */
int lua_call1_FXIconDict__getIconPath(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconDict * __self__;
    
    __self__ = ( class FXIconDict * )lua_to_FXIconDict(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getIconPath().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXVec::FXVec() */
int lua_call1_FXVec__FXVec(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXVec(__S__, new FXVec());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXVec::FXVec(FXColor color) */
int lua_call2_FXVec__FXVec(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     unsigned int color;
    
    color = ( unsigned int )(int)lua_tonumber(__S__, 1);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXVec(__S__, new FXVec(color));
    return 1;
  }
  
error:
  return lua_call1_FXVec__FXVec(__S__);
}
/*  FXVec::FXVec(const class FXVec & w) */
int lua_call3_FXVec__FXVec(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
    
     class FXVec & w = ( class FXVec & )(*lua_to_FXVec(__S__, 1, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXVec(__S__, new FXVec(w));
    return 1;
  }
  
error:
  return lua_call2_FXVec__FXVec(__S__);
}
/*  FXVec::FXVec(FXfloat x, FXfloat y, FXfloat z) */
int lua_call4_FXVec__FXVec(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 3) goto error;
  {
     float x;
     float y;
     float z;
    
    x = ( float )(float)lua_tonumber(__S__, 1);
    y = ( float )(float)lua_tonumber(__S__, 2);
    z = ( float )(float)lua_tonumber(__S__, 3);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXVec(__S__, new FXVec(x, y, z));
    return 1;
  }
  
error:
  return lua_call3_FXVec__FXVec(__S__);
}
/* FXint FXHorizontalFrame::getDefaultWidth() */
int lua_call1_FXHorizontalFrame__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXHorizontalFrame * __self__;
    
    __self__ = ( class FXHorizontalFrame * )lua_to_FXHorizontalFrame(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXHeader::getItemSize(FXint index)const  */
int lua_call1_FXHeader__getItemSize(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXHeader * __self__;
     int index;
    
    __self__ = ( class FXHeader * )lua_to_FXHeader(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getItemSize(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDirList::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXMDIClient::onUpdWindowSelect(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXIconList::appendItem(class FXIconItem * item, FXbool notify=0) */
int lua_call1_FXIconList__appendItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconList * __self__;
     class FXIconItem * item;
     unsigned char notify;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    item = ( class FXIconItem * )lua_to_FXIconItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->appendItem(item));
      return 1;
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->appendItem(item, notify));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXIconList::appendItem(const class FXString & text, class FXIcon * big=__null, class FXIcon * mini=__null, void * ptr=__null, FXbool notify=0) */
int lua_call2_FXIconList__appendItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconList * __self__;
     class FXIcon * big;
     class FXIcon * mini;
     void * ptr;
     unsigned char notify;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    int __err__60; static FXString __cstr__60; FXString * __str__60 = lua_to_FXString(__S__, 2, &__err__60);  class FXString & text = ( class FXString & ) (__str__60? *__str__60 : (__cstr__60 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__60));
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->appendItem(text));
      return 1;
    } else {
      big = ( class FXIcon * )lua_to_FXIcon(__S__, 3, &__ERROR__);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_pushnumber(__S__, __self__->appendItem(text, big));
        return 1;
      } else {
        mini = ( class FXIcon * )lua_to_FXIcon(__S__, 4, &__ERROR__);
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_pushnumber(__S__, __self__->appendItem(text, big, mini));
          return 1;
        } else {
          if (nparam <= 5) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_pushnumber(__S__, __self__->appendItem(text, big, mini, ptr));
            return 1;
          } else {
            notify = ( unsigned char )(char)lua_tonumber(__S__, 6);
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_pushnumber(__S__, __self__->appendItem(text, big, mini, ptr, notify));
            return 1;
          }
        }
      }
    }
  }
  
error:
  return lua_call1_FXIconList__appendItem(__S__);
}
/* long FXCheckButton::onKeyPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXFontDialog::manufacture() */
int lua_call1_FXFontDialog__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXFontDialog::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXText::setCursorCol(FXint col, FXbool notify=0) */
int lua_call1_FXText__setCursorCol(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXText * __self__;
     int col;
     unsigned char notify;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    col = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      __self__->setCursorCol(col);
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      __self__->setCursorCol(col, notify);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXSettings::writeColorEntry(const FXchar * section, const FXchar * key, FXColor val) */
int lua_call1_FXSettings__writeColorEntry(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXSettings * __self__;
     char * section;
     char * key;
     unsigned int val;
    
    __self__ = ( class FXSettings * )lua_to_FXSettings(__S__, 1, &__ERROR__);
    section = ( char * )(char  *)lua_tostring(__S__, 2);
    key = ( char * )(char  *)lua_tostring(__S__, 3);
    val = ( unsigned int )(int)lua_tonumber(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->writeColorEntry(section, key, val));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXCursor::getHotX()const  */
int lua_call1_FXCursor__getHotX(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXCursor * __self__;
    
    __self__ = ( class FXCursor * )lua_to_FXCursor(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getHotX());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXPacker::getPadTop()const  */
int lua_call1_FXPacker__getPadTop(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXPacker * __self__;
    
    __self__ = ( class FXPacker * )lua_to_FXPacker(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getPadTop());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXRecentFiles::getTarget()const  */
int lua_call1_FXRecentFiles__getTarget(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXRecentFiles * __self__;
    
    __self__ = ( class FXRecentFiles * )lua_to_FXRecentFiles(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, __self__->getTarget());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXTreeItem * FXTreeItem::getAbove()const  */
int lua_call1_FXTreeItem__getAbove(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeItem * __self__;
    
    __self__ = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXTreeItem(__S__, __self__->getAbove());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDriveBox::create() */
int lua_call1_FXDriveBox__create(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDriveBox * __self__;
    
    __self__ = ( class FXDriveBox * )lua_to_FXDriveBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->create();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCWindow::setTile(class FXImage * tile, FXint dx=0, FXint dy=0) */
int lua_call1_FXDCWindow__setTile(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDCWindow * __self__;
     class FXImage * tile;
     int dx;
     int dy;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    tile = ( class FXImage * )lua_to_FXImage(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      __self__->setTile(tile);
    } else {
      dx = ( int )(int)lua_tonumber(__S__, 3);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        __self__->setTile(tile, dx);
      } else {
        dy = ( int )(int)lua_tonumber(__S__, 4);
        if (__ERROR__) goto error;
        
        __self__->setTile(tile, dx, dy);
      }
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXQuat & FXQuat::adjust() */
int lua_call1_FXQuat__adjust(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXQuat * __self__;
    
    __self__ = ( class FXQuat * )lua_to_FXQuat(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXQuat(__S__, &(__self__->adjust()));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCWindow::setTextFont(class FXFont * fnt) */
int lua_call1_FXDCWindow__setTextFont(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDCWindow * __self__;
     class FXFont * fnt;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    fnt = ( class FXFont * )lua_to_FXFont(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTextFont(fnt);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXColorBar::getTipText()const  */
int lua_call1_FXColorBar__getTipText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorBar * __self__;
    
    __self__ = ( class FXColorBar * )lua_to_FXColorBar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getTipText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXVec & ( FXVec::operator /=)(FXfloat n) */
/* SKIPPED (operator) */
/* FXint FXWindow::getX()const  */
int lua_call1_FXWindow__getX(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getX());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXWindow * FXScrollWindow::contentWindow()const  */
int lua_call1_FXScrollWindow__contentWindow(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXScrollWindow * __self__;
    
    __self__ = ( class FXScrollWindow * )lua_to_FXScrollWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXWindow(__S__, __self__->contentWindow());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXWindow * FXWindow::getOwner()const  */
int lua_call1_FXWindow__getOwner(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXWindow(__S__, __self__->getOwner());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXDriveBox::getMetaClass()const  */
int lua_call1_FXDriveBox__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDriveBox * __self__;
    
    __self__ = ( class FXDriveBox * )lua_to_FXDriveBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXScrollbar::onCmdSetIntRange(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXApp::setTipforeColor(FXColor color) */
int lua_call1_FXApp__setTipforeColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXApp * __self__;
     unsigned int color;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    color = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTipforeColor(color);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXRectangle::contains(const class FXRectangle & r)const  */
int lua_call1_FXRectangle__contains(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXRectangle * __self__;
    
    __self__ = ( class FXRectangle * )lua_to_FXRectangle(__S__, 1, &__ERROR__);
     class FXRectangle & r = ( class FXRectangle & )(*lua_to_FXRectangle(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->contains(r));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXRectangle::contains(const class FXPoint & p)const  */
int lua_call2_FXRectangle__contains(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXRectangle * __self__;
    
    __self__ = ( class FXRectangle * )lua_to_FXRectangle(__S__, 1, &__ERROR__);
     class FXPoint & p = ( class FXPoint & )(*lua_to_FXPoint(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->contains(p));
    return 1;
  }
  
error:
  return lua_call1_FXRectangle__contains(__S__);
}
/* FXbool FXRectangle::contains(FXshort xx, FXshort yy)const  */
int lua_call3_FXRectangle__contains(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXRectangle * __self__;
     short xx;
     short yy;
    
    __self__ = ( class FXRectangle * )lua_to_FXRectangle(__S__, 1, &__ERROR__);
    xx = ( short )(short)lua_tonumber(__S__, 2);
    yy = ( short )(short)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->contains(xx, yy));
    return 1;
  }
  
error:
  return lua_call2_FXRectangle__contains(__S__);
}
/* FXint FXHeader::getItemOffset(FXint index)const  */
int lua_call1_FXHeader__getItemOffset(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXHeader * __self__;
     int index;
    
    __self__ = ( class FXHeader * )lua_to_FXHeader(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getItemOffset(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXIconList::getItemSpace()const  */
int lua_call1_FXIconList__getItemSpace(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconList * __self__;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getItemSpace());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIconList::resize(FXint w, FXint h) */
int lua_call1_FXIconList__resize(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXIconList * __self__;
     int w;
     int h;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    w = ( int )(int)lua_tonumber(__S__, 2);
    h = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->resize(w, h);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXFileList::isItemDirectory(FXint index)const  */
int lua_call1_FXFileList__isItemDirectory(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileList * __self__;
     int index;
    
    __self__ = ( class FXFileList * )lua_to_FXFileList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isItemDirectory(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCWindow::setFillStyle(FXFillStyle fillstyle=FILL_SOLID) */
int lua_call1_FXDCWindow__setFillStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDCWindow * __self__;
     FXFillStyle fillstyle;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->setFillStyle();
    } else {
      fillstyle = ( FXFillStyle )(FXFillStyle)(int)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->setFillStyle(fillstyle);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTextField::onCmdSetIntValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTreeListBox::onFieldButton(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXImage::savePixels(class FXStream & store)const  */
int lua_call1_FXImage__savePixels(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXImage * __self__;
    
    __self__ = ( class FXImage * )lua_to_FXImage(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->savePixels(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXIcon * FXTopWindow::getIcon()const  */
int lua_call1_FXTopWindow__getIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTopWindow * __self__;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXIcon(__S__, __self__->getIcon());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FX4Splitter::FX4Splitter(class FXComposite * p, FXuint opts=FOURSPLITTER_NORMAL, FXint x=0, FXint y=0, FXint w=0, FXint h=0) */
int lua_call1_FX4Splitter__FX4Splitter(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FX4Splitter(__S__, new FX4Splitter(p));
      return 1;
    } else {
      opts = ( unsigned int )(int)lua_tonumber(__S__, 2);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FX4Splitter(__S__, new FX4Splitter(p, opts));
        return 1;
      } else {
        x = ( int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FX4Splitter(__S__, new FX4Splitter(p, opts, x));
          return 1;
        } else {
          y = ( int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FX4Splitter(__S__, new FX4Splitter(p, opts, x, y));
            return 1;
          } else {
            w = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FX4Splitter(__S__, new FX4Splitter(p, opts, x, y, w));
              return 1;
            } else {
              h = ( int )(int)lua_tonumber(__S__, 6);
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FX4Splitter(__S__, new FX4Splitter(p, opts, x, y, w, h));
              return 1;
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FX4Splitter::FX4Splitter(class FXComposite * p, class FXObject * tgt, FXSelector sel, FXuint opts=FOURSPLITTER_NORMAL, FXint x=0, FXint y=0, FXint w=0, FXint h=0) */
int lua_call2_FX4Splitter__FX4Splitter(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 3) goto error;
  {
     class FXComposite * p;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    tgt = ( class FXObject * )lua_to_FXObject(__S__, 2, &__ERROR__);
    sel = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FX4Splitter(__S__, new FX4Splitter(p, tgt, sel));
      return 1;
    } else {
      opts = ( unsigned int )(int)lua_tonumber(__S__, 4);
      if (nparam <= 4) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FX4Splitter(__S__, new FX4Splitter(p, tgt, sel, opts));
        return 1;
      } else {
        x = ( int )(int)lua_tonumber(__S__, 5);
        if (nparam <= 5) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FX4Splitter(__S__, new FX4Splitter(p, tgt, sel, opts, x));
          return 1;
        } else {
          y = ( int )(int)lua_tonumber(__S__, 6);
          if (nparam <= 6) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FX4Splitter(__S__, new FX4Splitter(p, tgt, sel, opts, x, y));
            return 1;
          } else {
            w = ( int )(int)lua_tonumber(__S__, 7);
            if (nparam <= 7) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FX4Splitter(__S__, new FX4Splitter(p, tgt, sel, opts, x, y, w));
              return 1;
            } else {
              h = ( int )(int)lua_tonumber(__S__, 8);
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FX4Splitter(__S__, new FX4Splitter(p, tgt, sel, opts, x, y, w, h));
              return 1;
            }
          }
        }
      }
    }
  }
  
error:
  return lua_call1_FX4Splitter__FX4Splitter(__S__);
}
/* FXint FXVerticalFrame::getDefaultWidth() */
int lua_call1_FXVerticalFrame__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXVerticalFrame * __self__;
    
    __self__ = ( class FXVerticalFrame * )lua_to_FXVerticalFrame(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXList::sortItems() */
int lua_call1_FXList__sortItems(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXList * __self__;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->sortItems();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXSwitcher::FXSwitcher(class FXComposite * p, FXuint opts=0, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=4, FXint pr=4, FXint pt=4, FXint pb=4) */
int lua_call1_FXSwitcher__FXSwitcher(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXSwitcher(__S__, new FXSwitcher(p));
      return 1;
    } else {
      opts = ( unsigned int )(int)lua_tonumber(__S__, 2);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXSwitcher(__S__, new FXSwitcher(p, opts));
        return 1;
      } else {
        x = ( int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXSwitcher(__S__, new FXSwitcher(p, opts, x));
          return 1;
        } else {
          y = ( int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXSwitcher(__S__, new FXSwitcher(p, opts, x, y));
            return 1;
          } else {
            w = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXSwitcher(__S__, new FXSwitcher(p, opts, x, y, w));
              return 1;
            } else {
              h = ( int )(int)lua_tonumber(__S__, 6);
              if (nparam <= 6) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXSwitcher(__S__, new FXSwitcher(p, opts, x, y, w, h));
                return 1;
              } else {
                pl = ( int )(int)lua_tonumber(__S__, 7);
                if (nparam <= 7) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXSwitcher(__S__, new FXSwitcher(p, opts, x, y, w, h, pl));
                  return 1;
                } else {
                  pr = ( int )(int)lua_tonumber(__S__, 8);
                  if (nparam <= 8) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXSwitcher(__S__, new FXSwitcher(p, opts, x, y, w, h, pl, pr));
                    return 1;
                  } else {
                    pt = ( int )(int)lua_tonumber(__S__, 9);
                    if (nparam <= 9) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXSwitcher(__S__, new FXSwitcher(p, opts, x, y, w, h, pl, pr, pt));
                      return 1;
                    } else {
                      pb = ( int )(int)lua_tonumber(__S__, 10);
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXSwitcher(__S__, new FXSwitcher(p, opts, x, y, w, h, pl, pr, pt, pb));
                      return 1;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXDict::mark(FXuint pos)const  */
int lua_call1_FXDict__mark(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDict * __self__;
     unsigned int pos;
    
    __self__ = ( class FXDict * )lua_to_FXDict(__S__, 1, &__ERROR__);
    pos = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->mark(pos));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMenuTitle::killFocus() */
int lua_call1_FXMenuTitle__killFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuTitle * __self__;
    
    __self__ = ( class FXMenuTitle * )lua_to_FXMenuTitle(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->killFocus();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXRadioButton::getMetaClass()const  */
int lua_call1_FXRadioButton__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXRadioButton * __self__;
    
    __self__ = ( class FXRadioButton * )lua_to_FXRadioButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXRecentFiles::FXRecentFiles() */
int lua_call1_FXRecentFiles__FXRecentFiles(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXRecentFiles(__S__, new FXRecentFiles());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXRecentFiles::FXRecentFiles(const class FXString & gp, class FXObject * tgt=__null, FXSelector sel=0) */
int lua_call2_FXRecentFiles__FXRecentFiles(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXObject * tgt;
     unsigned int sel;
    
    int __err__61; static FXString __cstr__61; FXString * __str__61 = lua_to_FXString(__S__, 1, &__err__61);  class FXString & gp = ( class FXString & ) (__str__61? *__str__61 : (__cstr__61 =(FXString) (char *)lua_tostring(__S__, 1), __cstr__61));
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXRecentFiles(__S__, new FXRecentFiles(gp));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 2, &__ERROR__);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXRecentFiles(__S__, new FXRecentFiles(gp, tgt));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 3);
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXRecentFiles(__S__, new FXRecentFiles(gp, tgt, sel));
        return 1;
      }
    }
  }
  
error:
  return lua_call1_FXRecentFiles__FXRecentFiles(__S__);
}
/* void FXTableItem::setText(const class FXString & txt) */
int lua_call1_FXTableItem__setText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTableItem * __self__;
    
    __self__ = ( class FXTableItem * )lua_to_FXTableItem(__S__, 1, &__ERROR__);
    int __err__62; static FXString __cstr__62; FXString * __str__62 = lua_to_FXString(__S__, 2, &__err__62);  class FXString & txt = ( class FXString & ) (__str__62? *__str__62 : (__cstr__62 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__62));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setText(txt);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXApp::removeInput(FXInputHandle fd, FXuint mode) */
/* SKIPPED (argument #2) */
/* class FXString FXHeaderItem::getText()const  */
int lua_call1_FXHeaderItem__getText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXHeaderItem * __self__;
    
    __self__ = ( class FXHeaderItem * )lua_to_FXHeaderItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXColorDialog::setOpaqueOnly(FXbool forceopaque) */
int lua_call1_FXColorDialog__setOpaqueOnly(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXColorDialog * __self__;
     unsigned char forceopaque;
    
    __self__ = ( class FXColorDialog * )lua_to_FXColorDialog(__S__, 1, &__ERROR__);
    forceopaque = ( unsigned char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setOpaqueOnly(forceopaque);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const FXchar * FXSettings::readStringEntry(const FXchar * section, const FXchar * key, const FXchar * def=__null) */
int lua_call1_FXSettings__readStringEntry(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXSettings * __self__;
     char * section;
     char * key;
     char * def;
    
    __self__ = ( class FXSettings * )lua_to_FXSettings(__S__, 1, &__ERROR__);
    section = ( char * )(char  *)lua_tostring(__S__, 2);
    key = ( char * )(char  *)lua_tostring(__S__, 3);
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushstring(__S__, (const char * ) __self__->readStringEntry(section, key));
      return 1;
    } else {
      def = ( char * )(char  *)lua_tostring(__S__, 4);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushstring(__S__, (const char * ) __self__->readStringEntry(section, key, def));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXIcon::getMetaClass()const  */
int lua_call1_FXIcon__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIcon * __self__;
    
    __self__ = ( class FXIcon * )lua_to_FXIcon(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXPacker::load(class FXStream & store) */
int lua_call1_FXPacker__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXPacker * __self__;
    
    __self__ = ( class FXPacker * )lua_to_FXPacker(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXStatusline::getDefaultWidth() */
int lua_call1_FXStatusline__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXStatusline * __self__;
    
    __self__ = ( class FXStatusline * )lua_to_FXStatusline(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIClient::onDefault(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void * FXListBox::getItemData(FXint index)const  */
/* SKIPPED (return type) */
/* FXColor FXFrame::getHiliteColor()const  */
int lua_call1_FXFrame__getHiliteColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFrame * __self__;
    
    __self__ = ( class FXFrame * )lua_to_FXFrame(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getHiliteColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTabBar::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXRecentFiles::setSelector(FXSelector sel) */
int lua_call1_FXRecentFiles__setSelector(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXRecentFiles * __self__;
     unsigned int sel;
    
    __self__ = ( class FXRecentFiles * )lua_to_FXRecentFiles(__S__, 1, &__ERROR__);
    sel = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setSelector(sel);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXCanvas::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXMDIMenu::FXMDIMenu(class FXWindow * owner, class FXObject * tgt=__null) */
int lua_call1_FXMDIMenu__FXMDIMenu(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXWindow * owner;
     class FXObject * tgt;
    
    owner = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXMDIMenu(__S__, new FXMDIMenu(owner));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 2, &__ERROR__);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXMDIMenu(__S__, new FXMDIMenu(owner, tgt));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTabBar::onFocusPrev(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXTreeListBox::FXTreeListBox(class FXComposite * p, FXint nvis, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=FRAME_SUNKEN|FRAME_THICK|TREELISTBOX_NORMAL, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=2, FXint pr=2, FXint pt=2, FXint pb=2) */
int lua_call1_FXTreeListBox__FXTreeListBox(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXComposite * p;
     int nvis;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    nvis = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXTreeListBox(__S__, new FXTreeListBox(p, nvis));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 3, &__ERROR__);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXTreeListBox(__S__, new FXTreeListBox(p, nvis, tgt));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 4);
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXTreeListBox(__S__, new FXTreeListBox(p, nvis, tgt, sel));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 5);
          if (nparam <= 5) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXTreeListBox(__S__, new FXTreeListBox(p, nvis, tgt, sel, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 6);
            if (nparam <= 6) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXTreeListBox(__S__, new FXTreeListBox(p, nvis, tgt, sel, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 7);
              if (nparam <= 7) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXTreeListBox(__S__, new FXTreeListBox(p, nvis, tgt, sel, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 8);
                if (nparam <= 8) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXTreeListBox(__S__, new FXTreeListBox(p, nvis, tgt, sel, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 9);
                  if (nparam <= 9) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXTreeListBox(__S__, new FXTreeListBox(p, nvis, tgt, sel, opts, x, y, w, h));
                    return 1;
                  } else {
                    pl = ( int )(int)lua_tonumber(__S__, 10);
                    if (nparam <= 10) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXTreeListBox(__S__, new FXTreeListBox(p, nvis, tgt, sel, opts, x, y, w, h, pl));
                      return 1;
                    } else {
                      pr = ( int )(int)lua_tonumber(__S__, 11);
                      if (nparam <= 11) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXTreeListBox(__S__, new FXTreeListBox(p, nvis, tgt, sel, opts, x, y, w, h, pl, pr));
                        return 1;
                      } else {
                        pt = ( int )(int)lua_tonumber(__S__, 12);
                        if (nparam <= 12) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXTreeListBox(__S__, new FXTreeListBox(p, nvis, tgt, sel, opts, x, y, w, h, pl, pr, pt));
                          return 1;
                        } else {
                          pb = ( int )(int)lua_tonumber(__S__, 13);
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXTreeListBox(__S__, new FXTreeListBox(p, nvis, tgt, sel, opts, x, y, w, h, pl, pr, pt, pb));
                          return 1;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXList::setSelTextColor(FXColor clr) */
int lua_call1_FXList__setSelTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXList * __self__;
     unsigned int clr;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setSelTextColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::setTrailingRows(FXint trailrows) */
int lua_call1_FXTable__setTrailingRows(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTable * __self__;
     int trailrows;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    trailrows = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTrailingRows(trailrows);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXOptionMenu::load(class FXStream & store) */
int lua_call1_FXOptionMenu__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXOptionMenu * __self__;
    
    __self__ = ( class FXOptionMenu * )lua_to_FXOptionMenu(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXLabel::save(class FXStream & store)const  */
int lua_call1_FXLabel__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXLabel * __self__;
    
    __self__ = ( class FXLabel * )lua_to_FXLabel(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXCommand::redoName()const  */
int lua_call1_FXCommand__redoName(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXCommand * __self__;
    
    __self__ = ( class FXCommand * )lua_to_FXCommand(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->redoName().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXFileSelector::FXFileSelector(class FXComposite * p, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=0, FXint x=0, FXint y=0, FXint w=0, FXint h=0) */
int lua_call1_FXFileSelector__FXFileSelector(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXFileSelector(__S__, new FXFileSelector(p));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 2, &__ERROR__);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXFileSelector(__S__, new FXFileSelector(p, tgt));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXFileSelector(__S__, new FXFileSelector(p, tgt, sel));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXFileSelector(__S__, new FXFileSelector(p, tgt, sel, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXFileSelector(__S__, new FXFileSelector(p, tgt, sel, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 6);
              if (nparam <= 6) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXFileSelector(__S__, new FXFileSelector(p, tgt, sel, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 7);
                if (nparam <= 7) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXFileSelector(__S__, new FXFileSelector(p, tgt, sel, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 8);
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXFileSelector(__S__, new FXFileSelector(p, tgt, sel, opts, x, y, w, h));
                  return 1;
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXStatusline::FXStatusline(class FXComposite * p, class FXObject * tgt=__null, FXSelector sel=0) */
int lua_call1_FXStatusline__FXStatusline(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     class FXObject * tgt;
     unsigned int sel;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXStatusline(__S__, new FXStatusline(p));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 2, &__ERROR__);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXStatusline(__S__, new FXStatusline(p, tgt));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 3);
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXStatusline(__S__, new FXStatusline(p, tgt, sel));
        return 1;
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXFileDialog::getPatternList()const  */
int lua_call1_FXFileDialog__getPatternList(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileDialog * __self__;
    
    __self__ = ( class FXFileDialog * )lua_to_FXFileDialog(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getPatternList().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuchar * FXImage::getData()const  */
int lua_call1_FXImage__getData(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXImage * __self__;
    
    __self__ = ( class FXImage * )lua_to_FXImage(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, (const char * ) __self__->getData());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIconList::setHeaderIcon(FXint index, class FXIcon * icon) */
int lua_call1_FXIconList__setHeaderIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXIconList * __self__;
     int index;
     class FXIcon * icon;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    icon = ( class FXIcon * )lua_to_FXIcon(__S__, 3, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setHeaderIcon(index, icon);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIconItem::load(class FXStream & store) */
int lua_call1_FXIconItem__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconItem * __self__;
    
    __self__ = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIClient::onUpdMenuClose(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXFont::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXList::killFocus() */
int lua_call1_FXList__killFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXList * __self__;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->killFocus();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXRadioButton::onEnter(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXRadioButton::getDefaultHeight() */
int lua_call1_FXRadioButton__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXRadioButton * __self__;
    
    __self__ = ( class FXRadioButton * )lua_to_FXRadioButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTextField::onCmdMark(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXColorSelector::onChgCustomWell(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXListBox::disable() */
int lua_call1_FXListBox__disable(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXListBox * __self__;
    
    __self__ = ( class FXListBox * )lua_to_FXListBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->disable();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXScrollWindow::onKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXToolbarTab::onUpdCollapse(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXFontDialog::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXShutterItem::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXFileSelector::onCmdNew(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXWindow::load(class FXStream & store) */
int lua_call1_FXWindow__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXFileList::showHiddenFiles()const  */
int lua_call1_FXFileList__showHiddenFiles(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileList * __self__;
    
    __self__ = ( class FXFileList * )lua_to_FXFileList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->showHiddenFiles());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXFileList::showHiddenFiles(FXbool showing) */
int lua_call2_FXFileList__showHiddenFiles(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileList * __self__;
     unsigned char showing;
    
    __self__ = ( class FXFileList * )lua_to_FXFileList(__S__, 1, &__ERROR__);
    showing = ( unsigned char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->showHiddenFiles(showing);
    ;
    return 0;
  }
  
error:
  return lua_call1_FXFileList__showHiddenFiles(__S__);
}
/* FXbool FXTable::isItemVisible(FXint r, FXint c)const  */
int lua_call1_FXTable__isItemVisible(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTable * __self__;
     int r;
     int c;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    r = ( int )(int)lua_tonumber(__S__, 2);
    c = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isItemVisible(r, c));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXTabItem::getTabOrientation()const  */
int lua_call1_FXTabItem__getTabOrientation(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTabItem * __self__;
    
    __self__ = ( class FXTabItem * )lua_to_FXTabItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTabOrientation());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXButton * FXFileSelector::cancelButton()const  */
int lua_call1_FXFileSelector__cancelButton(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileSelector * __self__;
    
    __self__ = ( class FXFileSelector * )lua_to_FXFileSelector(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXButton(__S__, __self__->cancelButton());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIClient::forallDocWindows(class FXObject * document, class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #5) */
/* FXint FXScrollWindow::getContentHeight() */
int lua_call1_FXScrollWindow__getContentHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXScrollWindow * __self__;
    
    __self__ = ( class FXScrollWindow * )lua_to_FXScrollWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getContentHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXBMPImage::manufacture() */
int lua_call1_FXBMPImage__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXBMPImage::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXText::makePositionVisible(FXint pos) */
int lua_call1_FXText__makePositionVisible(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXText * __self__;
     int pos;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    pos = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->makePositionVisible(pos);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXOption::onHotKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXuint FXToolbarTab::getTabStyle()const  */
int lua_call1_FXToolbarTab__getTabStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbarTab * __self__;
    
    __self__ = ( class FXToolbarTab * )lua_to_FXToolbarTab(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTabStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXWindow::setDNDData(FXDNDOrigin origin, FXDragType type, FXuchar * data, FXuint size) */
int lua_call1_FXWindow__setDNDData(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 5) goto error;
  {
     class FXWindow * __self__;
     FXDNDOrigin origin;
     unsigned short type;
     unsigned char * data;
     unsigned int size;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    origin = ( FXDNDOrigin )(FXDNDOrigin)(int)lua_tonumber(__S__, 2);
    type = ( unsigned short )(short)lua_tonumber(__S__, 3);
    data = ( unsigned char * )(char  *)lua_tostring(__S__, 4);
    size = ( unsigned int )(int)lua_tonumber(__S__, 5);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->setDNDData(origin, type, data, size));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXHorizontalSeparator::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXDCWindow::drawLineSegments(const struct FXSegment * segments, FXuint nsegments) */
int lua_call1_FXDCWindow__drawLineSegments(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDCWindow * __self__;
     struct FXSegment * segments;
     unsigned int nsegments;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    segments = ( struct FXSegment * )lua_to_FXSegment(__S__, 2, &__ERROR__);
    nsegments = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawLineSegments(segments, nsegments);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXFileStream::FXFileStream(const class FXObject * cont=__null) */
int lua_call1_FXFileStream__FXFileStream(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  {
     class FXObject * cont;
    
    
    /* Actual call */
    if (nparam <= 0) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXFileStream(__S__, new FXFileStream());
      return 1;
    } else {
      cont = ( class FXObject * )lua_to_FXObject(__S__, 1, &__ERROR__);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXFileStream(__S__, new FXFileStream(cont));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXDirDialog::manufacture() */
int lua_call1_FXDirDialog__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXDirDialog::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXReplaceDialog::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXTreeList::onTripleClicked(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXString FXFileList::getItemPathname(FXint index)const  */
int lua_call1_FXFileList__getItemPathname(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileList * __self__;
     int index;
    
    __self__ = ( class FXFileList * )lua_to_FXFileList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getItemPathname(index).text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIconItem::setText(const class FXString & txt) */
int lua_call1_FXIconItem__setText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconItem * __self__;
    
    __self__ = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
    int __err__63; static FXString __cstr__63; FXString * __str__63 = lua_to_FXString(__S__, 2, &__err__63);  class FXString & txt = ( class FXString & ) (__str__63? *__str__63 : (__cstr__63 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__63));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setText(txt);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPopup::onKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXToolbarGrip::save(class FXStream & store)const  */
int lua_call1_FXToolbarGrip__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXToolbarGrip * __self__;
    
    __self__ = ( class FXToolbarGrip * )lua_to_FXToolbarGrip(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXLabel::setFont(class FXFont * fnt) */
int lua_call1_FXLabel__setFont(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXLabel * __self__;
     class FXFont * fnt;
    
    __self__ = ( class FXLabel * )lua_to_FXLabel(__S__, 1, &__ERROR__);
    fnt = ( class FXFont * )lua_to_FXFont(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setFont(fnt);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXColorDialog::isOpaqueOnly()const  */
int lua_call1_FXColorDialog__isOpaqueOnly(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorDialog * __self__;
    
    __self__ = ( class FXColorDialog * )lua_to_FXColorDialog(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isOpaqueOnly());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXList::getNumVisible()const  */
int lua_call1_FXList__getNumVisible(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXList * __self__;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getNumVisible());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTable::getVisibleRows()const  */
int lua_call1_FXTable__getVisibleRows(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getVisibleRows());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXSettings::readFormatEntry(const FXchar * section, const FXchar * key, const FXchar * fmt, ...) */
int lua_call1_FXSettings__readFormatEntry(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXSettings * __self__;
     char * section;
     char * key;
     char * fmt;
    
    __self__ = ( class FXSettings * )lua_to_FXSettings(__S__, 1, &__ERROR__);
    section = ( char * )(char  *)lua_tostring(__S__, 2);
    key = ( char * )(char  *)lua_tostring(__S__, 3);
    fmt = ( char * )(char  *)lua_tostring(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->readFormatEntry(section, key, fmt));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXOptionMenu::getCurrentNo()const  */
int lua_call1_FXOptionMenu__getCurrentNo(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXOptionMenu * __self__;
    
    __self__ = ( class FXOptionMenu * )lua_to_FXOptionMenu(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getCurrentNo());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXSettings::existingSection(const FXchar * section) */
int lua_call1_FXSettings__existingSection(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXSettings * __self__;
     char * section;
    
    __self__ = ( class FXSettings * )lua_to_FXSettings(__S__, 1, &__ERROR__);
    section = ( char * )(char  *)lua_tostring(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->existingSection(section));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTreeList::sortChildItems(class FXTreeItem * item) */
int lua_call1_FXTreeList__sortChildItems(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeList * __self__;
     class FXTreeItem * item;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->sortChildItems(item);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXFileList::onDragged(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXTreeList::getNumItems()const  */
int lua_call1_FXTreeList__getNumItems(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeList * __self__;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getNumItems());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCWindow::fillPolygonRel(const class FXPoint * points, FXuint npoints) */
int lua_call1_FXDCWindow__fillPolygonRel(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDCWindow * __self__;
     class FXPoint * points;
     unsigned int npoints;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    points = ( class FXPoint * )lua_to_FXPoint(__S__, 2, &__ERROR__);
    npoints = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->fillPolygonRel(points, npoints);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorSelector::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXMenuTitle::onKeyPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXSpinner::isTextVisible()const  */
int lua_call1_FXSpinner__isTextVisible(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSpinner * __self__;
    
    __self__ = ( class FXSpinner * )lua_to_FXSpinner(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isTextVisible());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIconList::setItemSpace(FXint s) */
int lua_call1_FXIconList__setItemSpace(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconList * __self__;
     int s;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    s = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setItemSpace(s);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXFileSelector::setItemSpace(FXint s) */
int lua_call1_FXFileSelector__setItemSpace(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileSelector * __self__;
     int s;
    
    __self__ = ( class FXFileSelector * )lua_to_FXFileSelector(__S__, 1, &__ERROR__);
    s = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setItemSpace(s);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXList::detach() */
int lua_call1_FXList__detach(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXList * __self__;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->detach();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString & FXString::trim() */
int lua_call1_FXString__trim(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXString * __self__;
    
    __self__ = ( class FXString * )lua_to_FXString(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->trim().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTextField::onMotion(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXFileList::onDNDEnter(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXFont * FXLabel::getFont()const  */
int lua_call1_FXLabel__getFont(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXLabel * __self__;
    
    __self__ = ( class FXLabel * )lua_to_FXLabel(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXFont(__S__, __self__->getFont());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXWindow::getMetaClass()const  */
int lua_call1_FXWindow__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMenuCascade::detach() */
int lua_call1_FXMenuCascade__detach(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuCascade * __self__;
    
    __self__ = ( class FXMenuCascade * )lua_to_FXMenuCascade(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->detach();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMenuCommand::onCheck(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXDialogBox::FXDialogBox(class FXWindow * owner, const class FXString & name, FXuint opts=DECOR_TITLE|DECOR_BORDER, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=10, FXint pr=10, FXint pt=10, FXint pb=10, FXint hs=4, FXint vs=4) */
int lua_call1_FXDialogBox__FXDialogBox(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXWindow * owner;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
     int hs;
     int vs;
    
    owner = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    int __err__64; static FXString __cstr__64; FXString * __str__64 = lua_to_FXString(__S__, 2, &__err__64);  class FXString & name = ( class FXString & ) (__str__64? *__str__64 : (__cstr__64 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__64));
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXDialogBox(__S__, new FXDialogBox(owner, name));
      return 1;
    } else {
      opts = ( unsigned int )(int)lua_tonumber(__S__, 3);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXDialogBox(__S__, new FXDialogBox(owner, name, opts));
        return 1;
      } else {
        x = ( int )(int)lua_tonumber(__S__, 4);
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXDialogBox(__S__, new FXDialogBox(owner, name, opts, x));
          return 1;
        } else {
          y = ( int )(int)lua_tonumber(__S__, 5);
          if (nparam <= 5) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXDialogBox(__S__, new FXDialogBox(owner, name, opts, x, y));
            return 1;
          } else {
            w = ( int )(int)lua_tonumber(__S__, 6);
            if (nparam <= 6) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXDialogBox(__S__, new FXDialogBox(owner, name, opts, x, y, w));
              return 1;
            } else {
              h = ( int )(int)lua_tonumber(__S__, 7);
              if (nparam <= 7) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXDialogBox(__S__, new FXDialogBox(owner, name, opts, x, y, w, h));
                return 1;
              } else {
                pl = ( int )(int)lua_tonumber(__S__, 8);
                if (nparam <= 8) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXDialogBox(__S__, new FXDialogBox(owner, name, opts, x, y, w, h, pl));
                  return 1;
                } else {
                  pr = ( int )(int)lua_tonumber(__S__, 9);
                  if (nparam <= 9) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXDialogBox(__S__, new FXDialogBox(owner, name, opts, x, y, w, h, pl, pr));
                    return 1;
                  } else {
                    pt = ( int )(int)lua_tonumber(__S__, 10);
                    if (nparam <= 10) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXDialogBox(__S__, new FXDialogBox(owner, name, opts, x, y, w, h, pl, pr, pt));
                      return 1;
                    } else {
                      pb = ( int )(int)lua_tonumber(__S__, 11);
                      if (nparam <= 11) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXDialogBox(__S__, new FXDialogBox(owner, name, opts, x, y, w, h, pl, pr, pt, pb));
                        return 1;
                      } else {
                        hs = ( int )(int)lua_tonumber(__S__, 12);
                        if (nparam <= 12) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXDialogBox(__S__, new FXDialogBox(owner, name, opts, x, y, w, h, pl, pr, pt, pb, hs));
                          return 1;
                        } else {
                          vs = ( int )(int)lua_tonumber(__S__, 13);
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXDialogBox(__S__, new FXDialogBox(owner, name, opts, x, y, w, h, pl, pr, pt, pb, hs, vs));
                          return 1;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXDialogBox::FXDialogBox(class FXApp * a, const class FXString & name, FXuint opts=DECOR_TITLE|DECOR_BORDER, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=10, FXint pr=10, FXint pt=10, FXint pb=10, FXint hs=4, FXint vs=4) */
int lua_call2_FXDialogBox__FXDialogBox(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXApp * a;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
     int hs;
     int vs;
    
    a = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    int __err__65; static FXString __cstr__65; FXString * __str__65 = lua_to_FXString(__S__, 2, &__err__65);  class FXString & name = ( class FXString & ) (__str__65? *__str__65 : (__cstr__65 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__65));
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXDialogBox(__S__, new FXDialogBox(a, name));
      return 1;
    } else {
      opts = ( unsigned int )(int)lua_tonumber(__S__, 3);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXDialogBox(__S__, new FXDialogBox(a, name, opts));
        return 1;
      } else {
        x = ( int )(int)lua_tonumber(__S__, 4);
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXDialogBox(__S__, new FXDialogBox(a, name, opts, x));
          return 1;
        } else {
          y = ( int )(int)lua_tonumber(__S__, 5);
          if (nparam <= 5) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXDialogBox(__S__, new FXDialogBox(a, name, opts, x, y));
            return 1;
          } else {
            w = ( int )(int)lua_tonumber(__S__, 6);
            if (nparam <= 6) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXDialogBox(__S__, new FXDialogBox(a, name, opts, x, y, w));
              return 1;
            } else {
              h = ( int )(int)lua_tonumber(__S__, 7);
              if (nparam <= 7) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXDialogBox(__S__, new FXDialogBox(a, name, opts, x, y, w, h));
                return 1;
              } else {
                pl = ( int )(int)lua_tonumber(__S__, 8);
                if (nparam <= 8) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXDialogBox(__S__, new FXDialogBox(a, name, opts, x, y, w, h, pl));
                  return 1;
                } else {
                  pr = ( int )(int)lua_tonumber(__S__, 9);
                  if (nparam <= 9) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXDialogBox(__S__, new FXDialogBox(a, name, opts, x, y, w, h, pl, pr));
                    return 1;
                  } else {
                    pt = ( int )(int)lua_tonumber(__S__, 10);
                    if (nparam <= 10) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXDialogBox(__S__, new FXDialogBox(a, name, opts, x, y, w, h, pl, pr, pt));
                      return 1;
                    } else {
                      pb = ( int )(int)lua_tonumber(__S__, 11);
                      if (nparam <= 11) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXDialogBox(__S__, new FXDialogBox(a, name, opts, x, y, w, h, pl, pr, pt, pb));
                        return 1;
                      } else {
                        hs = ( int )(int)lua_tonumber(__S__, 12);
                        if (nparam <= 12) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXDialogBox(__S__, new FXDialogBox(a, name, opts, x, y, w, h, pl, pr, pt, pb, hs));
                          return 1;
                        } else {
                          vs = ( int )(int)lua_tonumber(__S__, 13);
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXDialogBox(__S__, new FXDialogBox(a, name, opts, x, y, w, h, pl, pr, pt, pb, hs, vs));
                          return 1;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  return lua_call1_FXDialogBox__FXDialogBox(__S__);
}
/* FXint FXMatrix::getDefaultWidth() */
int lua_call1_FXMatrix__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMatrix * __self__;
    
    __self__ = ( class FXMatrix * )lua_to_FXMatrix(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXComposite::isComposite()const  */
int lua_call1_FXComposite__isComposite(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXComposite * __self__;
    
    __self__ = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isComposite());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTable::colAtX(FXint x)const  */
int lua_call1_FXTable__colAtX(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTable * __self__;
     int x;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->colAtX(x));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXTable::isItemEnabled(FXint r, FXint c)const  */
int lua_call1_FXTable__isItemEnabled(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTable * __self__;
     int r;
     int c;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    r = ( int )(int)lua_tonumber(__S__, 2);
    c = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isItemEnabled(r, c));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXToolbarGrip::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXTreeListBox::setListStyle(FXuint style) */
int lua_call1_FXTreeListBox__setListStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeListBox * __self__;
     unsigned int style;
    
    __self__ = ( class FXTreeListBox * )lua_to_FXTreeListBox(__S__, 1, &__ERROR__);
    style = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setListStyle(style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXButton::onEnter(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXColorDialog::onCmdColor(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXArrowButton::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXList::updateItem(FXint index) */
int lua_call1_FXList__updateItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXList * __self__;
     int index;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->updateItem(index);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXStream & ( FXStream::operator >>)(FXdouble & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator >>)(FXchar & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator >>)(FXuint & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator >>)(FXuchar & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator >>)(FXfloat & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator >>)(FXulong & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator >>)(FXint & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator >>)(FXlong & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator >>)(FXshort & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXStream::operator >>)(FXushort & v) */
/* SKIPPED (operator) */
/* FXColor FXMenuCaption::getShadowColor()const  */
int lua_call1_FXMenuCaption__getShadowColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuCaption * __self__;
    
    __self__ = ( class FXMenuCaption * )lua_to_FXMenuCaption(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getShadowColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMDIChild::onCloseAll(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTooltip::onCmdSetStringValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXLineStyle FXDC::getLineStyle()const  */
int lua_call1_FXDC__getLineStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDC * __self__;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getLineStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXVisual::detach() */
int lua_call1_FXVisual__detach(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXVisual * __self__;
    
    __self__ = ( class FXVisual * )lua_to_FXVisual(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->detach();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void * FXDict::remove(const FXchar * ky) */
/* SKIPPED (return type) */
/*  ( FXDHVec::operator FXdouble*)() */
/* SKIPPED (operator) */
/* void FXListItem::setEnabled(FXbool enabled) */
int lua_call1_FXListItem__setEnabled(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXListItem * __self__;
     unsigned char enabled;
    
    __self__ = ( class FXListItem * )lua_to_FXListItem(__S__, 1, &__ERROR__);
    enabled = ( unsigned char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setEnabled(enabled);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXList::setListStyle(FXuint style) */
int lua_call1_FXList__setListStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXList * __self__;
     unsigned int style;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    style = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setListStyle(style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXListItem::manufacture() */
int lua_call1_FXListItem__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXListItem::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXFileList::onCmdDirectoryUp(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXPopup::onFocusRight(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXSpinner::setHelpText(const class FXString & text) */
int lua_call1_FXSpinner__setHelpText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXSpinner * __self__;
    
    __self__ = ( class FXSpinner * )lua_to_FXSpinner(__S__, 1, &__ERROR__);
    int __err__66; static FXString __cstr__66; FXString * __str__66 = lua_to_FXString(__S__, 2, &__err__66);  class FXString & text = ( class FXString & ) (__str__66? *__str__66 : (__cstr__66 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__66));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setHelpText(text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXDHVec & ( FXDHVec::operator *=)(FXdouble n) */
/* SKIPPED (operator) */
/* long FXTable::onCmdInsertColumn(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXIconList::getItemHeight()const  */
int lua_call1_FXIconList__getItemHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconList * __self__;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getItemHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXDirList::getMetaClass()const  */
int lua_call1_FXDirList__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDirList * __self__;
    
    __self__ = ( class FXDirList * )lua_to_FXDirList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXStringDict::getMetaClass()const  */
int lua_call1_FXStringDict__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXStringDict * __self__;
    
    __self__ = ( class FXStringDict * )lua_to_FXStringDict(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXReplaceDialog::manufacture() */
int lua_call1_FXReplaceDialog__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXReplaceDialog::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXLabel::getTextColor()const  */
int lua_call1_FXLabel__getTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXLabel * __self__;
    
    __self__ = ( class FXLabel * )lua_to_FXLabel(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTextColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXMessageBox::getMetaClass()const  */
int lua_call1_FXMessageBox__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMessageBox * __self__;
    
    __self__ = ( class FXMessageBox * )lua_to_FXMessageBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTreeList::getDefaultHeight() */
int lua_call1_FXTreeList__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeList * __self__;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCWindow::fillArcs(const struct FXArc * arcs, FXuint narcs) */
int lua_call1_FXDCWindow__fillArcs(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDCWindow * __self__;
     struct FXArc * arcs;
     unsigned int narcs;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    arcs = ( struct FXArc * )lua_to_FXArc(__S__, 2, &__ERROR__);
    narcs = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->fillArcs(arcs, narcs);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXArrowButton::onKeyPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXPacker::setFrameStyle(FXuint style) */
int lua_call1_FXPacker__setFrameStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXPacker * __self__;
     unsigned int style;
    
    __self__ = ( class FXPacker * )lua_to_FXPacker(__S__, 1, &__ERROR__);
    style = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setFrameStyle(style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void * FXDataTarget::getData()const  */
/* SKIPPED (return type) */
/* FXbool FXMenuTitle::canFocus()const  */
int lua_call1_FXMenuTitle__canFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuTitle * __self__;
    
    __self__ = ( class FXMenuTitle * )lua_to_FXMenuTitle(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->canFocus());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXHeader::getTextColor()const  */
int lua_call1_FXHeader__getTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXHeader * __self__;
    
    __self__ = ( class FXHeader * )lua_to_FXHeader(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTextColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXTreeItem * FXTreeList::getFirstItem()const  */
int lua_call1_FXTreeList__getFirstItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeList * __self__;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXTreeItem(__S__, __self__->getFirstItem());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXObjectList::prepend(class FXObject * p) */
int lua_call1_FXObjectList__prepend(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXObjectList * __self__;
     class FXObject * p;
    
    __self__ = ( class FXObjectList * )lua_to_FXObjectList(__S__, 1, &__ERROR__);
    p = ( class FXObject * )lua_to_FXObject(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->prepend(p);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXFileList::getPattern()const  */
int lua_call1_FXFileList__getPattern(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileList * __self__;
    
    __self__ = ( class FXFileList * )lua_to_FXFileList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getPattern().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXRadioButton::canFocus()const  */
int lua_call1_FXRadioButton__canFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXRadioButton * __self__;
    
    __self__ = ( class FXRadioButton * )lua_to_FXRadioButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->canFocus());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const class FXString & FXApp::getVendorName()const  */
int lua_call1_FXApp__getVendorName(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getVendorName().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXToolbar::onBeginDragGrip(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXDQuat & FXDQuat::adjust() */
int lua_call1_FXDQuat__adjust(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDQuat * __self__;
    
    __self__ = ( class FXDQuat * )lua_to_FXDQuat(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXDQuat(__S__, &(__self__->adjust()));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXSlider::onCmdGetRealValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXTooltip::doesSaveUnder()const  */
int lua_call1_FXTooltip__doesSaveUnder(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTooltip * __self__;
    
    __self__ = ( class FXTooltip * )lua_to_FXTooltip(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->doesSaveUnder());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXProgressDialog::getTotal()const  */
int lua_call1_FXProgressDialog__getTotal(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXProgressDialog * __self__;
    
    __self__ = ( class FXProgressDialog * )lua_to_FXProgressDialog(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getTotal());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXPopup::doesSaveUnder()const  */
int lua_call1_FXPopup__doesSaveUnder(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXPopup * __self__;
    
    __self__ = ( class FXPopup * )lua_to_FXPopup(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->doesSaveUnder());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXStream::isLittleEndian() */
int lua_call1_FXStream__isLittleEndian(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, FXStream::isLittleEndian());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPacker::onFocusRight(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  ( FXVec::operator constFXfloat*)()const  */
/* SKIPPED (operator) */
/* long FXMenuCommand::onKeyPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXToolbar::isDocked()const  */
int lua_call1_FXToolbar__isDocked(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbar * __self__;
    
    __self__ = ( class FXToolbar * )lua_to_FXToolbar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isDocked());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXStatusline::setNormalText(const class FXString & text) */
int lua_call1_FXStatusline__setNormalText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXStatusline * __self__;
    
    __self__ = ( class FXStatusline * )lua_to_FXStatusline(__S__, 1, &__ERROR__);
    int __err__67; static FXString __cstr__67; FXString * __str__67 = lua_to_FXString(__S__, 2, &__err__67);  class FXString & text = ( class FXString & ) (__str__67? *__str__67 : (__cstr__67 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__67));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setNormalText(text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXToggleButton::onUngrabbed(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXMenuCommand::save(class FXStream & store)const  */
int lua_call1_FXMenuCommand__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMenuCommand * __self__;
    
    __self__ = ( class FXMenuCommand * )lua_to_FXMenuCommand(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXCheckButton::onCmdSetValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDCWindow::drawArc(FXint x, FXint y, FXint w, FXint h, FXint ang1, FXint ang2) */
int lua_call1_FXDCWindow__drawArc(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 7) goto error;
  {
     class FXDCWindow * __self__;
     int x;
     int y;
     int w;
     int h;
     int ang1;
     int ang2;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    w = ( int )(int)lua_tonumber(__S__, 4);
    h = ( int )(int)lua_tonumber(__S__, 5);
    ang1 = ( int )(int)lua_tonumber(__S__, 6);
    ang2 = ( int )(int)lua_tonumber(__S__, 7);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawArc(x, y, w, h, ang1, ang2);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXString::after(FXchar ch, FXint n=1)const  */
int lua_call1_FXString__after(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXString * __self__;
     char ch;
     int n;
    
    __self__ = ( class FXString * )lua_to_FXString(__S__, 1, &__ERROR__);
    ch = ( char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushstring(__S__, __self__->after(ch).text());
      return 1;
    } else {
      n = ( int )(int)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushstring(__S__, __self__->after(ch, n).text());
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTreeListBox::setItemOpenIcon(class FXTreeItem * item, class FXIcon * icon) */
int lua_call1_FXTreeListBox__setItemOpenIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTreeListBox * __self__;
     class FXTreeItem * item;
     class FXIcon * icon;
    
    __self__ = ( class FXTreeListBox * )lua_to_FXTreeListBox(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    icon = ( class FXIcon * )lua_to_FXIcon(__S__, 3, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setItemOpenIcon(item, icon);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTabBar::getCurrent()const  */
int lua_call1_FXTabBar__getCurrent(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTabBar * __self__;
    
    __self__ = ( class FXTabBar * )lua_to_FXTabBar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getCurrent());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXToggleButton::getAltHelpText()const  */
int lua_call1_FXToggleButton__getAltHelpText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToggleButton * __self__;
    
    __self__ = ( class FXToggleButton * )lua_to_FXToggleButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getAltHelpText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXButton::canFocus()const  */
int lua_call1_FXButton__canFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXButton * __self__;
    
    __self__ = ( class FXButton * )lua_to_FXButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->canFocus());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXSize & ( FXSize::operator *=)(FXshort c) */
/* SKIPPED (operator) */
/* long FXTable::onCmdMark(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXStream & FXStream::save(const FXchar * p, FXuint n) */
int lua_call1_FXStream__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXStream * __self__;
     char * p;
     unsigned int n;
    
    __self__ = ( class FXStream * )lua_to_FXStream(__S__, 1, &__ERROR__);
    p = ( char * )(char  *)lua_tostring(__S__, 2);
    n = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXStream(__S__, &(__self__->save(p, n)));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXStream & FXStream::save(const FXuint * p, FXuint n) */
/* SKIPPED (argument #2) */
/* class FXStream & FXStream::save(const FXushort * p, FXuint n) */
/* SKIPPED (argument #2) */
/* class FXStream & FXStream::save(const FXshort * p, FXuint n) */
/* SKIPPED (argument #2) */
/* class FXStream & FXStream::save(const FXuchar * p, FXuint n) */
int lua_call5_FXStream__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXStream * __self__;
     unsigned char * p;
     unsigned int n;
    
    __self__ = ( class FXStream * )lua_to_FXStream(__S__, 1, &__ERROR__);
    p = ( unsigned char * )(char  *)lua_tostring(__S__, 2);
    n = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXStream(__S__, &(__self__->save(p, n)));
    return 1;
  }
  
error:
  return lua_call1_FXStream__save(__S__);
}
/* class FXStream & FXStream::save(const FXfloat * p, FXuint n) */
/* SKIPPED (argument #2) */
/* class FXStream & FXStream::save(const FXulong * p, FXuint n) */
/* SKIPPED (argument #2) */
/* class FXStream & FXStream::save(const FXdouble * p, FXuint n) */
/* SKIPPED (argument #2) */
/* class FXStream & FXStream::save(const FXlong * p, FXuint n) */
/* SKIPPED (argument #2) */
/* class FXStream & FXStream::save(const FXint * p, FXuint n) */
/* SKIPPED (argument #2) */
/* long FXMenubar::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXWindow::onUpdate(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTextField::onFocusIn(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXList::enableItem(FXint index) */
int lua_call1_FXList__enableItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXList * __self__;
     int index;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->enableItem(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXWindow::isEnabled()const  */
int lua_call1_FXWindow__isEnabled(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isEnabled());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXIconList::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXTableItem::load(class FXStream & store) */
int lua_call1_FXTableItem__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTableItem * __self__;
    
    __self__ = ( class FXTableItem * )lua_to_FXTableItem(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXApp::setBackColor(FXColor color) */
int lua_call1_FXApp__setBackColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXApp * __self__;
     unsigned int color;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    color = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBackColor(color);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXImage::setPixel(FXint x, FXint y, FXColor color) */
int lua_call1_FXImage__setPixel(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXImage * __self__;
     int x;
     int y;
     unsigned int color;
    
    __self__ = ( class FXImage * )lua_to_FXImage(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    color = ( unsigned int )(int)lua_tonumber(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setPixel(x, y, color);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXTreeList::FXTreeList(class FXComposite * p, FXint nvis, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=TREELIST_NORMAL, FXint x=0, FXint y=0, FXint w=0, FXint h=0) */
int lua_call1_FXTreeList__FXTreeList(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXComposite * p;
     int nvis;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    nvis = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXTreeList(__S__, new FXTreeList(p, nvis));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 3, &__ERROR__);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXTreeList(__S__, new FXTreeList(p, nvis, tgt));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 4);
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXTreeList(__S__, new FXTreeList(p, nvis, tgt, sel));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 5);
          if (nparam <= 5) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXTreeList(__S__, new FXTreeList(p, nvis, tgt, sel, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 6);
            if (nparam <= 6) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXTreeList(__S__, new FXTreeList(p, nvis, tgt, sel, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 7);
              if (nparam <= 7) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXTreeList(__S__, new FXTreeList(p, nvis, tgt, sel, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 8);
                if (nparam <= 8) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXTreeList(__S__, new FXTreeList(p, nvis, tgt, sel, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 9);
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXTreeList(__S__, new FXTreeList(p, nvis, tgt, sel, opts, x, y, w, h));
                  return 1;
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXFileList::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXTextField::enable() */
int lua_call1_FXTextField__enable(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTextField * __self__;
    
    __self__ = ( class FXTextField * )lua_to_FXTextField(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->enable();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXDragAction FXWindow::didAccept()const  */
int lua_call1_FXWindow__didAccept(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->didAccept());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPrintDialog::onUpdProps(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXFileDict::save(class FXStream & store)const  */
int lua_call1_FXFileDict__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileDict * __self__;
    
    __self__ = ( class FXFileDict * )lua_to_FXFileDict(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCPrint::setLineStyle(FXLineStyle linestyle=LINE_SOLID) */
int lua_call1_FXDCPrint__setLineStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDCPrint * __self__;
     FXLineStyle linestyle;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->setLineStyle();
    } else {
      linestyle = ( FXLineStyle )(FXLineStyle)(int)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->setLineStyle(linestyle);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXFontSelector::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* FXbool FXMenuButton::contains(FXint parentx, FXint parenty)const  */
int lua_call1_FXMenuButton__contains(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXMenuButton * __self__;
     int parentx;
     int parenty;
    
    __self__ = ( class FXMenuButton * )lua_to_FXMenuButton(__S__, 1, &__ERROR__);
    parentx = ( int )(int)lua_tonumber(__S__, 2);
    parenty = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->contains(parentx, parenty));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXImage::setOptions(FXuint opts) */
int lua_call1_FXImage__setOptions(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXImage * __self__;
     unsigned int opts;
    
    __self__ = ( class FXImage * )lua_to_FXImage(__S__, 1, &__ERROR__);
    opts = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setOptions(opts);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPopup::onLeave(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXScrollbar::setRange(FXint r) */
int lua_call1_FXScrollbar__setRange(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXScrollbar * __self__;
     int r;
    
    __self__ = ( class FXScrollbar * )lua_to_FXScrollbar(__S__, 1, &__ERROR__);
    r = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setRange(r);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorBar::onQueryTip(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXObject::isMemberOf(const struct FXMetaClass * metaclass)const  */
int lua_call1_FXObject__isMemberOf(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXObject * __self__;
     struct FXMetaClass * metaclass;
    
    __self__ = ( class FXObject * )lua_to_FXObject(__S__, 1, &__ERROR__);
    metaclass = ( struct FXMetaClass * )lua_to_FXMetaClass(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isMemberOf(metaclass));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXMDIWindowButton::getDefaultHeight() */
int lua_call1_FXMDIWindowButton__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIWindowButton * __self__;
    
    __self__ = ( class FXMDIWindowButton * )lua_to_FXMDIWindowButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXLfloat::set(float v) */
int lua_call1_FXLfloat__set(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXLfloat * __self__;
     float v;
    
    __self__ = ( class FXLfloat * )lua_to_FXLfloat(__S__, 1, &__ERROR__);
    v = ( float )(float)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->set(v);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorSelector::onCmdSetValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXShutterItem::onCmdButton(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXTreeList::setCurrentItem(class FXTreeItem * item, FXbool notify=0) */
int lua_call1_FXTreeList__setCurrentItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeList * __self__;
     class FXTreeItem * item;
     unsigned char notify;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      __self__->setCurrentItem(item);
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 3);
      if (__ERROR__) goto error;
      
      __self__->setCurrentItem(item, notify);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXUndoList::FXUndoList() */
int lua_call1_FXUndoList__FXUndoList(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXUndoList(__S__, new FXUndoList());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorWell::onQueryTip(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXuint FXPopup::getFrameStyle()const  */
int lua_call1_FXPopup__getFrameStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXPopup * __self__;
    
    __self__ = ( class FXPopup * )lua_to_FXPopup(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getFrameStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDC::drawRectangles(const class FXRectangle * rectangles, FXuint nrectangles) */
int lua_call1_FXDC__drawRectangles(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDC * __self__;
     class FXRectangle * rectangles;
     unsigned int nrectangles;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    rectangles = ( class FXRectangle * )lua_to_FXRectangle(__S__, 2, &__ERROR__);
    nrectangles = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawRectangles(rectangles, nrectangles);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCWindow::fillComplexPolygonRel(const class FXPoint * points, FXuint npoints) */
int lua_call1_FXDCWindow__fillComplexPolygonRel(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDCWindow * __self__;
     class FXPoint * points;
     unsigned int npoints;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    points = ( class FXPoint * )lua_to_FXPoint(__S__, 2, &__ERROR__);
    npoints = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->fillComplexPolygonRel(points, npoints);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXLabel::onCmdSetStringValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXImageView::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXSwitcher::onCmdSetValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDCPrint::clearClipRectangle() */
int lua_call1_FXDCPrint__clearClipRectangle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDCPrint * __self__;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->clearClipRectangle();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXVisual::manufacture() */
int lua_call1_FXVisual__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXVisual::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXFileList::onUpdSortByGroup(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* const struct FXMetaClass * FXGIFImage::getMetaClass()const  */
int lua_call1_FXGIFImage__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXGIFImage * __self__;
    
    __self__ = ( class FXGIFImage * )lua_to_FXGIFImage(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXComboBox::load(class FXStream & store) */
int lua_call1_FXComboBox__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXComboBox * __self__;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXCheckButton::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXHeaderItem::save(class FXStream & store)const  */
int lua_call1_FXHeaderItem__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXHeaderItem * __self__;
    
    __self__ = ( class FXHeaderItem * )lua_to_FXHeaderItem(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXShutterItem::getHelpText()const  */
int lua_call1_FXShutterItem__getHelpText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXShutterItem * __self__;
    
    __self__ = ( class FXShutterItem * )lua_to_FXShutterItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getHelpText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXFont * FXTable::getFont()const  */
int lua_call1_FXTable__getFont(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXFont(__S__, __self__->getFont());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXTreeList::isItemVisible(const class FXTreeItem * item)const  */
int lua_call1_FXTreeList__isItemVisible(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeList * __self__;
     class FXTreeItem * item;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isItemVisible(item));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTopWindow::setPadTop(FXint pt) */
int lua_call1_FXTopWindow__setPadTop(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTopWindow * __self__;
     int pt;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    pt = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setPadTop(pt);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorWell::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* FXint FXObjectList::size()const  */
int lua_call1_FXObjectList__size(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXObjectList * __self__;
    
    __self__ = ( class FXObjectList * )lua_to_FXObjectList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->size());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXObjectList::size(FXint m) */
int lua_call2_FXObjectList__size(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXObjectList * __self__;
     int m;
    
    __self__ = ( class FXObjectList * )lua_to_FXObjectList(__S__, 1, &__ERROR__);
    m = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->size(m);
    ;
    return 0;
  }
  
error:
  return lua_call1_FXObjectList__size(__S__);
}
/* void FXTreeItem::setSelected(FXbool selected) */
int lua_call1_FXTreeItem__setSelected(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeItem * __self__;
     unsigned char selected;
    
    __self__ = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 1, &__ERROR__);
    selected = ( unsigned char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setSelected(selected);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXSlider::onCmdSetIntRange(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXModality FXApp::modalModality()const  */
int lua_call1_FXApp__modalModality(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->modalModality());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXText::setSelection(FXint pos, FXint len, FXbool notify=0) */
int lua_call1_FXText__setSelection(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXText * __self__;
     int pos;
     int len;
     unsigned char notify;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    pos = ( int )(int)lua_tonumber(__S__, 2);
    len = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->setSelection(pos, len));
      return 1;
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 4);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->setSelection(pos, len, notify));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXSpinner::getDefaultHeight() */
int lua_call1_FXSpinner__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSpinner * __self__;
    
    __self__ = ( class FXSpinner * )lua_to_FXSpinner(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXApp::getHiliteColor()const  */
int lua_call1_FXApp__getHiliteColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getHiliteColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXFileItem::isDirectory()const  */
int lua_call1_FXFileItem__isDirectory(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileItem * __self__;
    
    __self__ = ( class FXFileItem * )lua_to_FXFileItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isDirectory());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXSplitter::getSplitterStyle()const  */
int lua_call1_FXSplitter__getSplitterStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSplitter * __self__;
    
    __self__ = ( class FXSplitter * )lua_to_FXSplitter(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getSplitterStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCWindow::setClipMask(class FXBitmap * mask, FXint dx=0, FXint dy=0) */
int lua_call1_FXDCWindow__setClipMask(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDCWindow * __self__;
     class FXBitmap * mask;
     int dx;
     int dy;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    mask = ( class FXBitmap * )lua_to_FXBitmap(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      __self__->setClipMask(mask);
    } else {
      dx = ( int )(int)lua_tonumber(__S__, 3);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        __self__->setClipMask(mask, dx);
      } else {
        dy = ( int )(int)lua_tonumber(__S__, 4);
        if (__ERROR__) goto error;
        
        __self__->setClipMask(mask, dx, dy);
      }
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXFileDialog::setPatternText(FXint patno, const class FXString & text) */
int lua_call1_FXFileDialog__setPatternText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXFileDialog * __self__;
     int patno;
    
    __self__ = ( class FXFileDialog * )lua_to_FXFileDialog(__S__, 1, &__ERROR__);
    patno = ( int )(int)lua_tonumber(__S__, 2);
    int __err__68; static FXString __cstr__68; FXString * __str__68 = lua_to_FXString(__S__, 3, &__err__68);  class FXString & text = ( class FXString & ) (__str__68? *__str__68 : (__cstr__68 =(FXString) (char *)lua_tostring(__S__, 3), __cstr__68));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setPatternText(patno, text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXLabel::onQueryHelp(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXuint FXMenuButton::getPopupStyle()const  */
int lua_call1_FXMenuButton__getPopupStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMenuButton * __self__;
    
    __self__ = ( class FXMenuButton * )lua_to_FXMenuButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getPopupStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXDCPrint::endPage() */
int lua_call1_FXDCPrint__endPage(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDCPrint * __self__;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->endPage());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTextField::onAutoScroll(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXLabel::onHotKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXText::onClipboardGained(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXMDIClient::getContentHeight() */
int lua_call1_FXMDIClient__getContentHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIClient * __self__;
    
    __self__ = ( class FXMDIClient * )lua_to_FXMDIClient(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getContentHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXId::detach() */
int lua_call1_FXId__detach(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXId * __self__;
    
    __self__ = ( class FXId * )lua_to_FXId(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->detach();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXIconList::onUpdShowBigIcons(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTopWindow::onFocusDown(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXOptionMenu::setCurrentNo(FXint no) */
int lua_call1_FXOptionMenu__setCurrentNo(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXOptionMenu * __self__;
     int no;
    
    __self__ = ( class FXOptionMenu * )lua_to_FXOptionMenu(__S__, 1, &__ERROR__);
    no = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setCurrentNo(no);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXColorWell::getDefaultHeight() */
int lua_call1_FXColorWell__getDefaultHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorWell * __self__;
    
    __self__ = ( class FXColorWell * )lua_to_FXColorWell(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultHeight());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXToggleButton::onKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDCWindow::end() */
int lua_call1_FXDCWindow__end(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDCWindow * __self__;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->end();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXIconItem::isEnabled()const  */
int lua_call1_FXIconItem__isEnabled(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconItem * __self__;
    
    __self__ = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isEnabled());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXDVec & ( FXDVec::operator =)(const class FXDVec & w) */
/* SKIPPED (operator) */
/* class FXDVec & ( FXDVec::operator =)(FXColor color) */
/* SKIPPED (operator) */
/* const struct FXMetaClass * FXRecentFiles::getMetaClass()const  */
int lua_call1_FXRecentFiles__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXRecentFiles * __self__;
    
    __self__ = ( class FXRecentFiles * )lua_to_FXRecentFiles(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXDirSelector::getDirectory()const  */
int lua_call1_FXDirSelector__getDirectory(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDirSelector * __self__;
    
    __self__ = ( class FXDirSelector * )lua_to_FXDirSelector(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getDirectory().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::setBackColor(FXColor clr) */
int lua_call1_FXWindow__setBackColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXWindow * __self__;
     unsigned int clr;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBackColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXWindow::onCmdShow(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXOptionMenu::onLeftBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXApp::dumpWidgets()const  */
int lua_call1_FXApp__dumpWidgets(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->dumpWidgets();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXComboBox::onTextChanged(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXLabel::getDefaultWidth() */
int lua_call1_FXLabel__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXLabel * __self__;
    
    __self__ = ( class FXLabel * )lua_to_FXLabel(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXWindow::isShell()const  */
int lua_call1_FXWindow__isShell(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isShell());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXGIFCursor::manufacture() */
int lua_call1_FXGIFCursor__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXGIFCursor::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXCheckButton::setBoxColor(FXColor clr) */
int lua_call1_FXCheckButton__setBoxColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXCheckButton * __self__;
     unsigned int clr;
    
    __self__ = ( class FXCheckButton * )lua_to_FXCheckButton(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBoxColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXText::setTextColor(FXColor clr) */
int lua_call1_FXText__setTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXText * __self__;
     unsigned int clr;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTextColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXuint FXVisual::getNumColors()const  */
int lua_call1_FXVisual__getNumColors(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXVisual * __self__;
    
    __self__ = ( class FXVisual * )lua_to_FXVisual(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getNumColors());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXFileDialog::save(class FXStream & store)const  */
int lua_call1_FXFileDialog__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileDialog * __self__;
    
    __self__ = ( class FXFileDialog * )lua_to_FXFileDialog(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXMDIChild::getBorderColor()const  */
int lua_call1_FXMDIChild__getBorderColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIChild * __self__;
    
    __self__ = ( class FXMDIChild * )lua_to_FXMDIChild(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBorderColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDCWindow::clearClipRectangle() */
int lua_call1_FXDCWindow__clearClipRectangle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDCWindow * __self__;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->clearClipRectangle();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTreeListBox::detach() */
int lua_call1_FXTreeListBox__detach(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeListBox * __self__;
    
    __self__ = ( class FXTreeListBox * )lua_to_FXTreeListBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->detach();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::move(FXint x, FXint y) */
int lua_call1_FXWindow__move(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXWindow * __self__;
     int x;
     int y;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    x = ( int )(int)lua_tonumber(__S__, 2);
    y = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->move(x, y);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXColorWheel::setSat(FXfloat s) */
int lua_call1_FXColorWheel__setSat(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXColorWheel * __self__;
     float s;
    
    __self__ = ( class FXColorWheel * )lua_to_FXColorWheel(__S__, 1, &__ERROR__);
    s = ( float )(float)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setSat(s);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXAccelTable::load(class FXStream & store) */
int lua_call1_FXAccelTable__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXAccelTable * __self__;
    
    __self__ = ( class FXAccelTable * )lua_to_FXAccelTable(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMenuCaption::setSelBackColor(FXColor clr) */
int lua_call1_FXMenuCaption__setSelBackColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMenuCaption * __self__;
     unsigned int clr;
    
    __self__ = ( class FXMenuCaption * )lua_to_FXMenuCaption(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setSelBackColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXStringDict::manufacture() */
int lua_call1_FXStringDict__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXStringDict::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXIconItem::getWidth(const class FXIconList * list)const  */
int lua_call1_FXIconItem__getWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconItem * __self__;
     class FXIconList * list;
    
    __self__ = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
    list = ( class FXIconList * )lua_to_FXIconList(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getWidth(list));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXToolbarGrip::setDoubleBar(FXbool dbl=1) */
int lua_call1_FXToolbarGrip__setDoubleBar(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbarGrip * __self__;
     unsigned char dbl;
    
    __self__ = ( class FXToolbarGrip * )lua_to_FXToolbarGrip(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->setDoubleBar();
    } else {
      dbl = ( unsigned char )(char)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->setDoubleBar(dbl);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPicker::onLeave(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTabItem::onKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXMenuTitle::onFocusUp(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXShutterItem::onFocusDown(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXBitmap::load(class FXStream & store) */
int lua_call1_FXBitmap__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXBitmap * __self__;
    
    __self__ = ( class FXBitmap * )lua_to_FXBitmap(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXToolbar::getMetaClass()const  */
int lua_call1_FXToolbar__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbar * __self__;
    
    __self__ = ( class FXToolbar * )lua_to_FXToolbar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXTable::isItemCurrent(FXint r, FXint c)const  */
int lua_call1_FXTable__isItemCurrent(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTable * __self__;
     int r;
     int c;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    r = ( int )(int)lua_tonumber(__S__, 2);
    c = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isItemCurrent(r, c));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXTopWindow::getTitle()const  */
int lua_call1_FXTopWindow__getTitle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTopWindow * __self__;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getTitle().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXScrollArea::setScrollStyle(FXuint style) */
int lua_call1_FXScrollArea__setScrollStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXScrollArea * __self__;
     unsigned int style;
    
    __self__ = ( class FXScrollArea * )lua_to_FXScrollArea(__S__, 1, &__ERROR__);
    style = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setScrollStyle(style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTabBook::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXTopWindow::onFocusUp(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXUndoList::marked()const  */
int lua_call1_FXUndoList__marked(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXUndoList * __self__;
    
    __self__ = ( class FXUndoList * )lua_to_FXUndoList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->marked());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXTopWindow::isIconified()const  */
int lua_call1_FXTopWindow__isIconified(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTopWindow * __self__;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isIconified());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDocument::onUpdTitle(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXReplaceDialog::onCmdSearchHist(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXMenuTitle::onLeftBtnPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXSlider::onLeftBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* const struct FXMetaClass * FXOption::getMetaClass()const  */
int lua_call1_FXOption__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXOption * __self__;
    
    __self__ = ( class FXOption * )lua_to_FXOption(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXSplitter::manufacture() */
int lua_call1_FXSplitter__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXSplitter::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXSettings::unparseFile(const class FXString & filename) */
int lua_call1_FXSettings__unparseFile(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXSettings * __self__;
    
    __self__ = ( class FXSettings * )lua_to_FXSettings(__S__, 1, &__ERROR__);
    int __err__69; static FXString __cstr__69; FXString * __str__69 = lua_to_FXString(__S__, 2, &__err__69);  class FXString & filename = ( class FXString & ) (__str__69? *__str__69 : (__cstr__69 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__69));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->unparseFile(filename));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXList::onClicked(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXToggleButton::onEnter(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXMatrix::setMatrixStyle(FXuint ph) */
int lua_call1_FXMatrix__setMatrixStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMatrix * __self__;
     unsigned int ph;
    
    __self__ = ( class FXMatrix * )lua_to_FXMatrix(__S__, 1, &__ERROR__);
    ph = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setMatrixStyle(ph);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXText::load(class FXStream & store) */
int lua_call1_FXText__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIconItem::setSelected(FXbool selected) */
int lua_call1_FXIconItem__setSelected(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconItem * __self__;
     unsigned char selected;
    
    __self__ = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
    selected = ( unsigned char )(char)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setSelected(selected);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXFrame::setBorderColor(FXColor clr) */
int lua_call1_FXFrame__setBorderColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFrame * __self__;
     unsigned int clr;
    
    __self__ = ( class FXFrame * )lua_to_FXFrame(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setBorderColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXMenuButton::onCmdPost(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXDialogBox::onKeyPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXSpinner::onCmdSetIntRange(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXWindow::onCmdUpdate(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXResourceException::FXResourceException() */
int lua_call1_FXResourceException__FXResourceException(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXResourceException(__S__, new FXResourceException());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXResourceException::FXResourceException(const FXchar * msg) */
int lua_call2_FXResourceException__FXResourceException(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     char * msg;
    
    msg = ( char * )(char  *)lua_tostring(__S__, 1);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXResourceException(__S__, new FXResourceException(msg));
    return 1;
  }
  
error:
  return lua_call1_FXResourceException__FXResourceException(__S__);
}
/* long FXDrawable::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* class FXObject * FXCanvas::manufacture() */
int lua_call1_FXCanvas__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXCanvas::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPrintDialog::onUpdGray(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXText::findText(const class FXString & string, FXint * beg=__null, FXint * end=__null, FXint start=0, FXuint flags=SEARCH_FORWARD|SEARCH_WRAP|SEARCH_EXACT, FXint npar=1) */
int lua_call1_FXText__findText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXText * __self__;
     int * beg;
     int * end;
     int start;
     unsigned int flags;
     int npar;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    int __err__70; static FXString __cstr__70; FXString * __str__70 = lua_to_FXString(__S__, 2, &__err__70);  class FXString & string = ( class FXString & ) (__str__70? *__str__70 : (__cstr__70 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__70));
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_pushnumber(__S__, __self__->findText(string));
      return 1;
    } else {
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_pushnumber(__S__, __self__->findText(string, beg));
        return 1;
      } else {
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_pushnumber(__S__, __self__->findText(string, beg, end));
          return 1;
        } else {
          start = ( int )(int)lua_tonumber(__S__, 5);
          if (nparam <= 5) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_pushnumber(__S__, __self__->findText(string, beg, end, start));
            return 1;
          } else {
            flags = ( unsigned int )(int)lua_tonumber(__S__, 6);
            if (nparam <= 6) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_pushnumber(__S__, __self__->findText(string, beg, end, start, flags));
              return 1;
            } else {
              npar = ( int )(int)lua_tonumber(__S__, 7);
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_pushnumber(__S__, __self__->findText(string, beg, end, start, flags, npar));
              return 1;
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTopWindow::resize(FXint w, FXint h) */
int lua_call1_FXTopWindow__resize(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTopWindow * __self__;
     int w;
     int h;
    
    __self__ = ( class FXTopWindow * )lua_to_FXTopWindow(__S__, 1, &__ERROR__);
    w = ( int )(int)lua_tonumber(__S__, 2);
    h = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->resize(w, h);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTextField::onCmdGetRealValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXSlider::setHelpText(const class FXString & text) */
int lua_call1_FXSlider__setHelpText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXSlider * __self__;
    
    __self__ = ( class FXSlider * )lua_to_FXSlider(__S__, 1, &__ERROR__);
    int __err__71; static FXString __cstr__71; FXString * __str__71 = lua_to_FXString(__S__, 2, &__err__71);  class FXString & text = ( class FXString & ) (__str__71? *__str__71 : (__cstr__71 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__71));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setHelpText(text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXComboBox::getHelpText()const  */
int lua_call1_FXComboBox__getHelpText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXComboBox * __self__;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getHelpText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXDict::last()const  */
int lua_call1_FXDict__last(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDict * __self__;
    
    __self__ = ( class FXDict * )lua_to_FXDict(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->last());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorWell::onLeftBtnPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXColor FXTextField::getSelBackColor()const  */
int lua_call1_FXTextField__getSelBackColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTextField * __self__;
    
    __self__ = ( class FXTextField * )lua_to_FXTextField(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getSelBackColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXLabel::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXTreeList::onKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXColor FXPacker::getShadowColor()const  */
int lua_call1_FXPacker__getShadowColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXPacker * __self__;
    
    __self__ = ( class FXPacker * )lua_to_FXPacker(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getShadowColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXHMat & FXHMat::yrot(FXfloat phi) */
int lua_call1_FXHMat__yrot(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXHMat * __self__;
     float phi;
    
    __self__ = ( class FXHMat * )lua_to_FXHMat(__S__, 1, &__ERROR__);
    phi = ( float )(float)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXHMat(__S__, &(__self__->yrot(phi)));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXHMat & FXHMat::yrot(FXfloat c, FXfloat s) */
int lua_call2_FXHMat__yrot(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXHMat * __self__;
     float c;
     float s;
    
    __self__ = ( class FXHMat * )lua_to_FXHMat(__S__, 1, &__ERROR__);
    c = ( float )(float)lua_tonumber(__S__, 2);
    s = ( float )(float)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXHMat(__S__, &(__self__->yrot(c, s)));
    return 1;
  }
  
error:
  return lua_call1_FXHMat__yrot(__S__);
}
/* long FXScrollbar::onLeftBtnPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXDirItem::manufacture() */
int lua_call1_FXDirItem__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXDirItem::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXFileStream::position(unsigned long p) */
int lua_call1_FXFileStream__position(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileStream * __self__;
     unsigned long p;
    
    __self__ = ( class FXFileStream * )lua_to_FXFileStream(__S__, 1, &__ERROR__);
    p = ( unsigned long )(long)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->position(p));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXIconDict::manufacture() */
int lua_call1_FXIconDict__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXIconDict::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXSlider::load(class FXStream & store) */
int lua_call1_FXSlider__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXSlider * __self__;
    
    __self__ = ( class FXSlider * )lua_to_FXSlider(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXTextField::canFocus()const  */
int lua_call1_FXTextField__canFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTextField * __self__;
    
    __self__ = ( class FXTextField * )lua_to_FXTextField(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->canFocus());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXTreeItem::isDraggable()const  */
int lua_call1_FXTreeItem__isDraggable(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTreeItem * __self__;
    
    __self__ = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isDraggable());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onCmdMark(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXAccelTable::onKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXVisual::create() */
int lua_call1_FXVisual__create(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXVisual * __self__;
    
    __self__ = ( class FXVisual * )lua_to_FXVisual(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->create();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXWindow::isChildOf(const class FXWindow * window)const  */
int lua_call1_FXWindow__isChildOf(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXWindow * __self__;
     class FXWindow * window;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    window = ( class FXWindow * )lua_to_FXWindow(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isChildOf(window));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTable::getMarginTop()const  */
int lua_call1_FXTable__getMarginTop(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getMarginTop());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXDirItem::isDirectory()const  */
int lua_call1_FXDirItem__isDirectory(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDirItem * __self__;
    
    __self__ = ( class FXDirItem * )lua_to_FXDirItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isDirectory());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXList::getSelBackColor()const  */
int lua_call1_FXList__getSelBackColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXList * __self__;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getSelBackColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDataTarget::setSelector(FXSelector sel) */
int lua_call1_FXDataTarget__setSelector(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDataTarget * __self__;
     unsigned int sel;
    
    __self__ = ( class FXDataTarget * )lua_to_FXDataTarget(__S__, 1, &__ERROR__);
    sel = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setSelector(sel);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXRecentFiles::getGroupName()const  */
int lua_call1_FXRecentFiles__getGroupName(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXRecentFiles * __self__;
    
    __self__ = ( class FXRecentFiles * )lua_to_FXRecentFiles(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getGroupName().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXComboBox::onFocusDown(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXIconList::setListStyle(FXuint style) */
int lua_call1_FXIconList__setListStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconList * __self__;
     unsigned int style;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    style = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setListStyle(style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDirSelector::onCmdDriveChanged(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXuint FXProgressBar::getBarStyle()const  */
int lua_call1_FXProgressBar__getBarStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXProgressBar * __self__;
    
    __self__ = ( class FXProgressBar * )lua_to_FXProgressBar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBarStyle());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXStream & ( FXMemoryStream::operator >>)(FXuchar & v) */
/* SKIPPED (operator) */
/* class FXStream & ( FXMemoryStream::operator >>)(FXchar & v) */
/* SKIPPED (operator) */
/*  FXIconList::FXIconList(class FXComposite * p, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=ICONLIST_NORMAL, FXint x=0, FXint y=0, FXint w=0, FXint h=0) */
int lua_call1_FXIconList__FXIconList(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXIconList(__S__, new FXIconList(p));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 2, &__ERROR__);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXIconList(__S__, new FXIconList(p, tgt));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 3);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXIconList(__S__, new FXIconList(p, tgt, sel));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 4);
          if (nparam <= 4) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXIconList(__S__, new FXIconList(p, tgt, sel, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 5);
            if (nparam <= 5) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXIconList(__S__, new FXIconList(p, tgt, sel, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 6);
              if (nparam <= 6) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXIconList(__S__, new FXIconList(p, tgt, sel, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 7);
                if (nparam <= 7) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXIconList(__S__, new FXIconList(p, tgt, sel, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 8);
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXIconList(__S__, new FXIconList(p, tgt, sel, opts, x, y, w, h));
                  return 1;
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDirList::onUpdShowHidden(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXTabItem::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXSplitter::getBarSize()const  */
int lua_call1_FXSplitter__getBarSize(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSplitter * __self__;
    
    __self__ = ( class FXSplitter * )lua_to_FXSplitter(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBarSize());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXFileItem::FXFileItem(const class FXString & text, class FXIcon * bi=__null, class FXIcon * mi=__null, void * ptr=__null) */
int lua_call1_FXFileItem__FXFileItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXIcon * bi;
     class FXIcon * mi;
     void * ptr;
    
    int __err__72; static FXString __cstr__72; FXString * __str__72 = lua_to_FXString(__S__, 1, &__err__72);  class FXString & text = ( class FXString & ) (__str__72? *__str__72 : (__cstr__72 =(FXString) (char *)lua_tostring(__S__, 1), __cstr__72));
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXFileItem(__S__, new FXFileItem(text));
      return 1;
    } else {
      bi = ( class FXIcon * )lua_to_FXIcon(__S__, 2, &__ERROR__);
      if (nparam <= 2) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXFileItem(__S__, new FXFileItem(text, bi));
        return 1;
      } else {
        mi = ( class FXIcon * )lua_to_FXIcon(__S__, 3, &__ERROR__);
        if (nparam <= 3) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXFileItem(__S__, new FXFileItem(text, bi, mi));
          return 1;
        } else {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXFileItem(__S__, new FXFileItem(text, bi, mi, ptr));
          return 1;
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDC::fillComplexPolygon(const class FXPoint * points, FXuint npoints) */
int lua_call1_FXDC__fillComplexPolygon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDC * __self__;
     class FXPoint * points;
     unsigned int npoints;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    points = ( class FXPoint * )lua_to_FXPoint(__S__, 2, &__ERROR__);
    npoints = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->fillComplexPolygon(points, npoints);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXBMPIcon::manufacture() */
int lua_call1_FXBMPIcon__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXBMPIcon::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTable::getAnchorColumn()const  */
int lua_call1_FXTable__getAnchorColumn(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getAnchorColumn());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDial::setDialStyle(FXuint opts) */
int lua_call1_FXDial__setDialStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDial * __self__;
     unsigned int opts;
    
    __self__ = ( class FXDial * )lua_to_FXDial(__S__, 1, &__ERROR__);
    opts = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setDialStyle(opts);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXIconDict::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXTextField::setJustify(FXuint mode) */
int lua_call1_FXTextField__setJustify(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTextField * __self__;
     unsigned int mode;
    
    __self__ = ( class FXTextField * )lua_to_FXTextField(__S__, 1, &__ERROR__);
    mode = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setJustify(mode);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXText::setTipText(const class FXString & text) */
int lua_call1_FXText__setTipText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    int __err__73; static FXString __cstr__73; FXString * __str__73 = lua_to_FXString(__S__, 2, &__err__73);  class FXString & text = ( class FXString & ) (__str__73? *__str__73 : (__cstr__73 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__73));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTipText(text);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPopup::onMotion(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXTableItem::getHeight(const class FXTable * table)const  */
int lua_call1_FXTableItem__getHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTableItem * __self__;
     class FXTable * table;
    
    __self__ = ( class FXTableItem * )lua_to_FXTableItem(__S__, 1, &__ERROR__);
    table = ( class FXTable * )lua_to_FXTable(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getHeight(table));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXFileItem::isFile()const  */
int lua_call1_FXFileItem__isFile(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileItem * __self__;
    
    __self__ = ( class FXFileItem * )lua_to_FXFileItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isFile());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString & FXString::substitute(FXchar orig, FXchar sub) */
int lua_call1_FXString__substitute(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXString * __self__;
     char orig;
     char sub;
    
    __self__ = ( class FXString * )lua_to_FXString(__S__, 1, &__ERROR__);
    orig = ( char )(char)lua_tonumber(__S__, 2);
    sub = ( char )(char)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->substitute(orig, sub).text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXIconList::onCmdArrangeByRows(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXTable::rowAtY(FXint y)const  */
int lua_call1_FXTable__rowAtY(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTable * __self__;
     int y;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    y = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->rowAtY(y));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIconDict::save(class FXStream & store)const  */
int lua_call1_FXIconDict__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconDict * __self__;
    
    __self__ = ( class FXIconDict * )lua_to_FXIconDict(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXFrame::getBorderWidth()const  */
int lua_call1_FXFrame__getBorderWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFrame * __self__;
    
    __self__ = ( class FXFrame * )lua_to_FXFrame(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBorderWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXWindow::onSelectionLost(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDirDialog::setDirBoxStyle(FXuint style) */
int lua_call1_FXDirDialog__setDirBoxStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDirDialog * __self__;
     unsigned int style;
    
    __self__ = ( class FXDirDialog * )lua_to_FXDirDialog(__S__, 1, &__ERROR__);
    style = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setDirBoxStyle(style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXFileList::cmpFTime(const class FXIconItem * pa, const class FXIconItem * pb) */
int lua_call1_FXFileList__cmpFTime(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXIconItem * pa;
     class FXIconItem * pb;
    
    pa = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
    pb = ( class FXIconItem * )lua_to_FXIconItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, FXFileList::cmpFTime(pa, pb));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXRectangle & FXRectangle::move(FXshort dx, FXshort dy) */
int lua_call1_FXRectangle__move(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXRectangle * __self__;
     short dx;
     short dy;
    
    __self__ = ( class FXRectangle * )lua_to_FXRectangle(__S__, 1, &__ERROR__);
    dx = ( short )(short)lua_tonumber(__S__, 2);
    dy = ( short )(short)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXRectangle(__S__, &(__self__->move(dx, dy)));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXCheckButton::onCheck(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXString * FXFileDialog::getOpenFilenames(class FXWindow * owner, const class FXString & caption, const class FXString & path, const class FXString & patterns="*", FXint initial=0) */
int lua_call1_FXFileDialog__getOpenFilenames(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 3) goto error;
  {
     class FXWindow * owner;
    int __err__74; static FXString __cstr__74; FXString * __str__74 = lua_to_FXString(__S__, 2, &__err__74);  class FXString & caption = ( class FXString & ) (__str__74? *__str__74 : (__cstr__74 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__74));
     int initial;
    
    owner = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    int __err__75; static FXString __cstr__75; FXString * __str__75 = lua_to_FXString(__S__, 3, &__err__75);  class FXString & path = ( class FXString & ) (__str__75? *__str__75 : (__cstr__75 =(FXString) (char *)lua_tostring(__S__, 3), __cstr__75));
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXString(__S__, FXFileDialog::getOpenFilenames(owner, caption, path));
      lua_pushstring(__S__, caption.text());
      return 2;
    } else {
      int __err__76; static FXString __cstr__76; FXString * __str__76 = lua_to_FXString(__S__, 4, &__err__76);  class FXString & patterns = ( class FXString & ) (__str__76? *__str__76 : (__cstr__76 =(FXString) (char *)lua_tostring(__S__, 4), __cstr__76));
      if (nparam <= 4) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXString(__S__, FXFileDialog::getOpenFilenames(owner, caption, path, patterns));
        lua_pushstring(__S__, caption.text());
        lua_pushstring(__S__, patterns.text());
        return 3;
      } else {
        initial = ( int )(int)lua_tonumber(__S__, 5);
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXString(__S__, FXFileDialog::getOpenFilenames(owner, caption, path, patterns, initial));
        lua_pushstring(__S__, caption.text());
        lua_pushstring(__S__, patterns.text());
        return 3;
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXSwitcher::getDefaultWidth() */
int lua_call1_FXSwitcher__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXSwitcher * __self__;
    
    __self__ = ( class FXSwitcher * )lua_to_FXSwitcher(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDirList::onUpdShowFiles(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXColorSelector::onUpdAlphaText(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXFrame::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/*  FXCharset::operator FXString() */
/* SKIPPED (operator) */
/* FXuint FXDC::getDashOffset()const  */
int lua_call1_FXDC__getDashOffset(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDC * __self__;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDashOffset());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onCmdInsertNewline(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXTable::canFocus()const  */
int lua_call1_FXTable__canFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTable * __self__;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->canFocus());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXIconList::onQueryHelp(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXCheckButton::setCheckButtonStyle(FXuint style) */
int lua_call1_FXCheckButton__setCheckButtonStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXCheckButton * __self__;
     unsigned int style;
    
    __self__ = ( class FXCheckButton * )lua_to_FXCheckButton(__S__, 1, &__ERROR__);
    style = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setCheckButtonStyle(style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXObject * FXScrollArea::manufacture() */
int lua_call1_FXScrollArea__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXScrollArea::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXHeader::onQueryTip(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXMDIChild::onRightBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXTooltip::manufacture() */
int lua_call1_FXTooltip__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXTooltip::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXMenuSeparator::FXMenuSeparator(class FXComposite * p, FXuint opts=0) */
int lua_call1_FXMenuSeparator__FXMenuSeparator(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     class FXComposite * p;
     unsigned int opts;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXMenuSeparator(__S__, new FXMenuSeparator(p));
      return 1;
    } else {
      opts = ( unsigned int )(int)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXMenuSeparator(__S__, new FXMenuSeparator(p, opts));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorWell::onMotion(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDCWindow::setForeground(FXColor clr) */
int lua_call1_FXDCWindow__setForeground(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDCWindow * __self__;
     unsigned int clr;
    
    __self__ = ( class FXDCWindow * )lua_to_FXDCWindow(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setForeground(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDC::drawArcs(const struct FXArc * arcs, FXuint narcs) */
int lua_call1_FXDC__drawArcs(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXDC * __self__;
     struct FXArc * arcs;
     unsigned int narcs;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    arcs = ( struct FXArc * )lua_to_FXArc(__S__, 2, &__ERROR__);
    narcs = ( unsigned int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawArcs(arcs, narcs);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXFileDict::load(class FXStream & store) */
int lua_call1_FXFileDict__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXFileDict * __self__;
    
    __self__ = ( class FXFileDict * )lua_to_FXFileDict(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXPopup::setHiliteColor(FXColor clr) */
int lua_call1_FXPopup__setHiliteColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXPopup * __self__;
     unsigned int clr;
    
    __self__ = ( class FXPopup * )lua_to_FXPopup(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setHiliteColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXStatusline::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXMDIClient::onCmdCloseDocument(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXDHVec & ( FXDHVec::operator +=)(const class FXDHVec & a) */
/* SKIPPED (operator) */
/* FXColor FXPopup::getBaseColor()const  */
int lua_call1_FXPopup__getBaseColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXPopup * __self__;
    
    __self__ = ( class FXPopup * )lua_to_FXPopup(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getBaseColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXStatusline::setTextColor(FXColor clr) */
int lua_call1_FXStatusline__setTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXStatusline * __self__;
     unsigned int clr;
    
    __self__ = ( class FXStatusline * )lua_to_FXStatusline(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTextColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXUndoList::undo() */
int lua_call1_FXUndoList__undo(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXUndoList * __self__;
    
    __self__ = ( class FXUndoList * )lua_to_FXUndoList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->undo());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXToolbarTab::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXToggleButton::onPaint(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXListBox::setTextColor(FXColor clr) */
int lua_call1_FXListBox__setTextColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXListBox * __self__;
     unsigned int clr;
    
    __self__ = ( class FXListBox * )lua_to_FXListBox(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTextColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXGIFIcon::savePixels(class FXStream & store)const  */
int lua_call1_FXGIFIcon__savePixels(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXGIFIcon * __self__;
    
    __self__ = ( class FXGIFIcon * )lua_to_FXGIFIcon(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->savePixels(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDC::clearClipMask() */
int lua_call1_FXDC__clearClipMask(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDC * __self__;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->clearClipMask();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXCheckButton::onHotKeyPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXHeader::getNumItems()const  */
int lua_call1_FXHeader__getNumItems(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXHeader * __self__;
    
    __self__ = ( class FXHeader * )lua_to_FXHeader(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getNumItems());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMenuButton::setYOffset(FXint offy) */
int lua_call1_FXMenuButton__setYOffset(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMenuButton * __self__;
     int offy;
    
    __self__ = ( class FXMenuButton * )lua_to_FXMenuButton(__S__, 1, &__ERROR__);
    offy = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setYOffset(offy);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXTable::setTrailingCols(FXint trailcols) */
int lua_call1_FXTable__setTrailingCols(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTable * __self__;
     int trailcols;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    trailcols = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setTrailingCols(trailcols);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXCursor::getMetaClass()const  */
int lua_call1_FXCursor__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXCursor * __self__;
    
    __self__ = ( class FXCursor * )lua_to_FXCursor(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXSpinner::onKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXRadioButton::save(class FXStream & store)const  */
int lua_call1_FXRadioButton__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXRadioButton * __self__;
    
    __self__ = ( class FXRadioButton * )lua_to_FXRadioButton(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXOptionMenu::onCmdUnpost(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXWindow * FXWindow::childAtIndex(FXint index)const  */
int lua_call1_FXWindow__childAtIndex(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXWindow * __self__;
     int index;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXWindow(__S__, __self__->childAtIndex(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMenuCaption::setFont(class FXFont * fnt) */
int lua_call1_FXMenuCaption__setFont(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMenuCaption * __self__;
     class FXFont * fnt;
    
    __self__ = ( class FXMenuCaption * )lua_to_FXMenuCaption(__S__, 1, &__ERROR__);
    fnt = ( class FXFont * )lua_to_FXFont(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setFont(fnt);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXTable::enableItem(FXint r, FXint c) */
int lua_call1_FXTable__enableItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTable * __self__;
     int r;
     int c;
    
    __self__ = ( class FXTable * )lua_to_FXTable(__S__, 1, &__ERROR__);
    r = ( int )(int)lua_tonumber(__S__, 2);
    c = ( int )(int)lua_tonumber(__S__, 3);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->enableItem(r, c));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXDirList::getItemPathname(const class FXTreeItem * item)const  */
int lua_call1_FXDirList__getItemPathname(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDirList * __self__;
     class FXTreeItem * item;
    
    __self__ = ( class FXDirList * )lua_to_FXDirList(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getItemPathname(item).text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXColor FXArrowButton::getArrowColor()const  */
int lua_call1_FXArrowButton__getArrowColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXArrowButton * __self__;
    
    __self__ = ( class FXArrowButton * )lua_to_FXArrowButton(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getArrowColor());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXPoint ( FXPoint::operator -)() */
/* SKIPPED (operator) */
/* long FXWindow::onCmdDelete(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXProgressBar::setFont(class FXFont * fnt) */
int lua_call1_FXProgressBar__setFont(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXProgressBar * __self__;
     class FXFont * fnt;
    
    __self__ = ( class FXProgressBar * )lua_to_FXProgressBar(__S__, 1, &__ERROR__);
    fnt = ( class FXFont * )lua_to_FXFont(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setFont(fnt);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXIconList::getContentWidth() */
int lua_call1_FXIconList__getContentWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconList * __self__;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getContentWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDirList::onDNDLeave(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXDCPrint::drawBitmap(const class FXBitmap * bitmap, FXint dx, FXint dy) */
int lua_call1_FXDCPrint__drawBitmap(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXDCPrint * __self__;
     class FXBitmap * bitmap;
     int dx;
     int dy;
    
    __self__ = ( class FXDCPrint * )lua_to_FXDCPrint(__S__, 1, &__ERROR__);
    bitmap = ( class FXBitmap * )lua_to_FXBitmap(__S__, 2, &__ERROR__);
    dx = ( int )(int)lua_tonumber(__S__, 3);
    dy = ( int )(int)lua_tonumber(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawBitmap(bitmap, dx, dy);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXFileItem::getMetaClass()const  */
int lua_call1_FXFileItem__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXFileItem * __self__;
    
    __self__ = ( class FXFileItem * )lua_to_FXFileItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXTreeItem * FXTreeList::addItemAfter(class FXTreeItem * other, class FXTreeItem * item, FXbool notify=0) */
int lua_call1_FXTreeList__addItemAfter(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTreeList * __self__;
     class FXTreeItem * other;
     class FXTreeItem * item;
     unsigned char notify;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    other = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 3, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXTreeItem(__S__, __self__->addItemAfter(other, item));
      return 1;
    } else {
      notify = ( unsigned char )(char)lua_tonumber(__S__, 4);
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXTreeItem(__S__, __self__->addItemAfter(other, item, notify));
      return 1;
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXTreeItem * FXTreeList::addItemAfter(class FXTreeItem * other, const class FXString & text, class FXIcon * oi=__null, class FXIcon * ci=__null, void * ptr=__null, FXbool notify=0) */
int lua_call2_FXTreeList__addItemAfter(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 3) goto error;
  {
     class FXTreeList * __self__;
     class FXTreeItem * other;
     class FXIcon * oi;
     class FXIcon * ci;
     void * ptr;
     unsigned char notify;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    other = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    int __err__77; static FXString __cstr__77; FXString * __str__77 = lua_to_FXString(__S__, 3, &__err__77);  class FXString & text = ( class FXString & ) (__str__77? *__str__77 : (__cstr__77 =(FXString) (char *)lua_tostring(__S__, 3), __cstr__77));
    
    /* Actual call */
    if (nparam <= 3) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXTreeItem(__S__, __self__->addItemAfter(other, text));
      return 1;
    } else {
      oi = ( class FXIcon * )lua_to_FXIcon(__S__, 4, &__ERROR__);
      if (nparam <= 4) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXTreeItem(__S__, __self__->addItemAfter(other, text, oi));
        return 1;
      } else {
        ci = ( class FXIcon * )lua_to_FXIcon(__S__, 5, &__ERROR__);
        if (nparam <= 5) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXTreeItem(__S__, __self__->addItemAfter(other, text, oi, ci));
          return 1;
        } else {
          if (nparam <= 6) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXTreeItem(__S__, __self__->addItemAfter(other, text, oi, ci, ptr));
            return 1;
          } else {
            notify = ( unsigned char )(char)lua_tonumber(__S__, 7);
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXTreeItem(__S__, __self__->addItemAfter(other, text, oi, ci, ptr, notify));
            return 1;
          }
        }
      }
    }
  }
  
error:
  return lua_call1_FXTreeList__addItemAfter(__S__);
}
/* long FXListBox::onFocusDown(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXint FXList::getContentWidth() */
int lua_call1_FXList__getContentWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXList * __self__;
    
    __self__ = ( class FXList * )lua_to_FXList(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getContentWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXIcon::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* FXint FXText::getVisRows()const  */
int lua_call1_FXText__getVisRows(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXText * __self__;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getVisRows());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXToggleButton::onQueryTip(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXRecentFiles::onCmdClear(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXToolbarShell::setShadowColor(FXColor clr) */
int lua_call1_FXToolbarShell__setShadowColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXToolbarShell * __self__;
     unsigned int clr;
    
    __self__ = ( class FXToolbarShell * )lua_to_FXToolbarShell(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setShadowColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXToolbarGrip::setActiveColor(FXColor clr) */
int lua_call1_FXToolbarGrip__setActiveColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXToolbarGrip * __self__;
     unsigned int clr;
    
    __self__ = ( class FXToolbarGrip * )lua_to_FXToolbarGrip(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setActiveColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXDebugTarget::getMetaClass()const  */
int lua_call1_FXDebugTarget__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDebugTarget * __self__;
    
    __self__ = ( class FXDebugTarget * )lua_to_FXDebugTarget(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXColorBar::getDefaultWidth() */
int lua_call1_FXColorBar__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorBar * __self__;
    
    __self__ = ( class FXColorBar * )lua_to_FXColorBar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTGAIcon::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* class FXIcon * FXTreeList::getItemOpenIcon(const class FXTreeItem * item)const  */
int lua_call1_FXTreeList__getItemOpenIcon(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeList * __self__;
     class FXTreeItem * item;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXIcon(__S__, __self__->getItemOpenIcon(item));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXbool FXIconList::isItemSelected(FXint index)const  */
int lua_call1_FXIconList__isItemSelected(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXIconList * __self__;
     int index;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->isItemSelected(index));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXColorWell::killFocus() */
int lua_call1_FXColorWell__killFocus(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXColorWell * __self__;
    
    __self__ = ( class FXColorWell * )lua_to_FXColorWell(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->killFocus();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXWindow::disable() */
int lua_call1_FXWindow__disable(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXWindow * __self__;
    
    __self__ = ( class FXWindow * )lua_to_FXWindow(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->disable();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTable::onUpdDeleteColumn(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXDataTarget::manufacture() */
int lua_call1_FXDataTarget__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXDataTarget::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIconItem::setIconOwned(FXuint owned=( BIGICONOWNED|MINIICONOWNED )) */
int lua_call1_FXIconItem__setIconOwned(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconItem * __self__;
     unsigned int owned;
    
    __self__ = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (nparam <= 1) {
      if (__ERROR__) goto error;
      
      __self__->setIconOwned();
    } else {
      owned = ( unsigned int )(int)lua_tonumber(__S__, 2);
      if (__ERROR__) goto error;
      
      __self__->setIconOwned(owned);
    }
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXVerticalSeparator::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void FXDirSelector::setDirectory(const class FXString & path) */
int lua_call1_FXDirSelector__setDirectory(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXDirSelector * __self__;
    
    __self__ = ( class FXDirSelector * )lua_to_FXDirSelector(__S__, 1, &__ERROR__);
    int __err__78; static FXString __cstr__78; FXString * __str__78 = lua_to_FXString(__S__, 2, &__err__78);  class FXString & path = ( class FXString & ) (__str__78? *__str__78 : (__cstr__78 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__78));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setDirectory(path);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXString FXListBox::getTipText()const  */
int lua_call1_FXListBox__getTipText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXListBox * __self__;
    
    __self__ = ( class FXListBox * )lua_to_FXListBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushstring(__S__, __self__->getTipText().text());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXColorSelector::onUpdCMYSlider(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXDragCorner::manufacture() */
int lua_call1_FXDragCorner__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXDragCorner::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXButton::FXButton(class FXComposite * p, const class FXString & text, class FXIcon * ic=__null, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=BUTTON_NORMAL, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=2, FXint pr=2, FXint pt=2, FXint pb=2) */
int lua_call1_FXButton__FXButton(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXComposite * p;
     class FXIcon * ic;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    int __err__79; static FXString __cstr__79; FXString * __str__79 = lua_to_FXString(__S__, 2, &__err__79);  class FXString & text = ( class FXString & ) (__str__79? *__str__79 : (__cstr__79 =(FXString) (char *)lua_tostring(__S__, 2), __cstr__79));
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXButton(__S__, new FXButton(p, text));
      return 1;
    } else {
      ic = ( class FXIcon * )lua_to_FXIcon(__S__, 3, &__ERROR__);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXButton(__S__, new FXButton(p, text, ic));
        return 1;
      } else {
        tgt = ( class FXObject * )lua_to_FXObject(__S__, 4, &__ERROR__);
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXButton(__S__, new FXButton(p, text, ic, tgt));
          return 1;
        } else {
          sel = ( unsigned int )(int)lua_tonumber(__S__, 5);
          if (nparam <= 5) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXButton(__S__, new FXButton(p, text, ic, tgt, sel));
            return 1;
          } else {
            opts = ( unsigned int )(int)lua_tonumber(__S__, 6);
            if (nparam <= 6) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXButton(__S__, new FXButton(p, text, ic, tgt, sel, opts));
              return 1;
            } else {
              x = ( int )(int)lua_tonumber(__S__, 7);
              if (nparam <= 7) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXButton(__S__, new FXButton(p, text, ic, tgt, sel, opts, x));
                return 1;
              } else {
                y = ( int )(int)lua_tonumber(__S__, 8);
                if (nparam <= 8) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXButton(__S__, new FXButton(p, text, ic, tgt, sel, opts, x, y));
                  return 1;
                } else {
                  w = ( int )(int)lua_tonumber(__S__, 9);
                  if (nparam <= 9) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXButton(__S__, new FXButton(p, text, ic, tgt, sel, opts, x, y, w));
                    return 1;
                  } else {
                    h = ( int )(int)lua_tonumber(__S__, 10);
                    if (nparam <= 10) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXButton(__S__, new FXButton(p, text, ic, tgt, sel, opts, x, y, w, h));
                      return 1;
                    } else {
                      pl = ( int )(int)lua_tonumber(__S__, 11);
                      if (nparam <= 11) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXButton(__S__, new FXButton(p, text, ic, tgt, sel, opts, x, y, w, h, pl));
                        return 1;
                      } else {
                        pr = ( int )(int)lua_tonumber(__S__, 12);
                        if (nparam <= 12) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXButton(__S__, new FXButton(p, text, ic, tgt, sel, opts, x, y, w, h, pl, pr));
                          return 1;
                        } else {
                          pt = ( int )(int)lua_tonumber(__S__, 13);
                          if (nparam <= 13) {
                            if (__ERROR__) goto error;
                            
                            lua_settop(__S__, 0);
                            lua_push_FXButton(__S__, new FXButton(p, text, ic, tgt, sel, opts, x, y, w, h, pl, pr, pt));
                            return 1;
                          } else {
                            pb = ( int )(int)lua_tonumber(__S__, 14);
                            if (__ERROR__) goto error;
                            
                            lua_settop(__S__, 0);
                            lua_push_FXButton(__S__, new FXButton(p, text, ic, tgt, sel, opts, x, y, w, h, pl, pr, pt, pb));
                            return 1;
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXText::onRightBtnPress(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* FXbool FXTextField::selectAll() */
int lua_call1_FXTextField__selectAll(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXTextField * __self__;
    
    __self__ = ( class FXTextField * )lua_to_FXTextField(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->selectAll());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXAccelTable::removeAccel(FXHotKey hotkey) */
int lua_call1_FXAccelTable__removeAccel(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXAccelTable * __self__;
     unsigned int hotkey;
    
    __self__ = ( class FXAccelTable * )lua_to_FXAccelTable(__S__, 1, &__ERROR__);
    hotkey = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->removeAccel(hotkey);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXSpinner::FXSpinner(class FXComposite * p, FXint cols, class FXObject * tgt=__null, FXSelector sel=0, FXuint opts=SPIN_NORMAL, FXint x=0, FXint y=0, FXint w=0, FXint h=0, FXint pl=2, FXint pr=2, FXint pt=2, FXint pb=2) */
int lua_call1_FXSpinner__FXSpinner(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXComposite * p;
     int cols;
     class FXObject * tgt;
     unsigned int sel;
     unsigned int opts;
     int x;
     int y;
     int w;
     int h;
     int pl;
     int pr;
     int pt;
     int pb;
    
    p = ( class FXComposite * )lua_to_FXComposite(__S__, 1, &__ERROR__);
    cols = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (nparam <= 2) {
      if (__ERROR__) goto error;
      
      lua_settop(__S__, 0);
      lua_push_FXSpinner(__S__, new FXSpinner(p, cols));
      return 1;
    } else {
      tgt = ( class FXObject * )lua_to_FXObject(__S__, 3, &__ERROR__);
      if (nparam <= 3) {
        if (__ERROR__) goto error;
        
        lua_settop(__S__, 0);
        lua_push_FXSpinner(__S__, new FXSpinner(p, cols, tgt));
        return 1;
      } else {
        sel = ( unsigned int )(int)lua_tonumber(__S__, 4);
        if (nparam <= 4) {
          if (__ERROR__) goto error;
          
          lua_settop(__S__, 0);
          lua_push_FXSpinner(__S__, new FXSpinner(p, cols, tgt, sel));
          return 1;
        } else {
          opts = ( unsigned int )(int)lua_tonumber(__S__, 5);
          if (nparam <= 5) {
            if (__ERROR__) goto error;
            
            lua_settop(__S__, 0);
            lua_push_FXSpinner(__S__, new FXSpinner(p, cols, tgt, sel, opts));
            return 1;
          } else {
            x = ( int )(int)lua_tonumber(__S__, 6);
            if (nparam <= 6) {
              if (__ERROR__) goto error;
              
              lua_settop(__S__, 0);
              lua_push_FXSpinner(__S__, new FXSpinner(p, cols, tgt, sel, opts, x));
              return 1;
            } else {
              y = ( int )(int)lua_tonumber(__S__, 7);
              if (nparam <= 7) {
                if (__ERROR__) goto error;
                
                lua_settop(__S__, 0);
                lua_push_FXSpinner(__S__, new FXSpinner(p, cols, tgt, sel, opts, x, y));
                return 1;
              } else {
                w = ( int )(int)lua_tonumber(__S__, 8);
                if (nparam <= 8) {
                  if (__ERROR__) goto error;
                  
                  lua_settop(__S__, 0);
                  lua_push_FXSpinner(__S__, new FXSpinner(p, cols, tgt, sel, opts, x, y, w));
                  return 1;
                } else {
                  h = ( int )(int)lua_tonumber(__S__, 9);
                  if (nparam <= 9) {
                    if (__ERROR__) goto error;
                    
                    lua_settop(__S__, 0);
                    lua_push_FXSpinner(__S__, new FXSpinner(p, cols, tgt, sel, opts, x, y, w, h));
                    return 1;
                  } else {
                    pl = ( int )(int)lua_tonumber(__S__, 10);
                    if (nparam <= 10) {
                      if (__ERROR__) goto error;
                      
                      lua_settop(__S__, 0);
                      lua_push_FXSpinner(__S__, new FXSpinner(p, cols, tgt, sel, opts, x, y, w, h, pl));
                      return 1;
                    } else {
                      pr = ( int )(int)lua_tonumber(__S__, 11);
                      if (nparam <= 11) {
                        if (__ERROR__) goto error;
                        
                        lua_settop(__S__, 0);
                        lua_push_FXSpinner(__S__, new FXSpinner(p, cols, tgt, sel, opts, x, y, w, h, pl, pr));
                        return 1;
                      } else {
                        pt = ( int )(int)lua_tonumber(__S__, 12);
                        if (nparam <= 12) {
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXSpinner(__S__, new FXSpinner(p, cols, tgt, sel, opts, x, y, w, h, pl, pr, pt));
                          return 1;
                        } else {
                          pb = ( int )(int)lua_tonumber(__S__, 13);
                          if (__ERROR__) goto error;
                          
                          lua_settop(__S__, 0);
                          lua_push_FXSpinner(__S__, new FXSpinner(p, cols, tgt, sel, opts, x, y, w, h, pl, pr, pt, pb));
                          return 1;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXWindow::onSelectionRequest(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXApp::load(class FXStream & store) */
int lua_call1_FXApp__load(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXApp * __self__;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->load(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* class FXComposite * FXToolbar::getDryDock()const  */
int lua_call1_FXToolbar__getDryDock(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbar * __self__;
    
    __self__ = ( class FXToolbar * )lua_to_FXToolbar(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXComposite(__S__, __self__->getDryDock());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXMenuSeparator::setShadowColor(FXColor clr) */
int lua_call1_FXMenuSeparator__setShadowColor(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXMenuSeparator * __self__;
     unsigned int clr;
    
    __self__ = ( class FXMenuSeparator * )lua_to_FXMenuSeparator(__S__, 1, &__ERROR__);
    clr = ( unsigned int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setShadowColor(clr);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXTreeList::getItemHeight(const class FXTreeItem * item)const  */
int lua_call1_FXTreeList__getItemHeight(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeList * __self__;
     class FXTreeItem * item;
    
    __self__ = ( class FXTreeList * )lua_to_FXTreeList(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getItemHeight(item));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDC::drawBitmap(const class FXBitmap * bitmap, FXint dx, FXint dy) */
int lua_call1_FXDC__drawBitmap(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXDC * __self__;
     class FXBitmap * bitmap;
     int dx;
     int dy;
    
    __self__ = ( class FXDC * )lua_to_FXDC(__S__, 1, &__ERROR__);
    bitmap = ( class FXBitmap * )lua_to_FXBitmap(__S__, 2, &__ERROR__);
    dx = ( int )(int)lua_tonumber(__S__, 3);
    dy = ( int )(int)lua_tonumber(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->drawBitmap(bitmap, dx, dy);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXString::hash()const  */
int lua_call1_FXString__hash(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXString * __self__;
    
    __self__ = ( class FXString * )lua_to_FXString(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->hash());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDialogBox::onKeyRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* class FXObject * FXFrame::manufacture() */
int lua_call1_FXFrame__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXFrame::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXToolbarGrip::getDefaultWidth() */
int lua_call1_FXToolbarGrip__getDefaultWidth(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXToolbarGrip * __self__;
    
    __self__ = ( class FXToolbarGrip * )lua_to_FXToolbarGrip(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getDefaultWidth());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXComboBox::removeItem(FXint index) */
int lua_call1_FXComboBox__removeItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXComboBox * __self__;
     int index;
    
    __self__ = ( class FXComboBox * )lua_to_FXComboBox(__S__, 1, &__ERROR__);
    index = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->removeItem(index);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXFileList::cmpFSize(const class FXIconItem * pa, const class FXIconItem * pb) */
int lua_call1_FXFileList__cmpFSize(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 2) goto error;
  {
     class FXIconItem * pa;
     class FXIconItem * pb;
    
    pa = ( class FXIconItem * )lua_to_FXIconItem(__S__, 1, &__ERROR__);
    pb = ( class FXIconItem * )lua_to_FXIconItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, FXFileList::cmpFSize(pa, pb));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXText::extractText(FXchar * text, FXint pos, FXint n)const  */
int lua_call1_FXText__extractText(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXText * __self__;
     char * text;
     int pos;
     int n;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    text = ( char * )(char  *)lua_tostring(__S__, 2);
    pos = ( int )(int)lua_tonumber(__S__, 3);
    n = ( int )(int)lua_tonumber(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->extractText(text, pos, n);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXDirBox::create() */
int lua_call1_FXDirBox__create(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXDirBox * __self__;
    
    __self__ = ( class FXDirBox * )lua_to_FXDirBox(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->create();
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXRootWindow::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* long FXTreeList::onCollapsed(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXIconList::onRightBtnRelease(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXLabel::onCmdGetStringValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXText::changeStyle(FXint pos, FXint n, FXint style) */
int lua_call1_FXText__changeStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXText * __self__;
     int pos;
     int n;
     int style;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    pos = ( int )(int)lua_tonumber(__S__, 2);
    n = ( int )(int)lua_tonumber(__S__, 3);
    style = ( int )(int)lua_tonumber(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->changeStyle(pos, n, style);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXText::changeStyle(FXint pos, FXint n, const FXchar * style) */
int lua_call2_FXText__changeStyle(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 4) goto error;
  {
     class FXText * __self__;
     int pos;
     int n;
     char * style;
    
    __self__ = ( class FXText * )lua_to_FXText(__S__, 1, &__ERROR__);
    pos = ( int )(int)lua_tonumber(__S__, 2);
    n = ( int )(int)lua_tonumber(__S__, 3);
    style = ( char * )(char  *)lua_tostring(__S__, 4);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->changeStyle(pos, n, style);
    ;
    return 0;
  }
  
error:
  return lua_call1_FXText__changeStyle(__S__);
}
/* class FXObject * FXInputDialog::manufacture() */
int lua_call1_FXInputDialog__manufacture(lua_State * __S__)
{
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); }
  {
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXObject(__S__, FXInputDialog::manufacture());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXLDataTarget::connect(class FXLdouble & v) */
int lua_call1_FXLDataTarget__connect(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXLDataTarget * __self__;
    
    __self__ = ( class FXLDataTarget * )lua_to_FXLDataTarget(__S__, 1, &__ERROR__);
     class FXLdouble & v = ( class FXLdouble & )(*lua_to_FXLdouble(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->connect(v);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXLDataTarget::connect(class FXLfloat & v) */
int lua_call2_FXLDataTarget__connect(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXLDataTarget * __self__;
    
    __self__ = ( class FXLDataTarget * )lua_to_FXLDataTarget(__S__, 1, &__ERROR__);
     class FXLfloat & v = ( class FXLfloat & )(*lua_to_FXLfloat(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->connect(v);
    ;
    return 0;
  }
  
error:
  return lua_call1_FXLDataTarget__connect(__S__);
}
/* void FXLDataTarget::connect(class FXLint & v) */
int lua_call3_FXLDataTarget__connect(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXLDataTarget * __self__;
    
    __self__ = ( class FXLDataTarget * )lua_to_FXLDataTarget(__S__, 1, &__ERROR__);
     class FXLint & v = ( class FXLint & )(*lua_to_FXLint(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->connect(v);
    ;
    return 0;
  }
  
error:
  return lua_call2_FXLDataTarget__connect(__S__);
}
/* FXfloat FXFloatVal(const class FXString & s) */
int lua_call1_FXFloatVal(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
    
    int __err__80; static FXString __cstr__80; FXString * __str__80 = lua_to_FXString(__S__, 1, &__err__80);  class FXString & s = ( class FXString & ) (__str__80? *__str__80 : (__cstr__80 =(FXString) (char *)lua_tostring(__S__, 1), __cstr__80));
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, FXFloatVal(s));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXApp::removeSignal(FXint sig) */
int lua_call1_FXApp__removeSignal(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXApp * __self__;
     int sig;
    
    __self__ = ( class FXApp * )lua_to_FXApp(__S__, 1, &__ERROR__);
    sig = ( int )(int)lua_tonumber(__S__, 2);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->removeSignal(sig);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXStatusline::setFont(class FXFont * fnt) */
int lua_call1_FXStatusline__setFont(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXStatusline * __self__;
     class FXFont * fnt;
    
    __self__ = ( class FXStatusline * )lua_to_FXStatusline(__S__, 1, &__ERROR__);
    fnt = ( class FXFont * )lua_to_FXFont(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->setFont(fnt);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* FXint FXMatrix::getNumColumns()const  */
int lua_call1_FXMatrix__getNumColumns(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMatrix * __self__;
    
    __self__ = ( class FXMatrix * )lua_to_FXMatrix(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_pushnumber(__S__, __self__->getNumColumns());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXDirList::onCmdSetValue(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXTreeListBox::removeItem(class FXTreeItem * item) */
int lua_call1_FXTreeListBox__removeItem(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXTreeListBox * __self__;
     class FXTreeItem * item;
    
    __self__ = ( class FXTreeListBox * )lua_to_FXTreeListBox(__S__, 1, &__ERROR__);
    item = ( class FXTreeItem * )lua_to_FXTreeItem(__S__, 2, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->removeItem(item);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/*  FXLfloat::FXLfloat(float v) */
int lua_call1_FXLfloat__FXLfloat(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  if (lua_istable(__S__, 1)) { lua_remove(__S__, 1); nparam--; }
  if (nparam < 1) goto error;
  {
     float v;
    
    v = ( float )(float)lua_tonumber(__S__, 1);
    
    /* Actual call */
    lua_settop(__S__, 0);
    lua_push_FXLfloat(__S__, new FXLfloat(v));
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXPrintDialog::onCmdAccept(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* long FXMDIChild::onCmdMinimize(class FXObject * , FXSelector , void * ) */
/* SKIPPED (argument #4) */
/* void FXSlider::save(class FXStream & store)const  */
int lua_call1_FXSlider__save(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 2) goto error;
  {
     class FXSlider * __self__;
    
    __self__ = ( class FXSlider * )lua_to_FXSlider(__S__, 1, &__ERROR__);
     class FXStream & store = ( class FXStream & )(*lua_to_FXStream(__S__, 2, &__ERROR__));
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    __self__->save(store);
    ;
    return 0;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* const struct FXMetaClass * FXMDIClient::getMetaClass()const  */
int lua_call1_FXMDIClient__getMetaClass(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXMDIClient * __self__;
    
    __self__ = ( class FXMDIClient * )lua_to_FXMDIClient(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXMetaClass(__S__, __self__->getMetaClass());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* long FXTabBar::handle(class FXObject * sender, FXSelector sel, void * ptr) */
/* SKIPPED (argument #4) */
/* void * FXTableItem::getData()const  */
/* SKIPPED (return type) */
/* class FXScrollbar * FXScrollArea::verticalScrollbar()const  */
int lua_call1_FXScrollArea__verticalScrollbar(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXScrollArea * __self__;
    
    __self__ = ( class FXScrollArea * )lua_to_FXScrollArea(__S__, 1, &__ERROR__);
    
    /* Actual call */
    if (__ERROR__) goto error;
    
    lua_settop(__S__, 0);
    lua_push_FXScrollbar(__S__, __self__->verticalScrollbar());
    return 1;
  }
  
error:
  luaL_error(__S__, badargs_error);
  return 0;
}
/* void FXIconList::detach() */
int lua_call1_FXIconList__detach(lua_State * __S__)
{
  int nparam = lua_gettop(__S__);
  int __ERROR__ = 0;
  if (nparam < 1) goto error;
  {
     class FXIconList * __self__;
    
    __self__ = ( class FXIconList * )lua_to_FXIconList(__