/* Copyright 1995-2002 Just For Fun Software, Inc. */
/* Author:  George Woltman */
/* Email: woltman@alum.mit.edu */

/* Include files */

#if defined(WIN32)
# include <windows.h>
# include <winsock.h>
# include "io.h"
# include "direct.h"
//#define EXTERNC extern "C"
//#define EXTERNC
# define Sleep fakeSleep
# ifdef __GNUC__
#  include <sys/timeb.h>
# endif
#endif

//extern "C" {
#include "linuxllr/lprime.h"
//}

#undef Sleep

#ifdef __FreeBSD__
/* FreeBSD needs to process sys/types.h before it can understand either
/* sys/time.h or sys/resource.h */
# include <sys/types.h>
#endif
#include <ctype.h>
#include <fcntl.h>
#include <math.h>
#include <memory.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#if defined(__CYGWIN__) || defined (__linux__) || defined (__FreeBSD__)
# include <dirent.h>
# include <unistd.h>
# include <sys/time.h>
# include <sys/timeb.h>
#endif
#ifndef WIN32
# include <sys/resource.h>
#endif

/* Globals */

#define OPEN_MAX 20 
#ifndef WIN32
#define $LLF "%qi"
#define __int64 long long
#else
#define $LLF "%I64d"
#endif
 
#ifdef MPRIME_LOADAVG
#define LINUX_LDAV_FILE "/proc/loadavg"
int volatile SLEEP_STOP = 0;
long LOAD_CHECK_TIME = 0;
double HI_LOAD = 0.0;
double LO_LOAD = 0.0;
#endif

int volatile THREAD_STOP = 0;
int volatile THREAD_KILL = 0;
int NO_GUI = 1;
int MENUING = 0;
int VERBOSE = 0;

/* Common code */

#ifdef __linux__
#define PORT	2
#endif
#ifdef __FreeBSD__
#define PORT	6
#endif
#ifdef __EMX__
#define PORT	7
#endif

#ifdef WIN32
#include "Llr95.c"
#else
#endif
#define LLR2

#ifdef MFCGUI
// new windoz stupidity
double log(int k) { return log(double(k)); }
double log(ULONG k) { return log(double(k)); }
double sqrt(int k) { return sqrt(double(k)); }
double sqrt(ULONG k) { return sqrt(double(k)); }
double pow(double a, unsigned long k) { return pow(a, double(k)); }
#endif

#include "cpuid.c" 
#include "gwnum.c"
//#include "gwnum_p.c"
#include "Jacobi.c"
#include "giants.c"
#include "Igjacobi.c"
#include "Riesel.c"
#include "Llr.c"

/* Signal handlers */

void sigterm_handler(int signo)
{
	THREAD_STOP = TRUE;
	if (signo != SIGINT) THREAD_KILL = TRUE;
	(void)signal(signo, sigterm_handler);
}

#ifdef MPRIME_LOADAVG

/* Routine to get the current load average */
double get_load_average ()
{
#if defined(__linux__) || defined(__CYGWIN__)
	char	ldavgbuf[40];
	double	load_avg;
	int	fd, count;

	fd = open (LINUX_LDAV_FILE, O_RDONLY);
	if (fd == -1) return (-1.0);
	count = read (fd, ldavgbuf, 40);
	(void) close (fd);
	if (count <= 0) return (-1.0);
	count = sscanf (ldavgbuf, "%lf", &load_avg);
	if (count < 1) return (-1.0);
	return (load_avg);
#endif
#ifdef __FreeBSD__
	double load[3];

	if (getloadavg (load, sizeof(load)/sizeof(load[0])) < 0) return (-1.0);
	return (load[0]);
#endif
}

/* load_handler: call by signal routine,
   sets SLEEP_STOP to TRUE if load is too high */
void load_handler (
	int	sig)
{
	double  load_avg;

	load_avg = get_load_average ();
	if (load_avg < 0.0) return;
  
	if (SLEEP_STOP) {
		if (load_avg < LO_LOAD)
			SLEEP_STOP = FALSE;
	} else {
		if (load_avg > HI_LOAD)
			SLEEP_STOP = TRUE;
	}
}

/* init_load_check: initialises timer that calls load_handler
   every LOAD_CHECK_TIME seconds */
void init_load_check ()
{
	struct itimerval timer, otimer;
	struct sigaction sigact;
	int	ret;

	timer.it_interval.tv_sec  =  LOAD_CHECK_TIME;
	timer.it_interval.tv_usec =  0;
	timer.it_value.tv_sec     =  LOAD_CHECK_TIME;
	timer.it_value.tv_usec    =  0;

	ret = setitimer (ITIMER_REAL, &timer, &otimer);
	if (ret < 0) return;
  
	sigact.sa_handler = &load_handler;
	sigemptyset(&sigact.sa_mask);
	sigact.sa_flags =  SA_RESTART;
	ret = sigaction(SIGALRM, &sigact, NULL);
	if (ret < 0) { /* clean up after ourselves */
		setitimer (ITIMER_REAL, &otimer, NULL);
	}
}

/* test_sleep: tests if SLEEP_STOP is set and sleeps until load is normal
   again or THREAD_STOP is set
*/
void test_sleep (void) 
{
	sigset_t newmask;

	while (SLEEP_STOP && !THREAD_STOP) {
		sigemptyset (&newmask);
		sigsuspend (&newmask);
	}
}
#endif

#ifndef MFCGUI
void title (char *msg)
{
}

void flashWindowAndBeep ()
{
	printf ("\007");
}

/* Return TRUE if we should stop calculating */

int escapeCheck ()
{
  if (THREAD_STOP) {
    //THREAD_STOP = 0;
    return (TRUE);
  }
  return (FALSE);
}

void doMiscTasks ()
{
#ifdef MPRIME_LOADAVG
	test_sleep ();
#endif
}

#endif

#ifndef WIN32
void Sleep (
	long	ms) 
{
	sleep (ms/1000);
}

/* Set priority.  Map one (prime95's lowest priority) to 20 */
/* (linux's lowest priority).  Map eight (prime95's normal priority) to */
/* 0 (linux's normal priority). */

void SetPriority ()
{
#ifndef __CYGWIN__
	int	p;
	p = (8 - (int) PRIORITY) * 20 / 7;
	setpriority (PRIO_PROCESS, getpid (), p);
#endif
}
#endif

#ifndef MFCGUI
void BlinkIcon (int x)
{
}

void ChangeIcon (int x)
{
}

void ReplaceableLine (int x)
{
}
#endif

#ifndef WIN32
/* This routine calls primeContinue unless there is another copy of mprime */
/* already running.  In that case, it outputs an optional error message. */

void linuxContinue (
	char	*error_message)
{
#if defined(__linux__) || defined(__CYGWIN__)
#define PROCNAME	"/proc/%d/exe"
#endif
#ifdef __FreeBSD__
#define PROCNAME	"/proc/%d/file"
#endif
	pid_t	my_pid, running_pid;
	char	filename[30];
	int	fd;
	struct stat filedata;
	ino_t	inode1, inode2;

/* Compare this process' ID and the pid from the INI file */

	my_pid = getpid ();
	openIniFile (INI_FILE, 1);
	running_pid = IniGetInt (INI_FILE, "Pid", 0);
	if (running_pid == 0 || my_pid == running_pid) goto ok;

/* See if the two pids are running the same executable */

	sprintf (filename, PROCNAME, my_pid);
	fd = _open (filename, _O_RDONLY);
	if (fd < 0) goto ok;
	fstat (fd, &filedata);
	inode1 = filedata.st_ino;
	_close (fd);
	sprintf (filename, PROCNAME, running_pid);
	fd = _open (filename, _O_RDONLY);
	if (fd < 0) goto ok;
	fstat (fd, &filedata);
	inode2 = filedata.st_ino;
	_close (fd);
	if (inode1 != inode2) goto ok;

/* The two pids are running the same executable, raise an error and return */

	if (error_message != NULL) printf ("%s", error_message);
	return;

/* All is OK.  Save our pid, run, then delete our pid */

ok:	IniWriteInt (INI_FILE, "Pid", my_pid);
	primeContinue ();
	IniWriteInt (INI_FILE, "Pid", 0);
}
#endif
 
/* Routines to access the high resolution performance counter */ 

#ifdef __CYGWIN__
#undef ULONG
#define Sleep fakeSleep
#include <stdarg.h>
#include <windef.h>
#include <wincon.h>
#include <winbase.h>
#undef Sleep
#undef WIN32
int isHighResTimerAvailable (void)
{
	LARGE_INTEGER large;
	return (QueryPerformanceCounter (&large));
}

double getHighResTimer (void)
{
	LARGE_INTEGER large;

	QueryPerformanceCounter (&large);
	return ((double) large.HighPart * 4294967296.0 +
		(double) large.LowPart);
}

double getHighResTimerFrequency (void)
{
	LARGE_INTEGER large;

	QueryPerformanceFrequency (&large);
	return ((double) large.HighPart * 4294967296.0 +
		(double) large.LowPart);
}
/* In Linux, I've read that gettimeofday is the most accurate counter */ 
#elif !defined(WIN32) // && !defined(__CYGWIN__)
int isHighResTimerAvailable (void) 
{ 
	struct timeval start, end; 
	struct timezone tz; 
	int	i; 
 
/* Return true if gettimeofday is more accurate than 1/10 millisecond. */ 
/* Try 10 times to see if gettimeofday returns two values less than */ 
/* 100 microseconds apart. */ 
 
	for (i = 0; i < 10; i++) { 
		gettimeofday (&start, &tz); 
		for ( ; ; ) { 
			gettimeofday (&end, &tz); 
			if (start.tv_sec != end.tv_sec) break; 
			if (start.tv_usec == end.tv_usec) continue; 
			if (end.tv_usec - start.tv_usec < 100) return (TRUE); 
			continue; 
		} 
		printf("%d\n", i);
	} 
	return (FALSE); 
} 
 
double getHighResTimer (void) 
{ 
	struct timeval x; 
	struct timezone tz; 
 
	gettimeofday (&x, &tz); 
	return ((double) x.tv_sec * 1000000.0 + (double) x.tv_usec); 
} 
 
double getHighResTimerFrequency (void) 
{ 
	return (1000000.0); 
} 
#endif


/* Defined in Llr.c */
extern char res64[17];

/* possible return values :
   -1 : some error, could not perform the test
   -2 : not prime ! check the value of residue 
    0 : is prime !
   */
int primeTest (const char * type, const char * input, char * residue)
{

#define	sgkbufsize 1024

  char	sgk[sgkbufsize];
  unsigned long i, chainlen, n, base, nfudge, mask;
  unsigned __int64 li;
  giant gk = 0;
  giant gkk = 0;
  int	res;
  char c;
  int retval;

  retval = -2; /* default return value : not prime ! */
  /*result[0] = 0;*/
  strcpy(residue, "0");

  /* Set appropriate priority */

  SetPriority ();

  /* Handle a newpgen output file */

  mask = 0;
  sscanf (type, $LLF":%c:%lu:%lu:%lu\n", &li, &c, &chainlen, &base, &mask);
  if (base != 2) { 
    //printf("%d %d %d\n", chainlen, base, mask);
    OutputStr ("Only base 2 is supported, use PRP for other bases.\n"); 
    return -1;
  } 
  if (mask & 0x40) {
    OutputStr ("Primoral NewPgen files are not supported.\n");
    return -1;
  }
  if (chainlen == 0) chainlen = 1;

  /* THIS SECTION IS FOR BACKWARDS COMPATIBILITY WITH PREVIOUS PRP.EXE */
  /* That version used the one character code to determine what to do. */
  /* The new version uses the mask field. */

  if (mask == 0/* || IniGetInt (INI_FILE, "UseCharCode", 0)*/) {

    /* The variable c is a one character code as follows: */
    /* P : k.b^n+1 (Plus)
       M : k.b^n-1 (Minus)
       T: k.b^n+-1 (Twin)
       S: k.b^n-1; k.b^(n+1)-1 (SG (CC 1st kind len 2))
       C: k.b^n+1; k.b^(n+1)+1 (CC 2nd kind len 2)
       B: k.b^n+-1; k.b^(n+1)+-1 (BiTwin)
       J: k.b^n+-1; k.b^(n+1)-1 (Twin/SG)
       K: k.b^n+-1; k.b^(n+1)+1 (Twin/CC)
       Y : k.b^n+1 + others (Lucky Plus)
       Z : k.b^n-1 + others (Lucky Minus)
       1: CC 1st kind chain
       2: CC 2nd kind chain
       3: BiTwin chain */
    /* Undo the increment of n that newpgen did on types 1, 2, 3 */
    /* Map P, M, Y, Z, T, S, C, B to their more generic counterparts */

    nfudge = 0;
    if (c == '1') nfudge = 1;
    if (c == '2') nfudge = 1;
    if (c == '3') nfudge = 1;
    if (c == 'P') c = '2', chainlen = 1;
    if (c == 'M') c = '1', chainlen = 1;
    if (c == 'Y') c = '2', chainlen = 1;
    if (c == 'Z') c = '1', chainlen = 1;
    if (c == 'T') c = '3', chainlen = 1;
    if (c == 'S') c = '1', chainlen = 2;
    if (c == 'C') c = '2', chainlen = 2;
    if (c == 'B') c = '3', chainlen = 2;

    /* Read the line, break at EOF */

    // allow k to be a big integer
    if (sscanf (input, "%s %lu\n", sgk, &n) != 2) {
      return -1;
    } 
    gk = newgiant(strlen(sgk)/2 + 1);
    ctog(sgk, gk);

    /* Test numbers according to the c variable */

    for (i = 0; i < chainlen; i++) {
      if (c == '1' || c == '3') {
	if (! process_num (gk, sgk, base, n - nfudge + i, -1, &res)) goto done;
	if (!res) break;
      }
      if (c == '2' || c == '3') {
	if (! process_num (gk, sgk, base, n - nfudge + i, +1, &res)) goto done;
	if (!res) break;
      }
      if (c == 'J') {
	int	res2;
	if (! process_num (gk, sgk, base, n, -1, &res)) goto done;
	if (!res) break;
	if (! process_num (gk, sgk, base, n, +1, &res)) goto done;
	if (! process_num (gk, sgk, base, n+1, -1, &res2)) goto done;
	res |= res2;
	break;
      }
      if (c == 'K') {
	int	res2;
	if (! process_num (gk, sgk, base, n, +1, &res)) goto done;
	if (!res) break;
	if (! process_num (gk, sgk, base, n, -1, &res)) goto done;
	if (! process_num (gk, sgk, base, n+1, +1, &res2)) goto done;
	res |= res2;
	break;
      }
      if (c == 'A') {
	if (! process_num (gk, sgk, base, n, -2, &res)) goto done;
	if (!res) break;
      }

      /* If all numbers tested were probable primes, copy the line to the output file */

/*      if (res) {
	sprintf (result, "%s %lu\n", sgk, n); 
      } */

      if (res)
	retval = 0; /* return value : is prime ! */
    }


    /* THIS IS THE NEW SECTION.  It uses both the mask field and the */
    /* character code to determine what to do */

  } else {
    unsigned long nn;

    /* NEWPGEN output files use the mask as defined below: */
#define MODE_PLUS    0x01	/* k.b^n+1 */
#define MODE_MINUS   0x02	/* k.b^n-1 */
#define MODE_2PLUS   0x04	/* k.b^(n+1)+1 (*) */
#define MODE_2MINUS  0x08	/* k.b^(n+1)-1 (*) */
#define MODE_4PLUS   0x10	/* k.b^(n+2)+1 (*) */
#define MODE_4MINUS  0x20	/* k.b^(n+2)-1 (*) */
#define MODE_PRIMORIAL 0x40	/* PRIMORIAL - can't handle this */
#define MODE_PLUS5  0x80	/* k.b^n+5 */
#define MODE_AP	    0x200	/* 2^n+2k-1 */
#define MODE_PLUS7  0x800	/* k.b^n+7 */
#define MODE_2PLUS3 0x1000	/* 2k.b^n+3 */
#define MODE_NOTGENERALISED 0x400
    /* Those entries that have a (*) next to them are modified if the */
    /* MODE_NOTGENERALISED flag is set.  If it is set, they are changed */
    /* as follows: */
    /* MODE_2PLUS      2k.b^n+1 */
    /* MODE_2MINUS     2k.b^n-1 */
    /* MODE_4PLUS      4k.b^n+1 */
    /* MODE_4MINUS     4k.b^n-1 */
    /* Similarly, longer chains are affected in the same way (so if the base */
    /* is 3 and we are after a CC of the 1st kind of length 4, rather that */
    /* looking at k.3^n-1 & k.3^(n+1)-1 & k.3^(n+2)-1 & k.3^(n+3)-1 we look */
    /* at k.3^n-1 & 2k.3^n-1 & 4k.3^n-1 & 8k.3^n-1). */

    /* Read the line, break at EOF */

    // allow k to be a big integer
    if (sscanf (input, "%s %lu\n", sgk, &n) != 2) {
      return -1;
    } 
    gk = newgiant(strlen(sgk)/2 + 1);
    gkk = newgiant(strlen(sgk)/2 + 1);
    ctog(sgk, gk);

    /* Undo the increment of n that newpgen did on types 1, 2, 3 */

    nn = n;
    if (c == '1' || c == '2' || c == '3') nn--;

    /* In "lucky" modes, only test the central candidate */

    if (c == 'Y') {
      nn--;
      mask = MODE_2PLUS;
    }
    if (c == 'Z') {
      nn--;
      mask = MODE_2MINUS;
    }

    /* Test numbers according to the mask variable */
    /* The J and K types (Twin/CC and Twin/SG) are special in that they */
    /* are output if either a Twin OR a CC/SG is found */

    gtog(gk, gkk);
    for (i = 0; i < chainlen; i++) {
      gtoc(gkk, sgk, sgkbufsize);
      if (c == 'J') {
	int	res2;
	if (! process_num (gkk, sgk, base, nn, -1, &res)) goto done;
	if (!res) break;
	if (! process_num (gkk, sgk, base, nn, +1, &res)) goto done;
	if (! process_num (gkk, sgk, base, nn+1, -1, &res2)) goto done;
	res |= res2;
	break;
      }
      if (c == 'K') {
	int	res2;
	if (! process_num (gkk, sgk, base, nn, +1, &res)) goto done;
	if (!res) break;
	if (! process_num (gkk, sgk, base, nn, -1, &res)) goto done;
	if (! process_num (gkk, sgk, base, nn+1, +1, &res2)) goto done;
	res |= res2;
	break;
      }
      if (mask & MODE_MINUS) {
	if (! process_num (gkk, sgk, base, nn, -1, &res)) goto done;
	if (!res) break;
      }
      if (mask & MODE_PLUS) {
	if (! process_num (gkk, sgk, base, nn, +1, &res)) goto done;
	if (!res) break;
      }
      if (mask & MODE_PLUS5) {
	if (! process_num (gkk, sgk, base, nn, +5, &res)) goto done;
	if (!res) break;
      }
      if (mask & MODE_PLUS7) {
	if (! process_num (gkk, sgk, base, nn, +7, &res)) goto done;
	if (!res) break;
      }
      if (mask & MODE_2PLUS3) {
	gshiftleft(1, gkk);	// Compute gkk + gkk
	gtoc(gkk, sgk, sgkbufsize);
	if (! process_num (gkk, sgk, base, nn, +3, &res)) goto done;
	gshiftright(1, gkk);	// Restore gkk
	gtoc(gkk, sgk, sgkbufsize);
	if (!res) break;
      }
      if (mask & MODE_AP) {
	if (! process_num (gkk, sgk, base, nn, -2, &res)) goto done;
	if (!res) break;
      }

      /* Bump k or n for the next itereation or for the MODE_2PLUS and */
      /* MODE_2MINUS flags */

      if (mask & MODE_NOTGENERALISED) gshiftleft(1, gkk); 
      else nn += 1;
      gtoc(gkk, sgk, sgkbufsize);

      /* If chainlength is more than 1, then we let the for loop do the work */
      /* rather than the MODE_2PLUS, etc. flags */

      if (chainlen > 1) continue;

      if (mask & MODE_2MINUS) {
	if (! process_num (gkk, sgk, base, nn, -1, &res)) goto done;
	if (!res) break;
      }
      if (mask & MODE_2PLUS) {
	if (! process_num (gkk, sgk, base, nn, +1, &res)) goto done;
	if (!res) break;
      }

      /* Bump k or n for the MODE_4PLUS and MODE_4MINUS flags */

      if (mask & MODE_NOTGENERALISED) gshiftleft(1, gkk); 
      else nn += 1;
      gtoc(gkk, sgk, sgkbufsize);

      if (mask & MODE_4MINUS) {
	if (! process_num (gkk, sgk, base, nn, -1, &res)) goto done;
	if (!res) break;
      }
      if (mask & MODE_4PLUS) {
	if (! process_num (gkk, sgk, base, nn, +1, &res)) goto done;
	if (!res) break;
      }
    }

    /* If all numbers tested were probable primes, copy the line to the output file */

    /*      if (res) {
	    gtoc(gk, sgk, sgkbufsize);
	    sprintf (result, "%s %lu\n", sgk, n); 
	    } */

    if (res)
      retval = 0; /* return value : is prime ! */
		
  }

 done:
  if (gk)
    free(gk);
  if (gkk)
    free(gkk);

  strcpy(residue, res64);

  return retval;
}


#ifdef MFCGUI
extern "C" {
#endif
#include "lua.h"
#include "lualib.h"
#ifdef MFCGUI
}
#endif

int lua_print(lua_State * L)
{
  int n = lua_gettop(L);
  int i;
  char s[1024];
  
  s[0] = 0;
  if (n>0) {
    for (i=1; i<n; i++) {
      strcat(s, lua_tostring(L, i));
      strcat(s, " ");
    }
    strcat(s, lua_tostring(L, i));
  }
  strcat(s, "\n");
  OutputStr(s);

  return 0;
}

int lua_OutputBoth(lua_State * L)
{
  int n = lua_gettop(L);
  int i;
  char s[1024];
  
  s[0] = 0;
  if (n>0) {
    for (i=1; i<n; i++) {
      strcat(s, lua_tostring(L, i));
      strcat(s, " ");
    }
    strcat(s, lua_tostring(L, i));
  }
  strcat(s, "\n");
#ifndef MFCGUI
  printf(s);
#else
  OutputStr(s);
#endif
  writeResults(s);

  return 0;
}

int lua_stopCheck(lua_State * L)
{
  int s = stopCheck();
  lua_settop(L, 0);
  if (s) {
    lua_pushnumber(L, 1);
    return 1;
  } else
    return 0;
}

int lua_stopReset(lua_State * L)
{
  THREAD_STOP = 0;
  return 0;
}

int lua_stopSet(lua_State * L)
{
  THREAD_STOP = 1;
  return 0;
}

void llr_signal(int signal)
{
  printf("signal caught\n");
  sigterm_handler(signal);
}

int lua_llrsignal(lua_State * L)
{
#ifndef MFCGUI
  signal(SIGINT, llr_signal);
  signal(SIGTERM, llr_signal);
  signal(SIGABRT, llr_signal);
#endif
#ifdef WIN32
  signal(SIGBREAK, llr_signal);
#endif
#ifndef WIN32
  signal(SIGKILL, llr_signal);
  signal(SIGQUIT, llr_signal);
#endif

  return 0;
}


int lua_disableSSE2(lua_State * L)
{
  CPU_FLAGS &= ~CPU_SSE2;
  printf("SSE2 disabled\n");

  return 0;
}


int llrInit(lua_State * L)
{
	char	buf[256];
	int	named_ini_files = -1;

/* Determine the names of the INI files */
/* Read the INI files */

	nameIniFiles (named_ini_files);
	readIniFiles ();

/* Read load averaging settings from INI files */

#ifdef MPRIME_LOADAVG
	IniGetString (INI_FILE, "MaxLoad", buf, sizeof (buf), "0");
	HI_LOAD = atof (buf);
	IniGetString (INI_FILE, "MinLoad", buf, sizeof (buf), "0");
	LO_LOAD = atof (buf);
	IniGetString (INI_FILE, "PauseTime", buf, sizeof (buf), "0");
	LOAD_CHECK_TIME = atol (buf);

/* Initialise load checking */

	if (HI_LOAD > 0.0 && LOAD_CHECK_TIME > 0)
		init_load_check ();
#endif

#ifdef MFCGUI
        lua_register(L, "print", lua_print);
#endif
        lua_register(L, "OutputBoth", lua_OutputBoth);
        lua_register(L, "stopCheck", lua_stopCheck);
        lua_register(L, "stopReset", lua_stopReset);
        lua_register(L, "stopSet", lua_stopSet);
        lua_register(L, "InstallLlrSignal", lua_llrsignal);

	lua_register(L, "disableSSE2", lua_disableSSE2);

        return 0;
}




#ifdef WIN32
#ifdef UNDER_CE
#define CMDSTR  LPWSTR
#else
#define CMDSTR  LPSTR
#endif

#define STDOUT_FILE	TEXT("stdout.txt")
#define STDERR_FILE	TEXT("stderr.txt")

//#define NO_STDIO_REDIRECT

static char **
CommandLineToArgv(char *cmdLine, int *argCount)
{
    int numArgs = 0;
    int inArg, inString;
    int i, len;
    char *res, *str, **aptr;

    len = strlen(cmdLine);

    /* 
     * Count the number of arguments...
     */
    inString = FALSE;
    inArg = FALSE;

    for(i=0; i<=len; i++)
    {
        if( cmdLine[i] == '"' )
        {
            inString = !inString;
        }

        if( (cmdLine[i] <= ' ' && !inString) || i == len )
        {
            if( inArg ) 
            {
                inArg = FALSE;
                
                numArgs++;
            }
        } 
        else if( !inArg )
        {
            inArg = TRUE;
        }
    }

    /* 
     * Allocate memory for result...
     */
    res = (char *)malloc(sizeof(char *) * numArgs + len + 1);
    str = res + sizeof(char *) * numArgs;
    aptr = (char **)res;

    strcpy(str, cmdLine);

    /*
     * Walk through cmdLine again this time setting pointer to each arg...
     */
    inArg = FALSE;
    inString = FALSE;

    for(i=0; i<=len; i++)
    {
        if( cmdLine[i] == '"' )
        {
            inString = !inString;
        }

        if( (cmdLine[i] <= ' ' && !inString) || i == len )
        {
            if( inArg ) 
            {
                if( str[i-1] == '"' )
                {
                    str[i-1] = '\0';
                }
                else
                {
                    str[i] = '\0';
                }
                
                inArg = FALSE;
            }
        } 
        else if( !inArg && cmdLine[i] != '"' )
        {
            inArg = TRUE; 
            
            *aptr++ = &str[i];
        }
    }

    *argCount = numArgs;

    return (char **)res;
}

#ifdef MFCGUI
int main(int argc, char * * argv);
void net_primeContinue ()
{
    int argc, i;
    char **argv;
    CMDSTR cmdLine;

   /*
     * Get proper command line params, cmdLine passed to us does not
     * work properly under all circumstances...
     */
    cmdLine = GetCommandLine();

    /*
     * Parse command line into standard (argv, argc) parameters...
     */
    argv = CommandLineToArgv(cmdLine, &argc);


    /* Call our main */
    main(argc, argv);


    /* 
     * Free the argv strings...
     */
    free(argv);
}
#else
int PASCAL
WinMain(HINSTANCE instance, 
        HINSTANCE prevInstance, 
        CMDSTR cmdLine, 
        int cmdShow)
{
    MSG message;
    int argc, i;
    char **argv;
    FILE * newfp;
    

#ifndef NO_STDIO_REDIRECT
    /* Redirect standard input and standard output */
    newfp = freopen(STDOUT_FILE, "w", stdout);
    if ( newfp == NULL ) {	/* This happens on NT */
#if !defined(stdout)
      stdout = fopen(STDOUT_FILE, "w");
#else
      newfp = fopen(STDOUT_FILE, "w");
      if ( newfp ) {
	*stdout = *newfp;
      }
#endif
    }
    newfp = freopen(STDERR_FILE, "w", stderr);
    if ( newfp == NULL ) {	/* This happens on NT */
#if !defined(stderr)
      stderr = fopen(STDERR_FILE, "w");
#else
      newfp = fopen(STDERR_FILE, "w");
      if ( newfp ) {
	*stderr = *newfp;
      }
#endif
    }
    setvbuf(stdout, NULL, _IOLBF, BUFSIZ);	/* Line buffered */
    setbuf(stderr, NULL);			/* No buffering */
#endif /* !NO_STDIO_REDIRECT */

#if 0
    peng_win32Instance = instance;

    /*
     * Register the window class...
     */
    if( !InitApplication(instance) )
    {
        return FALSE;
    }
#endif

    /*
     * Get proper command line params, cmdLine passed to us does not
     * work properly under all circumstances...
     */
    cmdLine = GetCommandLine();

    /*
     * Parse command line into standard (argv, argc) parameters...
     */
    argv = CommandLineToArgv(cmdLine, &argc);


    /* Call our main */
    main(argc, argv);


    /* 
     * Free the argv strings...
     */
    free(argv);

    return message.wParam;

}
#endif

#endif
