/*
 * LLRNet - network part of LLR
 *
 * (C) 2004-2005 Vincent Penne
 *
 * Released under GNU LIBRARY GENERAL PUBLIC LICENSE
 * (See file LICENSE that must be included with this software)
 *
 */

#ifndef _NET_H_
#define _NET_H_

/* --- HEADERS --- */
#include "threads.h"

/* ---  DECLS  --- */

int net_Init();

int net_Shutdown();

class net_Server_t {

  struct threadPool_t {
    int socket;
    int quit;
    thrd_Sema_t sema;
    Thrd_Thread id;
    net_Server_t * server;
  } * threadPool;

  int maxConnections;
  int s;

  static void * connection_thread(void * arg);

 public:
  net_Server_t(int maxConnections = 16);
  virtual ~net_Server_t();

  int Init(int maxConnections = 16);
  virtual void Kill();

  // WARNING : this function delete the net_Server object on exit !
  int Listen(int port, const char * mask, const char * allow);

  virtual int OnConnect(int socket);
};


int net_Connect(const char * address, int port, int nonblock = 0);

int net_Close(int s);

int net_Recv(int s, void * buffer, int length);

int net_Send(int s, const void * buffer, int length);

int net_NonBlock(int s, int m);


#endif /* ifdef _NET_H_ */
