<?php

$timestart = microtime();

//DEFINE("llrdbg", TRUE);
DEFINE("llrdbg", FALSE);

$showcheckers = 1;

include "phpllr-config.php";
if (file_exists('./phpllr-config-local.php')) {
    include './phpllr-config-local.php';
}

session_name($llrcfg["sessionName"]);
// if (isset($_REQUEST[$llrcfg["sessionName"]])) {
//   session_id($_REQUEST[$llrcfg["sessionName"]]);
// }
session_start();

// if (!session_id()) {
//   session_regenerate_id();
// }

// settings in status can be modified via GET and POST requests
// put only informations which cannot cause dangerous behaviour,
// for example, do NOT put here the information wheither 
// a user is logged on or not here !
$status = &$_SESSION["status"];

// private status, modified only through php code
$private_status = &$_SESSION["private_status"];


// some default values
if (!$status["results_sort"]) {
  $status["results_sort"] = "desc_date";
  $status["rejected_sort"] = "desc_date";
  $status["jobs_sort"] = "desc_date";
}

if (!$nohtml && llrdbg) {
  echo "<small><small>Session ID = ".session_id()."<p>\n";
}

// update status according to the current POST and GET
// all parameters are simply copied
if ($_GET["action"] == "set") {
  foreach ($_GET as $i => $v) {
    $status[$i] = $v;
    if (llrdbg && !$nohtml) {
      echo "Updating status[$i] = $v<p>\n";
    }
  }
}

if ($_POST["action"] == "set") {
  foreach ($_POST as $i => $v) {
    $status[$i] = $v;
    if (llrdbg && !$nohtml) {
      echo "Updating status[$i] = $v<p>\n";
    }
  }
}

if (!$nohtml && llrdbg) {
  echo "</small></small>";
}

function startperf($label)
{
  global $measure_perfs, $cperf;
  if ($measure_perfs) {
    $cperf = array($label, microtime());
  }
}

function stopperf()
{
  global $measure_perfs, $cperf, $perfs;
  if ($measure_perfs) {
    $cperf[2] = microtime();
    $perfs[] = $cperf;
  }
}

function showperfs()
{
  global $measure_perfs, $perfs;
  if ($measure_perfs) {
    echo "<hr/>\n";
    echo "Script performances :\n";
    echo "<table><tr>\n";
    foreach ($perfs as $p) {
      echo "<th>".$p[0]."</th>";
    }
    echo "\n</tr><tr>\n";
    foreach ($perfs as $p) {
      $timestart = $p[1];
      $timeend = $p[2];
      $diff = number_format(((substr($timeend,0,9)) + (substr($timeend,-10)) - (substr($timestart,0,9)) - (substr($timestart,-10))),4);
      echo "<td bgcolor='#DDDDDD'>$diff s</td>";
    }
    echo "\n</tr></table>\n";
  }
}

function StartForm($action, $legend)
{
?>
<fieldset><legend><?=$legend?></legend>
<form action="./index.php?<?=SID?>" method="post">
   <input type="hidden" name="action" value="<?=$action?>" />
   <table cellpadding="3" cellspacing="0">
<?php
}

function EndForm($label="Set", $forceSubmit=NULL)
{
  echo "</table>\n";
  if (!$forceSubmit) {
    echo "<noscript>\n";
  }
  echo "<button type='submit'>$label</button>\n";
  if (!$forceSubmit) {
    echo "</noscript>";
  }
  echo "</form></fieldset>\n";
}

function Input($name, $label, $default=NULL, $option=NULL)
{
?>
   <tr><td align="right">
   <?=$label?>
   </td><td>
   <input <?=$option?> name="<?=$name?>" value="<?=$default?>"/>
   </td></tr>
<?php
}

function Select($name, $label, $choices, $select)
{
?>
   <tr><td align="right">
   <?=$label?>
   </td><td>
   <select name="<?=$name?>" onchange="this.form.submit()">
<?php
   foreach ($choices as $choice) {
     echo "<option";
     if ($choice == $select) {
       echo ' selected="selected"';
     }
     echo ">$choice</option>\n"; //"
   }
?>
   </select>
   </td></tr>
<?php
}

function Button($label, $action, $index, $value, $url)
{
?>
<form action="<?=$url?>" method="post">
   <?php if ($index) {?>
 <input type="hidden" name="<?=$index?>" value="<?=$value?>" />
   <?php } ?>
 <input type="hidden" name="action" value="<?=$action?>" />
 <input type="submit" value="<?=$label?>"/>
</form>

<?php
}

function ImageButton($label, $image, $action, $index, $value)
{
?>
<form action="./index.php?<?=SID?>" method="post">
   <?php if ($index) {?>
 <input type="hidden" name="<?=$index?>" value="<?=$value?>" />
   <?php } ?>
 <input type="hidden" name="action" value="<?=$action?>" />
 <input type ="image" src="<?=$image?>" alt="<?=$label?>" />
</form>

<?php
  //  echo "<a href='./index.php?$action=$index&amp;value=$value'><img src='$image' alt='$label' border='0' hspace='2'/> </a>\n";
}

function SetButton($label, $index)
{
  Button($label, "set", $index, 1, "./index.php?".SID);
}

function UnsetButton($label, $index)
{
  Button($label, "set", $index, 0, "./index.php?".SID);
}


function StartTab($pre)
{
?>
<table border="0" cellspacing="0" cellpadding="0" width="100%" id="<?=$pre?>_tab">
    <tr>
        <td class="nav" align="center" nowrap="nowrap" valign="bottom">            <table border="0" cellpadding="0" cellspacing="0"><tr>                <td nowrap="nowrap"><img src="./img/spacer.png" width="2" height="1" border="0" alt="" /></td>                <td class="navSpacer"><img src="./img/spacer.png" width="1" height="1" border="0" alt="" /></td>
<?php
}

function TabEntry($pre, $name, $label)
{
  global $status;
  if ($status[$pre."_tab"] == $name) {
?>

        <td class="navSpacer"><img src="./img/spacer.png" width="1" height="1" border="0" alt="" /></td>
        <td class="navActive" nowrap="nowrap">
<?php 
  } else { 
?>
        <td class="navSpacer"><img src="./img/spacer.png" width="1" height="1" border="0" alt="" /></td>
        <td class="navNormal" nowrap="nowrap">
<?php
  }
?>
            <a href="index.php?<?=SID?>&amp;action=set&amp;<?=$pre."_tab=".$name?>"><?=$label?></a>
        </td>
<?php
}


function EndTab()
{
?>
        <td class="navSpacer"><img src="./img/spacer.png" width="1" height="1" border="0" alt="" /></td>
                <td nowrap="nowrap"><img src="./img/spacer.png" width="2" height="1" border="0" alt="" /></td>            </tr></table>
        </td>
    </tr>
</table><br/>
<?php
}


// from phpmyadmin
/**
 * Returns a given timespan value in a readable format.
 *
 * @param  int     the timespan
 *
 * @return string  the formatted value
 */
function PMA_timespanFormat($seconds)
{
  $return_string = '';
  $days = floor($seconds / 86400);
  if ($days > 0) {
    $seconds -= $days * 86400;
  }
  $hours = floor($seconds / 3600);
  if ($days > 0 || $hours > 0) {
    $seconds -= $hours * 3600;
  }
  $minutes = floor($seconds / 60);
  if ($days > 0 || $hours > 0 || $minutes > 0) {
    $seconds -= $minutes * 60;
  }
  return sprintf("%2d days, %2d hours, %2d mins and %2d secs", (string)$days, (string)$hours, (string)$minutes, (string)$seconds);
}

if (!$nohtml) {
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en" dir="ltr">

<head>
<title>llrnet server info</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<style type="text/css">
<!--
body {
    font-family: arial, helvetica, geneva, sans-serif;
    font-size: small;
    color: #000000;
    background-image: url('./images/vertical_line.gif');
    background-repeat: repeat-y;
    background-color: #F5F5F5
}
pre, tt         {font-size: small}
th              {font-family: arial, helvetica, geneva, sans-serif; font-size: small; font-weight: bold; color: #000000; background-color: #D3DCE3}
td              {font-family: arial, helvetica, geneva, sans-serif; font-size: small}
form            {font-family: arial, helvetica, geneva, sans-serif; font-size: small}
input           {font-family: arial, helvetica, geneva, sans-serif; font-size: small}
input.textfield {font-family: arial, helvetica, geneva, sans-serif; font-size: small; color: #000000; background-color: #FFFFFF}
select          {font-family: arial, helvetica, geneva, sans-serif; font-size: small; color: #000000; background-color: #FFFFFF}
textarea        {font-family: arial, helvetica, geneva, sans-serif; font-size: small; color: #000000; background-color: #FFFFFF}
h1              {font-family: arial, helvetica, geneva, sans-serif; font-size: large; font-weight: bold}
a:link          {font-family: arial, helvetica, geneva, sans-serif; font-size: small; text-decoration: none; color: #0000FF}
a:visited       {font-family: arial, helvetica, geneva, sans-serif; font-size: small; text-decoration: none; color: #0000FF}
a:hover         {font-family: arial, helvetica, geneva, sans-serif; font-size: small; text-decoration: underline; color: #FF0000}
a.nav:link      {font-family: arial, helvetica, geneva, sans-serif; color: #000000}
a.nav:visited   {font-family: arial, helvetica, geneva, sans-serif; color: #000000}
a.nav:hover     {font-family: arial, helvetica, geneva, sans-serif; color: #FF0000}
a.h1:link       {font-family: arial, helvetica, geneva, sans-serif; font-size: large; font-weight: bold; color: #000000}
a.h1:visited    {font-family: arial, helvetica, geneva, sans-serif; font-size: large; font-weight: bold; color: #000000}
a.h1:hover      {font-family: arial, helvetica, geneva, sans-serif; font-size: large; font-weight: bold; color: #FF0000}
a.drop:link     {font-family: arial, helvetica, geneva, sans-serif; color: #ff0000}
a.drop:visited  {font-family: arial, helvetica, geneva, sans-serif; color: #ff0000}
a.drop:hover    {font-family: arial, helvetica, geneva, sans-serif; color: #ffffff; background-color:#ff0000; text-decoration: none}
.nav            {font-family: arial, helvetica, geneva, sans-serif; color: #000000}
.warning        {font-family: arial, helvetica, geneva, sans-serif; font-size: small; font-weight: bold; color: #FF0000}
td.topline      {font-size: 1px}
td.tab          {
    border-top: 1px solid #999;
    border-right: 1px solid #666;
    border-left: 1px solid #999;
    border-bottom: none;
    border-radius: 2px;
    -moz-border-radius: 2px;
}
table.tabs      {
    border-top: none;
    border-right: none;
    border-left: none;
    border-bottom: 1px solid #666;
}

/* new styles for navigation */

.nav {
    font-family: arial, helvetica, geneva, sans-serif;
    color: #000000;
    border-top: none;
    border-right: none;
    border-left: none;
    border-bottom: 1px solid #666;
}
.navSpacer {
    width:            5px;
    height:           16px;
}
.navNormal, .navDrop, .navActive {
    font-family:      arial, helvetica, geneva, sans-serif;
    font-size:        small;
    font-weight:      bold;
    border-top: 1px solid #999;
    border-right: 1px solid #666;
    border-left: 1px solid #999;
    border-bottom: none;
    border-radius: 2px;
    -moz-border-radius: 2px;
    padding: 2px 5px 2px 5px;
}
.navNormal {
    color:            #000000;
    background-color: #E5E5E5;
}
.navActive{
    font-family:      arial, helvetica, geneva, sans-serif;
    font-size:        small;
    font-weight:      bold;
    color:            #000000;
    background-color: #CCCCCC;
}
.navDrop{
    color: #000000;
    background-color: #E5E5E5;
}
.navNormal a:link, .navNormal a:active, .navNormal a:visited, .navActive a:link, .navActive a:active, .navActive a:visited{
    color: #0000FF;
}

.navDrop a:link, .navDrop a:active, .navDrop a:visited{
    color: #FF0000;
}
.navDrop a:hover{
    color: #FFFFFF;
    background-color: #FF0000;
}
.navNormal a:hover, .navActive a:hover{
    color: #FF0000;
}



.syntax {font-family: sans-serif; font-size: x-small;}
.syntax_comment            {}
.syntax_digit              {}
.syntax_digit_hex          {}
.syntax_digit_integer      {}
.syntax_digit_float        {}
.syntax_punct              {}
.syntax_alpha              {text-transform: lowercase;}
.syntax_alpha_columnType   {text-transform: uppercase;}
.syntax_alpha_columnAttrib {text-transform: uppercase;}
.syntax_alpha_reservedWord {text-transform: uppercase; font-weight: bold;}
.syntax_alpha_functionName {text-transform: uppercase;}
.syntax_alpha_identifier   {}
.syntax_alpha_variable     {}
.syntax_quote              {}
.syntax_quote_backtick     {}
.syntax_comment {color: #808000;}
.syntax_comment_mysql {}
.syntax_comment_ansi {}
.syntax_comment_c {}
.syntax_digit {}
.syntax_digit_hex {color: teal;}
.syntax_digit_integer {color: teal;}
.syntax_digit_float {color: aqua;}
.syntax_punct {color: fuchsia;}
.syntax_alpha {}
.syntax_alpha_columnType {color: #FF9900;}
.syntax_alpha_columnAttrib {color: #0000FF;}
.syntax_alpha_reservedWord {color: #990099;}
.syntax_alpha_functionName {color: #FF0000;}
.syntax_alpha_identifier {color: black;}
.syntax_alpha_variable {color: #800000;}
.syntax_quote {color: #008000;}
.syntax_quote_double {}
.syntax_quote_single {}
.syntax_quote_backtick {}
.syntax_indent0 {margin-left: 0em;}
.syntax_indent1 {margin-left: 1em;}
.syntax_indent2 {margin-left: 2em;}
.syntax_indent3 {margin-left: 3em;}
.syntax_indent4 {margin-left: 4em;}
.syntax_indent5 {margin-left: 5em;}
.syntax_indent6 {margin-left: 6em;}
.syntax_indent7 {margin-left: 7em;}
//-->
</style>

<!--
<script src="libraries/functions.js" type="text/javascript" language="javascript"></script>
-->
    
</head>

<body bgcolor="#F5F5F5">

<?php
    //echo 'sid='.session_id().'<p>';
}
?>