--
-- LLRNet - network part of LLR
--
-- (C) 2004-2005 Vincent Penne
--
-- Released under GNU LIBRARY GENERAL PUBLIC LICENSE
-- (See file LICENSE that must be included with this software)
--

-- WIN32 specific : systray icon and service

if WIN32 then
   local noreent
   function trayCB(hwnd, iMsg, wParam, lParam)

      if noreent then return end
      noreent = 1

      if not hideTrayIcon and iMsg == WM_WTSSESSION_CHANGE then
	 if wParam == WTS_SESSION_LOGON then
	    print("LOGON --> adding tray icon")
	    trayIcon = TrayIconAdd("LLRtray", 0, nil, serviceName)
	 end
	 if wParam == WTS_SESSION_LOGOFF then
	    if trayIcon then
	       print("LOGOFF --> removing tray icon")
	       TrayIconRemove(trayIcon)
	       trayIcon = nil
	    end
	 end
      end

--      print(iMsg, wParam, lParam)
      if lParam == 514 then -- left click release
--	 SW_NORMAL = 1
--	 ShellExecute(hwnd, "open", arg[0], "gui.lua", "", SW_NORMAL)

--	 if HasConsole() ~= 1 then
--	    AllocConsole("LLRnet console")  
--	    print("LLRnet current status :")
--	    print(statusStr)
--	    llrVerbose(1)
--	 else
--	    FreeConsole()
--	    llrVerbose(0)
--	 end

	 if GUIrunning and mainWindow then
	    tinsert(GUIcommandQueue, 
		    function()
		       if mainWindow:shown() ~= 0 then
			  mainWindow:hide()
		       else
			  mainWindow:show()
		       end
		    end)
	 end

      end

      if lParam == 517 then -- right click release

	 local serviceManager = OpenSCManager()
	 local service

	 if serviceManager then
	    service = OpenService(serviceManager, serviceName)
	 end

	 local menu = CreatePopupMenu()
	 if GUIrunning then
	    InsertMenuItem(menu, 1, 1, "Toggle GUI window", 2)
	 elseif fox_init then
	    InsertMenuItem(menu, 1, 1, "New GUI window", 2)
	 end
	 InsertMenuItem(menu, 0, 1, "Exit "..serviceName, 1)
	 if HasConsole() ~= 1 then
	    InsertMenuItem(menu, 3, 1, "Open a console", 3)
	 else
	    InsertMenuItem(menu, 4, 1, "Detach console", 4)
	 end

	 if serviceManager then
	    if service then
	       InsertMenuItem(menu, 5, 1, "Remove "..serviceName.." as service", 5)
	    else
	       InsertMenuItem(menu, 5, 1, "Add "..serviceName.." as service", 5)
	    end	       
	 end

	 InsertMenuItem(menu, 6, 1, "Hide tray icon", 6)

	 --InsertMenuItem(menu, 1, 1, "Titi", 2)
	 local res = PopupMenu(hwnd, menu)

	 --print("res", res)

	 if res == 1 then
	    paused = nil
	    sleeping = nil
	    --LLRglobals = nil
	    if not LlrSignalsInstalled then
	       --Win32Exit()
	    end
	    raise(SIGINT)
	    --stopSet()
	 end

	 if res == 2 then
	    if GUIrunning then
	       tinsert(GUIcommandQueue, 
		       function()
			  if mainWindow:shown() ~= 0 then
			     mainWindow:hide()
			  else
			     mainWindow:show()
			  end
		       end)
	    else
	       SW_NORMAL = 1
	       ShellExecute(hwnd, "open", arg[0], "gui.lua", "", SW_NORMAL)
	    end

--	    GUIrunning = 1
--	    create_thread(function()
--			     system(arg[0].." gui.lua")
--			     GUIrunning = nil
--			  end)
--	    SW_NORMAL = 1
--	    ShellExecute(hwnd, "open", arg[0], "gui.lua -no-console", "", SW_NORMAL)

--	    GUIrunning = 1
--	    create_thread(LaunchGui)
	    
	 end

	 if res == 3 then 
	    AllocConsole(serviceName.." console")
	    local p = orig_print
	    local orig_print = p or print
	    orig_print(serviceName.." current status :")
	    orig_print(statusStr)

	    if backLog then
	       local i, n
	       n = getn(backLog)
	       for i=1, n, 1 do
		  orig_print(string.sub(backLog[i], 1, -2))
	       end
	    end

	    --llrVerbose(1)
	 end
	 if res == 4 then
	    FreeConsole(logOutput)
	    --llrVerbose(0)
	 end

	 if res == 5 then
	    if service then
	       DeleteService(service)
	       --service = nil
	    else
	       service = CreateService(serviceManager, 
				       serviceName, serviceDisplayName)
	    end
	 end

	 if res == 6 then
	    if trayIcon then
	       print("removing tray icon")
	       TrayIconRemove(trayIcon)
	       trayIcon = nil
	       hideTrayIcon = 1
	    end

	    if GUIrunning then
	       hideTrayIcon = 1
	       tinsert(GUIcommandQueue, 
		    function()
		       if mainWindow:shown() == 0 then
			  mainWindow:show()
		       end
		    end)
	    end	    
	 end

	 if service then
	    CloseServiceHandle(service)
	 end
	 if serviceManager then
	    CloseServiceHandle(serviceManager)
	 end

      end

      noreent = nil
      return 1
   end

   function serviceCB(control, eventType, eventData)
      print("service event :", control, eventType, eventData)
      if control == SERVICE_CONTROL_STOP or control == SERVICE_CONTROL_SHUTDOWN then
	 paused = nil
	 sleeping = nil
	 SetServiceStatus(SERVICE_STOP_PENDING)
	 if LlrSignalsInstalled then
	 else
	    --Win32Exit()
	 end
	 raise(SIGINT)
      end
   end

   function WinLoopThread()
      --AllocConsole() -- for debug

      trayIcon = TrayIconAdd("LLRtray", 0, nil, serviceName)
      print("winloop thread")
      WinLoop()
   end

   -- log output if necessary
   if logOutput then
      FreeConsole(1)
   end

   -- service dispatcher thread
   serviceRunning = 1
   create_thread(function()
		    RegisterServiceCtrlHandler(serviceName)
		    serviceRunning = nil
		 end)

   -- winloop thread
   if not hideTrayIcon then
      if 1 or not GUIremote then
	 create_thread(WinLoopThread, 64*1024)
      end
   end

   function Win32Exit()
      print("Win32Exit")
      if trayIcon then
	 TrayIconRemove(trayIcon)
	 trayIcon = nil
      end
      
      if serviceRunning then
	 print("Stopping service")
	 serviceRunning = nil
	 SetServiceStatus(SERVICE_STOPPED)
      end
   end

end

return 1
