#ifndef LPRIME_H   
#define LPRIME_H   
  
/* Handy definitions */

#define FALSE	0
#define TRUE	1

/* This controls whether we want to pause computation if the load average */
/* becomes too great.  This does not apply to OS/2. */

#if defined (__linux__) || defined (__FreeBSD__)
#define MPRIME_LOADAVG
#endif

#ifndef WIN32
/* Handle the difference between the naming conventions in the two */
/* C compilers.  We only need to to this for global variables that */
/* referenced by the assembly routines */

#define ASSERT	assert
#if defined (__linux__) || defined (__FreeBSD__)
#define ERRCHK	 _ERRCHK
#define CPU_TYPE	_CPU_TYPE
#define MAXERR	 _MAXERR
#define GWERROR	 _GWERROR
#define PARG	 _PARG
#define KARG	_KARG
#define CARG	_CARG
#define DKARG	_DKARG
#define LOG2K	_LOG2K
#define LOGeK	_LOGeK
#define limit_first _limit_first
#define limit_inverse_first _limit_inverse_first
#define sval	_sval
#define scarry	_scarry

#define FFTLEN	_FFTLEN
#define CPU_L2_CACHE_SIZE _CPU_L2_CACHE_SIZE
#define SRCARG	_SRCARG
#define SRC2ARG	_SRC2ARG
#define DESTARG	_DESTARG
#define DEST2ARG _DEST2ARG
#define MAXDIFF _MAXDIFF
#define INFP	_INFP
#define INFF	_INFF
#define INFT	_INFT
#define GWPROCPTRS _GWPROCPTRS
#define UU	_UU
#define VV	_VV
#define Ulen	_Ulen
#define Vlen	_Vlen
#define EGCD_A	_EGCD_A
#define EGCD_B	_EGCD_B
#define EGCD_C	_EGCD_C
#define EGCD_D	_EGCD_D
#define EGCD_ODD _EGCD_ODD
#define NORM_ARRAY1 _NORM_ARRAY1
#define NORM_ARRAY2 _NORM_ARRAY2
#define RES	_RES
#define CARRYL	_CARRYL
#define CARRYH	_CARRYH
#define PLUS1	_PLUS1
#define NUMLIT	_NUMLIT
#define NUMBIG	_NUMBIG
#define MULCONST _MULCONST
#define FFTZERO	_FFTZERO
#define CPU_FLAGS	_CPU_FLAGS 
#define BITS_PER_WORD	_BITS_PER_WORD 
#define FFTLEN_INV	_FFTLEN_INV 
#define PROTHVALS _PROTHVALS
#define ADDIN_ROW	_ADDIN_ROW 
#define ADDIN_OFFSET	_ADDIN_OFFSET 
#define ADDIN_VALUE	_ADDIN_VALUE 
#define COPYZERO	_COPYZERO 
#define POSTFFT	_POSTFFT 
#define NORMRTN	_NORMRTN
#define CPUID_EAX	_CPUID_EAX 
#define CPUID_EBX	_CPUID_EBX 
#define CPUID_ECX	_CPUID_ECX 
#define CPUID_EDX	_CPUID_EDX 
#define RATIONAL_FFT _RATIONAL_FFT
#define EXTRA_BITS _EXTRA_BITS
#define SPREAD_CARRY_OVER_4_WORDS _SPREAD_CARRY_OVER_4_WORDS
#define TOP_CARRY_NEEDS_ADJUSTING _TOP_CARRY_NEEDS_ADJUSTING
#define CARRY_ADJUST1 _CARRY_ADJUST1
#define CARRY_ADJUST2 _CARRY_ADJUST2
#define CARRY_ADJUST3 _CARRY_ADJUST3
#define CARRY_ADJUST4 _CARRY_ADJUST4
#define CARRY_ADJUST5 _CARRY_ADJUST5
#define CARRY_ADJUST6 _CARRY_ADJUST6
#define HIGH_WORD1_OFFSET _HIGH_WORD1_OFFSET
#define HIGH_WORD2_OFFSET _HIGH_WORD2_OFFSET
#define HIGH_WORD3_OFFSET _HIGH_WORD3_OFFSET
#define HIGH_SCRATCH1_OFFSET _HIGH_SCRATCH1_OFFSET
#define HIGH_SCRATCH2_OFFSET _HIGH_SCRATCH2_OFFSET
#define HIGH_SCRATCH3_OFFSET _HIGH_SCRATCH3_OFFSET

#define ZERO_PADDED_FFT _ZERO_PADDED_FFT
#define ZPAD_TYPE _ZPAD_TYPE
#define ZPAD_INVERSE_K6 _ZPAD_INVERSE_K6
#define ZPAD_INVERSE_K5 _ZPAD_INVERSE_K5
#define ZPAD_INVERSE_K4 _ZPAD_INVERSE_K4
#define ZPAD_INVERSE_K3 _ZPAD_INVERSE_K3
#define ZPAD_INVERSE_K2 _ZPAD_INVERSE_K2
#define ZPAD_INVERSE_K1 _ZPAD_INVERSE_K1
#define ZPAD_K6_HI _ZPAD_K6_HI
#define ZPAD_K5_HI _ZPAD_K5_HI
#define ZPAD_K4_HI _ZPAD_K4_HI
#define ZPAD_K3_HI _ZPAD_K3_HI
#define ZPAD_K2_HI _ZPAD_K2_HI
#define ZPAD_K1_HI _ZPAD_K1_HI
#define ZPAD_K6_MID _ZPAD_K6_MID
#define ZPAD_K5_MID _ZPAD_K5_MID
#define ZPAD_K4_MID _ZPAD_K4_MID
#define ZPAD_K3_MID _ZPAD_K3_MID
#define ZPAD_K2_MID _ZPAD_K2_MID
#define ZPAD_K1_MID _ZPAD_K1_MID
#define ZPAD_K6_LO _ZPAD_K6_LO
#define ZPAD_K5_LO _ZPAD_K5_LO
#define ZPAD_K4_LO _ZPAD_K4_LO
#define ZPAD_K3_LO _ZPAD_K3_LO
#define ZPAD_K2_LO _ZPAD_K2_LO
#define ZPAD_K1_LO _ZPAD_K1_LO
#define ZPAD_SHIFT6 _ZPAD_SHIFT6
#define ZPAD_SHIFT5 _ZPAD_SHIFT5
#define ZPAD_SHIFT4 _ZPAD_SHIFT4
#define ZPAD_SHIFT3 _ZPAD_SHIFT3
#define ZPAD_SHIFT2 _ZPAD_SHIFT2
#define ZPAD_SHIFT1 _ZPAD_SHIFT1

#define BIGLIT_INCR2 _BIGLIT_INCR2
#define BIGLIT_INCR4 _BIGLIT_INCR4

#define INVERSE_KARG _INVERSE_KARG
#define KARG_HI _KARG_HI
#define KARG_LO _KARG_LO

#define norm_grp_mults _norm_grp_mults
#define norm_col_mults _norm_col_mults
#define limit_first _limit_first
#define limit_inverse_first _limit_inverse_first

/* Handle the difference in the way the two C compilers name routines */

#define gw_setup1 _gw_setup1
#define gw_setup2 _gw_setup2
#define egetval _egetval
#define egcdhlp _egcdhlp
#define eaddhlp	_eaddhlp
#define emuladdhlp _emuladdhlp
#define emulsubhlp _emulsubhlp
#define emuladd2hlp _emuladd2hlp
#define gwinfo1	_gwinfo1
#define gwsetup1 _gwsetup1
#define gwsetup2 _gwsetup2
#define esubhlp _esubhlp
#define emulmod	_emulmod
#define eisvaliddouble _eisvaliddouble
#define fpu_init _fpu_init
#define erdtsc	_erdtsc
#define etwo_to_pow _etwo_to_pow 
#define esincos	_esincos 
#define esincos3 _esincos3 
#define etwo_to_pow_over_fftlen _etwo_to_pow_over_fftlen 
#define eset_mul_const _eset_mul_const 
#define ecpuidsupport _ecpuidsupport 
#define ecpuid _ecpuid 
#define efft_weight _efft_weight
#define efft_weight_inverse _efft_weight_inverse
#define efft_weight_inverse_over_fftlen _efft_weight_inverse_over_fftlen
#define efft_base _efft_base
#endif

/* Handle differences between Windows and Linux runtime libraries */

#define stricmp(x,y)	strcasecmp(x,y)
#if defined (__linux__) || defined (__FreeBSD__)
# define _commit(f)	fsync(f)
#endif
#define _open		open
#define _close		close
#define _read		read
#define _write		write
#define _lseek		lseek
#define _unlink		unlink
#define _creat		creat
#define _chdir		chdir
#define _ftime		ftime
#define _timeb		timeb
#define IsCharAlphaNumeric(c) isalnum(c)
#define _O_APPEND	O_APPEND
#define _O_RDONLY	O_RDONLY
#define _O_WRONLY	O_WRONLY
#define _O_RDWR		O_RDWR
#define _O_CREAT	O_CREAT
#define _O_TRUNC	O_TRUNC
#define _O_BINARY 	0
#define _O_TEXT		0
#endif

/* The common include files */

#include <time.h>
#include <assert.h>
/*#define SERVER_TESTING*/
#ifndef EXTERNC   
#define EXTERNC
#endif   
#undef NO_GUI 
extern int NO_GUI;
#include "cpuid.h" 
#include "giants.h"
#include "gwnum.h"
#include "Llr.h"

/* Global variables */

extern int volatile THREAD_STOP;	/* TRUE if thread should stop */
extern int volatile THREAD_KILL;	/* TRUE if program should terminate */
extern int MENUING;			/* TRUE when main menu active */

/* Internal routines */

void main_menu ();
void linuxContinue (char *);
void Sleep (long);

#endif
